; Misc. macros
; Written by Viktors Berstis

winstack macro  n
; align stack to 16 byte boundary for Windows calls
; n = anticipating n additional parameters after first 4
        mov     winsavestack,rsp        ;save current stack pointer
        ifb <n> ;
          sub   rsp,40
          or    rsp,0fh
          xor   rsp,0fh
        else
          sub   rsp,40+8*n
          or    rsp,0fh
          xor   rsp,0fh
        endif
        endm

winstacke macro  n
; restore stack to what it was before winstack macro
        mov     rsp,winsavestack        ;save current stack pointer
        endm

; Use these around code sections that cannot handle xptr in registers
storxptr macro
 mov xptr,r14
 mov xptr+ALENG,r15
 endm
loadxptr macro
 mov r14,xptr
 mov r15,xptr+ALENG
 endm
