; Info for one I/O unit number
; Written by Viktors Berstis

UNITSTR STRUCT

UNITSTART EQU   $       ;FIRST BYTE OF UNIT INFO
STRDESC DQ      ?,?,?,? ;Specifier header info for STRING type

UNITPLACE DQ    ?       ;OFFSET WITHIN BLOCK (BUFFER) For output: how much data in UNITBUF to be written
UNITBLOCKE DQ   ?       ;OFFSET OF LAST+1 BYTE IN BLOCK READ INTO UNITBUF (could use just 2 byte number but...)
UNITHANDLE DQ   ?       ;HANDLE FOR IO

UNITVALID DQ    ?       ;This should be set to 12345 to show a valid unit area
UNITVALIDCODE EQU 12345

UNITVSEEK DQ    ?       ;Virtual offset within file (where the user thinks he is)
UNITSKINV DB    ?       ;0=unitvseek valid, 1=invalid (after error)
UNITWASEEK DB   ?       ;Zero if no seeks, 1 if some seeks (non-seq i/o)

UNITPW  DW      ?       ;Special value to mark this as a really open UNIT
UNITPWMK EQU    -25237  ;This is the special value

UNITOPEN DB     ?       ;0=NOT DECIDED, ROPEN=FOR READ, WOPEN=FOR WRITE
ROPEN   EQU     1       ;To be opened for read
WOPEN   EQU     2       ;To be opened for write

CDchanged DB    ?       ;0=current directory not changed, 1=need to restore CWD

UNITEOF DB      ?       ;EOF READ CODE 0-NOT EOF, 1-EOF, 2-EOF ALREADY READ
UNITERROR DB    ?       ;Not zero if system call error occured ####

; Defaults set in FILNAMI and FILENAMO
UNITFLAGS DW    ?       ;FLAGS on=1 off=0     default=0 except for CR and EF     on     off
UNITBIN EQU     1       ;Read/write as BINARY file (no CR-LF 1Ah handling)       -b     -a
UNITNOBUF EQU   2       ;No file buffering                                       -buf   -nbuf
UNITNOTABEX EQU 4       ;TAB expand on read, compress on write (only for ASCII)  -ntabx -tabx
UNITECHO EQU    8       ;Echo input                                              -e     -ne
UNITAPPEND EQU  16      ;Append to existing file on write                        -ap    -r
UNITLCKW EQU    32      ;Lock exclusive / write    ####                          -lw
UNITLCKR EQU    64      ;Lock read allowed         ####                          -lr
UNITPROMPT EQU  128     ;Prompt terminal input with ? mark                       -pr    -npr
UNITVARLEN EQU  256     ;Variable length reads                                   -vl    -fl
UNITIC  EQU     512     ;Include / Implicit concatenation                        -i     -ni
UNITSTD EQU     1024    ;Standard I/O unit named                                 -std
;##### set defaults based on linux or windows
UNITNOCR EQU    2048    ;No carriage return handling output (default 1 windows)  -ncr   -cr
UNITNOEF EQU    4096    ;Use/handle end-of-file charater 1Ah(default 0 windows)  -nef   -ef
UNITDIR EQU     8192    ;Looking at a directory

UNITINCLUDESW   DB      ? ;Not zero if should check for include line
includenamemax equ 512
includename     DB      includenamemax DUP(?) ;peek ahead data on read (for include processing)
        ALIGN   8
includenamelen  DQ      ? ;how much peek data is in UNITPEEK
includecaller   dq      ? ;address of unit invoking this include or zero

UNITNAMEL EQU   512
UNITCD  DB      UNITNAMEL DUP(?) ;Path name for cur dir of file ASCIIZ string
UNITNAME DB     UNITNAMEL DUP(?) ;Path name for file in form of ASCIIZ string

UNITBUFL EQU    1048576 ;Length of I/O buffer
        ALIGN   16
UNITBUF DB      UNITBUFL DUP(?) ;IN/OUT BUFFER

        ALIGN   16                ;Pad with CPD bytes for good measure ## should be at least 8
UNITHERE DB     ?
UNITSIZE EQU    UNITSTR.UNITHERE-UNITSTR.STRDESC ;Size without padding ##### manually set to offset of UNITHERE
UNITSTR ENDS
