; STREAM syntax parser
; Written by Viktors Berstis
; INPUT:
;       OP1 AND OP2
;       rbx      TABLE NUMBER
; INTERNAL:
;       rdi     OP2
;       rsi     CHAR STRING
;       rcx     REMAINING LENGTH
; OUTPUT:
;       rdx     PUT VALUE
; These are essentially state machine parsers


SIL106: ; STREAM Stream for token
; On entry:
; Operand 1 SPEC1 address is in r8
; Operand 2 SPEC2 address is in rdi
; Operand 3 TABLE address is in rbx


; PUT(TAB 'lea r8,' OP1)
; PUT(TAB 'lea rdi,' OP2)
; PUT(TAB 'mov rbx,' OP3)

        mov     rsi,qword ptr [rdi]
        add     rsi,qword ptr [rdi+OOFFSET]
; Operand 2 SPEC2 A+O address is in rsi
        mov     rcx,qword ptr [rdi+LOFFSET]
        shr     rcx,8
; Operand 2 SPEC2 L length is in rcx
        MOV     r9,rcx          ;save original length in r9
        MOV     r10,rdi         ;save SPEC2 address in r10

        SUB     rdx,rdx         ;SET 'PUT' VALUE TO ZERO
        mov     STYPE,rdx       ;Place to return type
        jrcxz   RUNOUT
        push    rbx
        ret

RUNOUT:
        MOV     rsi,rdi         ;SPEC2
        MOV     rdi,r8          ;SPEC1
        MOVSQ
        MOVSQ
        MOVSQ
        MOVSQ
        SUB     rsi,LLENG
        MOV     QWORD PTR [rsi],0 ;SPEC2 L to zero
        MOV     STYPE,rdx       ;SET PUT CODE in STYPE
        cmp     rax,rax         ;set eq flags
        ret

STOP:
        MOV     rsi,rdi         ;SPEC2
        mov     rdi,r8          ;SPEC1
        MOVSQ
        MOVSQ
        MOVSQ

        MOV     rax,r9
        SUB     rax,rcx
        ADD     [r10+OOFFSET],rax ;+J in SPEC2 O field
        shl     rax,8
        SUB     [r10+LOFFSET],rax ;-J in SPEC2 L field
        MOV     [rdi],rax       ;J in SPEC1 L field
        MOV     STYPE,rdx       ;SET PUT CODE in STYPE
        mov     r11,1
        cmp     r11,2           ;set low flags
        ret


STOPSH:
        MOV     rsi,rdi         ;SPEC2
        mov     rdi,r8          ;SPEC1
        MOVSQ
        MOVSQ
        MOVSQ

        MOV     rax,r9
        SUB     rax,rcx
        DEC     rax             ;Change J to J-1
        ADD     [r10+OOFFSET],rax ;+(J-1) in SPEC2 O field
        shl     rax,8
        SUB     [r10+LOFFSET],rax ;-(J-1) in SPEC2 L field
        MOV     [rdi],rax       ;J-1 in SPEC1 L field
        MOV     STYPE,rdx       ;SET PUT CODE in STYPE
        mov     r11,1
        cmp     r11,2           ;set low flags
        ret


ERROR:
        MOV     rsi,rdi         ;SPEC2
        mov     rdi,r8          ;SPEC1
        MOVSQ
        MOVSQ
        MOVSQ
        MOVSQ

        MOV     STYPE,rdx       ;SET PUT CODE in STYPE
        mov     r11,2
        cmp     r11,1           ;set high flags
        ret


FPG     MACRO   TAB,P,G ;FOR(TAB) PUT(P) GOTO(G)
        LOCAL   F
        CALL    TAB
        JNE     F
        MOV     rdx,P   ;PUT P as type
        JMP     G
F:
        ENDM

FPGA    MACRO   TAB,P,G ;FOR(TAB) PUT(P) GOTO(G)
        LOCAL   F
        CALL    TAB
        JNE     F
        LEA     rdx,P   ;PUT P as address
        JMP     G
F:
        ENDM

FPSH    MACRO   TAB,P   ;FOR(TAB) PUT(P) STOPSH
        LOCAL   F
        CALL    TAB
        JNE     F
        MOV     rdx,P   ;PUT P
        JMP     STOPSH
F:
        ENDM

FE      MACRO   TAB     ;FOR(TAB) ERROR
        LOCAL   F
        CALL    TAB
        JNE     F
        JMP     ERROR
F:
        ENDM

FORtSTOP MACRO  TAB     ;FOR(TAB) STOP
        LOCAL   F
        CALL    TAB
        JNE     F
        JMP     STOP
F:
        ENDM

FSH     MACRO   TAB     ;FOR(TAB) STOPSH
        LOCAL   F
        CALL    TAB
        JNE     F
        JMP     STOPSH
F:
        ENDM

FPS     MACRO   TAB,P   ;FOR(TAB) PUT(P) STOP
        LOCAL   F
        CALL    TAB
        JNE     F
        MOV     rdx,P   ;PUT P
        JMP     STOP
F:
        ENDM

FG      MACRO   TAB,G   ;FOR(TAB) GOTO(G)
        LOCAL   F
        CALL    TAB
        JNE     F
        JMP     G
F:
        ENDM

CHK     MACRO   LBL
        and     rcx,rcx
        jz      RUNOUT
        DEC     rcx
        CLD
        LODSB   ;AL,[rsi]
        ENDM


; SYNTAX TABLES: =============================================================

BIOPTB: CHK     BIOPTB
        FPGA PLUS,ADDFN,TBLKTB
        FPGA MINUS,SUBFN,TBLKTB
        FPGA DOT,NAMFN,TBLKTB
        FPGA DOLLAR,DOLFN,TBLKTB
        FPGA STAR,MPYFN,STARTB
        FPGA SLASH,DIVFN,TBLKTB
        FPGA AT,BIATFN,TBLKTB
        FPGA POUND,BIPDFN,TBLKTB
        FPGA PERCENT,BIPRFN,TBLKTB
        FPGA RAISE,EXPFN,TBLKTB
        FPGA ORSYM,ORFN,TBLKTB
        FPGA KEYSYM,BIAMFN,TBLKTB
        FPGA NOTSYM,BINGFN,TBLKTB
        FPGA QUESYM,BIQSFN,TBLKTB
        JMP     ERROR
;===========================================

CARDTB: CHK     CARDTB
        FPSH CMT,CMTTYP
        FPSH CTL,CTLTYP
        FPSH CNT,CNTTYP
        MOV rdx,NEWTYP  ;PUT(NEWTYP)
        JMP     STOPSH
;===========================================

DQLITB: CHK     DQLITB
        FORtSTOP DQUOTE
        JMP     DQLITB ;CONTIN
;===========================================

ELEMTB: CHK     ELEMTB
        FPG NUMBER,ILITYP,INTGTB
        FPG LETTER,VARTYP,VARTB
        FPG SQUOTE,QLITYP,SQLITB
        FPG DQUOTE,QLITYP,DQLITB
        FPS LEFTPAREN,NSTTYP
        JMP     ERROR
;===========================================

EOSTB:  CHK     EOSTB
        FORtSTOP EOS
        JMP     EOSTB ;CONTIN
;===========================================

FLITB:  CHK     FLITB
        FG NUMBER,FLITB
        FG FLTENOT,FLITC
        FSH TERMINATOR
        JMP     ERROR
;===========================================

FLITC:  CHK     FLITC
        FG PLUS,FLITD
        FG MINUS,FLITD
        FG NUMBER,FLITD
        JMP     ERROR
;===========================================

FLITD:  CHK     FLITD
        FG NUMBER,FLITD
        FSH TERMINATOR
        JMP     ERROR
;===========================================

FRWDTB: CHK     FRWDTB
        FG BLANK,FRWDTB
        FPS EQUAL,EQTYP
        FPS RIGHTPAREN,RPTYP
        FPS RIGHTBR,RBTYP
        FPS COMMA,CMATYP
        FPS COLON,CLNTYP
        FPS EOS,EOSTYP
        MOV rdx,NBTYP ;PUT NBTYP
        JMP     STOPSH
;===========================================

GOTFTB: CHK     GOTFTB
        FPS LEFTPAREN,FGOTYP
        FPS LEFTBR,FTOTYP
        JMP     ERROR
;===========================================

GOTOTB: CHK     GOTOTB
        FG SGOSYM,GOTSTB
        FG FGOSYM,GOTFTB
        FPS LEFTPAREN,UGOTYP
        FPS LEFTBR,UTOTYP
        JMP     ERROR
;===========================================

GOTSTB: CHK     GOTSTB
        FPS LEFTPAREN,SGOTYP
        FPS LEFTBR,STOTYP
        JMP     ERROR
;===========================================

IBLKTB: CHK     IBLKTB
        FG BLANK,FRWDTB
        FPS EOS,EOSTYP
        JMP     ERROR
;===========================================

INTGTB: CHK     INTGTB
        FG NUMBER,INTGTB
        FPSH TERMINATOR,ILITYP
        FPG DOT,FLITYP,FLITB
        FPG FLTENOT,FLITYP,FLITC
        JMP     ERROR
;===========================================

LBLTB:  CHK     LBLTB
        FG ALPHANUMERIC,LBLXTB
        FSH BLANK
        FSH EOS
        JMP     ERROR
;===========================================

LBLXTB: CHK     LBLXTB
        FSH BLANK
        FSH EOS
        JMP     LBLXTB
;===========================================

NBLKTB: CHK     NBLKTB
        FE TERMINATOR
        JMP     STOPSH
;===========================================

NUMBTB: CHK     NUMBTB
        FG NUMBER,NUMCTB
        FG PLUS,NUMCTB
        FG MINUS,NUMCTB
        FPSH COMMA,CMATYP
        FPSH COLON,DIMTYP
        JMP     ERROR
;===========================================

NUMCTB: CHK     NUMCTB
        FG NUMBER,NUMCTB
        FPSH COMMA,CMATYP
        FPSH COLON,DIMTYP
        JMP     ERROR
;===========================================

SNABTB: CHK     SNABTB
        SUB     rbx,rbx
        MOV     BL,AL
        LEA     R12,TRTABLE
        ADD     R12,RBX
        MOV     BL,[R12]
        CMP     BL,0
        JE      SNABTB ;CONTIN
        CMP     BL,2
        JE      SNABTBE ;ERROR
        CMP     BL,3
        JE      SNABTBS ;STOP
        JMP     STOPSH  ;STOPSH=4
SNABTBS: JMP    STOP
SNABTBE: JMP    ERROR
;===========================================

SQLITB: CHK     SQLITB
        FORtSTOP SQUOTE
        JMP     SQLITB
;===========================================

STARTB: CHK     STARTB
        FORtSTOP BLANK
        FPGA STAR,EXPFN,TBLKTB
        JMP     ERROR
;===========================================

TBLKTB: CHK     TBLKTB
        FORtSTOP BLANK
        JMP     ERROR
;===========================================

UNOPTB: CHK     UNOPTB
        FPGA PLUS,PLSFN,NBLKTB
        FPGA MINUS,MNSFN,NBLKTB
        FPGA DOT,DOTFN,NBLKTB
        FPGA DOLLAR,INDFN,NBLKTB
        FPGA STAR,STRFN,NBLKTB
        FPGA SLASH,SLHFN,NBLKTB
        FPGA PERCENT,PRFN,NBLKTB
        FPGA AT,ATFN,NBLKTB
        FPGA POUND,PDFN,NBLKTB
        FPGA KEYSYM,KEYFN,NBLKTB
        FPGA NOTSYM,NEGFN,NBLKTB
        FPGA ORSYM,BARFN,NBLKTB
        FPGA QUESYM,QUESFN,NBLKTB
        FPGA RAISE,AROWFN,NBLKTB
        JMP     ERROR
;===========================================

VARATB: CHK     VARATB
        FG LETTER,VARBTB
        FPSH COMMA,CMATYP
        FPSH RIGHTPAREN,RPTYP
        JMP     ERROR
;===========================================

VARBTB: CHK     VARBTB
        FG ALPHANUMERIC,VARBTB
        FG BREAK,VARBTB
        FPSH LEFTPAREN,LPTYP
        FPSH COMMA,CMATYP
        FPSH RIGHTPAREN,RPTYP
        JMP     ERROR
;===========================================

VARTB:  CHK     VARTB
        FG ALPHANUMERIC,VARTB
        FG BREAK,VARTB
        FPSH TERMINATOR,VARTYP
        FPS LEFTPAREN,FNCTYP
        FPS LEFTBR,ARYTYP
        JMP     ERROR
;===========================================

;CHARACTER TABLES =============================================================

ALPHANUMERIC:
        CMP     AL,'0'
        JB      ALNUMF
        CMP     AL,'9'+1
        JB      ALNUMS
        CMP     AL,'A'
        JB      ALNUMF
        CMP     AL,'Z'+1
        JB      ALNUMS
        CMP     AL,'a'
        JB      ALNUMF
        CMP     AL,'z'
        JA      ALNUMF
ALNUMS: SUB     AH,AH
ALNUMF: RET
;===================================

AT:
        CMP     AL,'@'
        RET
;===================================

BLANK:
        CMP     AL,' '
        JE      BLANKS
        CMP     AL,9    ;HORIZ TAB
BLANKS: RET
;===================================

BREAK:
        CMP     AL,'.'
        JE      BREAKS
        CMP     AL,'_'  ;UNDERSCORE
BREAKS: RET
;===================================

CMT:    ; These characters can start a comment line
        CMP     AL,'*'
        JE      CMTS
        CMP     AL,'#'
        JE      CMTS
        CMP     AL,'/'
CMTS:   RET
;===================================

CNT:
        CMP     AL,'+'
        JE      CNTS
        CMP     AL,'.'
CNTS:   RET
;===================================

COLON:
        CMP     AL,':'
        RET
;===================================

COMMA:
        CMP     AL,','
        RET
;===================================

CTL:
        CMP     AL,'-'
        RET
;===================================

DOLLAR:
        CMP     AL,'$'
        RET
;===================================

DOT:
        CMP     AL,'.'
        RET
;===================================

DQUOTE:
        CMP     AL,'"'
        RET
;===================================

EOS:
        CMP     AL,';'
        RET
;===================================

EQUAL:
        CMP     AL,'='
        RET
;===================================

FGOSYM:
        CMP     AL,'F'
        JE      FGOSYMS
        CMP     AL,'f'
FGOSYMS: RET
;===================================

FLTENOT:
        CMP     AL,'e'
        JE      FLTES
        CMP     AL,'E'
FLTES:  RET
;===================================

KEYSYM:
        CMP     AL,'&'
        RET
;===================================

LEFTBR:
        CMP     AL,'<'
        JE      LEFTBRS
        CMP     AL,'['
LEFTBRS: RET
;===================================

LEFTPAREN:
        CMP     AL,'('
        RET
;===================================

LETTER:
        CMP     AL,'A'
        JB      LETTERF
        CMP     AL,'Z'+1
        JB      LETTERS
        CMP     AL,'a'
        JB      LETTERF
        CMP     AL,'z'
        JA      LETTERF
LETTERS: SUB     AH,AH
LETTERF: RET
;===================================

MINUS:
        CMP     AL,'-'
        RET
;===================================

NOTSYM:
        CMP     AL,'~'
        RET
;===================================

NUMBER:
        CMP     AL,'0'
        JB      NUMBERF
        CMP     AL,'9'
        JA      NUMBERF
        SUB     AH,AH
NUMBERF: RET
;===================================

ORSYM:
        CMP     AL,'|'
        RET
;===================================

PERCENT:
        CMP     AL,'%'
        RET
;===================================

PLUS:
        CMP     AL,'+'
        RET
;===================================

POUND:
        CMP     AL,'#'
        RET
;===================================

QUESYM:
        CMP     AL,'?'
        RET
;===================================

RAISE:
        CMP     AL,'!'
        JE      RAISES
        CMP     AL,'^'
RAISES: RET
;===================================

RIGHTBR:
        CMP     AL,'>'
        JE      RIGHTBRS
        CMP     AL,']'
RIGHTBRS: RET
;===================================

RIGHTPAREN:
        CMP     AL,')'
        RET
;===================================

SGOSYM:
        CMP     AL,'S'
        JE      SGOSYMS
        CMP     AL,'s'
SGOSYMS: RET
;===================================

SLASH:
        CMP     AL,'/'
        RET
;===================================

SQUOTE:
        CMP     AL,27H  ;SINGLE QUOTE
        RET
;===================================

STAR:
        CMP     AL,'*'
        RET
;===================================

TERMINATOR:
        CMP     AL,' '
        JE      TERMINS
        CMP     AL,';'
        JE      TERMINS
        CMP     AL,')'
        JE      TERMINS
        CMP     AL,'>'
        JE      TERMINS
        CMP     AL,','
        JE      TERMINS
        CMP     AL,']'
        JE      TERMINS
        CMP     AL,9 ;HORIZ TAB
TERMINS: RET
;===================================

