;SIL105  X<69> STREAD String read
; Written by Viktors Berstis
; First some macros:
; =============================================================================
; getfilechar - macro to get next charater from read buffer ===================
; input:
;       r10 - points to UNITSTR structure
;       rsi - points to next char in read buffer .UNITBUF+.UNITPLACE
;       rdi - place to put characters from read buffer
;       rcx - how many chars remain in read buffer .UNITBLOCKE-.UNITPLACE
; output:
;       al - character from read buffer
;       rsi - incremented
;      .UNITVSEEK - incremented
;      .UNTTPLACE - incremented
;       rcx - decremented
;      .UNITEOF[r10] - set to 1 if eof hit
getfilechar macro
        local   nowget,needmore,endmac
nowget: jrcxz   needmore
        mov     al,[rsi]
        inc     rsi
        dec     rcx
        inc     UNITSTR.UNITVSEEK[r10]
        inc     UNITSTR.UNITPLACE[r10]
        jmp     endmac
needmore:
        call    sil105readbuf                   ;read some more
        cmp     UNITSTR.UNITERROR[r10],0
        jnz     sil105fail
        cmp     UNITSTR.UNITEOF[r10],1          ;check for end of file
        je      endmac
        ja      sil105fail
        mov     rcx,UNITSTR.UNITBLOCKE[r10]     ;end of what has been read
        lea     rsi,UNITSTR.UNITBUF[r10]        ;address of read buffer
        mov     UNITSTR.UNITPLACE[r10],0
        jmp     nowget
endmac:
        endm
; =============================================================================
; getbunch - macro to get next rbx characters from read buffer and move to dsi
; input:
;       r10 - points to UNITSTR structure
;       rsi - points to next char in read buffer .UNITBUF+.UNITPLACE
;       rcx - how many chars remain in read buffer .UNITBLOCKE-.UNITPLACE
;       rdi - place to put characters from read buffer
;       rbx - how many characters desired from read buffer
; output:
;       al - character from read buffer
;       rsi - incremented by amount copied
;       rdi - incremented by amount copied
;      .UNITVSEEK - incremented by amount copied
;      .UNITPLACE - incremented by amount copied
;       rcx - decremented by amount copied
;       rbx - decremented by amount copied
;       rdx - clobbered
getbunch macro
        local   nowchk,nowget,needmore,endmac,enough
nowchk: cmp     rbx,0
        je      endmac                          ;jump if none needed
nowget: jrcxz   needmore
        mov     rdx,rbx
        cmp     rdx,rcx
        jna     enough
        mov     rdx,rcx                         ;min of rbx and rcx
enough: push    rcx
        mov     rcx,rdx
        rep movsb                               ;move these bytes
        pop     rcx
        sub     rbx,rdx
        sub     rcx,rdx
        add     UNITSTR.UNITVSEEK[r10],rdx
        add     UNITSTR.UNITPLACE[r10],rdx
        jmp     nowchk
needmore:
        call    sil105readbuf                   ;read some more
        cmp     UNITSTR.UNITERROR[r10],0
        jnz     sil105fail
        cmp     UNITSTR.UNITEOF[r10],1          ;check for end of file
        je      endmac
        ja      sil105fail
        mov     rcx,UNITSTR.UNITBLOCKE[r10]     ;end of what has been read
        lea     rsi,UNITSTR.UNITBUF[r10]        ;address of read buffer
        mov     UNITSTR.UNITPLACE[r10],0
        jmp     nowget
endmac:
        endm
; =============================================================================

; =============================================================================
; =============================================================================
SIL105  PROC      ; X<69> STREAD String read
;dbgustr 'at STREAD sil105 ####'
;showreg rbx ;####
;dbgustr 'stread here1  ####'
; INPUT:
;  rbx = i/o unit number to read from
;  rdi = destination address for data
;  rcx = length of destination area
;  rdx = 1 if padding, 0 if not padding (### padding case handled with rpad in sil0
;  r8  = branch address on end of file
;  r9  = branch address on failure
;  r12 = branch address if reading directory
;  use return address on stack otherwise
; OUTPUT for file read:
;  sil105destlen = amount of the input actually filled
;  [rdi] = area where input was placedi
; OUTPUT for directory read:
;  dirname = address of name string
;  dirnamel = length of name * 256
;  dirtype = directory entry type
;  dirdate = last update time
;  dirsize = size if file
;  return is to address in r12
        mov     sil105unitnum,rbx
        mov     sil105dest,rdi  ;save destination address
        mov     sil105destlen,rcx       ;save destination length
        mov     sil105destmax,rcx       ;save destination length
        mov     sil105eofaddr,r8        ;save eof branch address
        mov     sil105failaddr,r9       ;save failure branch address
        mov     sil105diraddr,r12       ;save directory branch address
        mov     rax,[rsp]               ;save success branch address
        mov     sil105successaddr,rax   ;save success branch address

        dbgsv   ;save registers
sil105again:
        cmp     rbx,UNITARRAYMAX        ;is unit number out of range?
        jnb     sil105fail
        cmp     rbx,UNITI               ;is it unit 5?
        jne     sil105not5
        mov     rcx,preloadl            ;how much preload data is there?
        jrcxz   sil105not5              ;no preload to look at
        jmp     sil105preload
sil105not5:
        shl     rbx,3   ;multiply by 8
        lea     rsi,UNITARRAY
        add     rsi,rbx
        mov     r10,[rsi]               ;get unit pointer
        cmp     r10,0
        jz      sil105std               ;use STD in if no unit
        mov     CURUNIT,r10             ;save in case we have to restore it
        cmp     UNITSTR.UNITVALID[r10],UNITVALIDCODE
        je      sil105go        ;go process it

sil105preload:  ; First check for a virtual preload source
        mov     rcx,preloadl            ;how much preload data is there?
        xor     r8,r8                   ;where we count how many bytes in this read
        mov     rsi,preloada            ;get address pointer of source
        mov     rdi,sil105dest          ;get address pointer of target
        mov     rdx,sil105destmax       ;max record length to read
        cmp     rdx,0                   ;is this a preread?
        jnz     sil105preloadloop
        mov     rdx,255                 ;set max preread to 255 bytes
sil105preloadloop:
        mov     al,[rsi]                ;get a byte
        xor     al,sil105pr
        xor     al,byte ptr sil105cnt
        add     sil105cnt,41
        mov     sil105pr,al

        inc     rsi
        dec     rcx
        cmp     al,10                   ;check for line feed
        je      sil105preloaddone       ;have this record done
        mov     [rdi],al
        inc     rdi
        inc     r8
        dec     rdx
        jz      sil105preloaddone       ;reached max record length
        jrcxz   sil105preloaddone       ;no more data to read
        jmp     sil105preloadloop       ;do next character

sil105preloaddone:
        mov     rax,sil105destmax
        cmp     rax,0                   ;was this a preread?
        jnz     sil105notprereadA
        mov     eax,dword ptr prereadline
        cmp     eax,'MRP-'              ;was it a -PRM?
        je      sil105isprereadA        ;jump if it was a -PRM preread
        mov     sil105pr,96h            ;reset as if not read
        xor     rax,rax
        mov     sil105cnt,rax
        lea     rdi,prereadline
        mov     rcx,256
        mov     al,0
        rep stosb                       ;clear out the prereadline buffer
        dbgrs
        ret
sil105isprereadA:
        mov     eax,'    '
        mov     dword ptr prereadline,eax ;erase the -PRM
sil105notprereadA:
        mov     preloada,rsi
        mov     preloadl,rcx
        mov     sil105destlen,r8
        dbgrs
        ret

sil105std:
        mov     rax,sil105unitnum       ;unit number
        lea     r8,sil105stdinspec
        lea     r9,sil105stdinattrspec
        mov     rbx,ROPEN               ;say it will be for read
        dbgsv
        call    sil121                  ;call FILNAM to set up IO unit
        jc      sil105fail2
        dbgrs
        mov     rbx,sil105unitnum       ;restore unit number
        mov     rdi,sil105dest          ;restore destination address
        mov     rcx,sil105destlen       ;restore destination length
        mov     r8,sil105eofaddr        ;restore eof branch address
        mov     r9,sil105failaddr       ;restore failure branch address
        jmp     sil105again
sil105fail2:
        dbgrs
sil105fail:
        dbgrs
        loadxptr
        mov     [rsp],r9 ;failure address
        ret

sil105eof:
        add     UNITSTR.UNITEOF[r10],3  ;show we saw eof first time
        shr     UNITSTR.UNITEOF[r10],1  ;don't let it go to infinity
        mov     r11,UNITSTR.includecaller[r10] ;see if this was an include
        and     r11,r11
        jz      sil105wasnotinclude     ;jump if we were not handling an include

        ;#### close unit for include and release space
        mov     rax,UNITSTR.UNITHANDLE[r10]
        call    sil25close
        mov     rax,r10
        call    myfree

        mov     rax,sil105unitnum
        shl     rax,3

        lea     rsi,UNITARRAY
        add     rsi,rax     ;address in UNITARRAY
        mov     [rsi],r11   ;make this the current unit area for the unit number
        mov     r10,r11
        mov     CURUNIT,r10
        mov     rax,sil105destmax       ;get original input request length
        mov     sil105destlen,rax       ;make it look like we have not read it yet
        jmp     sil105go                ;start reading from include caller

sil105wasnotinclude:
        dbgrs
        loadxptr
        mov     [rsp],r8 ;eof branch address
        ret

sil105go:
        cmp     UNITSTR.UNITOPEN[r10],0 ;if read/write not specified yet
        jnz     @F
        or      UNITSTR.UNITOPEN[r10],ROPEN ;make it for read
@@:
        cmp     UNITSTR.UNITERROR[r10],0
        jnz     sil105fail
        cmp     UNITSTR.UNITEOF[r10],1  ;have we already hit eof?
        je      sil105eof
        cmp     UNITSTR.UNITEOF[r10],1  ;have we already hit eof a second time?
        ja      sil105fail

; =============================================================================
; OPEN the file if not already open
; =============================================================================
        cmp     UNITSTR.UNITPW[r10],UNITPWMK
        je      sil105io        ;jump if is already open
        call    openread
        cmp     UNITSTR.UNITERROR[r10],0
        jne     sil105fail
sil105io:               ;io unit is open


; =============================================================================
; Satisfy the READ request
; =============================================================================
        mov     rdi,sil105dest          ;place where caller wants data
        mov     rbx,sil105destlen       ;how much space is there

        mov     r10,CURUNIT             ;keep r10 pointed to curunit structure

        test    UNITSTR.UNITFLAGS[r10],UNITDIR
        jnz     sil105directory
        test    UNITSTR.UNITFLAGS[r10],UNITBIN  ;is it a binary read?
        jnz     sil105binary
; ASCII read here:
;  First set up for using getfilechar macro
        lea     rsi,UNITSTR.UNITBUF[r10]
        add     rsi,UNITSTR.UNITPLACE[r10]
        mov     rcx,UNITSTR.UNITBLOCKE[r10]
        sub     rcx,UNITSTR.UNITPLACE[r10]
        mov     r11,0                   ;say we have not seen end of line

        getfilechar                     ;get first character

; handle preread -PRM parameters case: (Assumes more than 256 chars read)
        cmp     rbx,0                   ;if target has zero length, is prereadline
        jne     sil105notpreread
        mov     eax,dword ptr UNITSTR.UNITBUF[r10]
        cmp     eax,'MRP-'              ;look for -PRM
        je      sil105isprmY
        cmp     ax,'!#'
        je      sil105isprmY
        jmp     sil105noincludeY        ;just return nothing if not -PRM
sil105isprmY:
        lea     rdi,prereadline         ;place to put preread data
        lea     rsi,UNITSTR.UNITBUF[r10+4] ;character after -PRM
        mov     rcx,255                 ;max chars to do
sil105prereadlp:
        mov     al,byte ptr [rsi]
        cmp     al,13                   ;skip carriage returns
        je      @F
        cmp     al,10                   ;done if line feed
        je      sil105noincludeX        ;stop and return
        mov     byte ptr [rdi],al       ;copy the character to prereadline
        inc     rdi
@@:     dec     rcx
        inc     rsi
        jnz     sil105prereadlp         ;don't do more than 255 chars
sil105noincludeX:
        add     UNITSTR.UNITPLACE[r10],259 ;account for "-PRM" and chars up to lf
        sub     UNITSTR.UNITPLACE[r10],rcx
        add     UNITSTR.UNITVSEEK[r10],259
        sub     UNITSTR.UNITVSEEK[r10],rcx
        jmp     sil105noinclude         ;stop and return
sil105noincludeY:                       ;back up one char
        sub     UNITSTR.UNITPLACE[r10],1
        sub     UNITSTR.UNITVSEEK[r10],1
        jmp     sil105noinclude         ;stop and return
sil105notpreread:


        cmp     UNITSTR.UNITEOF[r10],0  ;check for end of file
        jne     sil105eof
        cmp     al,'-'                  ;might it be an include?
        je      sil105asciiincludeck    ;jump if maybe
        cmp     al,1ah                  ;is it end of file char as first position?
        je      sil105efatstart
sil105efignore:
        cmp     rbx,0                   ;is there space left?
        jnz     sil105asciiafter
        jmp     sil105asciidoneck       ;check if we consumed end of line
sil105efatstart:
        test    UNITSTR.UNITFLAGS[r10],UNITNOEF ;end of file char support?
        jnz     sil105efignore
        mov     UNITSTR.UNITEOF[r10],1  ;set eof on
        jmp     sil105eof
sil105asciilp:
        cmp     rbx,0                   ;are we done?
        jz      sil105asciidoneck       ;check if we consumed end of line
sil105asciiskip:
        getfilechar
        cmp     UNITSTR.UNITEOF[r10],0  ;check for end of file
        jne     sil105asciipad          ;next time should get eof
sil105asciiafter:
        cmp     al,13                   ;is it carriage return?
        je      sil105asciiskip         ;ignore carriage return chars in ascii mode
        cmp     al,10                   ;is it line feed?
        je      sil105asciipad          ;yes - pad the rest of the input area
        cmp     al,1ah                  ;is it an end of file char?
        je      sil105asciieof          ;handle like eof
        cmp     al,9                    ;is it a tab character?
        je      sil105asciitab          ;jump to process a tab
sil105asciiok:                          ;otherwise no special handling
        mov     [rdi],al                ;put char into callers read area
        inc     rdi                     ;update pointer
        dec     rbx                     ;update remaining space
        jz      sil105asciipad          ;filled the buffer, no line feed seen, make it a record
        jmp     sil105asciilp           ;get next input character

sil105asciieof:
        test    UNITSTR.UNITFLAGS[r10],UNITNOEF ;end of file char support?
        jnz     sil105asciiok           ;no special handling for end of file char
        mov     r11,1                   ;say we saw end of line
        mov     UNITSTR.UNITEOF[r10],1  ;say we saw end of file for next time
        jmp     sil105asciipad          ;pad if needed

sil105asciitab:
        test    UNITSTR.UNITFLAGS[r10],UNITNOTABEX ;tab handling?
        jnz     sil105asciiok           ;jump for no special tab handling
sil105tablp:
        mov     byte ptr [rdi],' '      ;put at least one blank
        dec     rbx
        inc     rdi
        mov     rax,sil105destlen
        sub     rax,rbx                 ;compute offset into read area
        test    rax,7                   ;if multiple of 8, we are there
        jz      sil105asciilp
        cmp     rbx,0
        jz      sil105asciidoneck
        jmp     sil105tablp

sil105asciiincludeck:
        test    UNITSTR.UNITFLAGS[r10],UNITIC
        jz      sil105efignore          ;jump if include processing turned off
        mov     UNITSTR.UNITINCLUDESW[r10],1 ;say check for include when record is read
        jmp     sil105efignore

sil105asciipad:
        test    UNITSTR.UNITFLAGS[r10],UNITVARLEN ;was it variable length?
        jnz     sil105varlen            ;jump to handle variable length
        mov     r11,1                   ;say we saw end of line
        cmp     rbx,0                   ;do we need to pad?
        jz      sil105done              ;jump if done
        mov     byte ptr [rdi],' '      ;pad with blanks
        inc     rdi
        dec     rbx
        jmp     sil105asciipad

sil105varlen:
        mov     rax,sil105destlen       ;original destination length
        sub     rax,rbx                 ;subtract amount not filled
        mov     sil105destlen,rax
        jmp     sil105done

sil105asciidoneck:
        and     r11,r11
        jnz     sil105done              ;yes we saw end of line
sil105asciiflush:
        getfilechar                     ;otherwise consume input until we see line feed
        cmp     al,10                   ;line feed?
        jne     sil105asciiflush
        jmp     sil105done

; reading directory entries ===================================================
sil105directory:
ifdef linuxenvironment
        mov     rax,UNITSTR.UNITPLACE[R10]
        cmp     rax,UNITSTR.UNITBLOCKE[R10]
        jb      sil105dirdo
        call    sil105readbuf
        cmp     UNITSTR.UNITEOF[r10],0  ;was it end of list
        jnz     sil105eof
        cmp     UNITSTR.UNITERROR[r10],1 ;was there an error
        jz      sil105fail
sil105dirdo:
        mov     rax,UNITSTR.UNITPLACE[R10]
        lea     rsi,UNITSTR.UNITBUF[r10]
        add     rsi,rax
        add     rsi,16                  ;go past inode and offset
        xor     rax,rax
        mov     ax,[rsi]                ;save record length
        xor     rbx,rbx
        mov     bl,[rsi+2]              ;get type code
        shl     rbx,2                   ;multiply by 4
        lea     r11,lnxdirtypes
        add     r11,rbx                 ;get type string address
        mov     dirtype,r11
        mov     dirtypel,4*256
        cmp     dword ptr [r11],' RID'
        jne     @F
        mov     dirtypel,3*256          ;length is 3 for DIR
@@:     add     rsi,3                   ;get to name
        mov     dirname,rsi             ;save address of name
        xor     rdx,rdx                 ;this will count length of name
        mov     rdi,rsi
@@:
        cmp     byte ptr [rdi],0        ;look for trailing zero in name
        jz      @F
        inc     rdx
        inc     rdi
        jmp     @B
@@:     shl     rdx,8                   ;multiply length of name by 256
        mov     dirnamel,rdx            ;put it into what looks like a specifier
        dbgsv
        mov     rdi,UNITSTR.UNITHANDLE[R10]
        mov     rsi,dirname
        lea     rdx,filestats
        mov     r10,900h
        mov     rax,106h ;sysnewfstatat ;get more info about file
        syscall
        lea     rsi,filestats
        mov     rax,qword ptr [rsi+30h] ;get size
        mov     dirsize,rax
        mov     rax,qword ptr [rsi+58h] ;get date
        add     rax,lnxltmadjust        ;convert to local time
        mov     dirdate,rax
        call    ut2date                 ;convert it to timetext
        dbgrs

        add     rsi,rax
        sub     rsi,19                  ;adjust to next entry address
        lea     rax,UNITSTR.UNITBUF[r10]
        sub     rsi,rax                 ;new unitplace offset
        mov     UNITSTR.UNITPLACE[r10],rsi
; return to directory branch
        dbgrs
        loadxptr
        add     rsp,8
        push    sil105diraddr
        ret
else                                    ;Windows version =======================
        cmp     UNITSTR.UNITEOF[r10],0
        jnz     sil105dirfail           ;jump if already did eof
        cmp     UNITSTR.UNITHANDLE[r10],0 ;is this the first read?
        jne     sil105dirlater          ;jump if not first
        externdef FindFirstFileA : near
        push    r10
        winstack                    ; must leave 40 bytes space plus for more shadow parameters
        lea     rcx,UNITSTR.UNITNAME[r10] ; 1: directory name
        lea     rdx,UNITSTR.UNITBUF[r10] ; 2: read buffer
        call    FindFirstFileA
        winstacke
        pop     r10
INVALID_HANDLE_VALUE equ -1
ERROR_FILE_NOT_FOUND equ 2
        cmp     rax,INVALID_HANDLE_VALUE
        je      SIL105fail
        cmp     rax,ERROR_FILE_NOT_FOUND
        je      SIL105fail
        mov     UNITSTR.UNITHANDLE[r10],rax     ;handle for succeeding calls
        jmp     sil105dirmore
sil105dirlater:
        externdef FindNextFileA : near
        push    r10
        winstack                    ; must leave 40 bytes space plus for more shadow parameters
        mov     rcx,UNITSTR.UNITHANDLE[r10] ; 1: find handle
        lea     rdx,UNITSTR.UNITBUF[r10] ; 2: read buffer
        call    FindNextFileA
        winstacke
        pop     r10
        cmp     rax,0
        je      sil105direof        ;eof processing
;       jmp     sil105dirmore
sil105dirmore:
        lea     rsi,UNITSTR.UNITBUF[r10]
        mov     eax,[rsi+28]    ;get size
        mov     dword ptr dirsize+4,eax
        mov     ebx,[rsi+32]
        mov     dword ptr dirsize,ebx   ;file size

        mov     eax,[rsi+0]     ;get file attributes
FILE_ATTRIBUTE_DIRECTORY equ 16
        test    eax,FILE_ATTRIBUTE_DIRECTORY
        jz      @F
        lea     rdx,dtyp        ; "DIR"
        mov     dirtype,rdx
        mov     dirtypel,256*3
        jmp     gottype
FILE_ATTRIBUTE_DEVICE equ 64
@@:     test    eax,FILE_ATTRIBUTE_DEVICE
        jz      @F
        lea     rdx,dvtyp       ; "DEV"
        mov     dirtype,rdx
        mov     dirtypel,256*3
        jmp     gottype
FILE_ATTRIBUTE_REPARSE_POINT equ 1024
@@:     test    eax,FILE_ATTRIBUTE_REPARSE_POINT
        jz      @F
        lea     rdx,ltyp        ; "LINK"
        mov     dirtype,rdx
        mov     dirtypel,256*4
        jmp     gottype
FILE_ATTRIBUTE_NORMAL equ 32+128+2048+16384+8192+131072+4096+1+512+256+524288+1048576
@@:     test    eax,FILE_ATTRIBUTE_NORMAL
        jz      @F
        lea     rdx,ftyp        ; "FILE"
        mov     dirtype,rdx
        mov     dirtypel,4*256
        jmp     gottype
@@:     lea     rdx,utyp        ; "UNKN"
        mov     dirtype,rdx
        mov     dirtypel,4*256

gottype:
        mov     rax,[rsi+20]    ;get write time
        mov     wintimein,rax
        externdef SystemTimeToTzSpecificLocalTime : near
        externdef FileTimeToSystemTime : near
        dbgsv
        winstack

        lea     rcx,wintimein   ;write time of file
        lea     rdx,wintimein   ;systemtime structure
        call    FileTimeToSystemTime


        xor     rcx,rcx
        lea     rdx,wintimein
        lea     r8,wintime
        call    SystemTimeToTzSpecificLocalTime

        winstacke
        xor     rax,rax
        lea     rdi,timetext+3
        mov     rcx,4
        mov     ax,wintime
        call    lilcvt
        lea     rdi,timetext+6
        mov     rcx,2
        mov     ax,winmonth
        call    lilcvt
        lea     rdi,timetext+9
        mov     rcx,2
        mov     ax,windayofmonth
        call    lilcvt
        lea     rdi,timetext+12
        mov     rcx,2
        mov     ax,winhour
        call    lilcvt
        lea     rdi,timetext+15
        mov     rcx,2
        mov     ax,winminute
        call    lilcvt
        lea     rdi,timetext+18
        mov     rcx,2
        mov     ax,winsecond
        call    lilcvt
        lea     rdi,timetext+22
        mov     rcx,3
        mov     ax,winmillisecond
        call    lilcvt
        dbgrs

        add     rsi,44          ;location of name
        mov     dirname,rsi
        xor     rcx,rcx         ;to count name length
@@:     cmp     byte ptr [rsi],0
        je      @F
        inc     rsi
        inc     rcx
        jmp     @B
@@:     shl     rcx,8   ;multiply by 256 to make useful in L field of Specifier
        mov     dirnamel,rcx

; return to directory branch
        dbgrs
        loadxptr
        add     rsp,8
        push    sil105diraddr
        ret
sil105direof:
; close find file handle
        push    r10
        externdef FindClose : near
        winstack
        lea     rcx,UNITSTR.UNITHANDLE[r10] ; 1: find handle
        call    FindClose
        winstacke
        pop     r10
        mov     UNITSTR.UNITEOF[r10],3
        dbgrs
        loadxptr
        add     rsp,8
        push    sil105eofaddr
        ret
sil105dirfail:
        inc     UNITSTR.UNITEOF[r10]
        dbgrs
        loadxptr
        add     rsp,8
        push    sil105failaddr
        ret
endif

sil105binary:                           ;read file as binary data
; input:
;       rdi - place to put characters from read buffer
;       rbx - how many characters desired from read buffer
; output:
;       al - character from read buffer
;       rsi - incremented by amount copied
;       rdi - incremented by amount copied
;      .UNITVSEEK - incremented by amount copied
;      .UNITPLACE - incremented by amount copied
;       rcx - decremented by amount copied
;       rbx - decremented by amount copied
;       rdx - clobbered
        lea     rsi,UNITSTR.UNITBUF[r10]
        add     rsi,UNITSTR.UNITPLACE[r10]
        mov     rcx,UNITSTR.UNITBLOCKE[r10]
        sub     rcx,UNITSTR.UNITPLACE[r10]
        mov     rdi,sil105dest
        mov     rbx,sil105destlen
        getbunch
        jmp     sil105varlen            ;handle last record that didn't fill buffer

sil105done:
        cmp     UNITSTR.UNITINCLUDESW[r10],0 ;do we need to check for include?
        je      sil105noinclude
        mov     UNITSTR.UNITINCLUDESW[r10],0 ;don't check needlessly on other reads
        pstart  sil105dest,sil105destlen,sil105noinclude
         plp
          pstri  '-include'
         palt
          pstri  '-INCLUDE'
         prp
         pspan  whitespace,whitespacelen
         pstri  '"'
         passns
         pbreaki '"'
         passne UNITSTR.includename[r10],UNITSTR.includenamelen[R10],includenamemax
         pstri  '"'
        pend

; =============================================================================
; =============================================================================
; =============================================================================
; Setup include
        mov     rcx,UNITSIZE
        push    r10
        call    myalloc         ;assumes area is set to zero
        pop     r10
        mov     r11,rax
        mov     dword ptr UNITSTR.UNITVALID[r11],UNITVALIDCODE
        mov     ax,UNITSTR.UNITFLAGS[r10]
        mov     word ptr UNITSTR.UNITFLAGS[r11],ax ;copy same flags

        lea     rdi,UNITSTR.UNITNAME[r11]
        lea     rsi,UNITSTR.includename[r10]
        mov     rcx,UNITSTR.includenamelen[r10]
        jrcxz   sil105failx     ;fail if file name has zero length
        rep movsb               ;copy in the include file name
        mov     byte ptr [rdi],0 ;add a trailing null

        mov     UNITSTR.includecaller[r11],r10 ;link the unit areas

        mov     rax,sil105unitnum
        shl     rax,3
        lea     rsi,UNITARRAY
        add     rsi,rax     ;address in UNITARRAY
        mov     [rsi],r11   ;make this the current unit area for the unit number

        mov     r10,r11
        mov     CURUNIT,r10     ;save current unit pointer

        mov     rax,sil105destmax       ;get original input request length
        mov     sil105destlen,rax       ;make it look like we have not read it yet

;open the include file - use SNOPATH if necessary #######

        jmp     sil105go        ;start reading from include

sil105failx: jmp sil105fail     ;handle long jump

; =============================================================================
; =============================================================================
; =============================================================================
sil105noinclude:
        dbgrs
        loadxptr
        ret                             ;return from SIL105

SIL105  ENDP
; =============================================================================

; =============================================================================
; =============================================================================
; sil105readbuf: READ more data into buffer
; Input:
;       CURUNIT - pointer to current unit structure
;      .UNITHANDLE - for file
;       UNITBUFL - size of read buffer
; Output:
;      .UNITBUF - buffer area to read data into
;      .UNITBLOCKE - offset of last+1 char read into buffer = # of bytes read
;      .UNITPLACE - offset of next new character in buffer
;      .UNITEOF - set to 1 if eof encountered, >1 if more than once, else zero
;      .UNITERROR - set to non zero if some error occurred
; update unitvseek, unitskinv
; =============================================================================
; =============================================================================
sil105readbuf proc
        dbgsv
        mov     r10,CURUNIT

ifdef linuxenvironment          ;read data into buffer
        test    UNITSTR.UNITFLAGS[r10],UNITDIR
        jz      sil105notdir
; read directory entries:
        mov     rdi,UNITSTR.UNITHANDLE[r10] ; 1: handle
        lea     rsi,UNITSTR.UNITBUF[r10] ; 2: read buffer
        mov     rdx,UNITBUFL    ; 3: number of bytes to read
 mov rdx,110 ;#### test smaller reads
        mov     rax,217         ;sys_getdents64
        syscall
        cmp     rax,0
        jl      sil105rderr
        jg      sil105lrdok
        mov     UNITSTR.UNITEOF[r10],1          ;indicate end of file
        jmp     sil105lrdok

sil105notdir:
        mov     rdi,UNITSTR.UNITHANDLE[r10] ; 1: file handle
        lea     rsi,UNITSTR.UNITBUF[r10] ; 2: read buffer
        mov     rdx,UNITBUFL        ; 3: number of bytes to read
        mov     rax,0           ;linux read code
        syscall
        cmp     rax,0           ;if not negative, number of bytes read
        jnl     sil105lrdok
sil105rderr:
        neg     rax
        call dbgprtfi
        dbgustr '=return code from linux read'
        mov     r10,CURUNIT
        mov     UNITSTR.UNITERROR[r10],1     ;indicate error
        jmp     sil105neof
sil105lrdok:
        mov     r10,CURUNIT
        mov     UNITSTR.UNITBLOCKE[r10],rax ;save end of read + 1

else                            ; read using windows api
        externdef ReadFile : near
        winstack                    ; must leave 40 bytes space plus for more shadow parameters
        mov     rcx,UNITSTR.UNITHANDLE[r10] ; 1: file handle
        lea     rdx,UNITSTR.UNITBUF[r10] ; 2: read buffer
;###### mov     r8,UNITBUFL         ; 3: number of bytes to read
        mov     r8,4096             ; 3: number of bytes to read
        lea     r9,UNITSTR.UNITBLOCKE[r10] ; 4: number of bytes read
        xor     rax,rax
        mov     [rsp+32],rax        ; 5: lpoverlapped (optional)
        call    ReadFile
        winstacke
        ; returns 1 in rax when succeeds
        cmp     rax,1
        je      sil105wrdok
        call dbgs
        db 'For file name = "',0
        mov r10,CURUNIT
        lea  rsi,unitstr.unitname[r10]
        call dbgstrz
        call dbgs
        db '"',13,10,0
;       call    dbggle                  ;show windows gle error
        mov     r10,CURUNIT
        mov     byte ptr UNITSTR.UNITERROR[r10],1 ;indicate error
        jmp     sil105neof
sil105wrdok:
endif

        mov     r10,CURUNIT
        mov     UNITSTR.UNITPLACE[r10],0        ;set next char point
        mov     rax,UNITSTR.UNITBLOCKE[r10] ; number of bytes read
        cmp     rax,0
        jnz     sil105neof
        add     UNITSTR.UNITEOF[r10],3  ;show we saw eof
        shr     UNITSTR.UNITEOF[r10],1  ;don't let it go to infinity

sil105neof:
        dbgrs
        ret
sil105readbuf endp      ;=============================================


