; SIL code for OUTPUT
; Written by Viktors Berstis
SIL104  PROC            ;OUTPUT - output record #### not really done yet

;*        STPRNT    &D1,&D2,&SP
;*        PLB(104,4,'DDDI')
;*STPRNT=  OP4 = '1'
;STPRNT= PUT(LABELCO TAB 'mov r10,' OP2)
;        PUT(TAB 'mov r10,[R10+DESCR]')
;        PUT(TAB 'mov rsi,' OP3)
;        PUT(TAB 'add rsi,qword ptr [' OP3 '+OOFFSET]')
;        PUT(TAB 'mov rcx,qword ptr [' OP3 '+LOFFSET]')
;        PUT(TAB 'shr rcx,8')
;        PUT(TAB 'call SIL104') DIFFER("#### not done")          :(STMT)
        xor     rax,rax
        mov     IOERCL,rax

sil104again:

        mov     r12,r10                 ;save unit number in case we need it later
        cmp     r10,0                   ;check for bad unit number
        jz      SIL104bad
        cmp     r10,UNITARRAYMAX
        jnl     SIL104bad
        shl     r10,3                   ;multiply by 8
        lea     r11,UNITARRAY
        add     r11,r10                 ;unit structure address
        mov     r10,qword ptr [r11]
        cmp     r10,0                   ;allocated?
        je      SIL104default
        cmp     UNITSTR.UNITVALID[r10],UNITVALIDCODE
        jne     SIL104default2          ;not really a unit structure
        mov     CURUNIT,r10
sil104show:
        cmp     UNITSTR.UNITPW[r10],UNITPWMK
        je      sil104isopen

        test    UNITSTR.UNITOPEN[r10],WOPEN+ROPEN ;do we know if I or O?
        jnz     @F
        or      UNITSTR.UNITOPEN[r10],WOPEN ;make it for write if uncertain
@@:
        call    openwrit
sil104isopen:
        cmp     UNITSTR.UNITOPEN[r10],WOPEN
        jne     sil104error             ;make sure it was open for write
        test    UNITSTR.UNITFLAGS[r10],UNITBIN  ;is this a binary write?
        jnz     sil104binary
; ASCII write ==================================================================
        test    UNITSTR.UNITFLAGS[r10],UNITNOTABEX ;compress to use tabs?
        jz      sil104tabproc

        call    dowrite
        jc      sil104baderror

        lea     rsi,crlf
        mov     rcx,2
        test    UNITSTR.UNITFLAGS[r10],UNITNOCR
        jz      sil104docr
        inc     rsi                     ;don't write the carriage return
        dec     rcx
sil104docr:
        mov     r10,CURUNIT
        call    dowrite
        jc      sil104baderror
        clc
        ret

sil104error:
        dbgustr 'attempt to write to IO unit open for read ####'
        stc
        ret
sil104baderror:
        stc
        ret


; TAB processing ===============================================================
sil104tabproc:
        xor     rbx,rbx                 ;virtual offset in record
        xor     r8,r8                   ;virtual offset of last non white space character
sil104continue:
        lea     rdi,UNITSTR.UNITBUF[r10] ; work area
        mov     rdx,UNITBUFL            ;output record length
sil104tablp:
        jrcxz   sil104wsdone            ;rcx = how many characters yet to process
        mov     al,[rsi]
        inc     rsi
        dec     rcx                     ;decrement source length
        cmp     al,' '                  ;is it a blank?
        je      sil104blank
        cmp     al,9                    ;is it a tab?
        je      sil104tab
        cmp     al,13                   ;if it a carriage return. reset tab processing
        jne     @F
        xor     rbx,rbx
        xor     r8,r8
        dec     rbx
        dec     r8
@@:
        cmp     al,10                   ;if it a line feed, reset tab processing
        jne     @F
        xor     rbx,rbx
        xor     r8,r8
        dec     rbx
        dec     r8
@@:
        mov     [rdi],al                ;copy non-white space character
        inc     rdi
        inc     r8                      ;increment offset of last non white space
        inc     rbx
        dec     rdx                     ;how much output area space left
        jnz     sil104tablp             ;have we run out of
; write out what is in the buffer
        call    writwork
        jc      sil104baderror
        jmp     sil104tablp

sil104wsdone:
        test    UNITSTR.UNITFLAGS[r10],UNITNOCR
        jnz     sil104ncr
        mov     byte ptr [rdi],13       ;add carriage return
        inc     rdi
        dec     rdx
        jnz     sil104ncr
        call    writwork
        jc      sil104baderror
sil104ncr: mov  byte ptr [rdi],10       ;add line feed
        dec     rdx
        call    writwork
        jc      sil104baderror
        ret

sil104tab:
        add     rbx,8
        and     rbx,tabmask             ;increment to next tab offset
        jmp     sil104next
sil104blank:
        inc     rbx                     ;increment virtual offset by one
sil104next:
        jrcxz   sil104wsdone            ;done if just trailing white space
        mov     al,[rsi]                ;get next output character
        inc     rsi
        dec     rcx
        cmp     al,' '                  ;is it another blank?
        je      sil104blank
        cmp     al,9                    ;is it another tab?
        je      sil104tab
;non white space character found
; rbx is where non white char should go, r8 is where last non white space was
sil104norunout:
        mov     r9,r8                  ;calculate next tab place after last non space char
        add     r9,8
        and     r9,tabmask             ;turn off 3 low order bits to get next tab point
        cmp     r9,rbx                 ;does white space take us to less than next tab spot?
        jle     sil104addatab
;now pad only with blanks
        cmp     r8,rbx
        jnl     sil104wsend             ;end of white space
        mov     byte ptr [rdi],' '      ;add a blank
        inc     rdi
        inc     r8
        dec     rdx
        jnz     sil104norunout
        call    writwork                ;work buffer full, write it
        jc      sil104baderror
        jmp     sil104norunout

sil104addatab:
        inc     r8
        cmp     r8,rbx                  ;if a blank instead of a tab will do
        jne     sil104yestab
        mov     byte ptr [rdi],32       ;use just a blank
        jmp     sil104notab
sil104yestab:
        mov     byte ptr [rdi],9        ;add a tab
sil104notab:
        inc     rdi
        mov     r8,r9
        dec     rdx
        jnz     sil104norunout
        call    writwork                ;work buffer full, write it
        jc      sil104baderror
        jmp     sil104norunout

sil104wsend:
        mov     [rdi],al                ;place non white space char in buffer
        inc     rdi
        inc     rbx
        mov     r8,rbx
        dec     rdx
        jnz     sil104tablp
        call    writwork                ;work buffer full, write it
        jc      sil104baderror
        jmp     sil104tablp

; BINARY write =================================================================
sil104binary:
        call    dowrite
        ret

sil104default2:
 mov rax,r12
 call dbgprtfi
 dbgustr ' unitarea exists but not valid ####'
sil104default:                          ;create a default standard output unit
        mov     rax,r12                 ;unit number
        lea     r8,sil104stdoutspec
        lea     r9,sil104stdoutattrspec
        dbgsv
        mov     rbx,WOPEN               ;say it will be for write
        call    sil121                  ;call FILNAM to set up IO unit
        jc      sil104121bad
        dbgrs
        mov     r10,r12
        jmp     sil104again

sil104121bad:
 dbgustr 'filnam failed in sil104 ####'
        dbgrs

SIL104bad:
 dbgustr 'invalid unit area encountered ####'
 call dbgexit

      SIL104 ENDP
;=============================================================================
; Write RCX bytes from RSI to file specified by UNITHANDLE
dowrite proc
        dbgsv
        mov     bytestowritelen,rcx
        mov     bytestowriteaddr,rsi

ifdef linuxenvironment

dowritelnxagain:
        mov     rdi,UNITSTR.UNITHANDLE[r10]     ; handle
;       mov     rsi,rsi                         ; address of bytes to write
        mov     rdx,rcx                         ; number of bytes to write
        mov     rax,1                           ; sys_write call
        syscall
; returns in rax number of bytes written - might not be all,
; if rax is negative, then -eax is he error number (erno.h)
        cmp     rax,0                           ; see how many bytes written
        jnl     somewrittenlnx
        neg     eax
        shl     rax,32
        shr     rax,32
        mov     IOERCL,rax      ;put error code in &IOERR
        mov     rbx,ERRLCL      ;skip message if &ERRLIMIT not zero
        and     rbx,rbx
        jnz     dowriteerror
 call dbgprtfi
 dbgustr '= linux sys_write error ####'
 jmp    dowriteerror
somewrittenlnx:
        sub     bytestowritelen,rax             ; see if need to write more
        jz      dowritedone
        add     bytestowriteaddr,rax
        mov     rsi,bytestowriteaddr
        mov     rdx,bytestowritelen
        mov     r10,CURUNIT
        jmp     dowritelnxagain
else ; ================= Windows version ====================================
        externdef WriteFile : near
dowritewinagain:
        winstack 1                              ; must leave 32 bytes space plus for more parameters
        mov     rdx,rsi                         ; 2: address of char to print
        mov     r8,rcx                          ; 3: number of chars to print
        cmp r8,C1073741824                      ; split writes at 1gb
        jl @F
        mov r8,C1073741824
@@:
        mov     rcx,UNITSTR.UNITHANDLE[r10]     ; 1: handle was returned in RAX
        lea     r9,byteswritten                 ; 4: returns number of bytes written
        mov     QWORD PTR [rsp+32], 0           ; 5: null
        call    WriteFile
        winstacke
        cmp     rax,0                   ; is zero if error
        jnz     dowritewinok
; get last error code and put into IOERCL
        winstack 1
        mov     rcx,0
        mov     rdx,0
        mov     r8d,0
        mov     r9,0
        mov     QWORD PTR [rsp+32],0
        call    GetLastError
        winstacke
        mov     IOERCL,rax
        jmp     dowriteerror
dowritewinok:
        mov     rax,byteswritten
;showreg rax
        sub     bytestowritelen,rax             ; see if need to write more
        jz      dowritedone
        add     bytestowriteaddr,rax
        mov     rsi,bytestowriteaddr
        mov     rcx,bytestowritelen
        mov     r10,CURUNIT
        jmp     dowritewinagain

endif

dowritedone:
        dbgrs
        clc
        ret
dowriteerror:
        mov     rax,ERRLCL
        and     rax,rax
        jnz     dowritenomsg3
 dbgustr '#### more serious write error'
dowritenomsg3:
;##### put in an error return
        dbgrs
        stc     ;set carry on error
        ret
dowrite endp

; writwork - write out full unitbuf ===========================================
writwork proc
; write out what is in the buffer
        push    rcx
        push    rsi
        mov     rcx,UNITBUFL
        sub     rcx,rdx                 ;how much to write
        jz      @F
        lea     rsi,UNITSTR.UNITBUF[r10] ; work area
        call    dowrite
; presever carry flag for error
@@:
        pop     rsi
        pop     rcx
        lea     rdi,UNITSTR.UNITBUF[r10] ; work area
        mov     rdx,UNITBUFL            ;output record length
        ret
writwork endp
