;SIL code for SORT
; Written by Viktors Berstis
;*      SORT(ARRAY,STYPE)                                        v3.20
;*
;SORT   PROC    ,                                                v3.20
;       RCALL   ZPTR,ARGVAL,,FAIL   Get 1st arg=array            v3.20
;       PUSH    ZPTR                                             v3.20
;       RCALL   XPTR,INTVAL,,FAIL   Get 2nd arg=sort type        v3.20
;       POP     ZPTR                                             v3.20
;       VEQLC   ZPTR,A,INTR1        Only arrays can be sorted    v3.20
;       SORT    ZPTR,XPTR,FAIL Sort                              v3.20
;       BRANCH  RTZPTR              Return sorted array          v3.20

;crtmain.sno:
;* SORT =========================================================================
;FNCSORT PUT(LABELCO 'mov rdi,[' OP1 '+AOFFSET]')
;        PUT(TAB 'mov r8,[' OP2 '+AOFFSET]')
;        PUT(TAB 'call sorta')
;        DIFFER(OP3) PUT(TAB 'jc ' OP3)                          :(STMT)

; Shell's sort as follows:
; ADDRESSES: N, M, S, L, H
; ARRAY: A(LBOUND(A)..HBOUND(A))
; DATA: T
;
;       S=HBOUND(A) - LBOUND(A) + 1;
;       DO WHILE(S>1);
;         S = (S / 4) * 2 + 1
;         L = LBOUND(A);
;         DO H=S+LBOUND(A) TO HBOUND(A) BY 1;
;           M=H;
;           N=L;
;           DO WHILE( N>=LBOUND(A) & A(N)>A(M) );
;             T=A(N);  A(N)=A(M);  A(M)=T;
;             M=N
;             N=N-S;
;           END;
;           L=L+1;
;         END;
;       END;


; INPUT:
;
; R8  = N is sort column and direction
;
; ARRAY:
;         ------------------------------
; RDI --->|SELFPTR |   TTL   |    SZ   |  SZ = number of descriptors following
;         ------------------------------
;         |  PROTO |   PTRF  |    S    |  PROTO = address of array prototype string
;         ------------------------------
;         |   D    |         |         |  D = number of dimensions (1 or 2 allowed for sort)
;         ------------------------------
; cols    |   I2   |         |   I2n   |  I2 = start index, I2n = number of cols
;         ------------------------------
; rows    |   I1   |         |   I1n   |  I1 = start index, I1n = number of rows
;         ------------------------------
;<I1,I2>  |   A0   |    F0   |    V0   |  First array entry (row major order)
;         ------------------------------
;         |   A1   |    F1   |    V1   |  <I1,I2+1>
;         ------------------------------
;                      ...
;         ------------------------------
; Last    |   Aj   |    Fj   |    Vj   |  <I1+I1n-1,I2+I2n-1>
;         ------------------------------
; x = row y = column
;
; For a two dimensional array:
;    For <x,y>;   j = (x - I1) * I2n + (y - I2)
;
; For a one dimensional array:  (cols descriptor removed)
;    For <x>;     j = x - I1
;
; OUTPUT:
;       Array sorted in place
;       Carry flag set on failure of some sort

; Sort one or two dimensional array using particular column as sort key
; Array is stored in row major order (column (2nd) index changes the fastest as stepping linear addresses thru array)
; INPUT:
;   EAX - sil address of array header (not relocated)
;   ECX:EDX - high:low order part of second operand to SORT()
;           negative means descending order, else ascending
;           ABS(CX:DX) is column number to sort on (not column index)
;           Zero is treated as one which means first column
; OUTPUT:
;       - sorted array in place
;   EAX - zero if no failure
;
; Note: This code only works in 64 bit addressing
;       Strings compare less than numerics
;       Snobol array ref:  A<row,column>

        .data

        ALIGN   16
PA      DQ      ?       ;Sil address of array header (input to routine)
PB      DQ      ?       ;Sil Address of data portion
PRWSZ   DQ      ?       ;Number of elements in a row (number of cols)
PCLSZ   DQ      ?       ;Number of elements in a column (number of rows)
PSCL    DQ      ?       ;Sil address to first key in sort column
PSCLN   DQ      ?       ;Sort column number (starts with 0)
PRSM1   DQ      ?       ;Number of bytes in a row minus DESCR
SDIR    DQ      ?       ;0 or positive=ascending, negative=descending (sort direction)

STARYA  DQ      0       ;stabilizing array address (has PCLSZ) quadwords

PS      DQ      ?       ;Sort algorithm variable = 1 to number of rows
PL      DQ      ?       ;Sort algorithm variable, 0 to (number of rows-1)
PH      DQ      ?       ;Sort algorithm variable, 1 to (number of rows)
PN      DQ      ?       ;Sort algorithm variable, 0 to (number of rows-1)
PM      DQ      ?       ;Sort algorithm variable, 0 to (number of rows-1)
; To make sort stable:
ECBN    DQ      ?       ;Sequence number used on equal compare
ECBM    DQ      ?       ;Sequence number used on equal compare

WFS     DW      ?       ;Float status word

        .code

SORTA   PROC
        MOV     SDIR,0
        MOV     PA,rdi          ;Save SIL address of array header
        mov     rdx,r8          ;Sort column and direction
        AND     rdx,rdx
        JNS     SORTASC         ;Jump if not negative (ascending)
; Descending sort:
        mov     SDIR,-1
        NEG     rdx
        JZ      SORTERROR       ;Error if overflows on taking ABS value
        JMP     SORTCOM
SORTASC:                        ;Ascending sort
        AND     rdx,rdx
        JZ      SORTCN1         ;If zero, no adjustment needed
SORTCOM:
        DEC     rdx             ;Make into column offset number (0...)
SORTCN1:
        MOV     PSCLN,rdx       ;Column offset number to sort on

        MOV     rsi,PA          ;Get sil pointer to array header
        CMP     qword ptr [rsi+DESCR*2+AOFFSET],2 ;Check number of dimensions (1 or 2 is ok)
        JA      SORTERROR
        JE      SORT2D          ;Jump if two dimensional
SORT1D: MOV     PRWSZ,1         ;just one column in single dimension array
        MOV     rax,[rsi+DESCR*3+VOFFSET] ;Number of rows
        shr     rax,8
        MOV     PCLSZ,rax
        MOV     rax,PA
        ADD     rax,4*DESCR     ;offset to data in 1 dim array
        MOV     PB,rax          ;Data address
        CMP     PSCLN,0
        JA      SORTERROR       ;Jump if sort column number too big
        MOV     PRSM1,0         ;not needed for one dim
        JMP     SORTSTART

SORTERROR: stc                  ;Indicate failure by setting carry flag
        RET

SORT2D: MOV     rax,[rsi+DESCR*3+VOFFSET] ;Number of columns
        shr     rax,8
        MOV     PRWSZ,rax
        CMP     PSCLN,rax
        JNB     SORTERROR       ;Jump if sort column number too big
        MOV     rax,[rsi+DESCR*4+VOFFSET] ;Number of rows
        shr     rax,8
        MOV     PCLSZ,rax
        SHL     rax,4           ;*DESCR to get bytes in a row
        sub     rax,DESCR
        mov     PRSM1,rax
        MOV     rax,PA
        ADD     rax,5*DESCR     ;Get past header to 2 dim array
        MOV     PB,rax          ;Data address

SORTSTART:
        MOV     rax,PSCLN       ;Get sort key column offset number
        MUL     PCLSZ           ;Multiply by size of a row
        JO      SORTERROR
        SHL     rax,4           ;*DESCR
        ADD     rax,PB          ;Add base address
        MOV     PSCL,rax        ;Sil address of compare key column start

        CALL    STABINS         ;Insert sort stabilizing data

;       S=HBOUND(A) - LBOUND(A) + 1;
        MOV     rax,PCLSZ
        MOV     PS,rax          ;number of columns
;       DO WHILE(S>1);
SORTLP1: CMP    PS,1
        JA      SORTLP1B
        JMP     SORTLP1E        ;done
SORTLP1B:
;         S = (S / 4) * 2 + 1
        MOV     rax,PS
        SHR     rax,1           ;Divide entry number by two
        or      rax,1
        xor     rax,1           ;Make even
        ADD     rax,1
        MOV     PS,rax
;         L = LBOUND(A);
        MOV     PL,0
;         DO H=S+LBOUND(A) TO HBOUND(A) BY 1;
        MOV     rax,PS
        SUB     rax,1           ;because we add first in loop lp2
        MOV     PH,rax
SORTLP2: MOV    rax,PH
        ADD     rax,1
        MOV     PH,rax
        CMP     rax,PCLSZ
        JB      SORTLP2B
        JMP     SORTLP2E
SORTLP2B:
;           M=H;
        MOV     rax,PH
        MOV     PM,rax
;           N=L;
        MOV     rax,PL
        MOV     PN,rax
;           DO WHILE( N>=LBOUND(A) & A(N)>A(M) );
SORTLP3:
        CALL    ISNGTM          ;is A(N) greater thatn A(M)?
        JC      SORTLP3E        ;Carry set if not A(N)>A(M)
;             T=A(N);  A(N)=A(M);  A(M)=T; (exchange A(N) and A(M)
        MOV     rbx,PN
        SHL     rbx,3           ;*qword size
        ADD     rbx,r8
        MOV     rdx,PM
        SHL     rdx,3           ;*qword size
        ADD     rdx,r8
        mov     rax,[rbx]
        xor     rax,[rdx]
        xor     [rbx],rax
        xor     [rdx],rax
;             M=N
        MOV     rax,PN
        MOV     PM,rax
;             N=N-S;
        MOV     rax,PN
        SUB     rax,PS
        JB      SORTLP3E
        MOV     PN,rax
;           END;
        JMP     SORTLP3
SORTLP3E:
;           L=L+1;
        INC     PL
;         END;
        JMP     SORTLP2
SORTLP2E:
;       END;
        JMP     SORTLP1
SORTLP1E:
        CALL    STABOTS         ;Remove sort stabilizing data

        clc                     ;Indicate no errors - clear carry
        RET
SORTA   ENDP

; Compare two descriptors
ISNGTM  PROC
        MOV     rsi,PN
        SHL     rsi,3           ;*qword size
        mov     rsi,[r8+rsi]
        MOV     rdi,PM
        SHL     rdi,3           ;*qword size
        mov     rdi,[r8+rdi]
        TEST    SDIR,1
        JZ      NODESCEND       ;Jump if ascending
        XCHG    rsi,rdi         ;Exchange operands for descending
NODESCEND:
        MOV     ECBN,rsi        ;Get equal compare buster for A(N)
        MOV     rax,[rsi+VOFFSET] ;type of A(N)
        shr     rax,8

        MOV     ECBM,rdi        ;Get equal compare buster for A(M)
        MOV     rbx,[rdi+VOFFSET] ;type of A(M)
        shr     rbx,8
        CMP     rax,rbx         ;see if types are the same
        JNE     DIFTYPES
; Here if both type are the same
        CMP     rax,I           ;is it integer?
        JE      SORTII
        CMP     rax,R           ;Is it real?
        JE      SORTRR
        CMP     rax,S           ;is it string:string?
        JNE     ISEQL           ;don't sort pairs of other types
        JMP     SORTSS1
ISEQL:  JMP     ISEQ1
DIFTYPES:
        MOV     rcx,rax
        XOR     rcx,rbx
        CMP     rcx,(I XOR R)    ;Could one be INTEGER and other REAL?
        JNE     TYPECOMP         ;Jump if not
        CMP     rax,I            ;Is A(N) INTEGER?
        JE      SORTIR
        CMP     rbx,I            ;Is A(M) INTEGER?
        JE      SORTRI
TYPECOMP:
        CMP     rax,rbx          ;Just compare on type codes
        JA      ISGT
        JE      ISEQ
        JMP     ISNOTGT

SORTRR:
        FLD     QWORD PTR [rsi] ;Load 8 byte float
        FCOMP   QWORD PTR [rdi] ;Compare to 8 byte float
        JMP     REALCOMP
SORTIR:
        FILD    QWORD PTR [rsi] ;Load 8 byte integer
        FCOMP   QWORD PTR [rdi] ;Compare to 8 byte float
        JMP     REALCOMP

SORTSS1: JMP    SORTSS  ;combine short jumps to keep long jump from bothering linker
ISEQ1:   JMP    ISEQ    ;combine short jumps to keep long jump from bothering linker

SORTRI:
        FILD    QWORD PTR [rdi] ;Load 8 byte float
        FCOMP   QWORD PTR [rsi] ;Compare to 8 byte integer
        FSTSW   ax              ;FSTSW
        WAIT
        TEST    AH,40H          ;CHECK FOR EQ
        JNZ     ISEQ            ;EQ
        AND     AH,41H          ;ISOLATE C3 AND C0
        JZ      ISNOTGT
        JC      ISGT            ;GT
;### CANNOT COMPARE NAN, Pretend they are both integers
        jmp     SORTII
REALCOMP:
        FSTSW   ax              ;FSTSW
        WAIT
        AND     AH,41H          ;ISOLATE C3 AND C0
        JZ      ISGT
        CMP     AH,40H          ;CHECK FOR EQ
        JE      ISEQ            ;EQ
        JC      ISNOTGT         ;LT
;### CANNOT COMPARE NAN, Pretend they are both integers

SORTII:
        MOV     rax,[rsi+AOFFSET] ;int of A(N)
        CMP     rax,[rdi+AOFFSET] ;int of A(M)
        JG      ISGT
        JE      ISEQ
        JMP     ISNOTGT

ISGT:
        CLC
        RET
ISNOTGT:
        STC
        RET

ISEQ:
        MOV     rax,ECBN
        MOV     rbx,ECBM
        TEST    SDIR,1
        JZ      NODESCEND2      ;Jump if ascending
        XCHG    rax,rbx         ;Tie breaker must always be ascending
NODESCEND2:
        CMP     rax,rbx
        JA      ISGT
        STC
        RET

SORTSS:
        MOV     rbx,[rdi+AOFFSET] ;Get SIL addr 1
        AND     rbx,rbx
        JZ      S1INS           ;Jump if string is null
        MOV     rdi,[rdi+AOFFSET]
        MOV     rbx,[rdi+VOFFSET] ;L1
        SHR     rbx,8
        ADD     rdi,DESCR*4     ;Address 1
S1INS:

        MOV     rdx,[rsi+AOFFSET] ;Get SIL addr 2
        AND     rdx,rdx
        JZ      S2INS           ;Jump if string is null
        MOV     rsi,[rsi+AOFFSET]
        MOV     rdx,[rsi+VOFFSET] ;L2
        SHR     rdx,8
        ADD     rsi,DESCR*4     ;Address 2
S2INS:

; S1(rdi len=rbx)    S2(rsi len=rdx)
        MOV     rcx,rbx
        CMP     rdx,rcx         ;CHECK LENGTHS
        JNC     SORTCX
        MOV     rcx,rdx         ;rcx=MIN(L1,L2)
SORTCX: JRCXZ   SORTCZL         ;ZERO LENGTH?
        CLD                     ;INCREMENTING ADDR DIRECTION
        REPZ    CMPSB           ;compare the strings
        JC      SORTCL
        JNE     SORTCH
SORTCZL: CMP    rdx,rbx         ;COMPARE ON LENGTH
        JC      SORTCL
        JNE     SORTCH
        JMP     ISEQ            ;S1=S2
SORTCL: JMP     ISNOTGT         ;S1<S2
SORTCH: JMP     ISGT            ;S1>S2

ISNGTM  ENDP

; STABINS - Insert sort stabilizing data
; Use array of row addresses to the keys, exchanges of addrs reduces data movement
STABINS PROC
        mov     rcx,PCLSZ       ;number of rows
        shl     rcx,3           ;* 8 for quadwords
        call    myalloc
        mov     STARYA,rax
        mov     r8,rax          ;keep this around here for other routines
        mov     rdi,rax         ;address array to keys
        MOV     rcx,PCLSZ       ;Number of rows
        mov     rsi,PSCL        ;First key address
        mov     rax,DESCR       ;number of rows
STABINLP:
        mov     [rdi],rsi       ;store address of key for the row
        add     rdi,8
        add     rsi,rax
        loop    STABINLP
        RET
STABINS ENDP

; STABOTS - Remove sort stabilizing data
STABOTS PROC
        mov     rsi,PA          ;array header address
        mov     rcx,[rsi+VOFFSET]
        shr     rcx,8           ;bytes in data part of array block
        call    myalloc         ;allocating a few extra descrs (not used)
        mov     r9,rax          ;save address of new storage area here
        mov     rbx,PSCL        ;address of first key in the array
        sub     rbx,PB          ;get offset of key into row
        mov     rdi,r9          ;new area where to copy rows to
        mov     rdx,STARYA      ;sorted addresses here
        mov     rax,PCLSZ       ;number of rows
STABcopy1:
        mov     rsi,[rdx]       ;get address of row
        sub     rsi,rbx         ;get to start of row
        mov     rcx,PRWSZ       ;number of columns
        push    rdi

STABcopy2:
        movsq
        movsq                   ;copy row cell and update rdi
        add     rdi,PRSM1       ;add row size minus DESCR
        add     rsi,PRSM1       ;add row size minus DESCR
        loop    STABcopy2

        pop     rdi
        add     rdi,DESCR       ;next row target
        add     rdx,8           ;next sorted address
        dec     rax             ;count down rows done
        jnz     STABcopy1

        mov     rdi,PB          ;original data start in array
        mov     rsi,r9          ;sorted data area
        mov     rcx,PA
        mov     rcx,[rcx+VOFFSET]
        shr     rcx,8           ;bytes in data part of array block
        mov     rax,PB
        sub     rax,PA
        sub     rax,DESCR       ;number of bytes in header info of array
        sub     rcx,rax         ;only move bytes of actual array data
        shr     rcx,3           ;number of quadwords to copy
        rep movsq

        mov     rax,r9
        call    myfree          ;get rid of array copy
        mov     rax,STARYA
        call    myfree          ;get rid of address array
        RET
STABOTS ENDP
