        TITLE "SNOBOL5 INTERPRETER - SIL INTERPRETER"

; Written by Viktors Berstis

; ---------------------------------------------------------------------
;
; CONDITIONS ON ENTRY
;
;
;   other         : All other registers are undefined.
;
;----------------------------------------------------------------------

        .data
        db      'S5 start of data'
        align   16
asmdatastart equ $
dbgperflast dq  0                       ;for performance measurement ####
dbgperflastbin dq dbgperfbin
dbgperfbin dq   250 DUP(0)      ;should be > opxlat size in crtmain.sno
dbgperfcnt dq   250 DUP(0)
        .code
        db      'S5 start of code'
asmcodestart equ $
        .data

        INCLUDE addrequ.inc
        INCLUDE equs.inc
        INCLUDE utilmac.inc
        INCLUDE silmacs.inc

;----------------------------------------------------------------------
; DATA
;----------------------------------------------------------------------
        .data
        align   16
MAXSTR  EQU     64000000000-48
MAXSTRS dq      MAXSTR
STRLIM  EQU     64000000000
STRLIMS dq      STRLIM
SIZLIM  EQU     64000000000
SIZLIMS dq      SIZLIM


DBGcounter dq 0 ;####
sasoe dq 0      ;stack at start of execution

PARMAX  equ     32767                   ;Max length allowed parameter string
prmstringa dq   PARM                    ;Command line string address
prmstringl dq   ?                       ;Command line string length
prmstringc dq   ?                       ;Number of parameters parsed
prmstringptrs dq ?                      ;Linux parameter pointers when C code is used
unitnumsav dq   ?                       ;used to turn on includes for unit 5
PARM       db   PARMAX dup(0)           ;Area in which to make a local copy of command lines string
prereadlinea dq prereadline
prereadline db  256 dup(0)              ;First line of source to check for possible parameters

ifdef linuxenvironment
linuxosname db 'Linux'
linuxosnamelen equ 5
linuxslash db '/'
 align 8
; ctrl-break stuff:
        align   16
sigaction dq    ctrlbreak       ;sa_handler
        dq      04000000h       ;SA_RESTORER flags
        dq      sigreturn       ;restorer
sigaction2 dq   usr1signal      ;sa_handler
        dq      04000000h       ;SA_RESTORER flags
        dq      sigreturn       ;restorer
else
windowsosname db 'Windows'
windowsosnamelen equ 7
windowsslash db '\'
endif

oldcwdmax equ 32767                     ;space in oldcwd
oldcwd    db oldcwdmax DUP(?)           ;to hold current working dir at start
envpathmax equ oldcwdmax
envpath db oldcwdmax DUP(?)
        align 16
envpathlen dq ?

ifdef customaddon
;pe3 data, custom for Personal Editor 3
        align 16
pe3data:
q3todo  dd      0                       ;todo
q3key   dd      0                       ;key
q3x     dd      0                       ;x
q3y     dd      0                       ;y
q3bc    dd      0                       ;bc
q3xx    dd      0                       ;xx
q3yy    dd      0                       ;yy
q3xmax  dd      0                       ;xmax
q3ymax  dd      0                       ;ymax
q3cur   dd      0                       ;cur
q3col   dd      0                       ;color
q3len   dd      0                       ;len
q3string dq     0                       ;string
pe3called db    0                       ;non zero if PE3 was called
endif

INCLUDE VERSION.INC                     ;Snobol version info

        align 16
WorkSpaceSize dq 30000000  ;Size of workspace to allocate in bytes (30meg default)
WorkSpaceAddr dq 0        ;Address of workspace allocated
WorkSpaceLast dq 0
lnxerror dq 0-4094        ;error if return in larger than this
workspacestr db 24 dup(0)
workspacelen dq 0
workspacemax equ 19
silcodeaddr dq silcodestart
silcodelast dq silcodeend
myallocaddr     dq ?    ;used by myalloc

count   dq      0
aplace  dq      0       ;first address in work space
HIGHMEM dq      0       ;last+1 address of work space
callrc  dq      0

OSTACK  Dq      0,0                     ;SIL oldstack pointer
STKALIGN dq 0FFFFFFFFFFFFFFF0h          ;used to 16 byte align stack
EXSTARTRSP dq 0                         ;esp at start of sil execution

MULTCwk DQ      0

sil25ef db      1ah     ;windows end of file character
sil25len dq     ?       ;bytes written

SIL120CT Dq     0       ;count for trapck


        align   16
; Default output if not specified
sil104stdoutspec dq     stdoutstr,0,0,stdoutstrlen*256
stdoutstr db 'out',0
stdoutstrlen equ 3
sil104stdoutattrspec dq stdoutattr,0,0,stdoutattrlen*256
stdoutattr db '-std-a',0
stdoutattrlen equ 6
        align   16
byteswritten dq ?
bytestowritelen dq ?
bytestowriteaddr dq ?
crlf    db      13,10   ;carriage return and line feed characters
digits  db      '0123456789'

        align   16
; Default input if not specified
sil105stdinspec dq     stdinstr,0,0,stdinstrlen*256
dirname dq      0,0,0   ;pointer to directory entry name (looks like specifier)
dirnamel dq     0       ;length of directory entry name * 256
dirtype dq      dirtype,0,0 ;specifier for dir entry type text
dirtypel dq     4*256   ;L field of type specifier
dirdate dq      0
dirsize dq      0
stdinstrlen equ 2
sil105stdinattrspec dq stdinattr,0,0,stdinattrlen*256
stdinstr db 'in',0
stdinattr db '-std-a',0
stdinattrlen equ 6
SIL105L DQ      0       ;quantity read
sil105unitnum  dq ?     ;unit number
sil105dest dq ?         ;save destination address
sil105destlen dq ?      ;save destination length
sil105destmax dq ?      ;save destination length
sil105eofaddr dq ?      ;save eof branch address
sil105failaddr dq ?     ;save failure branch address
sil105diraddr dq ?      ;save directory branch address
sil105successaddr dq ?  ;save success branch address
sil105cnt dq 0
sil105pr db 96h
        align 16
filestats db 256 dup(81h)
lnxdirtypes db 'UNKN'   ;0 unknown
        db 'PIPE'       ;1 pipe
        db 'CHAR'       ;2 char
        db 'UNKN'       ;3 unknown
dtyp    db 'DIR '       ;4 directory
        db 'UNKN'       ;5 unknown
        db 'BLOK'       ;6 block device
        db 'UNKN'       ;7 unknown
ftyp    db 'FILE'       ;8 regular file
        db 'UNKN'       ;9 unknown
ltyp    db 'LINK'       ;10 symbolic link
utyp    db 'UNKN'       ;11 unknown
        db 'SOCK'       ;12 socket
        db 'UNKN'       ;13 unknown
        db 'UNKN'       ;14 white out
dvtyp   db 'DEV '       ;   device

C1073741824 dq 1073741824

INTSPCbuf db    24 DUP(0)
SIL100highbit dq 8000000000000000h      ; =-9223372036854775808
SIL100allbits dq 0FFFFFFFFFFFFFFFFh
SIL100maxpos  dq 07FFFFFFFFFFFFFFFh     ; =9223372036854775807
SIL100ten dq    10
SIL100sign db 0
SIL122noflags dq 0FFFFFFFFFFFFFF00h
silmillion dq   1000000
silbillion dq   1000000000
siltimespecs dd 0                       ;seconds part for linux sleep
siltimespecn dd 0                       ;nanoseconds part for linux sleep
SIL122CT        db 0
silsleeping db  0

        align   16
randx   dq      randa                   ;prior random number
randa   dq      6364136223846793005     ;rand multiplier
randc   dq      1442695040888963407     ;rand increment

LOWBITS8 dq     0101010101010101h       ;low order bits on (for lob function)
CHAR8ONES dq    3030303030303030h       ;eight '1' characters (for lob function)

sil127seeknew dq ?
sil127rxwk dt ?                         ;place to assemble ten byte extended float
sil127fcw dw ?
        align   8
; for DATE
ten     dq      10
lnxtime dq      2 dup(8181818181818181h)
lnxtimezone dq      4 dup(8181818181818181h)
wintimein dq    ?       ;windows system time
wintimeout dq    ?      ;windows local time
wintime dw      ?                       ;Year
winmonth dw     ?                       ;Month
windayofw dw    ?                       ;Day of week
windayofmonth dw ?                      ;Day of month
winhour dw      ?                       ;Hour
winminute dw    ?                       ;Minute
winsecond dw    ?                       ;Second
winmillisecond dw ?                     ;Millisecond
timetext        db      'YYYY-MM-DD HH:MM:SS.000',0
mdays   dw      0,0,31,31,60,59,91,90,121,120,152,151,182,181,213,212,244,243,274,273,305,304,335,334,366,365
timetextcl dq   timetext,0,0,23*256     ;specifier to timetext

; for MSTIME SIL63
        align 16
processormhz dq 4000
billionflt dq 1000000000.0
timeplaces dq  384 DUP(8181818181818181h) ;##### up to 64 processors of info
timeplace dq    0,0
junkplace dq    0,0

; for CLERTB PLUGTB:
CONTINconst dq 0
ERRORconst  dq 0202020202020202h
STOPconst   dq 0303030303030303h
STOPSHconst dq 0404040404040404h

; used by block.inc:
SIZLIMX dq SIZLIM

; used by debug.inc:
debuglast dq 8181
debugcnt dq 0
oldbukptr dq 8181
oldsubptr dq 8181
oldmemptr dq 8181
MapLbl0 dq 0,0

        include patmac.inc
        patvars         ;######
teststr db 'xxxxxx test is a test subject'
teststrl equ 29
lookstr db 'test'
lookstrl equ 4
foundstr db 64 dup(?)

mystery db 4096 dup(44h)


        align   16
foundl  dq 0
foundlmax equ 64

vara    db 64 dup(?)
varal   dq      0
varamx  dq      64


FMTBUF  DB      132 DUP(?)

IDMSG   DB      'The Oregon SNOBOL'
        DB      MNVERL1,'.',MNVERL2
        DB      ' Interpreter'
        DB      ': Version '
        db 'Beta 5.0',13,10
;       DB      MNVERC1,'.',MNVERC2,MNVERC3,13,10
        db 'Implemented by Viktors Berstis, report bugs to snobol5@berstis.com' ;####
        DB      13,10
IDMSGE  DB      0,1AH

        align   16
;SYSTEMTIME structure returned by GetSystemTime in Windows:
time_year           dw      ?       ;eg 2022
time_month          dw      ?       ;0-59
time_DayOfWeek      dw      ?       ;0-59
time_Day            dw      ?       ;0-99
time_Hour           dw      ?       ;1-31
time_Minute         dw      ?       ;1-12
time_Second         dw      ?       ;eg 1999
time_Milliseconds   dw      ?       ;minutes dif from GMT

        align   16
winzerotime dq  132854688000000000 ;windows filetime = Jan 1, 2022 0:00.000


monthtab dw     0       ;number of days in year before the month (no leap day)
        dw      0                                ;january
        dw      31                               ;february
        dw      31+28                            ;march
        dw      31+28+31                         ;april
        dw      31+28+31+30                      ;may
        dw      31+28+31+30+31                   ;june
        dw      31+28+31+30+31+30                ;july
        dw      31+28+31+30+31+30+31             ;august
        dw      31+28+31+30+31+30+31+31          ;september
        dw      31+28+31+30+31+30+31+31+30       ;october
        dw      31+28+31+30+31+30+31+31+30+31    ;november
        dw      31+28+31+30+31+30+31+31+30+31+30 ;december


RPADC   DB      0               ;Pad character for RPAD
I2SMAX  DB      '9223372036854775808'

; Things needed for floating point:
WD0     DW      0,0,0,0,0,0,0,0,0,0
        ALIGN   8
BUFFER  DB      1000 DUP(0)

FLTESW  DB      0                       ;0=dont use e notation, 1=use e notation
        align   16
fltbufst dq     0                       ;address of output area for FLT2STR
FLTW    DQ      0               ;place to save float number
logFLTW DQ      0
aoexexb DQ      800FFFFFFFFFFFFFH ;TURN on all but exponent bits
jsc     DQ      000FFFFFFFFFFFFFH ;JUST SIGNIFICAND Bits remain
fltsgn  DQ      8000000000000000H ;TEST FOR SIGN
dnrlml  DQ      7FF0000000000000H ;TEST FOR DENORMAL (exponent zero, significand not zero)
DWD4    DQ      0
DWD6    DQ      0
FLTEEXP DQ      0
NORML   DQ      3810000000000000H ;FUDGE TO NORMALIZE WITH
FZERO   DQ      0.0
FONE    DQ      1.0
FTWO    DQ      2.0
F10     DQ      10.0
Fsinfix DQ      8192.0  ; 4096 doesn't work for tangent
FHALF   DQ      0.5
FINF    DQ      7FF0000000000000h       ;Positive infinity
FNAN    DQ      7FF8000000000000h       ;NAN
FNANQ   DQ      7FF8000000000001h       ;Quiet NAN
NaNoffexp dq    7FF0000000000000h
NaNfrac dq      000FFFFFFFFFFFFFh
NaNindef dq     0007FFFFFFFFFFFFh
FMAX    dq       7FEFFFFFFFFFFFFFh      ;almost infinity
FMIN    dq      0FFEFFFFFFFFFFFFFh      ;almost -infinity
FLTE    dq      0                       ;e notation exponent
FLTADJUST DQ    1.000000000000001       ;to get rid of .9999... problem
L2EV    DT      0.0     ;FLTINIT sets this to LOG2(&E)
L2EVI   DT      0.0     ;FLTINIT sets this to 1.0/LOG2(&E)
L2TEN   DT      0.0     ;FLTINIT sets this to LOG2(10)
L2TENI  DT      0.0     ;FLTINIT sets this to 1.0/LOG2(10)
FPI     DT      3.14159265358979323846264 ; FLTINIT resets this
FEV     DT      2.71    ;e   FLTINIT makes this accurate
;for fltrtn.inc:
;Powers of ten table for displaying
        DT      342 DUP(0)      ;Powers of 10 table
;Computed negative powers as inverses of positive
TENSHFT DT      342 DUP(0)      ;Negative powers of 10 table
        align   16
exrealtemp dq   0
exrealctl dw   0
word10  dw      10
s2fexpsign db   '+'             ;sign of exponent after E in float number
expflags db   0  ;4 if exponent is integer, 1 if exponent even, 2 x negative
        align   16
dumpflt0 dq     ?
dumpflt1 dq     ?
dumpflt2 dq     ?
dumpflt3 dq     ?
dumpflt4 dq     ?
dumpflt5 dq     ?
dumpflt6 dq     ?
dumpflt7 dq     ?
dumpfstring db  64 dup(?)

;LONG1   DB      0       ;LONG NORMALIZED FORM OF DENORMALIZED SHORT NUMBER
;LONG2   DW      0
;LONG3   DW      0
;LONG4   DW      0
;LONG5   DB      0

        align   16
DWD0    DQ      0
NEGSWD  DB      0,0,0,0,0,0,0 ;Qword version of NEGSW
NEGSW   DB      ?
PKDVAL  DT      0

        align   16
ZEROINT DQ      0                       ;just zero in storage

;SPAN, BREAK, ANY, NOTANY character scan table:
TRTABLEW LABEL  WORD
TRTABLE DB      256 DUP(?)      ;SIL SNABTB TABLE

;hex digit conversion table
HEXTABLE DB     48 DUP(0)
        DB      0,1,2,3,4,5,6,7,8,9     ;digits 0-9
        DB      7 DUP(0)
        DB      10,11,12,13,14,15       ;upper case A-F
        DB      26 DUP(0)
        DB      10,11,12,13,14,15       ;lower case a-f
        DB      25 DUP(0)
        DB      128 DUP(0)

MAKNOD6 DB      0               ;For SIL53 and SIL54
        ALIGN 16

foutputbuf db   500 dup(?) ;work area for sil67 OUTPUT macro
sil67fltbuf db  500 dup(?)
        align   16
;for DIVIDE SIL22:
DW0     DD      0
DW4     DD      0
DW8     DD      0
DW12    DD      0
DIVSIGN DB      0

RPLTAB  DB      256 DUP(0)              ;For RPLACE

;for GC:
GCPASS  DD      0                       ;Pass number #### not used yet
        align   16
GCCHANGED DQ    0                       ;1 if another mark pass required
COMPBAR DQ      0                       ;SIL address of compression barrier
STACNT  DQ      0                       ;Number of entries to examine in stack
STLIMIT DQ      0     ;lower address bound of stack not to be exceeded too much
ADJBDYaddr DQ ADJBDY
ENDLOCaddr DQ ENDLOC
QSTACK DQ 0 ;#####
chaincnt dq 0
GClow4  DQ      0FFFFFFFFFFFFFFF0h      ;used to turn off 4 low order bits
GCREQEST DQ     ?
CSTACK  DQ      ?,?                     ;stack pointer before calling GC
WSCOPYaddr dq 0  ;##### temp for test
WSCOPYlen dq 0   ;#####
GCmarkcnt dq 0 ;#####
GCSTLIMIT DQ    0
DBGpriorval dq 0  ;####
DBGproblemcnt dq 0 ;####
DBGsaveloc dq 0 ;####
DBGnewaddr dq 0 ;####
testparameter dq 120 ;####
dbgclobaddr dq 0
badtitle dq 0 ;####
againcnt dq 0 ;####
GCSAVED dq 0
GCOLD dq 0
TLSGP1orig dq 0

dbgwas dq 0 ;#### used in debug.inc

whitespace db   ' ',9,0                 ;used for white space pattern match
whitespacelen equ 3
whitespacez db  ' ',13,9,0              ;used for white space pattern match
whitespacezlen equ 4
zerochar db     0
delimchar db    ' ',9,0                 ;blank, tab, zero
scanunitnum db 3 dup(?)
scanunitnumlen dq ?
scanunitnummax equ 3
filenam db 1024 dup(?)
filenamlen dq   ?
filenammax equ  1024
attribs db 256 dup(?)
attribslen dq ?
attribsmax equ 256
tabmask dq      0FFFFFFFFFFFFFFF8h      ;used to turn off 3 low order bits
blockcount dq 0 ;##### for debugging block

systcommandl equ 32768
systcommand db systcommandl dup(?)      ;also used by sil30 getbal
ifdef linuxenvironment
        align 8
lnxargsp dq lnxargsa
lnxargsa dq lnxarg1,systcommand,0,0
lnxcmdname db   '/bin/bash',0,0
lnxarg1 db '-c',0
else
wincmdname db 'cmd /C ',0
winmsgbuf db 1024 dup(81h) ;LPMSG structure
wincmdpgm db 'cmd.exe',0 ;#### used?
        align 8
winsavestack dq ?
winjunk1 dq      10 dup(0)       ;####
winjunk2 dq      10 dup(0)       ;####
endif

        align   16

        INCLUDE unit.inc

        align   16
CURUNIT dq 0                            ;pointer to current unit being handled
UNITARRAYMAX equ 1000   ;allow unit numbers 1 to 999 (#### set MXUNIT in main.a)
UNITARRAY dq  UNITARRAYMAX DUP(0)       ;addresses of I/O units
;----------------------------------------------------------------------
; MAIN PROGRAM
;----------------------------------------------------------------------
        .code
        INCLUDE debug64.inc
        INCLUDE debug.inc               ;#### special trap for debugging only
        include dumpunit.inc    ;####
        include lnxmhz.inc
        include rand.inc                ;random number generator
        include findunit.inc            ;find free unit number
        include getenv.inc
ifdef linuxenvironment
        include lnxloctm.inc            ;establish local time correction for linux
endif

; Execution starts here
;       public mainCRTStartup           ;when just assembling without c code and no /entry main on link.exe
;mainCRTStartup:
        public main                     ;when including compiled c code
main:


ifdef linuxenvironment
ifdef customaddon
; custom for Personal Editor 3
        mov     prmstringc,rdi  ;number of parameters
        mov     prmstringptrs,rsi ;parameter string pointers
endif
endif

        envsetup ;set up environment variable things

        CLD                     ;clear direction flag to ascending

ifdef linuxenvironment  ; LINUX VERSION ========================================
sys_rt_sigaction equ 13
SIGINT equ 2                    ;to catch ctrl-c
SIGUSR1 equ 10                  ;to catch kill nn -USR1
SIGSEGV equ 11                  ;segment violation
SA_NOCLDSTOP equ  00000001h
SA_NOCLDWAIT equ  00000002h
SA_SIGINFO   equ  00000004h
SA_ONSTACK   equ  08000000h
SA_RESTART   equ  10000000h
SA_NODEFER   equ  40000000h
SA_RESETHAND equ  80000000h

        mov     rax,sys_rt_sigaction
        mov     rdi,SIGINT      ;interrupt
        mov     rdi,SIGSEGV     ;interrupt #####
        lea     rsi,sigaction
        xor rdx,rdx             ;old sigaction
        mov     r10,8 ;128      ;size_t
        syscall
        cmp     rax,0
        jz      @F
        call    dbgprtfi
        dbgustr 'error from sigaction ####'
@@:

        mov     rax,sys_rt_sigaction
        mov     rdi,SIGUSR1     ;USR1 signal
        lea     rsi,sigaction2
        xor     rdx,rdx         ;old sigaction
        mov     r10,8 ;128      ;size_t
        syscall
        cmp     rax,0
        jz      @F
        call    dbgprtfi
        dbgustr 'error from sigaction ####'
@@:


        lea     rax,linuxosname        ; for &OS
        mov     OSSP,rax
        mov     QWORD PTR OSSP+LOFFSET,linuxosnamelen*256

        lea     rax,linuxslash          ;for &DS
        mov     DSSP,rax
        mov     QWORD PTR DSSP+LOFFSET,1*256

; get the environment variable
        lea     rsi,envarname
        mov     rcx,envarnamelen
        call    s5getenv

        mov     rax,4fh         ;sys_getcwd
        lea     rdi,oldcwd      ;place to put current directory
        mov     rsi,oldcwdmax
        syscall
        cmp     rax,0
        jne     gotcwd
        dbgustr 'could not retrieve current working directory name ####'
gotcwd:

; now get the command line:
ifdef customaddon
; custom for Personal Editor 3
        mov     rcx,prmstringc  ;number of parameters
        mov     rsi,prmstringptrs ;pointer array to parameters
else
        mov     rcx,qword ptr [rsp]
        mov     prmstringc,rcx  ;save number of parameters parsed
        mov     rsi,rsp
        add     rsi,8
endif

        lea     rdi,PARM        ;make local copy here
        mov     rdx,PARMAX
prmlx0: mov     rbx,qword ptr [rsi] ;get address of parameter
prmlx1: mov     al,[rbx]
        mov     [rdi],al
        inc     rdi
        inc     rbx
        dec     rdx
        jz      prmoverx        ;quit if too long
        cmp     al,0
        jne     prmlx1
        add     rsi,8
        loop    prmlx0
prmoverx: sub   rdi,prmstringa
        mov     prmstringl,rdi  ;total length of parameters

else                            ;Windows 64 version ===========================
        externdef SetConsoleCtrlHandler : near
        winstack
        lea     rcx,ctrlbreak
        mov     rdx,1           ;True
        call    SetConsoleCtrlHandler   ;#########
        winstacke
        cmp     rax,0
        jnz     nosccher
        dbgustr 'SetConsoleCtrlHandler return code'
nosccher:

        lea     rax,windowsosname               ;for &OS
        mov     OSSP,rax
        mov     QWORD PTR OSSP+LOFFSET,windowsosnamelen*256

        lea     rax,windowsslash                ;for &DS
        mov     DSSP,rax
        mov     QWORD PTR DSSP+LOFFSET,1*256

; get the environment variable
        lea     rsi,envarname
        mov     rcx,envarnamelen
        call    s5getenv

        externdef GetCurrentDirectoryA : near
        winstack
        mov     rcx,oldcwdmax
        lea     rdx,oldcwd
        call    GetCurrentDirectoryA
        winstacke
        cmp     rax,0
        jne     gotcwd
        dbgustr 'failed to get current directory name ####'
gotcwd:

        externdef GetCommandLineW : near
        winstack                ; must leave 32 bytes space plus for more parameters
        call    GetCommandLineW
        winstacke
        externdef CommandLineToArgvW : near
        winstack
        mov     rcx,rax
        lea     rdx,count
        call    CommandLineToArgvW
        winstacke

        mov     rcx,count
        mov     prmstringc,rcx  ;save number of parameters parsed
        mov     rsi,rax
        lea     rdi,PARM        ;make local copy here

        mov     rdx,PARMAX
prmlp0: mov     rbx,qword ptr [rsi] ;get address of parameter
prmlp1: mov     al,[rbx]
        mov     [rdi],al
        inc     rdi
        inc     rbx
        inc     rbx
        dec     rdx
        jz      prmoverp
        cmp     al,0
        jne     prmlp1
        add     rsi,8
        loop    prmlp0
prmoverp: sub   rdi,prmstringa
        mov     prmstringl,rdi  ;total length of parameters
endif                           ; END WINDOWS version


; Set command line string to work space &PARM keyword
        mov     rax,prmstringa
        mov     PARMSP,rax
        mov     rax,prmstringl
        shl     rax,8
        mov     qword ptr [PARMSP+LOFFSET],rax

;push    rsi ;#### show what we will try to parse
;push    rcx
;call    dbgs
;db      '"',0
;mov     rsi,prmstringa
;mov     rcx,prmstringl
;call    dbgstr
;call    dbgs
;db      '"',13,10,0
;pop     rcx
;pop     rsi ;####

      pstart  prmstringa,prmstringl,testfail
        pbreak  zerochar,1              ;skip program name
        plen    1
        parbnos
          plp
            plp     ;alternatives for work space
              pstri   '--help'
; Print version ID message           ####
              lea     rsi,IDMSG
              lea     rcx,IDMSGE
              sub     rcx,rsi
              call    dbgstr
              call    dbgcrlf
ifdef linuxenvironment
              dbgustr 'To run: ./snobol5 [options...] [files...] [:user data]'
else
              dbgustr 'To run: snobol5 [options...] [files...] [:user data]'
endif
              dbgustr 'options:'
              dbgustr '  --work=nnnn[b|k|m|g]  work space size'
              dbgustr '  -ex                   execute even if have compile errors'
              dbgustr '  -s                    produce statistics'
              dbgustr '  -d                    set &DUMP to 1'
              dbgustr '  -v                    produce source listing and statistics'
              dbgustr '  --help                this help'
              dbgustr 'files:    if -nn is omitted it is assumed to be -5'
              dbgustr '  [-nn] filename [attribs...]  where nn is i/o unit number'
              dbgustr 'attribs:                file attributes'
              dbgustr '  -a = ascii text lines vs. -b = binary'
              dbgustr '  -tabx vs. -ntabx      tab decoding/encoding'
              dbgustr '  -r = replace on write vs. -ap = append on write'
              dbgustr '  -vl = variable length ascii read vs. -fl = fixed length'
              dbgustr '  -i vs. -ni            include & snopath processing on ascii reads'
              dbgustr '  -std                  standard i/o, use name=in, out or err'
              dbgustr '  -cr vs. -ncr          use carriage control characters'
              dbgustr 'Example:'
              dbgustr 'snobol5 -v myprogram.sno -1 datafileA.xxx -b'
ifdef linuxenvironment
              mov     rdi,0               ;return code
              mov     rax,60              ;exit call
              syscall                     ;exit program
else
              externdef ExitProcess : near
              mov     rcx, 0              ; return code
              call    ExitProcess
endif
            palt
              pstri   '-v'
              pspan   whitespacez,whitespacezlen
              mov     qword ptr LISTCL,1
              mov     qword ptr STATCL,1
            palt
              pstri   '-s'
              pspan   whitespacez,whitespacezlen
              mov     qword ptr STATCL,1
            palt
              pstri   '-d'
              pspan   whitespacez,whitespacezlen
              mov     qword ptr DMPCL,1
            palt
              pstri   '-ex'
              pspan   whitespacez,whitespacezlen
              mov     qword ptr EXECER,1        ;execute even if compile errors
            palt              ;##### for testing only

              pstri   '--test='
              passns
                pspani  '0123456789'
              passne  workspacestr,workspacelen,workspacemax
              pspan   whitespacez,whitespacezlen
              lea     rsi,workspacestr
              mov     rcx,workspacelen
              call    SIL100
              jo      priorprv
              mov     testparameter,rcx

            palt

              pstri   '--work='
              passns
                pspani  '0123456789'
              passne  workspacestr,workspacelen,workspacemax
              panyi   'kK'
              pspan   whitespacez,whitespacezlen
              lea     rsi,workspacestr
              mov     rcx,workspacelen
              call    SIL100
              jo      priorprv
              mov     rax,rcx
              mov     rbx,1024
              mul     rbx
              jo      priorprv
              mov     WorkSpaceSize,rax

            palt

              pstri   '--work='
              passns
                pspani  '0123456789'
              passne  workspacestr,workspacelen,workspacemax
              panyi   'mM'
              pspan   whitespacez,whitespacezlen
              lea     rsi,workspacestr
              mov     rcx,workspacelen
              call    SIL100
              jo      priorprv
              mov     rax,rcx
              mov     rbx,1048576
              mul     rbx
              jo      priorprv
              mov     WorkSpaceSize,rax

            palt

              pstri   '--work='
              passns
                pspani  '0123456789'
              passne  workspacestr,workspacelen,workspacemax
              panyi   'gG'
              pspan   whitespacez,whitespacezlen
              lea     rsi,workspacestr
              mov     rcx,workspacelen
              call    SIL100
              jo      priorprv
              mov     rax,rcx
              mov     rbx,1073741824
              mul     rbx
              jo      priorprv
              mov     WorkSpaceSize,rax

            palt

              pstri   '--work='
              passns
                pspani  '0123456789'
              passne  workspacestr,workspacelen,workspacemax
              panyi   'bB'
              pspan   whitespacez,whitespacezlen
              lea     rsi,workspacestr
              mov     rcx,workspacelen
              call    SIL100
              jo      priorprv
              mov     WorkSpaceSize,rcx

            palt

              pstri   '--work='
              passns
                pspani  '0123456789'
              passne  workspacestr,workspacelen,workspacemax
              pspan   whitespacez,whitespacezlen
              lea     rsi,workspacestr
              mov     rcx,workspacelen
              call    SIL100
              jo      priorprv
              mov     WorkSpaceSize,rcx

            prp                 ;end alternatives for work space

            mov     rax,WorkSpaceSize
            add     rax,0fffh
            or      rax,0fffh
            xor     rax,0fffh               ;round up to next 4096 boundary
            mov     WorkSpaceSize,rax
;           call    dbgprtfi
;           dbgustr ' bytes of work space to be allocated'
;           ;##### at least 397k needed

          palt                          ;file assignments:
            pstri '-'
            passns
              pspani  '0123456789'
            passne  scanunitnum,scanunitnumlen,scanunitnummax
            pspan   whitespacez,whitespacezlen
            passns
              pbreak  zerochar,1
            passne  filenam,filenamlen,filenammax

            mov         CURUNIT,0       ;clear current unit poitner
; allocate i/o unit
                lea rsi,scanunitnum
                mov rcx,scanunitnumlen
                call SIL100
                jo  unoor       ;unit number out of range
                cmp rcx,0
                jl  unoor
                cmp rcx,UNITARRAYMAX
                jnl unoor
                jmp unoir
unoor:  dbgustr 'Unit number out of range'
                jmp priorprv
unoir:
                mov unitnumsav,rcx
                shl rcx,3
                lea rsi,UNITARRAY
                add rsi,rcx     ;address in UNITARRAY
                mov rdi,[rsi]   ;see if already allocated
                cmp rdi,0
                jnz unoal       ;jump if already allocated
                mov     rcx,UNITSIZE
                push    rsi
                call    myalloc
                pop     rsi
                mov     [rsi],rax
                mov     r10,rax
unoal:          mov     CURUNIT,r10     ;save current unit pointer
                mov     dword ptr UNITSTR.UNITVALID[r10],UNITVALIDCODE
; Set some default attributes for files,  also done in FILNAMI and FILNAMO
ifdef linuxenvironment
        mov     dword ptr UNITSTR.UNITFLAGS[r10],UNITNOCR+UNITNOEF   ;default for linux
else
        mov     dword ptr UNITSTR.UNITFLAGS[r10],UNITNOEF            ;default for windows
endif
                lea     rdi,UNITSTR.UNITNAME[r10]
                lea     rsi,filenam
                mov     rcx,filenamlen ;#### make sure not too long
                rep movsb ;copy file name to unit area
                mov     byte ptr [rdi],0 ;add trailing null
                cmp unitnumsav,5        ;if unit 5
                jnz @F
                or      UNITSTR.UNITFLAGS[r10],UNITIC ;turn on includes
@@:
            passns
              parbnos
                plp
                  plen 0
                palt
                  pspan whitespacez,whitespacezlen
                prp
                  mov   r10,CURUNIT
                  cmp   r10,0
                  je    priorprv        ;don't go further if unit not set
                include fileattr.inc    ;file attribute flags
              parbnoe

            passne  attribs,attribslen,attribsmax
            pspan   whitespacez,whitespacezlen
          palt                  ;user parameters after colon (:)
            pstri ':'
              xor rax,rax
              mov CURUNIT,rax   ;don't handle stuff after colon for any file
            prem
          palt                  ;unit 5 filename
            passns
              pnotanyi '-:'
              pbreakx whitespacez,whitespacezlen
            passne  filenam,filenamlen,filenammax

            lea rsi,UNITARRAY
            add rsi,40      ;address in UNITARRAY for unit 5
            mov rdi,[rsi]   ;see if already allocated
            cmp rdi,0
            jnz unoal2      ;jump if already allocated
            mov     rcx,UNITSIZE
            call    myalloc
            mov [rsi],rax
            mov     r10,rax
unoal2:     mov     CURUNIT,r10     ;save current unit pointer
            mov     dword ptr UNITSTR.UNITVALID[r10],UNITVALIDCODE
            lea     rdi,UNITSTR.UNITNAME[r10]
            lea     rsi,filenam
            mov     rcx,filenamlen ;#### make sure not too long
            rep movsb ;copy file name to unit area
            mov     byte ptr [rdi],0
            or      UNITSTR.UNITFLAGS[r10],UNITIC ;turn on includes
            passns
              parbnos
                plp
                  plen 0
                palt
                  pspan   whitespacez,whitespacezlen
                prp
                  mov   r10,CURUNIT
                  cmp   r10,0
                  je    priorprv        ;don't go further if unit not set
                include fileattr.inc    ;file attribute flags
              parbnoe

            passne  attribs,attribslen,attribsmax
            pspan   whitespacez,whitespacezlen

          prp                   ;end of big alternative
        parbnoe
        prpos   0
      pend

        jmp     testsuccess

testfail:
        mov     rax,cursormax
        call    dbgprtfi
        call    dbgs
        db      '= cursor, Failed to understand all parameters on command line.',13,10,0
        mov     rsi,prmstringa
        mov     rcx,prmstringl
        call    dbgstr
        call    dbgs
        db      '"',13,10,0
        jmp     testdone
testsuccess:
testdone:


; try prereading first line of source for -PRM parameters
        mov     rbx,UNITI       ;unit number for source
        lea     rdi,prereadline
        mov     rcx,0
        mov     rdx,0
        lea     r8,prparsefail
        lea     r9,prparsefail
        lea     r12,prparsefail
        call    SIL105          ;preread the first line of source
; now parse the preread line for any paramters
        pstart  prereadlinea,256,prparsefail
          pbreaki '-'
          parbnos
              plp     ;alternatives for work space
                pstri   '-v'
                pspan   delimchar,3
                mov     qword ptr LISTCL,1
                mov     qword ptr STATCL,1
              palt
                pstri   '-s'
                pspan   delimchar,3
                mov     qword ptr STATCL,1
              palt
                pstri   '-d'
                pspan   delimchar,3
                mov     qword ptr DMPCL,1
              palt
                pstri   '-ex'
                pspan   delimchar,3
                mov     qword ptr EXECER,1        ;execute even if compile errors
              palt
                pstri   '--work='
                passns
                  pspani  '0123456789'
                passne  workspacestr,workspacelen,workspacemax
                panyi   'kK'
                pspan   delimchar,3
                lea     rsi,workspacestr
                mov     rcx,workspacelen
                call    SIL100
                jo      priorprv
                mov     rax,rcx
                mov     rbx,1024
                mul     rbx
                jo      priorprv
                mov     WorkSpaceSize,rax
              palt
                pstri   '--work='
                passns
                  pspani  '0123456789'
                passne  workspacestr,workspacelen,workspacemax
                panyi   'mM'
                pspan   delimchar,3
                lea     rsi,workspacestr
                mov     rcx,workspacelen
                call    SIL100
                jo      priorprv
                mov     rax,rcx
                mov     rbx,1048576
                mul     rbx
                jo      priorprv
                mov     WorkSpaceSize,rax
              palt
                pstri   '--work='
                passns
                  pspani  '0123456789'
                passne  workspacestr,workspacelen,workspacemax
                panyi   'gG'
                pspan   delimchar,3
                lea     rsi,workspacestr
                mov     rcx,workspacelen
                call    SIL100
                jo      priorprv
                mov     rax,rcx
                mov     rbx,1073741824
                mul     rbx
                jo      priorprv
                mov     WorkSpaceSize,rax
              palt
                pstri   '--work='
                passns
                  pspani  '0123456789'
                passne  workspacestr,workspacelen,workspacemax
                panyi   'bB'
                pspan   delimchar,3
                lea     rsi,workspacestr
                mov     rcx,workspacelen
                call    SIL100
                jo      priorprv
                mov     WorkSpaceSize,rcx
              palt
                pstri   '--work='
                passns
                  pspani  '0123456789'
                passne  workspacestr,workspacelen,workspacemax
                pspan   delimchar,3
                lea     rsi,workspacestr
                mov     rcx,workspacelen
                call    SIL100
                jo      priorprv
                mov     WorkSpaceSize,rcx
              prp                 ;end alternatives for work space
              mov     rax,WorkSpaceSize
              add     rax,0fffh
              or      rax,0fffh
              xor     rax,0fffh               ;round up to next 4096 boundary
              mov     WorkSpaceSize,rax
          parbnoe
          prpos   0
        pend
        jmp     prparseok
prparsefail:
; Don't give message because #!/bin/bash line might have parameters or not
;       dbgustr 'failed to understand -PRM parameters'
prparseok:
; end try prereading first line of sourceend

        CLD                     ;clear direction flag to ascending


; Allocate and initialize work space

        mov     rcx,WorkSpaceSize       ; length
        call    myalloc
        mov     WorkSpaceAddr,rax
        add     rax,WorkSpaceSize
        mov     WorkSpaceLast,rax

; Set up floating point

        CALL    SETUP8087               ;Initialize floating point

; Initialize random number seed
        call    sil19
        mov     rax,qword ptr timetext
        xor     randx,rax
        mov     rax,qword ptr timetext+8
        xor     randx,rax
        mov     rax,qword ptr timetext+16
        xor     randx,rax

ifdef linuxenvironment
        call    ReadLocalTime
endif

        push    rax
        and     rsp,stkalign
        mov     EXSTARTRSP,rsp          ;Save to reset stack later

        call    setstack                ;set STLIMIT

ifdef   showstart
;jmp nodebuginfo       ;show or not show debug info
 dbgustr 'Environment variable: ####'
 lea rsi,envbuffer
 mov rcx,envbufferlen
 call dbgstr
 call dbgcrlf
 call dbgdump
 call    dbgs    ;##############
 db      'Parameter string:',13,10,0
 mov     rsi,prmstringa
 mov     rcx,prmstringl
 mov     al,'"'
 call    dbgprtc
 call    dbgstr
 mov     al,'"'
 call    dbgprtc
 call    dbgcrlf
 call    dbgdump
 call dbgcrlf
 mov rax,rsp
 mov sasoe,rax
 call dbgprtx
 call dbgblnk
 call dbgprtfi
 dbgustr '= Stack at start of execution'
 mov rax,STLIMIT
 call dbgprtx
 call dbgblnk
 call dbgprtfi
 dbgustr '= STLIMIT'
 mov rax,WorkSpaceAddr
 call dbgprtx
 dbgustr '= Work space start'
 mov rax,WorkSpaceLast
 call dbgprtx
 dbgustr '= Work space end'
 lea rax,AUGATL
 call dbgprtx
 dbgustr '= Start of SIL code'
 lea rax,XLATND
 call dbgprtx
 dbgustr '= Almost end of SIL code'
 lea rax,MSGLST
 call dbgprtx
 dbgustr '= start of staic SIL data'
 lea rax,ADJBDY
 call dbgprtx
 dbgustr '= ADJBDY start of string storage bin lists'
 lea rax,GCBDY
 call dbgprtx
 dbgustr '= GCBDY'
 lea rax,ENDLOC
 call dbgprtx
 dbgustr '= end of static SIL data'
 call dbgcrlf
 lea rax,asmdataend  ;######
 lea rbx,asmdatastart
 sub rax,rbx
 mov rcx,rax
 call dbgprtfi
 dbgustr '=asm data len'
 lea rax,silcodeend
 lea rbx,silcodestart
 sub rax,rbx
 call dbgprtfi
 dbgustr '=sil code size'
 lea rax,datainite
 lea rbx,datainit
 sub rax,rbx
 call dbgprtfi
 dbgustr '=sil data size'
 sub rcx,rax
 mov rax,rcx
 call dbgprtfi
 dbgustr '=non sil data size'
nodebuginfo:
endif


include addrmap.inc                     ;#### address dump for debug


; Starting SIL code execution
        JMP     BEGIN                   ;Go to INIT statement in SIL code

; Ctrl-break handler
sigreturn: mov  rax,15  ;sys_rt_sigreturn
        syscall

usr1signal:
        call    dbgs
        db      13,10,'Program running at statement ',0
        mov     rax,STNOCL
        call    dbgprtfi
        call    dbgs
        db      ' with ',0
        mov     rax,EXNOCL
        call    dbgprtfi
        call    dbgs
        db      ' statements executed so far',13,10,0
        ret

ctrlbreak:
        cmp     silsleeping,0
        jne     breakit
        inc     SIL120CT                ;increment ctrl-break count
        cmp     SIL120CT,9
        jna     @F                      ;force stop if get 10 unhandled breaks
breakit: mov    rsp,EXSTARTRSP
        jmp     SYSCUT
@@:     ret

;**********************************************************************
; The following are the SIL opcode implementations
;**********************************************************************
        INCLUDE GETSTACK.INC
        INCLUDE INT2STR.INC
        INCLUDE FLTINIT.INC
        INCLUDE MYALLOC.INC
        INCLUDE FLTRTN.INC
        INCLUDE SORT.INC
        INCLUDE SILCODE.INC
        INCLUDE ORDVST.INC
ifdef customaddon
        INCLUDE PE3.INC
endif

;**********************************************************************
; The following is the expanded SIL implementation of Snobol
;**********************************************************************

        .code
silcodestart:
        INCLUDE intcod.inc
silcodeend:
        db      'S5 code finish!!'

        .data
        align   16
datainit dq      0,0         ;16 byte zero is first slot
        INCLUDE intdta.inc
datainite db    0
datainitl equ   (datainite-datainit)    ;length of preloaded data area

        align   16
preloadl dq     preloade-preload
preloada dq     preload
preload equ $
;       db      1024 dup('yuky')        ;####
        INCLUDE INCCODE.INC
preloade equ    $
asmdataend equ  $
        db      'S5 data finish!!'
        END

