rand    proc
; Written by Viktors Berstis
; mixed congruential generator
; m = 2**64
; a = 6364136223846793005
; c = 1442695040888963407
; xnew = (a * xold + c) mod m
; m > 0
; 0 < a < m
; 0 <= c < m
; 0 <= xstart < m
; https://en.wikipedia.org/wiki/Linear_congruential_generator
; Could be improved with a better algorithm
        cmp     rax,0
        jnz     @F              ;if argument not zero, it is new seed
        mov     rax,randx
@@:     mov     rbx,randa
        mul     rbx
        add     rax,randc
        mov     randx,rax
        mov     qword ptr [rdi],rax
        ret
rand    endp
