; ORDVST - sort the variables for the dump ====================================
; Written by Viktors Berstis
ordvst  proc

        lea     rsi,OBSTRT-DESCR ;Hash bin before first
        lea     rdx,OBSTRT+(OBSIZ*DESCR)-DESCR ;last chain address
binlp:  cmp     rsi,rdx
        ja      binsdone        ;Jump if examined all hash bins
        add     rsi,DESCR

        mov     rdi,[rsi]       ;get first item in the bin
        mov     qword ptr [rsi],0 ;set that bin to empty
varlp:
        and     rdi,rdi         ;anything there?
        jz      binlp           ;go do next bin

        mov     r14,[rdi+LNKFLD] ;save its next pointer
        mov     rbx,[rdi+1*DESCR+VOFFSET] ;address field
        shr     rbx,8
        cmp     rbx,S           ;is it a string?
        jne     varnots
        mov     rax,[rdi+1*DESCR] ;address field
        and     rax,rax
        jz      skipvar         ;skip ones pointing to null string
varnots:

        ;insert this into proper place in the list

        lea     r8,[rdi+4*DESCR] ;address of this name
        mov     r9,[rdi+VOFFSET]
        shr     r9,8             ;length of this name
; compare loop
        lea     r13,OBSTRT-LNKFLD ;fake prior entry for big list
        mov     r10,r13
compareloop:
        mov     r13,r10         ;prior entry for next one:
        mov     r10,[r10+LNKFLD] ;next entry in big list
        and     r10,r10         ;is list empty or at end of list
        jnz     varthere        ;there is one there
        mov     r15,rdi         ;make this var first or last in the big list
        mov     qword ptr [r13+LNKFLD],rdi ;have big list point to this var
        mov     qword ptr [rdi+LNKFLD],0 ;no next ptr
        jmp     skipvar
varthere:
        lea     r11,[r10+4*DESCR] ;address of name in big list
        mov     r12,[r10+VOFFSET]
        shr     r12,8             ;length of name in big list
      push rcx
      push rsi
      push rdi
        mov     rcx,r9
        cmp     rcx,r12
        jna     @F
        mov     rcx,r12         ;shortest of the two lengths
@@:
        jrcxz   oneiszero
        mov     rsi,r8          ;address of name to insert
        mov     rdi,r11         ;address of name in big list
        repe cmpsb

        jb      insertbefore    ;lower than big list item
        ja      notyet          ;higher than big list item
oneiszero:                      ;compare lengths now
        cmp     r9,r12
        jb      insertbefore
        ja      notyet          ;if eq, that would be strange!####
notyet:
      pop rdi
      pop rsi
      pop rcx
        jmp compareloop

skipvar:
        mov     rdi,r14         ;next item in bin list
        jmp     varlp

insertbefore:
      pop rdi
      pop rsi
      pop rcx
;dbgustr 'inserting'
        mov     rax,[r13+LNKFLD] ;big lists next pointer
        mov     [r13+LNKFLD],rdi ;put new item into big list
        mov     [rdi+LNKFLD],rax ;put next pointer into new entry
        jmp     skipvar

binsdone:

        ret
ordvst  endp
