; =============================================================================
; =============================================================================
; openwrit: Open a file for writing
; Written by Viktors Berstis
; Input:
;       CURUNIT - pointer to unit structure
;      .UNITNAME - pointer to file name string
;      .UNITOPEN - to check if meant for write
; Output:
;      .UNITHANDLE - file handle
;      .UNITPW - set to show unit is valid UNITPWMK
;      Assumes myalloc sets offsets to zero ###
; =============================================================================
; =============================================================================
openwrit proc
        dbgsv
        mov     r10,CURUNIT
        test    UNITSTR.UNITOPEN[r10],ROPEN ;is it already set for read?
        jz      OPENWRonow
  dbgustr 'already open for read while trying to open for write ####'
  ;jmp to some error #####
        jmp     OPENWRio
OPENWRonow:
        or      UNITSTR.UNITOPEN[r10],WOPEN
        cmp     UNITSTR.UNITPW[r10],UNITPWMK ;is it already open for write?
        je      OPENWRio                ;skip if already open
        test    UNITSTR.UNITFLAGS[r10],UNITDIR ;cannot write directory
        jnz     OPENWRio
        test    UNITSTR.UNITFLAGS[r10],UNITSTD ;standard input?
        jz      OPENWRfo        ;go do file open

; =============================================================================
; STANDARD INPUT open:
; =============================================================================
; check if name is "OUT" or "ERR" or "out" or "err"
        xor     rcx,rcx

        mov     rax,qword ptr UNITSTR.UNITNAME[r10]
        and     rax,0ffffffffh
        cmp     rax,0074756fh   ;if it is "out"
        jne     openwritnotout
        mov     ecx,-11         ; STD_OUTPUT_HANDLE
openwritnotout:
        cmp     rax,0054554fh   ;if it is "OUT"
        jne     openwritnotout2
        mov     ecx,-11         ; STD_OUTPUT_HANDLE
openwritnotout2:
        cmp     rax,00727265h   ;if it is "err"
        jne     openwritnoterr
        mov     ecx,-12         ; STD_ERROR_HANDLE
openwritnoterr:
        cmp     rax,00535345h   ;if it is "ERR"
        jne     openwritnoterr2
        mov     ecx,-12         ; STD_ERROR_HANDLE
openwritnoterr2:
        cmp     ecx,0           ; did we get a correct standard name?
        jnz     openwrithok
 dbgustr 'was not standard output "out" or standard error "err" name ####'
  ;##### jump to some error point
openwrithok:

ifdef linuxenvironment          ;do standard handle open
        neg     ecx
        sub     ecx,10
        mov     dword ptr UNITSTR.UNITHANDLE[r10],ecx ;standard out handle 1
                                                  ; or standard error handle 2
else                            ; Windows version
        winstack                ; must leave 32 bytes space plus for more parameters
        call    GetStdHandle
        mov     r10,CURUNIT
        mov     UNITSTR.UNITHANDLE[r10],rax
        winstacke
endif
        mov     UNITSTR.UNITPW[r10],UNITPWMK    ;indicate open
        jmp     OPENWRio        ;is open now

; =============================================================================
; OPEN file using name
; ##### implement using environment variable to find includes
; =============================================================================
OPENWRfo:                       ;open a file by name
ifdef linuxenvironment          ;do file handle open
O_WRONLY EQU 1
O_RDWR EQU 2
O_APPEND EQU 400h
O_TRUNC EQU 200h
O_CREAT EQU 40h
        mov     rax,2           ;linux sys_open system call
        lea     rdi,UNITSTR.UNITNAME[r10] ; 1: filename pointer
        mov     rsi,O_TRUNC+O_CREAT+O_RDWR ; 2: flags
        test    UNITSTR.UNITFLAGS[r10],UNITAPPEND
        jz      @F
        mov     rsi,O_APPEND+O_CREAT+O_RDWR ; 2: flags
@@:
        mov     rdx,1c0h        ; 3: mode  700 octal
        syscall
        cmp     rax,0
        jl      OPENWRopenerror
        mov     r10,CURUNIT
        mov     UNITSTR.UNITHANDLE[r10],rax
        mov     UNITSTR.UNITPW[r10],UNITPWMK    ;indicate open
        jmp OPENWRio                    ;unit is open
OPENWRopenerror:
        mov     rbx,ERRLCL
        and     rbx,rbx
        jnz     OPENWRskiper1   ;dont write error if ERRLIMIT not zero
        neg     eax
        and     rax,0ffffffffh
        call    dbgprtfi
        dbgustr '= linux error opening file'
OPENWRskiper1:
        mov     r10,CURUNIT
        mov     UNITSTR.UNITERROR[r10],1
        jmp     OPENWRio                ;##### give error instead
else                            ;Windows version
        externdef CreateFileA : near
FILE_SHARE_READ equ 1
FILE_SHARE_WRITE equ 2
GENERIC_READ    equ 80000000h
GENERIC_WRITE   equ 40000000h
;OPEN_EXISTING   equ 3
OPEN_ALWAYS     equ 4
CREATE_ALWAYS   equ 2
;##### how to open for append
        winstack 3                  ; must leave 32 bytes space plus for more shadow parameters
        lea     rcx,UNITSTR.UNITNAME[r10] ; 1: filename pointer
        mov     rdx,GENERIC_WRITE   ; 2: desired access
        mov     r8d,FILE_SHARE_READ ; 3: allow reading while we write
        mov     r9, 0               ; 4: security attributes
        mov     rax,OPEN_ALWAYS     ; 5: creation disposition - append version
        test    UNITSTR.UNITFLAGS[r10],UNITAPPEND
        jnz     @F
        mov     rax,CREATE_ALWAYS   ; 5: creation disposition - replace version
@@:
        mov     [rsp+32],rax
        xor     rax,rax             ; 6: flags and attributes
        mov     [rsp+40],rax
        mov     [rsp+48],rax        ; 7: optional
        call    CreateFileA
        winstacke
        cmp     rax,-1
        je      OPENWRopenerror
        mov     r10,CURUNIT
        mov     UNITSTR.UNITHANDLE[r10],rax
        mov     UNITSTR.UNITPW[r10],UNITPWMK    ;indicate open
; check if we have to move pointer to the end of the file
        test    UNITSTR.UNITFLAGS[r10],UNITAPPEND
        jz      OPENWRio                ;no append to end
;##### todo: move pointer to end of file (handle 1ah also)
        push    r10
        winstack                ; must leave 40 bytes space plus for more shadow parameters
        mov     rcx,UNITSTR.UNITHANDLE[r10] ; 1: file handle
        mov     rdx,0           ; 2: reposition value
        lea     r8,sil127seeknew ; 3: place to put new position
        mov     r9,2            ; 4: seek type - FILE_END
        xor     rax,rax
        call    SetFilePointerEx
        winstacke
        pop     r10
        ; returns 0 on failure
        and     rax,rax
        jz      OPENWRopenerror
        mov     r11,sil127seeknew
        mov     UNITSTR.UNITVSEEK[r10],r11 ;set new position in file
        jmp OPENWRio                    ;unit is open

OPENWRopenerror:
; #### might give for existing or not existing file
        mov     rax,ERRLCL
        and     rax,rax
        jnz     OPENWRskiper2   ;no message if ERRLIMIT not zero
        dbgustr 'error opening file'
        call    dbggle
OPENWRskiper2:
        mov     r10,CURUNIT
        mov     UNITSTR.UNITERROR[r10],1
        jmp     OPENWRio
endif


        mov     UNITSTR.UNITVSEEK[r10],0

OPENWRio:                               ;is open now
        dbgrs
        ret
openwrit endp
