; =============================================================================
; =============================================================================
; openread: Open a file for reading
; Written by Viktors Berstis
; Input:
;       CURUNIT - pointer to unit structure
;      .UNITNAME - pointer to file name string
;      .UNITOPEN - to check if open meant for read
; Output:
;      .UNITHANDLE - file handle
;      .UNITPW - set to show unit is valid UNITPWMK
;      Assumes myalloc sets offsets to zero ###
; =============================================================================
; =============================================================================
openread proc

        dbgsv
        mov     r10,CURUNIT

        test    UNITSTR.UNITOPEN[r10],WOPEN ;is it already open for write?
        jz      OPENRDonow
;  dbgustr 'unit already set for write while trying to open for read ####'
  ;jmp to some error #####

OPENRDonow:
        or      UNITSTR.UNITOPEN[r10],ROPEN ;open for read in case of doubt
        cmp     UNITSTR.UNITPW[r10],UNITPWMK ;is it already open for read?
        je      OPENRDio                ;skip if already open
        test    UNITSTR.UNITFLAGS[r10],UNITDIR ;directory read?
        jnz     OPENRDdir       ;go do directory open
        test    UNITSTR.UNITFLAGS[r10],UNITSTD ;standard input?
        jz      OPENRDfo        ;go do file open
        jmp     OPENRDst        ;go do standard input open

; =============================================================================
; DIRECTORY INPUT open:
; =============================================================================
OPENRDdir: ;########
ifdef linuxenvironment
        jmp     OPENRDfo        ;same as file open for linux
else
; Add "/*",0 to the end of the path name, will use FindFirstFile... later
        lea     rdi,UNITSTR.UNITNAME[r10]
        mov     rcx,UNITNAMEL   ;max length
@@:     cmp     byte ptr [rdi],0        ;look for trailing zero
        jz      @F              ;found trailling zero
        inc     rdi
        dec     rcx
        jz      OPENRDreallyno  ;return error
        jmp     @B
@@:     mov     byte ptr [rdi],'/'
        mov     byte ptr [rdi+1],'*'
        mov     byte ptr [rdi+2],0
        mov     UNITSTR.UNITHANDLE[r10],0       ;to indicate no reads yet
        jmp     OPENRDio ;done
endif

; =============================================================================
; STANDARD INPUT open:
; =============================================================================
; check if name is "in" or "IN"
OPENRDst: mov   rax,qword ptr UNITSTR.UNITNAME[r10]
        and     rax,000ffffffh
        cmp     rax,00006e69h   ;if it is "in"
        jne     openreadnotin
        mov     ecx,-10         ; STD_INPUT_HANDLE
openreadnotin:
        cmp     rax,0004e49fh   ;if it is "IN"
        jne     openreadnotin2
        mov     ecx,-10         ; STD_INPUT_HANDLE
openreadnotin2:
        cmp     ecx,0           ; did we get a correct standard name?
        jnz     openreadhok
 ;###### jump to some error point?
openreadhok:
; dbgustr 'at openread6  ####'
;dbgustr 'opening standard input ####'
ifdef linuxenvironment          ;do standard handle open
        mov     dword ptr UNITSTR.UNITHANDLE[r10],0 ;standard input handle
else                            ; Windows version
        winstack                ; must leave 32 bytes space plus for more parameters
        mov     ecx,-10         ; STD_INPUT_HANDLE
        call    GetStdHandle
        mov     r10,CURUNIT
        mov     UNITSTR.UNITHANDLE[r10],rax
        winstacke
endif
        mov     UNITSTR.UNITPW[r10],UNITPWMK    ;indicate open
        jmp     OPENRDio        ;is open now

; =============================================================================
; OPEN file using name
; ##### implement using environment variable to find includes
; =============================================================================
OPENRDfo:                       ;open a file by name
        mov     environoffset,0 ;offset in environment variable of paths
; get file handle
OPENRDretry:
        call    actualopen
        jc      OPENRDopenerror

OPENRDio:                       ;is open
; restore current directory if changed
        call    restorecwd
        mov     r10,CURUNIT
        mov     UNITSTR.UNITPW[r10],UNITPWMK    ;indicate open
        dbgrs
        ret             ;unit is open

OPENRDopenerror:
        mov     r10,CURUNIT

        test    UNITSTR.UNITFLAGS[r10],UNITIC ;possible include file?
        jz      OPENRDreallyno
getnextenv:

        lea     r15,envbuffer
        mov     r14,envbufferlen
        add     r15,environoffset
        sub     r14,environoffset

        pstart  r15,r14,OPENRDreallyno
          plp
           passns
            pbreak envdelim,1
           passne envpath,envpathlen,envpathmax
           pany envdelim,1
          palt
           passns
            plen 1
            prem
           passne envpath,envpathlen,envpathmax
          prp
          mov   rax,cursoro
          add   environoffset,rax       ;start here next time
        pend

;#### SetCurrentDirectoryA  sys_chdir
ifdef linuxenvironment          ;LINUX version ================================
        lea     rdi,envpath
        mov     rax,rdi
        add     rax,envpathlen
        mov     byte ptr [rax],0
        mov     rax,50h         ;sys_chdir
        syscall
        and     rax,rax
        jz      @F
 dbgustr 'sys_chdir failed ####'
        jmp     getnextenv
@@:
else                            ;WINDOW version ===============================
        externdef SetCurrentDirectoryA : near
        winstack
        lea     rcx,envpath
        mov     rax,rcx
        add     rax,envpathlen
        mov     byte ptr [rax],0
        call    SetCurrentDirectoryA
        winstacke
        and     rax,rax
        jnz     @F
        jmp     getnextenv
@@:
endif
        mov     r10,CURUNIT
        mov     UNITSTR.CDchanged[r10],1
        jmp     OPENRDretry

OPENRDreallyno:
        call    restorecwd
        mov     rax,ERRLCL
        and     rax,rax
        jnz     IOREADskiper1   ; no messag if ERRLIMIT not zero
        dbgustr 'Error opening file or directory:'
        lea     rsi,UNITSTR.UNITNAME[r10]
        call    dbgstrz
;#### could call dbggle for windows version
IOREADskiper1:
        mov     r10,CURUNIT
        mov     UNITSTR.UNITERROR[r10],1
        dbgrs
        ret
openread endp

; Get the file handle to open the file
; returns carry flag if this fails
actualopen proc

ifdef linuxenvironment          ;LINUX version ================================
O_RDONLY EQU 0
        mov     rax,2           ;linux open system call
        lea     rdi,UNITSTR.UNITNAME[r10] ; 1: filename pointer
        mov     rsi,0                     ; 2: flags
        mov     rdx,O_RDONLY              ; 3: mode
        syscall
        cmp     rax,0
        jl      actuallyfailed
        mov     r10,CURUNIT
        mov     UNITSTR.UNITHANDLE[r10],rax
        mov     UNITSTR.UNITPW[r10],UNITPWMK    ;indicate open
        jmp     actuallyopen            ;unit is open
else                            ;Windows version ==============================
        externdef CreateFileA : near
FILE_SHARE_READ equ 1
GENERIC_READ    equ 80000000h
OPEN_EXISTING   equ 3
        winstack 3                  ; must leave 32 bytes space plus for more shadow parameters
        lea     rcx,UNITSTR.UNITNAME[r10] ; 1: filename pointer
        mov     rdx,GENERIC_READ    ; 2: desired access
        mov     r8d,FILE_SHARE_READ ; 3: allow others to read also
        mov     r9, 0               ; 4: security attributes
        mov     rax,OPEN_EXISTING   ; 5: creation disposition
        mov     [rsp+32],rax
        xor     rax,rax             ; 6: flags and attributes
        mov     [rsp+40],rax
        mov     [rsp+48],rax        ; 7: optional
        call    CreateFileA
        winstacke
        cmp     rax,-1
        je      actuallyfailed
        mov     r10,CURUNIT
        mov     UNITSTR.UNITHANDLE[r10],rax
endif
actuallyopen:   clc
        ret
actuallyfailed: stc
        ret
actualopen endp

restorecwd proc ;restore current working directory if we changed it============
        mov     r10,CURUNIT
        test    UNITSTR.CDchanged[r10],0FFh
; restoring cwd
ifdef linuxenvironment          ;LINUX version ================================
        lea     rdi,oldcwd
        mov     rax,50h         ;sys_chdir
        syscall
        and     rax,rax
        jz      @F
 dbgustr 'sys_chdir failed ####'
@@:
else                            ;WINDOW version ===============================
        externdef SetCurrentDirectoryA : near
        winstack
        lea     rcx,oldcwd
        call    SetCurrentDirectoryA
        winstacke
        and     rax,rax
        jnz     @F
 dbgustr 'SetCurentDirectoryA failed ####'
@@:
endif
        mov     r10,CURUNIT
        mov     UNITSTR.CDchanged[r10],0
cwdnotchanged:
        ret
restorecwd endp
