; My OS independent memory allocator
; Written by Viktors Berstis
;input: rcx     = number of bytes requested
;output: rax    = address of area allocated

myalloc proc
        dbgsv
        mov     myallocaddr,0   ;clear address (not allocated yet)

ifdef linuxenvironment
; https://syscalls64.paolostivanin.com/
        mov     rdi,0                   ; addr
        mov     rsi,rcx                 ; length
        add     rsi,16                  ; add area to save length in
        push    rsi
PROT_READ EQU 1
PROT_WRITE EQU 2
        mov     rdx,PROT_READ+PROT_WRITE ; protect
MAP_ANONYMOUS EQU 022h  ;plus MAP_PRIVATE
        mov     r10,MAP_ANONYMOUS       ; flags
        mov     r8,rdi
         dec    r8                      ; fd (-1)
        mov     r9,rdi                  ; offset (0)
        mov     rax,9                   ; mmap call
        syscall
        cmp     rax,lnxerror            ;error if returned val is larger
        ja      failedalloc
        pop     rcx                     ;get adjusted length
        mov     qword ptr [rax],rcx     ;save length used to allocate
        add     rax,16                  ;return address slightly higher
        jmp     allocok
else                                    ;Windows 64 version
        externdef VirtualAlloc : near
        xor     rax,rax
        winstack 1                      ; must leave 32 bytes space plus for more parameters
        mov     rdx, rcx                ; 2: SIZE_T dwSize
        mov     rcx, rax                ; 1: LPVOID lpAddress (starting address)
MEM_COMMIT equ 00001000h
MEM_RESERVE equ 00002000h
        mov     r8d, MEM_COMMIT+MEM_RESERVE ; 3: flAllocationType
PAGE_READWRITE equ 4
        mov     r9, PAGE_READWRITE      ; 4: DWORD flProtect
        mov     QWORD PTR [rsp+32],0    ; 5: null
        call    VirtualAlloc
        winstacke
        cmp     rax,0
        jne     allocok
failedallocw:
        call    dbggle
endif

failedalloc: call dbgs
        db 'Failed to allocate memory area of',0
        pop     rcx
        mov     rax,rcx                 ;amount requested
        call    dbgprtfi
        call    dbgs
        db ' bytes',13,10,0
        call    dbgexit
allocok:
        mov     myallocaddr,rax
        dbgrs
        mov     rax,myallocaddr
        ret

myalloc endp

; my memory allocation free routine
; input: rax = address of area to free
myfree  proc
        dbgsv
ifdef linuxenvironment
        mov     rdi,rax
        sub     rdi,16
        mov     rsi,qword ptr [rdi]     ;size of allocation (saved)
        mov     rax,0bh
        syscall
        cmp     rax,0                   ;check if ok
        jz      myfreeok
        call    dbgs
        db      'Freeing memory failure',13,10,0
        call    dbgexit
else                                    ;windows 64 version
        externdef VirtualFree : near
        winstack
        mov     rcx,rax                 ;address of area to free
        xor     rdx,rdx                 ;zero
MEM_RELEASE equ 8000h
        mov     r8d,MEM_RELEASE
        call    VirtualFree
        winstacke
        cmp     rax,0
        jnz     myfreeok
        call    dbgs
        db      'Freeing memory failure',13,10,0
        call    dbgexit
endif
myfreeok:
        dbgrs
        ret
myfree  endp
