; Get top code processor speed
; Written by Viktors Berstis

ifdef linuxenvironment

        .data
lnxmhzsiz equ 1800              ;buffer size
lnxmhznum db 21 dup(?)
lnxmhzbuf db lnxmhzsiz dup(?)   ;read buffer
lnxmhznam db '/proc/cpuinfo',0  ;info path
lnxmhzlf db 10
        align 16
lnxmhzbad dq lnxmhzbuf          ;address of read buffer
lnxmhznuml dq 0
lnxmhznumx dq 21
lnxmhzhan dq 0                  ;handle
lnxmhzlen dq 0                  ;bytes read
lnxmhzmax dq 1                  ;highest mhz core
lnxmhzmaxcur dq 0               ;maximum cursoro
lnxmhzcarry dq 0
        .code

lnxmhz proc

D_FILE_OFFSET_BITS EQU 64
O_RDONLY EQU 0
        mov     rax,2           ;linux open system call
        lea     rdi,lnxmhznam ; 1: filename pointer
        mov     rsi,D_FILE_OFFSET_BITS ; 2: flags
        mov     rdx,O_RDONLY    ; 3: mode
        syscall
        cmp     rax,0
        jl      badmhz
        mov     lnxmhzhan,rax ;save handle
        mov     lnxmhzcarry,0
        jmp     lnxmhzfirst

lnxmhzreadmore:
        mov     rsi,lnxmhzbad   ;buffer start address
        mov     rdi,rsi
        add     rsi,lnxmhzlen   ;end of last record read + 1

        mov     rax,lnxmhzlen   ;length of record
        sub     rax,lnxmhzmaxcur ;how much we didnt match last time
        cmp     rax,14          ;make it no more than 14
        jl      @F
        mov     rax,14
@@:     mov     lnxmhzcarry,rax
        sub     rsi,rax
        mov     rcx,rax
        jrcxz   @F
        rep movsb               ;copy tail end of last record to buffer start
@@:

        lea     rsi,lnxmhzbuf   ;place to read into
        mov     rdx,lnxmhzsiz   ;max length to read
        add     rsi,rax         ;after prior record end
        sub     rdx,rax
        jmp     lnxmhznext

lnxmhzfirst:
        lea     rsi,lnxmhzbuf   ;2: place to read into
        mov     rdx,lnxmhzsiz   ;3: max length to read
lnxmhznext:
        mov     rdi,lnxmhzhan   ;1: handle
        mov     rax,0           ;sys_read
        syscall
        cmp     rax,0
        jz      lnxmhzdone
        add     rax,lnxmhzcarry
        mov     lnxmhzlen,rax   ;number of bytes that were read + carry over

        mov     lnxmhzmaxcur,0
        pstart  lnxmhzbad,lnxmhzlen,lnxmhzreadmore
        parb

        pstri   'cpu'
        pspan   whitespace,whitespacelen
        pstri   'MHz'
        pspan   whitespace,whitespacelen
        pstri   ':'
        pspan   whitespace,whitespacelen
        passns
        pspani  '0123456789'
        passne  lnxmhznum,lnxmhznuml,lnxmhznumx
        lea     rsi,lnxmhznum
        mov     rcx,lnxmhznuml
        call    sil100
        cmp     lnxmhzmax,rcx
        jg      lnxnotmax
        mov     lnxmhzmax,rcx
lnxnotmax:
        mov     rax,cursoro
        cmp     rax,lnxmhzmaxcur
        jl      @F
        mov     lnxmhzmaxcur,rax        ;highest point matched in record
@@:
        pstri   '.'
        pspani  '0123456789'
        pfail
        pend
lnxmhzdone:
        mov     rax,3           ;sys_close
        mov     rdi,lnxmhzhan ;handle
        syscall

        mov     rax,lnxmhzmax
        mov     processormhz,rax

        ret

badmhz:
        dbgustr 'lnxmhz failed'
        ret

lnxmhz endp

endif
