;* read /etc/localtime per rfc 8536
; Written by Viktors Berstis
;
; ===============================================================
; Read /etc/localtime file
;
; load big endian values from memory into rax
bige4   macro   place   ;4 byte version
        xor     rax,rax
        mov     al,byte ptr [place]
        shl     rax,8
        mov     al,byte ptr [place+1]
        shl     rax,8
        mov     al,byte ptr [place+2]
        shl     rax,8
        mov     al,byte ptr [place+3]
        movsxd  rax,eax ;sign extend it
        endm
bige4u  macro   place   ;4 byte version
        xor     rax,rax
        mov     al,byte ptr [place]
        shl     rax,8
        mov     al,byte ptr [place+1]
        shl     rax,8
        mov     al,byte ptr [place+2]
        shl     rax,8
        mov     al,byte ptr [place+3]
        endm
bige8   macro   place   ;8 byte version
        xor     rax,rax
        mov     al,byte ptr [place]
        shl     rax,8
        mov     al,byte ptr [place+1]
        shl     rax,8
        mov     al,byte ptr [place+2]
        shl     rax,8
        mov     al,byte ptr [place+3]
        shl     rax,8
        mov     al,byte ptr [place+4]
        shl     rax,8
        mov     al,byte ptr [place+5]
        shl     rax,8
        mov     al,byte ptr [place+6]
        shl     rax,8
        mov     al,byte ptr [place+7]
        endm


        .data
lnxltmnam db    '/etc/localtime',0
lnxltmtz db     'TZ',0
lnxltmtzn db    '/usr/share/zoneinfo/'
lnxltmzni db    256 dup(0)      ;zone info from TZ enivronment variable
lnxltmtype db   0               ;header type
        align   8
lnxltmbuf db    8192 dup(0)
lnxltmhan dq    0
lnxltmrdo dq    lnxltmbuf
lnxltmrdn dq    8192
lnxltmadjust dq 0               ;time zone adjustment in seconds
;Addresses in data area:
transitiontimes dq 0
transitiontypes dq 0
localtimetyperecords dq 0
timezonedesignators dq 0
leapsecondrecords dq 0
standardwallindicators dq 0
utlocalindicators dq 0
;Header values:
lnxltm_isutcnt dq 0
lnxltm_isstcnt dq 0
lnxltm_leapcnt dq 0
lnxltm_timecnt dq 0
lnxltm_typecnt dq 0
lnxltm_charcnt dq 0
lnxltm_timesize dq 4            ;this will be 4 or 8
        .code
ReadLocalTime proc
        dbgsv
; first get current UTC time
        mov     rax,201         ;sys_time
        lea     rdi,lnxtime     ; struct __kernel_old_timeval __user *tv
        xor     rsi,rsi         ; time zone adjustment not returned any more
        syscall                 ; current utc will be in lnxtime

;First see if env var TZ points us elsewhere
        lea     rsi,lnxltmtz    ;TZ name of environment variable
        mov     rcx,2           ;Length of TZ
        call    s5getenv
        mov     rcx,envbufferlen
        jrcxz   lnxltmnoTZ      ;jump if env variable not there
        lea     rsi,envbuffer
        lea     rdi,lnxltmzni   ;place to put TZ environment variable value
        rep     movsb           ;copy name here
        mov     byte ptr [rdi],0 ;add trailing zero
        lea     rdi,lnxltmtzn   ;use this as time zone file name
        call    lnxltmread      ;read the time zone file
        jnc     lnxltmcheck
lnxltmnoTZ:
        lea     rdi,lnxltmnam   ;try /etc/localtime file
        call    lnxltmread
        jnc     lnxltmcheck
        dbgustr 'no time zone file found ####'
        dbgrs
        ret


; Check header
lnxltmcheck:
        lea     rsi,lnxltmbuf
        lea     rsi,lnxltmbuf
        mov     lnxltmrdo,rsi
        mov     lnxltm_timesize,4
        call    lnxltmt
        mov     rsi,lnxltmrdo
        mov     lnxltm_timesize,8
        call    lnxltmt



        dbgrs
        ret

lnxltmfailx:
        dbgrs
 dbgustr 'could not read linux local time file ####'
        ret
ReadLocalTime   endp

; Parse time zone file
lnxltmt proc
        cmp     byte ptr [rsi+0],'T'
        jne     lnxltmfail
        cmp     byte ptr [rsi+1],'Z'
        jne     lnxltmfail
        cmp     byte ptr [rsi+2],'i'
        jne     lnxltmfail
        cmp     byte ptr [rsi+3],'f'
        jne     lnxltmfail
        mov     al,byte ptr [rsi+4]     ;get header type
        mov     lnxltmtype,al
        add     rsi,20
        bige4u  rsi+0
        mov     lnxltm_isutcnt,rax
        bige4u  rsi+4
        mov     lnxltm_isstcnt,rax
        bige4u  rsi+8
        mov     lnxltm_leapcnt,rax
        bige4u  rsi+12
        mov     lnxltm_timecnt,rax
        bige4u  rsi+16
        mov     lnxltm_typecnt,rax
        bige4u  rsi+20
        mov     lnxltm_charcnt,rax
        add     rsi,24

; Check to see if it is GMT
        cmp     byte ptr [rsi+0],'G'
        jne     lnxltmnotgmt
        cmp     byte ptr [rsi+1],'M'
        jne     lnxltmnotgmt
        cmp     byte ptr [rsi+2],'T'
        jne     lnxltmnotgmt
        ret     ; return, adjustment is zero

lnxltmnotgmt:
; Look at the data according to timesize
        cmp     lnxltm_timesize,4
        jne     lnxltm_tz8
lnxltm_tz4:

        mov     transitiontimes,rsi
        mov     rax,lnxltm_timecnt
        shl     rax,2           ;* timesize 4
        add     rsi,rax

        mov     transitiontypes,rsi
        mov     rax,lnxltm_timecnt
        add     rsi,rax

        mov     localtimetyperecords,rsi
        mov     rax,lnxltm_typecnt
        shl     rax,1
        add     rsi,rax
        add     rsi,rax
        add     rsi,rax

        mov     timezonedesignators,rsi
        mov     rax,lnxltm_charcnt
        add     rsi,rax

        mov     leapsecondrecords,rsi
        mov     rax,lnxltm_leapcnt
        shl     rax,3   ;* timesize + 4
        add     rsi,rax

        mov     standardwallindicators,rsi
        mov     rax,lnxltm_isstcnt
        add     rsi,rax

        mov     utlocalindicators,rsi
        mov     rax,lnxltm_isutcnt
        add     rsi,rax
        jmp     lnxltmmoredata

lnxltm_tz8:
        mov     transitiontimes,rsi
        mov     rax,lnxltm_timecnt
        shl     rax,3           ;* timesize 8
        add     rsi,rax

        mov     transitiontypes,rsi
        mov     rax,lnxltm_timecnt
        add     rsi,rax

        mov     localtimetyperecords,rsi
        mov     rax,lnxltm_typecnt
        shl     rax,1
        add     rsi,rax
        add     rsi,rax
        add     rsi,rax

        mov     timezonedesignators,rsi
        mov     rax,lnxltm_charcnt
        add     rsi,rax

        mov     leapsecondrecords,rsi
        mov     rax,lnxltm_leapcnt
        shl     rax,2   ;* timesize + 4
        mov     rbx,rax
        shl     rax,1
        add     rsi,rbx
        add     rsi,rax

        mov     standardwallindicators,rsi
        mov     rax,lnxltm_isstcnt
        add     rsi,rax

        mov     utlocalindicators,rsi
        mov     rax,lnxltm_isutcnt
        add     rsi,rax

lnxltmmoredata:
        mov     lnxltmrdo,rsi
        xor     rbx,rbx         ;counter
        xor     rdx,rdx         ;lastadjust
lnxltm_dataloop:
        mov     rdi,transitiontimes
        cmp     lnxltm_timesize,4
        je      lnxltm_4
        bige8   rdi
        jmp     lnxltm_8
lnxltm_4:
        bige4   rdi
lnxltm_8:
        cmp     rax,lnxtime
        jl      lnxltmnotthis
        mov     rdi,localtimetyperecords
        mov     rax,rdx
        shl     rax,2
        add     rax,rdx
        add     rax,rdx ;* 6
        add     rdi,rax
        bige4   rdi
        mov     lnxltmadjust,rax
; call dbgprtfi
; dbgustr '=time adjust ####'
        ret

lnxltmnotthis:
        inc     rbx
        mov     rdi,transitiontypes
        mov     dl,[rdi]
        inc     transitiontypes
        mov     rdi,transitiontimes
        mov     rax,lnxltm_timesize
        add     rdi,rax
        mov     transitiontimes,rdi
        cmp     rbx,lnxltm_timecnt
        jl      lnxltm_dataloop
;dbgustr 'didnt find local time adjustment ####'
        ret

lnxltmfail:
 showreg rax
 call dbgprtfi
 dbgustr 'lnxltm failed ####'
        ret
lnxltmt endp


; Code to read time zone file
; rdi is pointer to file name
; carry flag is set if there was an error
lnxltmread proc
O_RDONLY EQU 0
D_FILE_OFFSET_BITS EQU 64
;       lea     rdi,lnxltmnam   ; 1: filename pointer, supplied by caller
        mov     rax,2           ;linux open system call
        mov     rsi,D_FILE_OFFSET_BITS ; 2: flags
        mov     rdx,O_RDONLY    ; 3: mode
        syscall
        cmp     rax,0
        jl      lnxltmfailxx
        mov     lnxltmhan,rax   ;save handle
lnxltmrdlp:
        mov     rsi,lnxltmrdo   ;2: place to read into
        mov     rdx,lnxltmrdn   ;3: max length to read
        mov     rdi,lnxltmhan   ;1: handle
        mov     rax,0           ;sys_read
        syscall
        cmp     rax,0
        jz      lnxltmrddone
        sub     lnxltmrdn,rax   ;reduce max bytes to read
        add     lnxltmrdo,rax   ;increment to new offset to read into
        jmp     lnxltmrdlp
lnxltmrddone:
        lea     rcx,lnxltmbuf
        sub     rcx,lnxltmrdo   ;total number of bytes read
        neg     rcx
        mov     rdi,lnxltmhan
        mov     rax,3           ;linux sys_close code
        syscall
        clc                     ;clear carry to indicate no error
        ret
lnxltmfailxx:
        stc                     ;set carry to indicate some error
        ret
lnxltmread endp



