; =============================================================================
; SEEK
; Written by Viktors Berstis
; =============================================================================
; Input:
;    r8  UNIT - descriptor containing unit number
;    r9  OFFSET - descriptor containing integer offset required
;    r11 TYPE - type of seek 0=absolute 1=relative to current 2=relative to end
; Output:
;    r11 NEWPOS - descriptor to receive new offset in file
;    c   FAIL address
;    nc  SUCCESS address
;
; Input:
;         ------------------------------
; UNIT    |   A1   |         |         |
;         ------------------------------
;         ------------------------------
; OFFSET  |   A2   |         |         |
;         ------------------------------
;         ------------------------------
; TYPE    |   A3   |         |         |
;         ------------------------------
; Output:
;         ------------------------------
; NEWPOS  |   POS  |         |         |
;         ------------------------------
        cmp     r8,UNITARRAYMAX        ;is unit number out of range?
        jnb     sil127seekfail
        shl     r8,3   ;multiply by 8
        lea     r10,UNITARRAY
        add     r10,r8
        mov     r10,[r10]       ;get unit pointer

        mov     CURUNIT,r10             ;save in case we have to restore it
        cmp     r10,0
        jz      sil127seekfail  ;quit if unit not allocated
        cmp     UNITSTR.UNITVALID[r10],UNITVALIDCODE
        jne     sil127seekfail  ;quit if not a valid unit
        cmp     UNITSTR.UNITOPEN[r10],0
        je      sil127seekfail  ;quit if not open (dont know if it will be read or write)

        test    UNITSTR.UNITOPEN[r10],ROPEN
        jz      @F
        call    openread        ;open unit if not already open
@@:
        test    UNITSTR.UNITOPEN[r10],WOPEN
        jz      @F
        call    openwrit        ;open unit if not already open
@@:
        mov     UNITSTR.UNITEOF[r10],0  ;reset eof indication

        cmp     r11,0           ;should not be negative
        jl      sil127seekfail
        cmp     r11,2           ;should not be more than 2
        jg      sil127seekfail
        cmp     r11,1           ;is it relative to current position?
        jne     sil127seeknotrel
        add     r9,UNITSTR.UNITPLACE[r10] ;adjust by where buffering is
        sub     r9,UNITSTR.UNITBLOCKE[r10]
sil127seeknotrel:

ifdef linuxenvironment          ;read data into buffer
        mov     rdi,UNITSTR.UNITHANDLE[r10]     ; 1: file handle
        mov     rsi,r9          ;reposition value
        mov     rdx,r11         ;type of seek
        mov     rax,8           ;sys_lseek
        push    r10
        syscall
        pop     r10
        cmp     rax,-1          ;-1 means error
        je      sil127seekfail
        mov     UNITSTR.UNITVSEEK[r10],rax ;new offset in file
        mov     r11,rax         ;return new position
        mov     UNITSTR.UNITPLACE[r10],0 ;reset buffer
        mov     UNITSTR.UNITBLOCKE[r10],0
        mov     UNITSTR.UNITWASEEK[r10],1
else                            ;windows version
        externdef SetFilePointerEx : near
        push    r10
        winstack                ; must leave 40 bytes space plus for more shadow parameters
        mov     rcx,UNITSTR.UNITHANDLE[r10] ; 1: file handle
        mov     rdx,r9          ; 2: reposition value
        lea     r8,sil127seeknew ; 3: place to put new position
        mov     r9,r11          ; 4: seek type
        xor     rax,rax
        call    SetFilePointerEx
        winstacke
        pop     r10
        ; returns 0 on failure
        and     rax,rax
        jz      sil127seekfail2
        mov     r11,sil127seeknew
        mov     UNITSTR.UNITPLACE[r10],0 ;reset buffer
        mov     UNITSTR.UNITBLOCKE[r10],0
        mov     UNITSTR.UNITWASEEK[r10],1
        jmp     sil127seekok
sil127seekfail2:
        dbgustr 'Windows SetFilePointerEx failed ####' ;### handle better
        call    dbggle                  ;show windows error
        jmp     sil127seekfail
endif
sil127seekok:
        clc                     ;clear carry to indicate success
        ret

sil127seekfail:
        stc                     ;set carry to indicate failure
        ret

