;SIL25  ENFILE End file - close
; Written by Viktors Berstis
; =============================================================================
SIL25   PROC      ; ENFILE close file
; INPUT:
;  rbx = i/o unit number to close
; OUTPUT:
;  UNITSTR is reset to not open
;  On write, end of file char may be written
;  File handle is closed
;  Includes are closed
;  Unit is deallocated
        mov     sil105unitnum,rbx
        cmp     rbx,UNITARRAYMAX        ;is unit number out of range?
        jnb     sil25done
        shl     rbx,3   ;multiply by 8
        lea     r12,UNITARRAY
        add     r12,rbx
        mov     r10,[r12]       ;get unit pointer
sil25loop:
        mov     CURUNIT,r10             ;save in case we have to restore it

        cmp     r10,0
        jz      sil25done       ;quit if unit not allocated
        cmp     UNITSTR.UNITVALID[r10],UNITVALIDCODE
        jne     sil25done       ;quit if not a valid unit
        test    UNITSTR.UNITOPEN[r10],ROPEN
        jnz     sil25readclose  ;jump if is open for read
        test    UNITSTR.UNITOPEN[r10],WOPEN
        jnz     sil25writeclose ;jump if is open for write
sil25closed:
        mov     r11,UNITSTR.includecaller[r10]
        and     r11,r11
        jnz     sil25uplevel    ;was this an include?
; now zero out most UNITSTR fields
        mov     UNITSTR.UNITPLACE[r10],0
        mov     UNITSTR.UNITPLACE[r10],0
        mov     UNITSTR.UNITBLOCKE[r10],0
        mov     UNITSTR.UNITVSEEK[r10],0
        mov     UNITSTR.UNITSKINV[r10],0
        mov     UNITSTR.UNITPW[r10],0
        mov     UNITSTR.UNITOPEN[r10],0
        mov     UNITSTR.UNITERROR[r10],0
        mov     UNITSTR.UNITEOF[r10],0
        mov     UNITSTR.UNITINCLUDESW[r10],0
        mov     UNITSTR.includecaller[r10],0
        mov     UNITSTR.includenamelen[r10],0
        mov     rax,r10 ;#### is the above zeroing needed?
        call    myfree
        mov     qword ptr [r12],0 ;no unit pointer
sil25done:

        ret

sil25uplevel:
        mov     [r12],r11
        mov     rax,r10
        push    r11
        push    r12
        call    myfree          ;get rid of the UNIT area
        pop     r12
        pop     r11
        mov     r10,r11
        jmp     sil25loop

sil25writeclose:
        mov     rax,UNITSTR.UNITHANDLE[r10] ;get handle
        and     rax,rax
        jz      sil25closed
        test    UNITSTR.UNITFLAGS[r10],UNITBIN  ;check if ascii or binary
        jnz     sil25readclose
        test    UNITSTR.UNITFLAGS[r10],UNITNOEF ;check if 1Ah char required
        jnz     sil25readclose
        call    sil25writeef    ;write the 1Ah character first
sil25readclose:
        mov     rax,UNITSTR.UNITHANDLE[r10] ;get handle
        and     rax,rax
        jz      sil25closed
        mov     UNITSTR.UNITHANDLE[r10],0
        call    sil25close
        jmp     sil25closed

SIL25   ENDP

; =============================================================================
; Close handle in rax
; =============================================================================
sil25close proc
        dbgsv

ifdef linuxenvironment          ;read data into buffer
        mov     rdi,rax         ; 1: file handle
        mov     rax,3           ;linux sys_close code
        syscall
        and     rax,rax
        jz      sil25noerror
        dbgustr 'linux close failed####'
else                            ;close using windows api
        test    UNITSTR.UNITFLAGS[r10],UNITSTD
        jnz     sil25noerror    ; don't close standard handles (cannot use them again)
        externdef CloseHandle   : near
        winstack                ; must leave 40 bytes space plus for more shadow parameters
        mov     rcx,rax         ; 1: file handle
        call    CloseHandle
        winstacke
        ; returns 0 on failure
        and     rax,rax
        jnz     sil25noerror
        mov     r10,CURUNIT
        test    UNITSTR.UNITFLAGS[r10],UNITDIR
        jnz     sil25noerror
        call dbgprtx
        dbgustr 'Windows CloseHandle failed ####' ;### handle better
        call    dbggle                  ;show windows error
endif
sil25noerror:
        dbgrs
        ret
sil25close endp

; =============================================================================
; Write 1Ah byte to end of file
; =============================================================================
sil25writeef proc
        dbgsv

ifdef linuxenvironment          ;write using linux syscall
        mov     rdi,rax         ; 1: file handle
        lea     rsi,sil25ef     ; 2: 1Ah character address
        mov     rdx,1           ; 3: one byte to write
        mov     rax,2           ;linux sys_write code
        syscall
        cmp     rax,1           ;was one byte written?
        je      sil25nowerror
else                            ;write using windows api
        externdef WriteFile     : near
        winstack 1              ; must leave 40 bytes space plus for more shadow parameters
        mov     rcx,rax         ; 1: file handle
        lea     rdx,sil25ef     ; 2: 1ah character address
        mov     r8,1            ; 3: one byte to write
        lea     r9,sil25len     ; 4: place to put number of bytes written
        mov     QWORD PTR [rsp+32], 0 ; 5: LPOVERLAPPED optional
        call    WriteFile
        winstacke
        ; returns 0 on failure
        and     rax,rax
        jnz     sil25nowerror1
        call dbgprtx
        dbgustr 'Windows WriteFile 1ah failed ####'
        call    dbggle          ;show windows error
sil25nowerror1:
        cmp     sil25len,1      ;was one byte written?
        je      sil25nowerror
        dbgustr 'Windows WriteFile didnt write one byte in sil25####'
endif
sil25nowerror:
        dbgrs
        ret
sil25writeef endp



