; Routine to convert 8 byte signed binary integer to string
; Written by Viktors Berstis
; INPUT:
;   RBX - INTEGER to convert
;   RDI - PLACE TO PUT STRING RESULT  (at least 20 bytes)
; OUTPUT:
;   RDI - LAST+1 OF STRING
INT2STR PROC
        PUSH    RAX
        PUSH    RBX
        PUSH    RCX
        PUSH    RDX
        PUSH    RSI

        CLD
        AND     RBX,RBX         ;check sign
        JNS     NOTNEG          ;jump if not negative
        MOV     AL,'-'          ;put minus in front
        STOSB
        NEG     RBX             ;invert to positive
        JO      I2SMAXs         ;handle max negative number
NOTNEG:
        MOV     RSI,RDI         ;save destination
        MOV     RCX,10          ;radix (base 10)
        MOV     RAX,RBX
DIVLP:  XOR     RDX,RDX
        DIV     RCX             ;divide by 10
; RDX contains remainder from dividing by 10
; RAX contains low order quotient
        XCHG    RDX,RAX
; EAX contains remainder from dividing by 10
        OR      AL,'0'          ;change to digit

        STOSB                   ;store it
        XCHG    RDX,RAX
        AND     RAX,RAX
        JNZ     DIVLP           ;loop until number is zero

        MOV     RCX,RDI         ;save last+1 loc

; RSI = location after sign
; RDI = last and most significant digit
        DEC     RDI             ;point at most significant digit
REVLP:  LODSB                   ;now reverse the number string
        XCHG    AL,[RDI]
        MOV     [RSI-1],AL
        DEC     RDI
        CMP     RSI,RDI
        JB      REVLP

        MOV     RDI,RCX           ;last+1 loc

INT2STRdone:

        POP     RSI
        POP     RDX
        POP     RCX
        POP     RBX
        POP     RAX
        RET

I2SMAXs:
        lea     rsi,I2SMAX
        mov     rcx,19
I2SMAXlp: movsb
        loop    I2SMAXlp
        jmp     INT2STRdone
INT2STR ENDP
