; Get starting address and length of Linux stack on intel 64 bit
; Written by Viktors Berstis
; OUTPUT:
;       STLIMIT = low address limit for stack (adjusted for 1mb of safe space)


ifdef linuxenvironment

        .data
lnxstacksiz equ 1800
lnxstacknum db 21 dup(?)
lnxstackbuf db lnxstacksiz dup(?)
lnxstacknam db '/proc/self/maps',0
lnxstacklf db 10
        align 16
lnxstacknuml dq 0
lnxstacknumx dq 21
lnxstackhan dq 0
lnxstacklen dq 0
lnxstackbad dq lnxstackbuf
lnxstackstart dq ?
lnxlimit dq     0,0
        .code

setstack proc

O_LARGEFILE EQU 400000h
D_FILE_OFFSET_BITS EQU 64
O_RDONLY EQU 0
        mov     rax,2           ;linux open system call
        lea     rdi,lnxstacknam ; 1: filename pointer
        mov     rsi,D_FILE_OFFSET_BITS ; 2: flags
        mov     rdx,O_RDONLY    ; 3: mode
        syscall
        cmp     rax,0
        jl      bad
        mov     lnxstackhan,rax ;save handle

lnxstackfail:
        lea     rsi,lnxstackbuf     ;place to read into
        mov     rdi,lnxstackhan     ;handle
        mov     rdx,0
        mov     rdx,lnxstacksiz     ;max length to read
        mov     rax,0               ;sys_read
        syscall
        mov     lnxstacklen,rax     ;number of bytes that were read
        cmp     rax,0
        je      bad

        pstart  lnxstackbad,lnxstacklen,lnxstackfail
        pbreakx lnxstacklf,1
        pstr    lnxstacklf,1
        pspani  '0123456789abcdef'
        pstri   '-'
        passns
        pspani  '0123456789abcdef'
        passne  lnxstacknum,lnxstacknuml,lnxstacknumx
        pspani  ' rwxp-'
        pspani  '0123456789abcdef: '
        pstri   '[stack]'
        pstr    lnxstacklf,1
        pend

        mov     rax,3           ;sys_close
        mov     rdi,lnxstackhan ;handle
        syscall

        mov     rcx,lnxstacknuml        ;convert hex text to binary
        lea     rsi,lnxstacknum
        xor     rax,rax
lnxstacklp: xor rbx,rbx
        shl     rax,4
        mov     bl,[rsi]
        sub     bl,'a'-10
        jnb     lnxstacknd
        add     bl,('a'-10)-'0'
lnxstacknd: add rax,rbx
        inc     rsi
        loop    lnxstacklp

        mov     lnxstackstart,rax       ;high address of stack


RLIMIT_STACK equ 3

        mov     rax,61h                 ;sys_getrlimit linux syscall
RLIMIT_STACK equ 3
        mov     rdi,RLIMIT_STACK        ;resource = stack
        lea     rsi,lnxlimit
        mov     [rsi],rsp
        syscall

        mov     rbx,lnxstackstart
        sub     rbx,lnxlimit            ;low address of stack
        add     rbx,100000h             ;add one megabyte of safe space
        mov     STLIMIT,rbx

        ret
bad:
        dbgustr 'lnxstack failed'
        ret

setstack endp

else                                    ;windows version
setstack proc
        MOV     RAX,rsp
        SUB     RAX,700000h             ;limit in 8mb stack #### set to match stack size in link.exe
        MOV     STLIMIT,rax             ;Limit of how deep GC can recurse in native stack
        ret
setstack endp
endif
