; Code to get environment variable value
; Written by Viktors Berstis
; INPUT:
;   rsi = pointer to environment variable name
;   rcx = length of environment variable name, max allowed 32k
; OUTPUT:
;   envbuffer = location of retrieved value
;   envbufferlen = length of retrieved value, zero if not found

envsetup macro
ifdef linuxenvironment
  ifdef pe3
        mov     linuxenvironmentvars,rdx
  else
        mov     rdi,[rsp]  ;get number of command line parms
        add     rdi,2      ;past two qwords of zero
        shl     rdi,3      ;multiply by 8
        add     rdi,rsp    ;location of environment variable pointers
        mov     linuxenvironmentvars,rdi
  endif
endif
        endm

        .data
envbuffermax equ 32768                  ;max env var name and data lengths
envarname db 'SNOPATH', envbuffermax dup(0) ;snopath = environment variable to use for -include

ifdef linuxenvironment
envdelim db ':'                         ;delimiter between path names
        align 8
linuxenvironmentvars dq 0               ;pointer to linux environment variables
; get the environment variable pointer
;#####  .code
;#####  mov     rdi,[rsp]  ;get number of command line parms
;#####  add     rdi,2      ;past two qwords of zero
;#####  shl     rdi,3      ;multiply by 8
;#####  add     rdi,rsp    ;location of environment variable pointers
;#####  mov     linuxenvironmentvars,rdi
;##### .data
else
envdelim db ';'
endif
        align 8
envarnamelen dq 7                       ;length of environment variable name
envbufferlen dq 0                       ;changed to length of value data
environoffset dq 0                      ;offset in envbuffer
envbuffer db envbuffermax DUP(?)        ;value of environment variable
        .code

;###########################################################################


s5getenv PROC

        lea     rdi,envarname
        mov     envarnamelen,rcx
        jrcxz   @F
        rep     movsb
@@:

ifdef linuxenvironment

        mov     rdi,linuxenvironmentvars
eloop:  mov     rsi,[rdi]
        cmp     rsi,0      ;are there no more?
        je      eloopef
        push    rdi
        pstart  rsi,envbuffermax,morenv
          pstr  envarname,envarnamelen
          pstri '='
          passns
          pbreaki 0
          passne envbuffer,envbufferlen,envbuffermax
        pend
        jmp     eloope2
eloopef: mov    envbufferlen,0  ;say environment variable was not found
        jmp     eloope
morenv:
        pop     rdi
        add     rdi,8
        jmp     eloop
eloope2: pop    rdi
eloope:

else                            ;Windows 64 version ===========================

        externdef GetEnvironmentVariableA : near
        winstack
        lea     rcx,envarname   ;1: environment variable to look up
        lea     rdx,envbuffer   ;2: place to put its value
        mov     r8,envarnamelen
        mov     byte ptr [rcx+r8],0 ;add trailing char(0) to name
        mov     r8,envbuffermax ;3: length of environment area
        call    GetEnvironmentVariableA
        winstacke
        mov     envbufferlen,rax ;returns number of bytes retrieved

endif

        ret

s5getenv endp
