REM All steps for generating snobol5
@REM Execute once: vcvars64.bat wherever it is, once for command prompt session
@REM Execute once: set snopath=.
@REM Execute once: set include=%include%;.
@REM Execute once: set LIBPATH=.;%LIBPATH%
@REM have the snobol5.exe in the path somewhere other than this directory

@REM set these to the login@address and path in your Linux machine, before running this script.
@REM set linuxmachine=yourid@yourmachine
@REM set linuxpath=x/

@if exist addrmap.inc erase /q addrmap.inc
@if exist xptropt erase /q xptropt
@if exist m.sil erase /q m.sil
@rem make addrmap.inc a zero length file:
@nullfile addrmap.inc
snobol5 renum.sno >listing0
@if errorlevel 1 pause
snobol5 partgen.sno -1 m.sil -7 main.sil -6 listing1 :%1
@if errorlevel 1 pause
snobol5 crtmain.sno -1 main.sil -7 intcod.inc -8 intdta.inc -9 equs.inc -6 listing2 :%1
@if errorlevel 1 goto pausex
@if not exist xptropt goto skipopt
snobol5 optimize.sno -6 listing3
@if errorlevel 1 goto pausex
@move /y intcod.inc intcodun.inc
@move /y intcodop.inc intcod.inc
:skipopt

@rem save this build in s subdirectory
@rem this section is optional, but useful if you might need to back out changes
@if exist tosave.zip erase /q tosave.zip
zip tosave.zip readme.txt snobol5.asm *.sno *.inc *.cmd main.? *.sil nullfile.exe
@if not exist s md s
@snobol5 savedate.sno
@if exist tosave.zip erase /Q tosave.zip

@if exist inccode.inc erase /Q inccode.inc
@nullfile inccode.inc
@REM To build for Windows use command prompt:
@if exist snobol5.exe erase /Q snobol5.exe
rem if there is a pause, then this copy of snobol5.exe is being executed somewhere
@if exist snobol5.exe pause
@if exist snobol5.exe erase /Q snobol5.exe
@if exist snobol5 erase /Q snobol5
@if exist snobol5.obj erase /Q snobol5.obj
@rem if doing custom build, for example for Personal Editor 3:
if x%1 == xcustom goto ending

ml64 /Sa /Fl /c -DX64 snobol5.asm
@if errorlevel 1 goto pausex

link /FORCE:UNRESOLVED /subsystem:console /STACK:8000000,200000 /machine:x64 snobol5.obj shell32.lib kernel32.lib powrprof.lib user32.lib /entry:main
@if errorlevel 1 goto pausex

@REM  LINUX version:
@REM save windows version:
@rename snobol5.exe snobol5.exesave

ml64 /Fl /Dlinuxenvironment /c snobol5.asm
@if errorlevel 1 goto pausex

link /FORCE:UNRESOLVED -map /subsystem:console /machine:x64 snobol5.obj /entry:main
@if errorlevel 1 goto pausex

@REM  copy program.exe to linux 64 system and there:
@scp snobol5.exe %linuxmachine%:%linuxpath%/.
@rem file is not useful on windows side:
@if exist snobol5.exe erase /q snobol5.exe
@rename snobol5.exesave snobol5.exe
ssh %linuxmachine% "objcopy -O elf64-x86-64 %linuxpath%/snobol5.exe %linuxpath%/snobol5"
scp %linuxmachine%:%linuxpath%/snobol5 .
ssh %linuxmachine% "rm %linuxpath%/snobol5.exe"
scp nq5.sno %linuxmachine%:%linuxpath%/.
@rem run linux test
ssh %linuxmachine% "%linuxpath%/snobol5 %linuxpath%/nq5.sno"
@echo linux version should have produced 10 solutions

@rem run windows test too
snobol5 nq8.sno >listing
@cat listing | grep "@map@" | sort >map.s
@tail listing --lines=15
@echo windows version should have produced 92 solutions

@if exist main.sil erase main.sil
goto ending
:pausex
@echo some problem
@pause
:ending
