; 'GC - Garbage Collector'
; Oregon SNOBOL5 source code writen by Viktors Berstis

; Replacement for mainline function of PROC GC at line 676 of SIL code.
; Note: Second half of any specifier must look like it has flags set to zero if
;       viewed at as a descriptor. Otherwise garbage collection can fail.
; Note: Error checks with #### messages can be removed. Useful during
;       development and debugging.  Removing them can speed up GC.

; =============================================================================
; Macro to find title descriptor from register pointing within a block
; =============================================================================
;gctest equ 1

findtitle macro regis,mytext            ; =====================================
        local   floop,found,lookok,foundbada,foundbadb

ifdef gctest                    ;gc testing code
 mov r13,regis
endif

floop:

ifdef gctest                    ;gc testing code
 mov badtitle,regis
 cmp regis,ADJBDYaddr
 jb foundbada
 cmp regis,ENDLOCaddr
 jnb foundbada
 jmp lookok
foundbada:
 cmp regis,WorkSpaceAddr
 jb foundbadb
 cmp regis,WorkSpaceLast
 jnb foundbadb
 jmp lookok
foundbadb:
 dbgustr '####findtitle is not in work areas &mytext& :'
 call dbgregs
 showreg regis
 showreg [badtitle]
 showreg r13
 showreg r14
 showblk r14
 dbgustr 'what is at rsi:'
 mov rcx,1024
 sub rsi,64
 call dbgdump
 call dbgexit ;####
lookok:
endif

        TEST    byte ptr [regis+FOFFSET],TTL+STTL ;is it pointing to head of block?
        jnz     found                   ;found title
        sub     regis,DESCR             ;go to prior descriptor in block
        jmp     floop
found:
        endm

setmarkbit macro regis                  ;======================================
        local   already,istit,istit2
ifdef gctest                    ;gc testing code
        test    byte ptr [regis+FOFFSET],TTL+STTL
        jnz     istit
        call    dbgs
        db 'setting mark bit at non title####',13,10,0
istit:
        cmp     regis,[regis+AOFFSET]
        je      istit2
        db 'setting mark bit at non self ptr title####',13,10,0
istit2:
endif
        test    byte ptr [regis+FOFFSET],MARK
        jnz     already
        or      byte ptr [regis+FOFFSET],MARK
        inc     GCCHANGED
already:
        endm

isittitle macro regis,mytext            ;======================================
        local   isok
ifdef gctest                    ;gc testing code
        test    byte ptr [regis+FOFFSET],TTL+STTL
        jnz     isok
        call dbgs
        db '=address is not a title &mytext& ####',13,10,0
isok:
endif
        endm

; ==== jump to nope if address in regis is not in a work area
inrange macro   regis,nope              ;======================================
        local   other,ok
        cmp     regis,WorkSpaceAddr
        jb      other
        cmp     regis,WorkSpaceLast
        jb      ok
other:  cmp     regis,ADJBDYaddr
        jb      nope
        cmp     regis,ENDLOCaddr
        jnb     nope
ok:
        endm

; ==== jump to nope if address in regis is not in a allocated work area
inwksp  macro   regis,nope              ;======================================
        local   other
        cmp     regis,WorkSpaceAddr
        jb      nope
        cmp     regis,WorkSpaceLast
        jnb     nope
        endm

GCP     PROC                            ;======================================
; GCREQ contains amount of free space requested
;dbgustr 'gc ' ;######
        mov     rax,rsp
        add     rax,DESCR
        mov     CSTACK,rax      ;don't go below this address in stack
        MOV     RAX,HDSGPT      ;start of allocated work area
        MOV     COMPBAR,RAX     ;Lowest compression barrier can be
        MOV     GCPASS,0        ;Zero passes so far
        mov     rax,10000       ;allow up to 10k descriptors of stack use
        shl     rax,4           ;multiply by DESCR
        neg     rax
        add     rax,rsp         ;allow this much stack growth from recursion
        cmp     rax,STLIMIT
        jnb     @F
        mov     rax,STLIMIT     ;don't go beyond the real stack end
        add     rax,DESCR*32    ;leave room for system
@@:
        mov     GCSTLIMIT,rax   ;don't let it recurse too deep

;ifdef gctest      #####              ;gc testing code
 mov againcnt,0 ;####
;endif

GCagain:
;ifdef gctest                    ;gc testing code
 inc againcnt ;####
;endif
        MOV     GCCHANGED,0
; =============================================================================
; Go thru string variables and mark ones containing something =================
        LEA     RSI,OBLOCK+3*DESCR ;Hash bin before first
        LEA     RDX,OBLOCK+2*DESCR+(OBSIZ*DESCR) ;last chain address
VARLP1: CMP     RSI,RDX
        JA      VARPASE1        ;Jump if examined all hash bins
        ADD     RSI,DESCR
        PUSH    RSI
        mov     rsi,[rsi]       ;get pointer to string
        jmp     CHNFP
CHNLP1:
        MOV     RSI,[RSI+LNKFLD]    ;Get address field of link
CHNFP:  AND     RSI,RSI
        JZ      VARNX1          ;Jump to new hash bin if end of this chain
        mov     rax,[rsi+DESCR]
        or      rax,[rsi+2*DESCR]
        or      rax,[rsi+2*DESCR+VOFFSET]
        jnz     GCmv            ;mark the variable
        cmp     qword ptr [rsi+DESCR+VOFFSET],S*256
        je      CHNLP1
GCmv:   setmarkbit rsi
        cmp     rsp,GCSTLIMIT
        jb      CHNLP1          ;don't go too deep in stack
        call    GCMARK1         ;mark things it points to also
        JMP     CHNLP1
VARNX1:
        POP     RSI
        JMP     VARLP1
VARPASE1:
; =============================================================================
; Mark basic blocks ===========================================================
        lea     rsi,ADJBDY
        lea     r8,ENDLOC
        call    GCWSMARK


; =============================================================================
; Mark things from descriptors pushed on stack ================================
        mov     rsi,EXSTARTRSP          ;first SIL stack address when nothing pushed
        mov     rcx,DESCR               ;descriptor size
        mov     rdx,CSTACK              ;get end of stack address
GCstacklp:
        sub     rsi,rcx
        cmp     rsi,rdx                 ;are we done with stack?
        jb      GCstackdoneA
        test    byte ptr [rsi+FOFFSET],PTRF
        jz      GCnotptr
        mov     rax,[rsi] ;look at poitner
        findtitle rax,titA
        push    rsi
        mov     rsi,rax
        setmarkbit rsi
        cmp     rsp,GCSTLIMIT
        jb      GCtoodeep               ;don't go too deep in stack
        call    GCMARK1                 ;go mark it
GCtoodeep:
        pop     rsi
GCnotptr:
        jmp     GCstacklp
GCstackdoneA:

; Now look at blocks in allocated work space =================================
        mov     rsi,WorkSpaceAddr
        mov     r8,FRSGPT
        call    GCWSMARK

        cmp     GCCHANGED,0
        jnz     GCagain                 ;take another pass if something changed

; =============================================================================
; =============================================================================
; Now adjust marked block self pointers in allocated work area
; =============================================================================
; =============================================================================
        mov     rsi,WorkSpaceAddr
        mov     r11,rsi                 ;compressed address
GCadjlp:
        cmp     rsi,[FRSGPT]            ;have we looked at everything?
        jnb     GCadjend                ;jump if we are at the end
; compute size of block
ifdef gctest                    ;gc testing code
        test    byte ptr [rsi+FOFFSET],TTL+STTL
        jnz     @F
        dbgustr '#### GCadjlp - not title'
@@:
endif
        mov     rax,[rsi+VOFFSET]
        shr     rax,8
        test    byte ptr [rsi+FOFFSET],STTL
        jz      GCadjns                 ;jump if not string
        add     rax,DESCR*5-1
        and     rax,GClow4
        jmp     GCadjhs
GCadjns:
        add     rax,DESCR
GCadjhs:                                ;have size in rax
        test    byte ptr [rsi+FOFFSET],MARK
        jz      GCadjnm                 ;jump if not marked
        mov     [rsi+AOFFSET],r11       ;adjust self pointer
        add     r11,rax
        add     rsi,rax                 ;move to next block
        jmp     GCadjlp
GCadjnm:
        add     rsi,rax                 ;move to next block
        jmp     GCadjlp

GCadjend: mov   COMPBAR,r11             ;this will be the new FRSGPT when done

; =============================================================================
; Fix all pointers pointing to marked blocks
; =============================================================================
; Go thru string variables and fix pointers ==================================
        LEA     RSI,OBLOCK+3*DESCR ;bin before first chain
        LEA     RDX,OBLOCK+2*DESCR+(OBSIZ*DESCR) ;last chain address
GCfxVARLP1: CMP RSI,RDX
        JA      GCfxVARPASE1        ;Jump if examined all hash bins
        ADD     RSI,DESCR
        mov     r8,rsi              ;remember prior pointer location
        PUSH    RSI
        mov     rsi,[rsi]
        jmp     GCfxCHNFP
GCfxCHNLP1:
        mov     rsi,[rsi+LNKFLD]    ;get addr of next one in chain
GCfxCHNFP:
        and     rsi,rsi
        jz      GCfxVARNX1
        test    byte ptr [rsi+FOFFSET],MARK
        jnz     GCfxwm              ;jump if was marked
        mov     rax,[rsi+LNKFLD]
        and     rax,rax
        jz      @F
        mov     rax,[rax+AOFFSET]   ;get self pointer of next var
@@:
        mov     [r8],rax            ;update prior pointer to skip this variable
        jmp     GCfxCHNLP1
GCfxwm:
        mov     rax,[rsi+AOFFSET]   ;get updated self pointer
        mov     [r8],rax            ;update prior pointer to relocated address
        lea     r8,[rsi+LNKFLD]     ;new prior pointer loc
        lea     rax,[rsi+DESCR]
        call    GCFIXD              ;fix the two pointer if present
        lea     rax,[rsi+DESCR*2]
        call    GCFIXD
        JMP     GCfxCHNLP1
GCfxVARNX1:
        POP     RSI
        JMP     GCfxVARLP1
GCfxVARPASE1:

; =============================================================================
; Fix pointers in basic blocks ================================================
        lea     rsi,ADJBDY
        lea     r8,ENDLOC
        call    GCWSFIX

; Fix descriptors pushed on stack =============================================
        mov     rsi,EXSTARTRSP          ;first SIL stack address with nothing pushed
        mov     rcx,DESCR               ;descriptor size
        mov     rdx,CSTACK              ;get stack address before leaving SIL code
GCfxstacklp:
        sub     rsi,rcx
        cmp     rsi,rdx
        jb      GCstackdoneB
        mov     rax,rsi
        call    GCFIXD
        jmp     GCfxstacklp
GCstackdoneB:

; Fix pointers in allocated work space ========================================
        mov     rsi,WorkSpaceAddr
        mov     r8,FRSGPT
        call    GCWSFIX

; =============================================================================
; Move the blocks to their proper compressed locations
; =============================================================================
        mov     rsi,WorkSpaceAddr
        mov     r8,rsi                  ;move target address
GCmvwslp:
        cmp     rsi,[FRSGPT]            ;have we looked at everything?
        jnb     GCmvatwsend             ;jump if we are at the end
        test    byte ptr [rsi+FOFFSET],STTL ;is it a string?
        jz      GCmvns                    ;not string
        mov     rcx,[rsi+VOFFSET]
        shr     rcx,8                   ;now is number of chars in string
        add     rcx,DESCR*5-1
        and     rcx,GClow4              ;round off
        jmp     GCmvwsgl
GCmvns:
        mov     rcx,[rsi+VOFFSET]
        shr     rcx,8                   ;isolate V value - block size
        add     rcx,DESCR               ;add for title descriptor
GCmvwsgl:                               ;have length of block in rcx
        test    byte ptr [rsi+FOFFSET],MARK
        jz      GCmvbnm                 ;skip unmarked blocks
        or      byte ptr [rsi+FOFFSET],MARK+VISITED ;turn off mark and visited
        xor     byte ptr [rsi+FOFFSET],MARK+VISITED ;turn off mark
skipunmark:
        cmp     r8,[rsi+AOFFSET]        ;these addresses should match
        je      GCmvok
 dbgustr '#### self pointer does not match target move address GCmv'
GCmvok:
        mov     rdi,r8
        add     r8,rcx                  ;update for next move
        shr     rcx,3                   ;change to number of qwords
ifdef gctest                    ;gc testing code
 cmp rdi,[rsi]
 je @F
 dbgustr '####new self pointer not pointing to self'
@@:
endif
        rep movsq                       ;move the block down
        jmp     GCmvwslp
GCmvbnm:
        add     rsi,rcx
        jmp     GCmvwslp
GCmvatwsend:

;       r8 = new FRSGPT value to set

; ============================================================================
        inc     qword ptr GCNO          ;increment garbage collection count

        mov     rax,FRSGPT              ;get old use point
        mov     GCOLD,rax               ;old usage peak
        mov     FRSGPT,r8               ;update
        sub     rax,r8                  ;how much was reclaimed
        mov     GCSAVED,rax

        mov     rbx,TLSGP1orig
        sub     rbx,FRSGPT              ;amount now available
        mov     GCGOT,rbx               ;how much is now available

        mov     rax,GCOLD
        sub     rax,HDSGPT              ;old peak amount used
        mov     r9,rax
        sub     rax,GCSAVED             ;minus how much was reclaimed
        shl     rax,2                   ;multiplied by 4

        mov     rcx,GCSAVED             ;how much was reclaimed
        shr     rcx,1                   ;divide by 2
        sub     r9,r9                   ;subtract from old peak amount used

        cmp     rax,r9
        ja      GCraxbigger
        mov     rax,r9
GCraxbigger:                            ;max of two sizes

        add     rax,HDSGPT
        cmp     rax,TLSGP1orig          ;is new computed size bigger than actual allocation?
        jna     GCraxok
        mov     rax,TLSGP1orig
GCraxok:
        mov     TLSGP1,rax              ;set new dynamic work space size

; make sure it is bigger than requested size too (if request was unusually large)
        sub     rax,FRSGPT
        cmp     rax,GCREQ
        ja      GCrqok
        mov     rax,FRSGPT
        add     rax,GCREQ
        add     rax,GCREQ
        add     rax,GCREQ
        add     rax,GCREQ
        cmp     rax,TLSGP1orig
        jb      GCat
        mov     rax,TLSGP1orig
GCat:   mov     TLSGP1,rax              ;reset to full size of allocated work space
GCrqok:

ifdef gctest                    ;gc testing code
 call   dbgcrlf
 mov    rax,GCOLD
 sub    rax,HDSGPT
 call   dbgprtfi
 dbgustr '=size used before GC'
 mov    rax,GCSAVED
 call   dbgprtfi
 dbgustr '=how much GC reclaimed'
 mov    rax,FRSGPT
 sub    rax,HDSGPT
 call   dbgprtfi
 dbgustr '=how much used after GC'
 mov    rax,TLSGP1
 sub    rax,HDSGPT
 call   dbgprtfi
 dbgustr '=new size limit'
endif
;dbgustr 'gcend ' ;######
        mov     rax,GCGOT
        cmp     rax,GCREQ               ;compare to amount requested
        ja      GCgotamount
        stc                             ;set on carry flag
        ret
GCgotamount:
        clc                             ;turn off carry flag
        ret
GCP     ENDP                            ;GC END


; =============================================================================
; =============================================================================
; =============================================================================
; GCWSMARK rsi is start of area, r8 is end+1 of area of blocks
GCWSMARK PROC
;GCagainX:
        push    rsi
        push    r8

GCwslp:

        cmp     rsi,r8                  ;have we looked at everything?
        jnb     GCatwsend               ;jump if we are at the end
ifdef gctest                    ;gc testing code
        test    byte ptr [rsi+FOFFSET],TTL+STTL
        jnz     GCatit
GCatit:
endif
        test    byte ptr [rsi+FOFFSET],MARK
        jz      GCbnm                   ;jump if block not marked
        call    GCMARK1                 ;mark pointers in marked block
GCbnm:
        test    byte ptr [rsi+FOFFSET],STTL ;is it a string?
        jz      GCns                    ;not string
        mov     rax,[rsi+VOFFSET]
        shr     rax,8                   ;now is number of chars in string
        add     rax,DESCR*5-1
        and     rax,GClow4              ;round off
        add     rsi,rax                 ;address after string
        jmp     GCwslp
GCns:   mov     rax,[rsi+VOFFSET]
        shr     rax,8                   ;isolate V value - block size
        add     rax,DESCR               ;add for title descriptor
        add     rsi,rax                 ;move to next block
        jmp     GCwslp
GCatwsend:
        pop     r8
        pop     rsi
        ret
GCWSMARK ENDP

; =============================================================================
; GCWSFIX adjust pointers in area starting with rsi and r8 is last+1 addr
GCWSFIX PROC
GCfxwslp:
        cmp     rsi,r8                  ;have we looked at everything?
        jnb     GCfxatwsend             ;jump if we are at the end
        test    byte ptr [rsi+FOFFSET],MARK
        jz      GCfxbnm                 ;skip unmarked blocks
ifdef gctest                    ;gc testing code
 test    byte ptr [rsi+FOFFSET],TTL+STTL  ;####
 jnz @F
 dbgustr '####not title before GCfxbnm'
@@:
endif
        call    GCFIXB
GCfxbnm:
        test    byte ptr [rsi+FOFFSET],STTL ;is it a string?
        jz      GCfxns                  ;not string
        mov     rax,[rsi+VOFFSET]
        shr     rax,8                   ;now is number of chars in string
        add     rax,DESCR*5-1
        and     rax,GClow4              ;round off
        add     rsi,rax                 ;address after string
        jmp     GCfxwslp
GCfxns:
        mov     rax,[rsi+VOFFSET]
        shr     rax,8                   ;isolate V value - block size
        add     rax,DESCR               ;add for title descriptor
        add     rsi,rax                 ;move to next block
        jmp     GCfxwslp
GCfxatwsend:
        ret
GCWSFIX ENDP


; =============================================================================
; Mark one layer of things it points to, if block is marked
; RSI = address of the block or string structure
; =============================================================================
GCMARK1 PROC
        TEST    byte ptr [rsi+FOFFSET],VISITED  ;See if we alread did this one
        jz      GCMARK1nv               ;not yet visited
        ret                             ;return if we did visit it
GCMARK1nv:
        cmp     rsp,GCSTLIMIT
        jg      GCMARKstlok
; this lets us set the visited bit at the start of GCMARK1 and avoids inf loops
        ret                             ;return if we would get too deep in stack
GCMARKstlok:
        PUSH    rax
        PUSH    rcx
        PUSH    rsi

ifdef gctest                    ;gc testing code
        cmp     rsi,0
        jnz     @F
        dbgustr 'rsi=zero to GCMARK1 ####'
@@:
endif
ifdef gctest                    ;gc testing code
        TEST    byte ptr [rsi+FOFFSET],TTL+STTL ;See if we are at the title
        jnz     @F
        mov     rax,rsi
        call    dbgprtx
        dbgustr '=GCMARK1 not at title descriptor ####'
@@:
endif

        inwksp  rsi,GC1MARKnws          ;only set visited flag on allocated area
        OR      byte ptr [rsi+FOFFSET],VISITED  ;Indicate we visited it
GC1MARKnws:

        TEST    byte ptr [rsi+FOFFSET],STTL ;is it a string?
        jnz     GC1MARKstring
        mov     rcx,[rsi+VOFFSET]       ;get size of this block
        shr     rcx,12                  ;get number of descriptors to check

GC1MARKlp:
        jrcxz   GC1MARKdonex             ;zero length block? ### might not occur
        jmp     GC1MARKnotz
GC1MARKdonex: jmp GC1MARKdone
GC1MARKnotz:
        add     rsi,DESCR
        dec     rcx
        TEST    byte ptr [rsi+FOFFSET],PTRF ;is it a pointer?
        jz      GC1MARKlp                ;try next descriptor if not a pointer
        mov     rax,[rsi+AOFFSET]        ;get the address
        inrange rax,GC1MARKlp            ;skip if not pointing within work sapces
        findtitle rax,titF
        setmarkbit rax
        push    rsi
        mov     rsi,rax
        call    GCMARK1
        pop     rsi
        jmp     GC1MARKlp

GC1MARKstring:
        mov     rcx,2                   ;examine only 2 descriptors in string
        jmp     GC1MARKlp

GC1MARKdone:
        POP     rsi
        POP     rcx
        POP     rax
        ret

GCMARK1 ENDP

; =============================================================================
; RAX points to desciptor with potential address to fix
; =============================================================================
GCFIXD  PROC
        test    byte ptr [rax+FOFFSET],PTRF ;do only if it is a pointer
        jz      GCFIXDnp
        test    byte ptr [rax+FOFFSET],TTL+STTL ;don't do block head ####
        jnz     GCFIXDnp                                            ;####
        push    rbx
        push    rcx
        mov     rbx,[rax+AOFFSET]       ;get current address
        and     rbx,rbx
        jz      GCFIXDzz                ;skip if zero address
        cmp     rbx,WorkSpaceAddr
        jb      GCFIXDz                 ;not in range of work space
        cmp     rbx,WorkSpaceLast
        jnb     GCFIXDz                 ;not in range of work space
GCFIXok2:
        mov     rcx,rbx                 ;save copy of unchanged address
        findtitle rbx,titH              ;find title of block it points within
        push    rdx
        mov     rdx,rbx                 ;prior to fixing self pointer addr
        mov     rbx,[rbx+AOFFSET]       ;get the block's new self pointer address
        sub     rdx,rbx                 ;compute how far block moved
        sub     rcx,rdx                 ;adjust pointer by same amount
        mov     [rax+AOFFSET],rcx       ;update it
        pop     rdx
        jmp     GCFIXDzz
GCFIXDz:
        cmp     rbx,ADJBDYaddr
        jb      GCFIXDzz
        cmp     rbx,ENDLOCaddr
        jb      GCFIXok2
GCFIXDzz:
        pop     rcx
        pop     rbx
GCFIXDnp:
        ret
GCFIXD  ENDP


; =============================================================================
; rsi points to block that needs pointers within it fixed
; =============================================================================
GCFIXB  PROC
        test    byte ptr [rsi+FOFFSET],STTL   ;skip strings (already done)
        jnz     GCFIXBsk

ifdef gctest                    ;gc testing code
        test    byte ptr [rsi+FOFFSET],TTL    ;make sure this is a title
        jnz     GCFIXBok
        dbgustr '#### not title in GCFIXB'
GCFIXBok:
endif
        push    rcx
        push    rax
        push    rsi
        mov     rcx,[rsi+VOFFSET]
        shr     rcx,12                  ;get count of descritprs in block
        jrcxz   GCFIXBz                 ;just in case of no descriptors
GCFIXBlp:
        add     rsi,DESCR
        mov     rax,rsi
        call    GCFIXD                  ;fix the descriptor
        loop    GCFIXBlp
GCFIXBz:
        pop     rsi
        pop     rax
        pop     rcx
GCFIXBsk:
        ret
GCFIXB  ENDP
