;Floating point initialization
; Written by Viktors Berstis
;SET Math modes
SET8087 PROC            ;SET TO ROUND TO NEAREST
        WAIT
        FSTCW   WD0
        AND     WD0,0F3FFH ;ROUND TO NEAREST
        WAIT
        FLDCW   WD0
        RET
SET8087 ENDP

SET8087T PROC           ;SET TO ROUND TOWARD ZERO
        WAIT
        FSTCW   WD0
        OR      WD0,00C00H ;ROUND TO ZERO
        WAIT
        FLDCW   WD0 ;FLDCW
        RET
SET8087T ENDP

;DETERMINE IF 8087 IS PRESENT AND SELECT IMPLEMENTATION ACCORDINGLY
SETUP8087 PROC
        FNINIT                  ;INITIALIZE Math coprocessor
        FWAIT

        WAIT
        FSTCW   WD0 ;FSTCW
        WAIT
        AND     WD0,0F3FFH ;ROUND TO NEAREST
        OR      WD0,01380H ;AFFINE MODE AND 64 BIT PRECISION AND MASKED ####check these
        FLDCW   WD0 ;FLDCW

        CALL    FLTABLE         ;SET UP POWERS OF TEN TABLE

        FLDPI                   ; ST(0) has pi after this
        FSTP    FPI             ; Save pi in storage

        FLDL2E                  ; log2(e) constant
        FSUB    FONE
        F2XM1
        FADD    FONE
        FMUL    FTWO
        FSTP    FEV             ;e

        fldl2e
        fstp    L2EV            ;LOG2(e)

        fld1
        fldl2e
        fdiv
        fstp    L2EVI           ;1.0/LOG2(e)

        fldl2t
        fstp    L2TEN           ;LOG2(10)

        fld1
        fldl2t
        fdiv
        fstp    L2TENI          ;1.0 / LOG2(10)

        mov     rax,FINF
        mov     INFCL,rax       ;set &INFINITY
        mov     rax,FNAN
        mov     NANCL,rax       ;set &NAN
        fld     TBYTE PTR FPI
        fstp    PICL            ;set &PI
        fld     TBYTE PTR FEV
        fstp    ECL             ;set &E

        ret
SETUP8087 ENDP

