; DUMPUNIT - shows what units are assigned
; Written by Viktors Berstis
dumpunit proc
        dbgsv
        dbgustr 'DUMPUNITs:'
        mov     r8,1            ;first unit number to do
dumpunitloop:
        lea     rsi,UNITARRAY
        mov     rax,r8
        shl     rax,3
        add     rsi,rax
        mov     r10,[rsi]
        cmp     r10,0
        jz      dumpnextunit
        call    dbgs
        db      13,10,'Unit number ',0
        mov     rax,r8
        call    dbgprtfi
        call    dbgs
        db      ' located at ',0
        mov     rax,r10
        call    dbgprtx
        call    dbgs
        db      ' =================',13,10,'  File name: "',0
        lea     rsi,UNITSTR.UNITNAME[r10]
        call    dbgstrz
        call    dbgs
        db      '"',13,10,0

        cmp     UNITSTR.UNITVALID[r10],UNITVALIDCODE
        je      @F
        call    dbgs
        db      '  UNIT allocated but not valid',13,10,0
        jmp     dumpnextunit
@@:     call    dbgs
        db      '  UNIT valid',0

        test    UNITSTR.UNITOPEN[r10],ROPEN
        jz      @F
        call    dbgs
        db      ' for READ',0
@@:
        test    UNITSTR.UNITOPEN[r10],WOPEN
        jz      @F
        call    dbgs
        db      ' for WRITE',13,10,0
@@:

        cmp     UNITSTR.UNITPW[r10],UNITPWMK
        je      @F
        call    dbgs
        db      '  UNIT not open',13,10,0
        jmp     dumpunit0
@@:     call    dbgs
        db      '  UNIT is open',13,10,0
dumpunit0:

        call    dbgs
        db      '  Flags:',0

        test    UNITSTR.UNITFLAGS[r10],UNITBIN
        jz      @F
        call    dbgs
        db      ' -b',0
        jmp     dumpunit1
@@:     call    dbgs
        db      ' -a',0
dumpunit1:

        test    UNITSTR.UNITFLAGS[r10],UNITNOBUF
        jz      @F
        call    dbgs
        db      ' -buf',0
        jmp     dumpunit2
@@:     call    dbgs
        db      ' -nbuf',0
dumpunit2:

        test    UNITSTR.UNITFLAGS[r10],UNITNOTABEX
        jz      @F
        call    dbgs
        db      ' -ntabx',0
        jmp     dumpunit3
@@:     call    dbgs
        db      ' -tabx',0
dumpunit3:

        test    UNITSTR.UNITFLAGS[r10],UNITECHO
        jz      @F
        call    dbgs
        db      ' -e',0
        jmp     dumpunit4
@@:     call    dbgs
        db      ' -ne',0
dumpunit4:

        test    UNITSTR.UNITFLAGS[r10],UNITAPPEND
        jz      @F
        call    dbgs
        db      ' -ap',0
        jmp     dumpunit5
@@:     call    dbgs
        db      ' -r',0
dumpunit5:

        test    UNITSTR.UNITFLAGS[r10],UNITLCKW
        jz      @F
        call    dbgs
        db      ' -lw',0

        test    UNITSTR.UNITFLAGS[r10],UNITLCKR
        jz      @F
        call    dbgs
        db      ' -lr',0

        test    UNITSTR.UNITFLAGS[r10],UNITPROMPT
        jz      @F
        call    dbgs
        db      ' -pr',0
        jmp     dumpunit8
@@:     call    dbgs
        db      ' -npr',0
dumpunit8:

        test    UNITSTR.UNITFLAGS[r10],UNITVARLEN
        jz      @F
        call    dbgs
        db      ' -vl',0
        jmp     dumpunit9
@@:     call    dbgs
        db      ' -fl',0
dumpunit9:

        test    UNITSTR.UNITFLAGS[r10],UNITIC
        jz      @F
        call    dbgs
        db      ' -i',0
        jmp     dumpunit10
@@:     call    dbgs
        db      ' -ni',0
dumpunit10:

        test    UNITSTR.UNITFLAGS[r10],UNITSTD
        jz      @F
        call    dbgs
        db      ' -std',0

        test    UNITSTR.UNITFLAGS[r10],UNITNOCR
        jz      @F
        call    dbgs
        db      ' -ncr',0
        jmp     dumpunit12
@@:     call    dbgs
        db      ' -cr',0
dumpunit12:

        test    UNITSTR.UNITFLAGS[r10],UNITNOEF
        jz      @F
        call    dbgs
        db      ' -nef',0
        jmp     dumpunit13
@@:     call    dbgs
        db      ' -ef',0
dumpunit13:

        call    dbgs
        db      13,10,32,32,0
        mov     rax,UNITSTR.UNITHANDLE[r10]
        call    dbgprtx
        call    dbgs
        db      ' =UNITHANDLE ',0

        call    dbgs
        db      13,10,32,32,0
        mov     rax,UNITSTR.UNITPLACE[r10]
        call    dbgprtfi
        call    dbgs
        db      ' =UNITPLACE ',0

        call    dbgs
        db      13,10,32,32,0
        mov     rax,UNITSTR.UNITBLOCKE[r10]
        call    dbgprtfi
        call    dbgs
        db      ' =UNITBLOCKE ',0

        call    dbgs
        db      13,10,32,32,0
        mov     rax,UNITSTR.UNITVSEEK[r10]
        call    dbgprtfi
        call    dbgs
        db      ' =UNITVSEEK ',0





dumpnextunit:
        inc     r8
        cmp     r8,UNITARRAYMAX
        jl      dumpunitloop
        dbgrs
        ret
dumpunit endp
