; Written by Viktors Berstis
; Debug	trap routine
; DBGT Print string or trace SIL opcde execution or check for something
; Set gendebug = 2 in crtmain.sno to use this
dbgt	proc
	PUSHFQ
	PUSH	RAX
	PUSH	RSI
	PUSH	RDI
	MOV	RSI,QWORD PTR [RSP+32] ;string loc
	MOV	RDI,RSI			;address from where we came
DBGTlp:	INC	QWORD PTR [RSP+32]  ;increment return address
	MOV	AL,[RSI]
	INC	RSI
	AND	AL,AL
	JZ	DBGTdone
	CALL	dbgprtc
	JMP	DBGTlp
DBGTdone:
	dbgsv
;=========================================
;===== put debug check here:

; who is changing unitvalid?

;	 mov	 r10,6*8		 ;multiply by 8
;	 lea	 r11,UNITARRAY
;	 add	 r11,r10		 ;unit structure address
;	 mov	 r10,qword ptr [r11]
;	 cmp	 r10,0			 ;allocated?
;	 je	 @F

;	 mov	 r10,UNITSTR.UNITVALID[r10]
;	 cmp	 r10,debuglast
;	 jz	 @F
;	 showreg r10
;	 mov	 debuglast,r10
;	 dbgustr ' unitvalid changed'
;@@:


;===== end of debug check
;=========================================
	dbgrs
	POP	RDI
	POP	RSI
	POP	RAX
	POPFQ
	RET
dbgt	ENDP


;#### temp macro for debug:
dbgtest	macro	here
	dbgsv
	dbgrs
	endm

; dbgperf - collect statistics about each sil op
dbgperf	macro	opnum

	rdtsc
	shl	rdx,32
	and	rax,0ffffffffh	;##### needed?
	or	rdx,rax
	mov	rax,rdx
	sub	rax,dbgperflast	;get delta from	last time
	mov	dbgperflast,rdx	;save for next one
	mov	rdx,dbgperflastbin ;get	address	of last	bin
	add	[rdx],rax	;add to	that bin
	inc	QWORD PTR [rdx+150*8] ;keep count too
	lea	rax,dbgperfbin+8*opnum
	mov	dbgperflastbin,rax ;set	for this one

	endm

dbgperfs proc
	lea	rsi,dbgperfbin
	xor	rbx,rbx
dbgperflp:
	add	rsi,8
	inc	rbx
	call	dbgs
	db	'opcode=',0
	mov	rax,rbx
	call	dbgprtfi
	call	dbgblnk
	mov	rax,[rsi]
	call	dbgprtfi
	call	dbgblnk
	mov	rax,QWORD PTR [rsi+150*8] ;count too
	call	dbgprtfi
	call	dbgcrlf
	cmp	rbx,149
	jl	dbgperflp
	ret
dbgperfs endp

