        TITLE 'SIL122 - BLOCK allocator'
; Oregon SNOBOL5 source code
; Written by Viktors Berstis

; Replacement for mainline function of PROC BLOCK at line 552 of SIL code:
;BLOCK  PROC    ,                   Procedure to allocate blocks    552
;       POP     ARG1CL              Restore size to allocate        553
;       ACOMP   ARG1CL,SIZLMT,SIZERR,SIZERR                         554
;*                                  Check against size limit        555
;BLOCK1 MOVD    BLOCL,FRSGPT        Position pointer to title       556
;       MOVV    BLOCL,ARG1CL        Move data type                  557
;       INCRI   FRSGPT,DESCR        Leave room for title            558
;       SUM     FRSGPT,FRSGPT,ARG1CL                                559
;*                                  Move position pointer past end  560
;       ICOMP   TLSGP1,FRSGPT,,,BLOGC                               561
;*                                  Check for end of region         562
;       ZERBLK  BLOCL,ARG1CL        Clear block                     563
;       PUTAC   BLOCL,0,BLOCL       Set up self-pointer in title    564
;       SETFI   BLOCL,TTL           Insert title flag               565
;       SETSIZ  BLOCL,ARG1CL        Insert block size               566
;       RRTURN  BLOCL,1             Return pointer to block         567
;*_                                                                 568
;BLOGC  MOVA    FRSGPT,BLOCL        Restore position pointer        569
;       RCALL   ,GC,(ARG1CL),(ALOC2,BLOCK1)                         570
;*                                  Regenerate storage              571

; Allocates block of size I bytes (from A field of descriptor D).  Garbage collects
; work space if needed.  Gives error if cannot allocate.  Block's title
; descriptor is set and rest of block is cleared to zeros.

; Parameters:
; R8     PARM     - addr of descriptor D
; R9     DESCR    - addr of descriptor R
;
; Input:  ------------------------------
;       D |   I    |         |    V    |
;         ------------------------------
;         ------------------------------
; FRSGPT  |   A    |    F    |         |
;         ------------------------------
;         ------------------------------
; TLSGP1  |   A2   |         |         |   Limit of work area
;         ------------------------------
;
; Output: ------------------------------
;      R  |   A    |    F    |    V    |
;         ------------------------------
;
;         ------------------------------
;      A  |   A    |   TTL   |    I    |   New allocated block
;         ------------------------------
;                     ...
;         ------------------------------
;    A+I  |   0    |    0    |    0    |
;         ------------------------------
;         ------------------------------
; FRSGPT  | A+I+D  |    F    |         |
;         ------------------------------

;SIL122 PROC    ; SIL122 X<7A> BLOCK Block allocator

        mov     SIL122CT,0      ;Show no collection done yet this call
SIL122REDO:
        mov     rcx,[r8]        ;Number of bytes needed
        cmp     rcx,SIZLIMX     ;check against size limit (#### leave room for F field)
        ja      SIL122ALOC2     ;Give size error if too big
        mov     rdx,rcx         ;save I value here
        add     rcx,DESCR       ;add extra descriptor
        mov     rbx,FRSGPT      ;Block location in free space
        mov     rax,rbx
        add     rax,rcx         ;potential new end address
;####   jc      SIL122GC        ;if overflow, garbage collect   needed?
        cmp     rax,TLSGP1      ;Check against free space limit
        ja      SIL122GC        ;Too high, go garbage collect
        mov     FRSGPT,rax      ;Update free space pointer
        mov     [r9],rbx        ;Return block location
        mov     rax,[r8+VOFFSET] ;Data type
        and     rax,SIL122noflags ;clear flags
        mov     al,byte ptr [FRSGPT+FOFFSET] ;get flags form FRSGPT #### constant??
        mov     [r9+VOFFSET],rax ;store V and flags in return descriptor
        mov     rax,rdx         ;get I field again
        shl     rax,8           ;shift into V position
        or      rax,TTL         ;Set title flag
        mov     [rbx+VOFFSET],rax ;set flags and V field in new block
        mov     [rbx],rbx       ;set self pointer for block
        mov     rdi,rbx
        add     rdi,DESCR       ;area to zero out
        mov     rcx,rdx         ;number of descriptors to zero *16
        shr     rcx,3           ;number of quadwords to zero
;#####  shr     rcx,4           ;number of octwords to zero
        xor     rax,rax         ;zero to be stored
;####   movdqa  xmm0,xmmword ptr ZEROSP
        cld                     ;clear direction
        rep stosq
;####SIL122xm: movups xmmword ptr [rdi],xmm0
;####   add     rdi,DESCR*2
;####   loop    SIL122xm
        ret

SIL122GC:       ;Garbage collection needed?
        cmp     SIL122CT,0      ;See if we already tried GC
        jnz     SIL122ALOC2     ;Jump and give error if we already called GC
; ##### parameters to GCP missing
        mov     GCREQ,rcx
        storxptr
; need to make stack look like descriptors without PTRF flag
        xor     r15,r15
       push     r15
        push    rax
       push     r15
        push    rbx
       push     r15
        push    rcx
       push     r15
        push    rdx
       push     r15
        push    rsi
       push     r15
        push    rdi
       push     r15
        push    r8
       push     r15
        push    r9
       push     r15
        CALL    GCP             ;Do garbage collection
       pop     r15
        pop    r9
       pop     r15
        pop    r8
       pop     r15
        pop    rdi
       pop     r15
        pop    rsi
       pop     r15
        pop    rdx
       pop     r15
        pop    rcx
       pop     r15
        pop    rbx
       pop     r15
        pop    rax
       pop     r15
        loadxptr
        mov     SIL122CT,1      ;Show collection done already
        jmp     SIL122REDO

SIL122ALOC2:
 dbgustr 'Work space exceeded' ;####
       loadxptr
       jmp     SIZERR          ;report size error
