; Descriptor and Specifier layout
; Written by Viktors Berstis

AUNITL  EQU     1               ;Bytes per address unit (addressing granularity) also CPA (characters per address)
CPA     EQU     1               ;Characters per address
CPD     EQU     16              ;Number of characters per descriptor.
RELADDR EQU     0               ;0=absolute addresses, 1=relative addresses
DESCR   EQU     16              ;number of bytes in a descriptor
SPEC    EQU     32              ;number of bytes in a specifier
; Need to retrofit use of these into code:
ALENG   EQU     8               ;Number of address units A field length
FLENG   EQU     1               ;Number of address units F field length
VLENG   EQU     7               ;Number of address units V field length
OLENG   EQU     8               ;Number of address units O field length
LLENG   EQU     8               ;Number of address units L field length
AOFFSET EQU     0               ;Offset of A field in descriptor or specifier
FOFFSET EQU     8               ;Offset of F field in descriptor or specifier
VOFFSET EQU     8               ;Offset of V field in descriptor or specifier
OOFFSET EQU     16              ;Offset of O field in specifier
LOFFSET EQU     24              ;Offset of L field in specifier

;   0       4       8       12
;  +-------+-------+-------+-------+
;  |       A       |  F + 256 * V  |    Descriptor with SIL address in A
;  +-------+-------+-------+-------+

;   0       4       8       12
;  +-------+-------+-------+-------+
;  |       A       |  F + 256 * V  |    Descriptor with SIL integer or float in A
;  +-------+-------+-------+-------+

;   0       4       8       12
;  +-------+-------+-------+-------+
;  |       A       |  F + 256 * V  |    Descriptor with sil code address in A
;  +-------+-------+-------+-------+

;   0       4       8       12      16      20      24      28
;  +-------+-------+-------+-------+-------+-------+-------+-------+
;  |       A       |  F + 256 * V  |       O       |     L*256     |    Specifier
;  +-------+-------+-------+-------+-------+-------+-------+-------+

UNITI   EQU     5               ;default input i/o unit
UNITO   EQU     6               ;default output i/o unit
UNITP   EQU     7               ;default punch i/o unit
UNITTI  EQU     97              ;default terminal input unit
UNITTO  EQU     98              ;default terminal output unit
