*---------------------------------------------------------------------*
       TITLE   'Other Operations'                                       4205
*
*      Assignment                                                       4207
*
ASGN   PROC    ,                   X = Y                                4209
       INCRA   OCICL,DESCR         Increment offset in object code      4210
       GETD    XPTR,OCBSCL,OCICL   Get object code descriptor           4211
       TESTF   XPTR,FNF,,ASGNC     Test for function descriptor
ASGNV  VEQLC   XPTR,K,,ASGNIC      Check for keyword subject            4213
       INCRA   OCICL,DESCR         Increment offset in object code      4214
       GETD    YPTR,OCBSCL,OCICL   Get object code descriptor           4215
       TESTF   YPTR,FNF,,ASGNCV    Test for function descriptor
ASGNVN IEQLC   INSWQ,0,,ASGNV1     Check &INPUT                         4217
       LOCAPV  ZPTR,INATL,YPTR,ASGNV1                                   4218
*                                  Look for input association           4219
       GETDC   ZPTR,ZPTR,DESCR     Get input association descriptor     4220
       RCALL   YPTR,PUTIN,(ZPTR,YPTR),(FAIL,ASGNVV)                     4221
*_
ASGNV1 GETDC   YPTR,YPTR,DESCR     Get value                            4223
ASGNVV PUTDC   XPTR,DESCR,YPTR     Perform assignment                   4224
       IEQLC   OUTSWQ,0,,ASGN1     Check &OUTPUT
       LOCAPV  ZPTR,OUTATL,XPTR,ASGN1                                   4226
*                                  Look for output association          4227
       GETDC   ZPTR,ZPTR,DESCR     Get output association descriptor    4228
       RCALL   ,PUTOUT,(ZPTR,YPTR) Perform output                       4229
ASGN1  ICOMPC  TRAPCL,0,ASGNX1                                          4230
       RRTURN  ,3
*                                  Check &TRACE                         4231
ASGNX1 LOCAPT  ATPTR,TVALL,XPTR,RTNUL3
*                                  Look for VALUE trace                 4233
       RCALL   ,TRPHND,ATPTR,RTNUL3 E3.3.1
*_
ASGNC  RCALL   XPTR,INVOKE,(XPTR),(FAIL,ASGNV,NEMO)                     4236
*_
ASGNCV PUSH    XPTR                Save subject of assignment           4238
       RCALL   YPTR,INVOKE,(YPTR),(FAIL,ASGNVP)                         4239
ASGNCJ POP     XPTR                Restore subject                      4240
       BRANCH  ASGNVV                                                   4241
*_
ASGNVP POP     XPTR                Restore subject                      4243
       BRANCH  ASGNVN                                                   4244
*_
ASGNIC PUSH    XPTR                Save subject of assignment           4246
       RCALL   YPTR,INTVAL,,(FAIL,ASGNCJ)                               4247
*                                  Get integer value for keyword        4248
*_
*---------------------------------------------------------------------*
*
*      X Y (concatenation)                                              4252
*
CON    PROC    ,                   X Y (concatenation)                  4254
       RCALL   ,XYARGS,,FAIL       Get two arguments                    4255
       DEQL    XPTR,NULVCL,CONX1   If first is null, return second
       RRTURN  YPTR,3
CONX1  DEQL    YPTR,NULVCL,,RTXPTR If second is null, return first
       VEQLC   XPTR,S,,CON5        Is first STRING?                     4258
       VEQLC   XPTR,P,,CON5        Is first PATTERN?                    4259
       VEQLC   XPTR,I,,CON4I       Is first INTEGER?                    4260
       VEQLC   XPTR,R,,CON4R       Is first REAL?                       4261
       VEQLC   XPTR,E,INTR1        Is first EXPRESSION?                 4262
       RCALL   TPTR,BLOCK,STARSZ   Allocate block for pattern           4263
       MOVBLK  TPTR,STRPAT,STARSZ  Set up pattern for expression        4264
       PUTDC   TPTR,4*DESCR,XPTR   Insert pointer to expression         4265
       MOVD    XPTR,TPTR           Set up as first argument             4266
       BRANCH  CON5                                                     4267
*_
CON4R  REALST  REALSP,XPTR         Convert REAL to STRING               4269
       SETSP   XSP,REALSP          Set up specifier                     4270
       RCALL   XPTR,GENVAR,XSPPTR,CON5                                  4271
*                                  Generate variable                    4272
*_
CON4I  INTSPC  ZSP,XPTR            Convert INTEGER to STRING            4274
       RCALL   XPTR,GENVAR,(ZSPPTR)                                     4275
*                                  Generate variable                    4276
CON5   VEQLC   YPTR,S,,CON7        Is second STRING?                    4277
       VEQLC   YPTR,P,,CON7        Is second PATTERN?                   4278
       VEQLC   YPTR,I,,CON5I       Is second INTEGER?                   4279
       VEQLC   YPTR,R,,CON5R       Is second REAL?                      4280
       VEQLC   YPTR,E,INTR1        Is second EXPRESSION?                4281
       RCALL   TPTR,BLOCK,STARSZ   Allocate block for pattern           4282
       MOVBLK  TPTR,STRPAT,STARSZ  Set up pattern for expression        4283
       PUTDC   TPTR,4*DESCR,YPTR   Insert pointer to expression         4284
       MOVD    YPTR,TPTR           Set up as second argument            4285
       BRANCH  CON7                Join processing                      4286
*_
CON5R  REALST  REALSP,YPTR         Convert REAL to STRING               4288
       SETSP   YSP,REALSP          Set up sepcifier                     4289
       RCALL   YPTR,GENVAR,YSPPTR,CON7                                  4290
*                                  Generate variable                    4291
*_
CON5I  INTSPC  ZSP,YPTR            Convert INTEGER to STRING            4293
       RCALL   YPTR,GENVAR,(ZSPPTR)                                     4294
*                                  Generate variable                    4295
CON7   SETAV   DTCL,XPTR           Get data type of first               4296
       MOVV    DTCL,YPTR           Get data type of second              4297
       DEQL    DTCL,VVDTP,,CONVV   Check for STRING-STRING              4298
       DEQL    DTCL,VPDTP,,CONVP   Check for STRING-PATTERN             4299
       DEQL    DTCL,PVDTP,,CONPV   Check for PATTERN-STRING             4300
       DEQL    DTCL,PPDTP,INTR1,CONPP                                   4301
*                                  Check for PATTERN-PATTERN            4302
*_
CONVV  LOCSP   XSP,XPTR            Specifier for first string           4304
       LOCSP   YSP,YPTR            Specifier for second string          4305
       GETLG   XCL,XSP             Length of first string               4306
       GETLG   YCL,YSP             Length of second string              4307
       SUM     XCL,XCL,YCL         Total length                         4308
       ICOMP   XCL,MLENCL,INTR8    Check against &MAXLNGTH
       RCALL   ZPTR,CONVAR,(XCL)   Allocate space for string            4310
       LOCSP   TSP,ZPTR            Get specifier to allocated space     4311
       SETLC   TSP,0               Clear length                         4312
       APDSP   TSP,XSP             Move in first string                 4313
       APDSP   TSP,YSP             Append second string                 4314
       BRANCH  GENVSZ              Generate variable                    4315
*_
CONVP  LOCSP   TSP,XPTR            Specifier to string                  4317
       GETLG   TMVAL,TSP           Get length of string                 4318
       RCALL   TPTR,BLOCK,LNODSZ   Allocate block for pattern           4319
       MAKNOD  XPTR,TPTR,TMVAL,ZEROCL,CHRCL,XPTR                        4320
*                                  Construct pattern                    4321
CONPP  GETSIZ  XSIZ,XPTR           Get size of first pattern            4322
       GETSIZ  YSIZ,YPTR           Get size of second pattern           4323
       SUM     TSIZ,XSIZ,YSIZ      Compute total size required          4324
       SETVC   TSIZ,P              Insert PATTERN data type             4325
       RCALL   TPTR,BLOCK,TSIZ     Allocate block for new pattern       4326
       MOVD    ZPTR,TPTR           Save copy to return                  4327
       LVALUE  TVAL,YPTR           Get least value for second pattern   4328
       CPYPAT  TPTR,XPTR,TVAL,ZEROCL,XSIZ,XSIZ                          4329
*                                  Copy in first pattern                4330
       CPYPAT  TPTR,YPTR,ZEROCL,XSIZ,ZEROCL,YSIZ                        4331
*                                  Copy in second pattern               4332
       RRTURN  ZPTR,3              Return pattern as value
*_
CONPV  LOCSP   TSP,YPTR            Get specifier to string              4335
       GETLG   TMVAL,TSP           Get length of string                 4336
       RCALL   TPTR,BLOCK,LNODSZ   Allocate block for pattern           4337
       MAKNOD  YPTR,TPTR,TMVAL,ZEROCL,CHRCL,YPTR                        4338
*                                  Construct pattern for string         4339
       BRANCH  CONPP               Join common processing               4340
*_
*---------------------------------------------------------------------*
*
*      Indirect Reference                                               4344
*
IND    PROC    ,                   $X                                   4346
       RCALL   XPTR,ARGVAL,,FAIL   Get argument                         4347
       VEQLC   XPTR,S,,INDV        STRING is acceptable                 4348
       VEQLC   XPTR,N,,RTXNAM      NAME can be returned directly        4349
       VEQLC   XPTR,I,,GENVIX      Convert INTEGER                      4350
       VEQLC   XPTR,R,,GENVRX      Convert REAL
       VEQLC   XPTR,K,INTR1,RTXNAM KEYWORD is like NAME                 4351
*_
INDV   IEQLC   XPTR,0,RTXNAM,NONAME                                     4353
*                                  Be sure string is not null           4354
*_
*---------------------------------------------------------------------*
*
*      Keywords                                                         4358
*
KEYWRD PROC    ,                   &X                                   4360
       INCRA   OCICL,DESCR         Increment offset                     4361
       GETD    XPTR,OCBSCL,OCICL   Get object code descriptor           4362
       TESTF   XPTR,FNF,,KEYC      Check for function
KEYN   LOCAPV  XPTR,KNATL,XPTR,KEYV                                     4364
*                                  Look up X on unprotected list        4365
       SETVC   XPTR,K              Set KEYWORD (NAME) data type         4366
       BRANCH  RTXNAM              Return by name                       4367
*_
KEYV   LOCAPV  ATPTR,KVATL,XPTR,UNKNKW                                  4369
*                                  Look up X on protected list          4370
       GETDC   ZPTR,ATPTR,DESCR    Get value                            4371
       RRTURN  ZPTR,3              Return by value
*_
KEYC   RCALL   XPTR,INVOKE,(XPTR),(FAIL,KEYN,NEMO)                      4374
*                                  Evaluate computed keyword            4375
*_
KEYT   PROC    KEYWRD              Procedure to get keyword for trace   4377
       POP     XPTR                Restore argument                     4378
       BRANCH  KEYN                                                     4379
*_                                 Join common processing               4380
*---------------------------------------------------------------------*
*      Literal Evaluation                                               4382
*
*
LIT    PROC    ,                   'X'                                  4385
       INCRA   OCICL,DESCR         Increment offset                     4386
       GETD    ZPTR,OCBSCL,OCICL   Get object code descriptor           4387
       RRTURN  ZPTR,3              Return value
*_
*---------------------------------------------------------------------*
*
*      Unary Name Operator                                              4392
*
NAMEOP PROC    ,                   .X
       INCRA   OCICL,DESCR         Increment offset                     4395
       GETD    ZPTR,OCBSCL,OCICL   Get object code descriptor           4396
       TESTF   ZPTR,FNF,RTZPTR     Test for function
       RCALL   ZPTR,INVOKE,ZPTR,(FAIL,RTZPTR,NEMO)                      4398
*_
*
*
*---------------------------------------------------------------------*
*
*      Value Assignment in Pattern Matching                             4404
*
NMD    PROC    ,                                                        4406
       MOVD    TCL,NHEDCL                                               4407
NMD1   ACOMP   TCL,NAMICL,INTR13,RTN2                                   4408
*                                  Check for end                        4409
       SUM     TPTR,NBSPTR,TCL     Compute address                      4410
       GETSPC  TSP,TPTR,DESCR      Get specifier                        4411
       GETDC   TVAL,TPTR,DESCR+SPEC                                     4412
*                                  get variable                         4413
       GETLG   XCL,TSP             Get length                           4414
       ICOMP   XCL,MLENCL,INTR8    Check &MAXLNGTH
       VEQLC   TVAL,E,,NAMEXN      Is Variable EXPRESSION?              4416
NMD5   VEQLC   TVAL,K,,NMDIC       Is variable KEYWORD?                 4417
       RCALL   VVAL,GENVAR,(TSPPTR)                                     4418
*                                  Generate string                      4419
NMD4   PUTDC   TVAL,DESCR,VVAL     Assign value                         4420
       IEQLC   OUTSWQ,0,,NMD3      Check &OUTPUT
       LOCAPV  ZPTR,OUTATL,TVAL,NMD3                                    4422
*                                  Look for output association          4423
       GETDC   ZPTR,ZPTR,DESCR     Get association                      4424
       RCALL   ,PUTOUT,(ZPTR,VVAL) Perform output                       4425
NMD3   ICOMPC  TRAPCL,0,,NMD2,NMD2 Check &TRACE                         4426
       LOCAPT  ATPTR,TVALL,TVAL,NMD2                                    4427
*                                  Look for VALUE trace                 4428
       PUSH    (TCL,NAMICL,NHEDCL) Save state                           4429
       MOVD    NHEDCL,NAMICL       Set up new name list                 4430
       RCALL   ,TRPHND,ATPTR       E3.3.1
*                                  Perform trace                        4432
       POP     (NHEDCL,NAMICL,TCL) Restore state                        4433
NMD2   INCRA   TCL,DESCR+SPEC      Move to next name                    4434
       BRANCH  NMD1                Continue                             4435
*_
NMDIC  SPCINT  VVAL,TSP,INTR1,NMD4 Convert to INTEGER                   4437
*_
NAMEXN RCALL   TVAL,EXPEVL,TVAL,(FAIL,NMD5,NEMO) E3.10.5
*                                  Evaluate expression                  4440
*_
*---------------------------------------------------------------------*
*
*      Unevaluated Expression                                           4444
*
STRLBL PROC    ,                   *X
       SUM     ZPTR,OCBSCL,OCICL   Compute position in code             4447
       RCALL   ,CODSKP,(ONECL)     Skip one nest                        4448
       SETVC   ZPTR,E              Insert EXPRESSION data type          4449
       RRTURN  ZPTR,3              Return pointer to code
*_
*---------------------------------------------------------------------*
       TITLE   'Other Predicates'                                       4453
*
*      DIFFER(X,Y)                                                      4455
*
DIFFER PROC    ,                   DIFFER(X,Y)                          4457
       RCALL   ,XYARGS,,FAIL       Evaluate arguments                   4458
       DEQL    XPTR,YPTR,RETNUL,FAIL                                    4459
*                                  Compare them                         4460
*_
*---------------------------------------------------------------------*
*
*      ISLABEL(X)
*
ISLAB  PROC    ,                   ISLABEL(X)
       RCALL   YPTR,VARVAL,,FAIL   Get argument
       VEQLC   YPTR,S,FAIL         Fail if not STRING
       VCMPIC  YPTR,DESCR*2,LABTST,FAIL,RETNUL,FAIL
*                                  Return null if it is a label
*_
*---------------------------------------------------------------------*
*
*      ISNAN(X)
*
ISNAN  PROC    ,                   ISNAN(X)
       RCALL   YPTR,ARGVAL,,FAIL   Get argument
       VEQLC   YPTR,R,FAIL         Fail if not REAL
       RCOMP   YPTR,YPTR,FAIL,FAIL,FAIL,RETNUL
*                                  Return null if is NAN
*_
*---------------------------------------------------------------------*
*
*      IDENT(X,Y)                                                       4464
*
IDENT  PROC    ,                   IDENT(X,Y)                           4466
       RCALL   ,XYARGS,,FAIL       Evaluate arguments                   4467
* ICOMPC EXNOCL,1011100,,SKIPY,SKIPY , ####
* DUMPD XPTR , ####
* DUMPD YPTR , ####
*SKIPY LHERE , ####
       DEQL    XPTR,YPTR,FAIL,RETNUL                                    4468
*                                  Compare arguments                    4469
*_
*---------------------------------------------------------------------*
*
*      LGT(X,Y)                                                         4473
*
LGT    PROC    ,                   LGT(X,Y)                             4475
       RCALL   XPTR,VARVAL,,FAIL   Evaluate first argument              4476
       PUSH    XPTR                Save first argument                  4477
       RCALL   YPTR,VARVAL,,FAIL   Evaluate second argument             4478
       POP     XPTR                Restore first argument               4479
       IEQLC   XPTR,0,,FAIL        Null is not greater than anything
       IEQLC   YPTR,0,,RETNUL      Similarly for second argument
       LOCSP   XSP,XPTR            Get specifier to first argument      4482
       LOCSP   YSP,YPTR            Get specifier to second argument     4483
       LEXCMP  XSP,YSP,RETNUL,FAIL,FAIL                                 4484
*                                  Compare lexically                    4485
*_
*---------------------------------------------------------------------*
*
*      LEQ(X,Y)
*
LEQ    PROC    ,                   LEQ(X,Y)
       RCALL   XPTR,VARVAL,,FAIL   Evaluate first argument
       PUSH    XPTR                Save first argument
       RCALL   YPTR,VARVAL,,FAIL   Evaluate second argument
       POP     XPTR                Restore first argument
       IEQLC   XPTR,0,,FAIL        Null is not greater than anything
       IEQLC   YPTR,0,,RETNUL      Similarly for second argument
       LOCSP   XSP,XPTR            Get specifier to first argument
       LOCSP   YSP,YPTR            Get specifier to second argument
       LEXCMP  XSP,YSP,FAIL,RETNUL,FAIL
*                                  Compare lexically
*_
*---------------------------------------------------------------------*
*
*      LGE(X,Y)
*
LGE    PROC    ,                   LGE(X,Y)
       RCALL   XPTR,VARVAL,,FAIL   Evaluate first argument
       PUSH    XPTR                Save first argument
       RCALL   YPTR,VARVAL,,FAIL   Evaluate second argument
       POP     XPTR                Restore first argument
       IEQLC   XPTR,0,,FAIL        Null is not greater than anything
       IEQLC   YPTR,0,,RETNUL      Similarly for second argument
       LOCSP   XSP,XPTR            Get specifier to first argument
       LOCSP   YSP,YPTR            Get specifier to second argument
       LEXCMP  XSP,YSP,RETNUL,RETNUL,FAIL
*                                  Compare lexically
*_
*---------------------------------------------------------------------*
*
*      LLE(X,Y)
*
LLE    PROC    ,                   LLE(X,Y)
       RCALL   XPTR,VARVAL,,FAIL   Evaluate first argument
       PUSH    XPTR                Save first argument
       RCALL   YPTR,VARVAL,,FAIL   Evaluate second argument
       POP     XPTR                Restore first argument
       IEQLC   XPTR,0,,FAIL        Null is not greater than anything
       IEQLC   YPTR,0,,RETNUL      Similarly for second argument
       LOCSP   XSP,XPTR            Get specifier to first argument
       LOCSP   YSP,YPTR            Get specifier to second argument
       LEXCMP  XSP,YSP,FAIL,RETNUL,RETNUL
*                                  Compare lexically
*_
*---------------------------------------------------------------------*
*
*      LLT(X,Y)
*
LLT    PROC    ,                   LLT(X,Y)
       RCALL   XPTR,VARVAL,,FAIL   Evaluate first argument
       PUSH    XPTR                Save first argument
       RCALL   YPTR,VARVAL,,FAIL   Evaluate second argument
       POP     XPTR                Restore first argument
       IEQLC   XPTR,0,,FAIL        Null is not greater than anything
       IEQLC   YPTR,0,,RETNUL      Similarly for second argument
       LOCSP   XSP,XPTR            Get specifier to first argument
       LOCSP   YSP,YPTR            Get specifier to second argument
       LEXCMP  XSP,YSP,FAIL,FAIL,RETNUL
*                                  Compare lexically
*_
*---------------------------------------------------------------------*
*
*      LNE(X,Y)
*
LNE    PROC    ,                   LNE(X,Y)
       RCALL   XPTR,VARVAL,,FAIL   Evaluate first argument
       PUSH    XPTR                Save first argument
       RCALL   YPTR,VARVAL,,FAIL   Evaluate second argument
       POP     XPTR                Restore first argument
       IEQLC   XPTR,0,,FAIL        Null is not greater than anything
       IEQLC   YPTR,0,,RETNUL      Similarly for second argument
       LOCSP   XSP,XPTR            Get specifier to first argument
       LOCSP   YSP,YPTR            Get specifier to second argument
       LEXCMP  XSP,YSP,RETNUL,FAIL,RETNUL
*                                  Compare lexically
*_
*---------------------------------------------------------------------*
*
*      Unary Negation Operator                                          4489
*
NEGLBL PROC    ,                   \X
       PUSH    (OCBSCL,OCICL)      Save object code position            4492
       RCALL   ,ARGVAL,,(,FAIL)    Fail on success                      4493
       POP     (OCICL,OCBSCL)      Restore object code position         4494
       RCALL   ,CODSKP,(ONECL),RETNUL                                   4495
*                                  Skip argument and return             4496
*_
*---------------------------------------------------------------------*
*
*      Unary Interrogation Operator                                     4500
*
QUES   PROC    ,                   ?X                                   4502
       RCALL   ,ARGVAL,,(FAIL,RETNUL)                                   4503
*                                  Evaluate argument                    4504
*_
*---------------------------------------------------------------------*
       TITLE   'Other Functions'                                        4507
*
*      APPLY(F,A\,...Ar)                                                4509
*
APPLY  PROC    ,                   APPLY(F,A\,...,Ar)                   4511
       SETAV   XCL,INCL            Get count of arguments               4512
       DECRA   XCL,1               Decrement to skip function name      4513
       ICOMPC  XCL,1,,,ARGNER      E3.3.3
       PUSH    XCL                 Save argument count                  4515
       RCALL   XPTR,VARVAL,,FAIL   Get function name                    4516
       POP     XCL                 Restore argument count               4517
       LOCAPV  XPTR,FNCPL,XPTR,UNDF                                     4518
*                                  Locate function                      4519
       GETDC   INCL,XPTR,DESCR     Get function descriptor              4520
       SETVA   INCL,XCL            Insert actual number of arguments    4521
       RCALL   ZPTR,INVOKE,(INCL),(FAIL,,RTZPTR)                        4522
       MOVD    XPTR,ZPTR           Return by name                       4523
       BRANCH  RTXNAM                                                   4524
*_
*---------------------------------------------------------------------*
*
*      PE3(todo,x,y,string)  Custom code for Personal Editor 3
*
PE3FUNC PROC   ,                                            ##custom##
       RCALL   XPTR,INTVAL,,FAIL   Get 1st arg=integer todo ##custom##
       PUSH    XPTR                                         ##custom##
       RCALL   YPTR,INTVAL,,FAIL   Get 2rd arg=integer x    ##custom##
       PUSH    YPTR                                         ##custom##
       RCALL   ZPTR,INTVAL,,FAIL   Get 2rd arg=integer y    ##custom##
       PUSH    ZPTR                                         ##custom##
       RCALL   WPTR,VARVAL,,FAIL   Get string               ##custom##
       POP     ZPTR                                         ##custom##
       POP     YPTR                                         ##custom##
       POP     XPTR                                         ##custom##
       LOCSP   WSP,WPTR            get specifier            ##custom##
       PE3     XPTR,YPTR,ZPTR,WSP                           ##custom##
       BRANCH  RETNUL                                       ##custom##
*_
*---------------------------------------------------------------------*
*
*      AND(x,y)
*
ANDFUNC PROC   ,
       RCALL   XPTR,VARVAL,,FAIL   Get first argument
       PUSH    XPTR                Save first argument
       RCALL   YPTR,VARVAL,,FAIL   Get second argument
       POP     XPTR                Restore first
       LOCSP   YSP,YPTR            Get specifier for second
       LOCSP   XSP,XPTR            Get specifier for first
       GETLG   XCL,XSP             Get length
       GETLG   YCL,YSP             Get length
       ICOMP   XCL,YCL,ANDFUNCX    Jump if first is longer
       MOVA    XCL,YCL             Set max of two lengths
ANDFUNCX RCALL ZPTR,CONVAR,XCL     Allocate space for result
       LOCSP   TSP,ZPTR            Get specifier
       ANDFUN  TSP,XSP,YSP         Perform logical AND function
       BRANCH  GENVSZ              Got generate variable
*_
*---------------------------------------------------------------------*
*
*      ARG(F,N), FIELD(F,N), and LOCAL(F,N)                             4528
*
ARG    PROC    ,                   ARG(F,N)                             4530
       PUSH    (ONECL,DEFCL)       Save ARG indicators                  4531
       BRANCH  ARG1                Join main processing                 4532
*_
ARGINT PROC    ARG                 Procedure used for CALL tracing      4534
       POP     (XPTR,XCL)          Restore arguments                    4535
       PUSH    (ONECL,DEFCL)       Save indicators                      4536
       BRANCH  ARG2                Join processing                      4537
*_
LQCAL  PROC    ARG                 LOCAL(F,N)
       PUSH    (ONECL,ZEROCL,DEFCL)                                     4540
*                                  Save LOCAL indicators                4541
       BRANCH  ARG1                Join main processing                 4542
*_
FIELDS PROC    ARG                 FIELD(F,N)                           4544
       PUSH    (ZEROCL,ZEROCL,DATCL)                                    4545
*                                  Save FIELD indicators                4546
ARG1   RCALL   XPTR,VARVAL,,FAIL   Get function name                    4547
       PUSH    XPTR                Save function name                   4548
       RCALL   XCL,INTVAL,,FAIL    Get number                           4549
       ICOMP   ZEROCL,XCL,FAIL,FAIL
*                                  Verify positive number               4551
       POP     XPTR                Restore function name                4552
ARG2   LOCAPV  XPTR,FNCPL,XPTR,INTR30                                   4553
*                                  Look for function descriptor         4554
       GETDC   XPTR,XPTR,DESCR     Get function descriptor              4555
       GETDC   YCL,XPTR,0          Get procedure descriptor             4556
       GETDC   XPTR,XPTR,DESCR     Get definition block                 4557
       POP     (ZCL,ALCL)          Restore indicators                   4558
       AEQL    YCL,ZCL,INTR30      Check procedure type                 4559
       MULTC   XCL,XCL,DESCR       Convert number to address units      4560
       INCRA   XCL,2*DESCR         Skip prototype information           4561
       SETAV   YCL,YCL             Get argument count                   4562
       MULTC   YCL,YCL,DESCR       Convert to address units             4563
       IEQLC   ALCL,0,,ARG4        Check funcion type
       INCRA   YCL,2*DESCR         Increment for heading                4565
       MOVD    ZCL,YCL             Get working copy                     4566
       BRANCH  ARG5                Branch to continue processing        4567
*_
ARG4   GETSIZ  ZCL,XPTR            Get size of block                    4569
       POP     ALCL                Restore entry indicator              4570
       IEQLC   ALCL,0,,ARG5        Check entry type
       SUM     XCL,XCL,YCL         Skip formal arguments                4572
ARG5   ICOMP   XCL,ZCL,FAIL        Check number in bounds               4573
       GETD    ZPTR,XPTR,XCL       Get the desired name                 4574
       RRTURN  ZPTR,3              Return name as value
*_
*---------------------------------------------------------------------*
*
*      CLEAR()                     Clear all variables                  4579
*
CLEAR  PROC    ,                   CLEAR()                              4581
       RCALL   ,ARGVAL,,FAIL       Get rid of argument                  4582
       SETAA   DMPPTR,OBLIST-DESCR Initialize bin pointer
CLEAR1 ACOMP   DMPPTR,OBEND,RETNUL Check for end                        4584
       INCRA   DMPPTR,DESCR        Update for next bin                  4585
       MOVD    YPTR,DMPPTR         Get working copy                     4586
CLEAR2 GETAC   YPTR,YPTR,LNKFLD    Get next variable                    4587
       IEQLC   YPTR,0,,CLEAR1      Check for end of chain
       PUTDC   YPTR,DESCR,NULVCL   Assign null value                    4589
       BRANCH  CLEAR2              Continue                             4590
*_
*---------------------------------------------------------------------*
*
*      COLLECT(N)                                                       4594
*
COLECT PROC    ,                   COLLECT(N)                           4596
       RCALL   XPTR,INTVAL,,FAIL   Get number of address units required 4597
       ICOMPC  XPTR,0,,,LENERR     Verify positive integer
       INCRI   XPTR,CPA-1          Adjust from bytes
       SETAC   ZPTR,CPA            Divisor
       DIVIDE  XPTR,XPTR,ZPTR      Adjust to address units
       RCALL   ZPTR,GC,(XPTR),FAIL Call for storage regeneration        4599
       MULTC   ZPTR,ZPTR,CPA       Give value in characters
       SETVC   ZPTR,I              Set INTEGER data type                4600
       RRTURN  ZPTR,3              Return amount collected
*_
*---------------------------------------------------------------------*
*
*      COPY(X)                                                          4605
*
COPY   PROC    ,                   COPY(X)                              4607
       RCALL   XPTR,ARGVAL,,FAIL   Get object to copy                   4608
       VEQLC   XPTR,S,,INTR1       STRING cannot be copied              4609
       VEQLC   XPTR,I,,INTR1       INTEGER cannot be copied             4610
       VEQLC   XPTR,R,,INTR1       REAL cannot be copied                4611
       VEQLC   XPTR,N,,INTR1       NAME cannot be copied                4612
       VEQLC   XPTR,K,,INTR1       KEYWORD (NAME) cannot be copied      4613
       VEQLC   XPTR,E,,INTR1       EXPRESSION cannot be copied          4614
       VEQLC   XPTR,T,,INTR1       TABLE cannot be copied               4615
       GETSIZ  XCL,XPTR            Get size of object to copy           4616
       MOVV    XCL,XPTR            Insert data type                     4617
       RCALL   ZPTR,BLOCK,XCL      Allocate block for copy              4618
       MOVBLK  ZPTR,XPTR,XCL       Copy contents                        4619
       RRTURN  ZPTR,3              Return the copy
*_
*---------------------------------------------------------------------*
*
*      INT(X)                      INT(x) converts to integer
*
CVINT  PROC    ,                   INT(X)
       RCALL   ZPTR,ARGVAL,,FAIL   Get object to be converted
       SETAV   DTCL,ZPTR           Insert object data type
       SETVC   DTCL,I              Integer target data type
       DEQL    DTCL,RIDTP,,CONRI   Check for REAL-INTEGER
       DEQL    DTCL,VIDTP,,CNVVI   Check for STRING-INTEGER
       VEQLC   ZPTR,I,FAIL,RTZPTR  Already an integer?
*_
*---------------------------------------------------------------------*
*
*      REAL(X)                     REAL(x) converts to real
*
CVREL  PROC    ,                   REAL(X)
       RCALL   ZPTR,ARGVAL,,FAIL   Get object to be converted
       SETAV   DTCL,ZPTR           Insert object data type
       SETVC   DTCL,R              Real target data type
       DEQL    DTCL,VRDTP,,CONVR   Check for STRING-REAL
       DEQL    DTCL,IRDTP,,CONIR   Check for INTEGER-REAL
       VEQLC   ZPTR,R,FAIL,RTZPTR  Already a REAL?
*_
*---------------------------------------------------------------------*
*
*      STR(X)                      STR(x) converts to string
*
CVSTR  PROC    ,                   STR(X)
       RCALL   ZPTR,ARGVAL,,FAIL   Get object to be converted
       SETAV   DTCL,ZPTR           Insert object data type
       SETVC   DTCL,S              Integer target data type
       DEQL    DTCL,IVDTP,,CNVIV   Check for INTEGER-STRING
       VEQLC   ZPTR,S,CNVRTS,RTZPTR Already a string?
*_
*---------------------------------------------------------------------*
*
*      CONVERT(X,T)                                                     4624
*
CNVRT  PROC    ,                   CONVERT(X,T)                         4626
       RCALL   ZPTR,ARGVAL,,FAIL   Get object to be converted           4627
       PUSH    ZPTR                Save object                          4628
       RCALL   YPTR,VARVAL,,FAIL   Get data type target                 4629
       POP     ZPTR                Restore object                       4630
       LOCAPV  XPTR,DTATL,YPTR,INTR1                                    4631
*                                  Look for data type code              4632
       GETDC   XPTR,XPTR,DESCR     Get code                             4633
       SETAV   DTCL,ZPTR           Insert object data type              4634
       MOVV    DTCL,XPTR           Insert target data type              4635
       DEQL    DTCL,IVDTP,,CNVIV   Check for INTEGER-STRING             4636
       DEQL    DTCL,VCDTP,,RECOMP  Check for STRING-CODE                4637
       DEQL    DTCL,VEDTP,,CONVE                                        4638
       DEQL    DTCL,VRDTP,,CONVR   Check for STRING-REAL                4639
       DEQL    DTCL,RIDTP,,CONRI   Check for REAL-INTEGER               4640
       DEQL    DTCL,IRDTP,,CONIR   Check for INTEGER-REAL               4641
       DEQL    DTCL,VIDTP,,CNVVI   CHeck for STRING-INTEGER             4642
       DEQL    DTCL,ATDTP,,CNVAT   Check for ARRAY-TABLE                4643
       DEQL    DTCL,TADTP,,CNVTA   Check for TABLE-ARRAY                4644
       VEQL    ZPTR,XPTR,,RTZPTR   E3.0.4
       VEQLC   XPTR,S,FAIL,CNVRTS  E3.0.4
*                                  Check for item-conversion
*_
RECOMP SETAC   SCL,1               Note STRING-CODE conversion          4649
RECOMJ LOCSP   TEXTSP,ZPTR         Set up global specifier              4650
RECOMT GETLG   OCALIM,TEXTSP       E3.1.5
       IEQLC   OCALIM,0,,RECOMN    E3.1.5
       MULTC   OCALIM,OCALIM,DESCR Convert to address units             4653
       INCRA   OCALIM,6*DESCR      Leave room for safety                4654
       SETVC   OCALIM,C            Insert CODE data type                4655
       RCALL   CMBSCL,BLOCK,OCALIM Allocate block for object code       4656
       SUM     OCLIM,CMBSCL,OCALIM Compute end                          4657
       DECRA   OCLIM,6*DESCR                                            4658
       SETAC   CMOFCL,0            Zero offset                          4659
       SETAC   ESAICL,0            Zero error count                     4660
       PUSH    CMBSCL              Save block pointer                   4661
       SELBRA  SCL,(,CONVEX)       Select correct procedure             4662
RECOM1 LEQLC   TEXTSP,0,,RECOM2    Is string exhausted?                 4663
       RCALL   ,CMPILE,,(RECOMF,,RECOM1)                                4664
*                                  Compile statement                    4665
RECOM2 SETAC   SCL,3               Set return switch                    4666
RECOMQ INCRA   CMOFCL,DESCR        Increment offset                     4667
       PUTD    CMBSCL,CMOFCL,ENDCL Insert END function                  4668
       POP     ZPTR                Restore pointer to code block        4669
RECOMZ SUM     CMBSCL,CMBSCL,CMOFCL                                     4670
*                                  Compute used portion of block        4671
       RCALL   ,SPLIT,(CMBSCL)     Split off remainder                  4672
       SETAC   OCLIM,0             Clear limit pointer                  4673
       SETAC   LPTR,0              Clear label pointer                  4674
       ZERBLK  COMREG,COMDCT       Zero compiler descriptors            4675
       SELBRA  SCL,(FAIL,INTR10,RTZPTR)                                 4676
*                                  Select return                        4677
*_
RECOMF SETAC   SCL,1               Set failure return                   4679
       BRANCH  RECOMQ              Rejoin processing                    4680
*_
RECOMN SETSP   TEXTSP,BLSP         E3.1.5
       BRANCH  RECOMT              E3.1.5
*_                                                              E3.1.5
CODER  PROC    CNVRT               CODE(S)                              4682
       RCALL   ZPTR,VARVAL,,(FAIL,RECOMP)                               4683
*                                  Get argument                         4684
*_
CONVE  PROC    CNVRT               Convert to EXPRESSION                4686
       SETAC   SCL,2               Set switch                           4687
       BRANCH  RECOMJ              Join common program                  4688
*_
CONVEX RCALL   FORMND,EXPR,,FAIL   Compile expression                   4690
       LEQLC   TEXTSP,0,FAIL       Verify complete compilation          4691
       RCALL   ,TREPUB,FORMND      Publish code tree                    4692
       MOVD    ZPTR,CMBSCL         E3.1.6
       SETVC   ZPTR,E              Insert EXPRESSION data type          4694
       SETAC   SCL,3               Set return branch                    4695
       BRANCH  RECOMZ              Join common program                  4696
*_
CONVR  LOCSP   ZSP,ZPTR            Get specifier                        4698
       SPCINT  ZPTR,ZSP,,CONIR     Try conversion to INTEGER first      4699
       SPREAL  ZPTR,ZSP,FAIL,RTZPTR                                     4700
*                                  Convert to REAL                      4701
*_
CONIR  INTRL   ZPTR,ZPTR           Convert INTEGER to REAL              4703
       RRTURN  ZPTR,3              Return value
*_
CONRI  RLINT   ZPTR,ZPTR,FAIL,RTZPTR                                    4706
*                                  Convert REAL to INTEGER              4707
*_
CNVIV  RCALL   ZPTR,GNVARI,ZPTR,RTZPTR                                  4709
*                                  Convert INTEGER to STRING            4710
*_
CNVVI  LOCSP   ZSP,ZPTR            Get specifier                        4712
       SPCINT  ZPTR,ZSP,,RTZPTR    Convert STRING to INTEGER            4713
       SPREAL  ZPTR,ZSP,FAIL,CONRI Try conversion to REAL               4714
*_
CNVRTS RCALL   XPTR,DTREP,ZPTR     Get data type representation         4716
       GETSPC  ZSP,XPTR,0          Get specifier                        4717
       BRANCH  GENVRZ              Go generate variable                 4718
*_
CNVTA  MOVD    YPTR,ZPTR           E3.2.3
       MOVD    YCL,ZEROCL          E3.2.3
CNVTA7 GETSIZ  XCL,YPTR            E3.2.3
       MOVD    WPTR,YPTR           E3.2.3
       MOVD    ZCL,XCL             E3.2.3
       DECRA   XCL,3*DESCR         E3.2.3
CNVTA1 GETD    WCL,WPTR,XCL        Get item value                       4724
       DEQL    WCL,NULVCL,,CNVTA2  Check for null value                 4725
       INCRA   YCL,1               Otherwise count item                 4726
CNVTA2 IEQLC   XCL,DESCR,,CNVTA6   E3.2.3
       DECRA   XCL,2*DESCR         Count down                           4728
       BRANCH  CNVTA1              Process next item                    4729
*_
CNVTA6 GETD    YPTR,YPTR,ZCL       E3.2.3
       IEQLC   YPTR,1,CNVTA7       E3.2.3
CNVTA4 IEQLC   YCL,0,,FAIL         Fail on empty table                  4731
       MOVD    WPTR,ZPTR           E3.2.3
       MULTC   XCL,YCL,2*DESCR     Convert count to address units       4732
       INTSPC  YSP,YCL             Get prototype for size               4733
       SETLC   PROTSP,0            Clear specifier                      4734
       APDSP   PROTSP,YSP          Append length                        4735
       APDSP   PROTSP,CMASP        Append comma                         4736
       MOVD    WCL,ZEROCL          E3.1.1
       SETAC   WCL,2               Set up 2 for second dimension        4737
       INTSPC  XSP,WCL             Convert to string                    4738
       APDSP   PROTSP,XSP          Append 2                             4739
       SETSP   XSP,PROTSP          Move specifier                       4740
       RCALL   TPTR,GENVAR,XSPPTR  E3.5.2
*                                  Generate variable for prototype      4742
       MOVD    ZCL,XCL             Save size                            4743
       INCRA   XCL,4*DESCR         Increment for heading                4744
       RCALL   ZPTR,BLOCK,XCL      Get block for array                  4745
       SETVC   ZPTR,A              Insert ARRAY data type               4746
       MOVD    ATPRCL,TPTR         E3.5.2
       SETVA   ATEXCL,YCL          Insert First dimension in head       4747
       MOVBLK  ZPTR,ATRHD,FRDSCL   Copy heading information             4748
       MOVD    YPTR,ZPTR           Save copy of block pointer           4749
       MULTC   YCL,YCL,DESCR       Convert item count to address units  4750
       INCRA   YPTR,5*DESCR        Skip heading                         4751
       SUM     TPTR,YPTR,YCL       Compute second half position         4752
CNVTA8 GETSIZ  WCL,WPTR            E3.2.3
       DECRA   WCL,2*DESCR         E3.2.3
       SUM     WCL,WPTR,WCL        E3.2.3
CNVTA3 GETDC   TCL,WPTR,DESCR      E3.2.3
       DEQL    TCL,NULVCL,,CNVTA5  E3.2.3
       PUTDC   TPTR,0,TCL          E3.2.3
       MOVDIC  YPTR,0,WPTR,2*DESCR                                      4756
       INCRA   YPTR,DESCR          Increment upper pointer              4759
       INCRA   TPTR,DESCR          Increment lower pointer              4760
CNVTA5 INCRA   WPTR,2*DESCR                                             4761
       AEQL    WCL,WPTR,CNVTA3     E3.2.3
       GETDC   WPTR,WCL,2*DESCR    E3.2.3
       IEQLC   WPTR,1,CNVTA8       E3.8.1
       SETAC   TPTR,0              E3.8.1
       RRTURN  ZPTR,3              E3.8.1
*_
CNVAT  GETDC   XCL,ZPTR,2*DESCR    Get array dimensionality             4764
       MOVD    YPTR,ZPTR           Save copy of array pointer           4765
       IEQLC   XCL,2,FAIL          Verify rectangular array
       GETDC   XCL,ZPTR,3*DESCR    Get second dimension                 4767
       VEQLC   XCL,2,FAIL          Verify extent of 2                   4768
       GETSIZ  XCL,ZPTR            Get size of array block              4769
       DECRA   XCL,2*DESCR         E3.2.3
       RCALL   XPTR,BLOCK,XCL      Allocate block for pair list         4771
       SETVC   XPTR,T              E3.2.3
       GETDC   YCL,ZPTR,4*DESCR    E3.2.3
       MOVD    ZPTR,XPTR           E3.2.3
       PUTD    XPTR,XCL,ONECL      E3.2.3
       DECRA   XCL,DESCR           E3.2.3
       MOVD    TCL,EXTVAL          E3.2.3
       INCRA   TCL,2*DESCR         E3.2.3
       PUTD    XPTR,XCL,TCL        E3.2.3
       SETAV   YCL,YCL             E3.2.3
       MULTC   YCL,YCL,DESCR       E3.2.3
       INCRA   YPTR,5*DESCR        E3.2.3
       SUM     WPTR,YPTR,YCL       E3.2.3
CNVAT2 MOVDIC  XPTR,DESCR,WPTR,0   E3.2.3
       MOVDIC  XPTR,2*DESCR,YPTR,0 E3.2.3
       DECRA   YCL,DESCR           E3.2.3
       IEQLC   YCL,0,,RTZPTR       E3.2.3
       INCRA   XPTR,2*DESCR        Increment pair list pointer          4786
       INCRA   WPTR,DESCR          Increment lower array pointer        4787
       INCRA   YPTR,DESCR          Increment upper array pointer        4788
       BRANCH  CNVAT2              Continue                             4789
*_
*---------------------------------------------------------------------*
*
*      DATE()                                                           4793
*
DATE   PROC    ,                   DATE()                               4795
       RCALL   ,ARGVAL,,FAIL       Get rid of argument                  4796
       DATE    ZSP                 Get the date                         4797
       BRANCH  GENVRZ              Go generate the variable             4798
*_
*---------------------------------------------------------------------*
*
*      DATATYPE(X)                                                      4802
*
DTLBL  PROC    ,                   DATATYPE(X)
       RCALL   A2PTR,ARGVAL,,FAIL  Get object                           4805
       MOVV    DT1CL,A2PTR         Insert data type                     4806
       LOCAPT  A3PTR,DTATL,DT1CL,DTEXTN                                 4807
*                                  Look for data type                   4808
       GETDC   A3PTR,A3PTR,2*DESCR Get data type name                   4809
DTRTN  RRTURN  A3PTR,3             Return name                          4810
*_
DTEXTN MOVD    A3PTR,EXTPTR        Set up EXTERNAL data type            4812
       BRANCH  DTRTN               Return                               4813
*_
*---------------------------------------------------------------------*
*
*      DUMP(N)                                                          4817
*
DMP    PROC    ,                   DUMP(N)                              4819
       RCALL   XPTR,INTVAL,,FAIL   Evaluate argument                    4820
       ICOMPC  XPTR,0,,RETNUL      No dump if zero
DUMP   PROC    DMP                 End game dump procedure              4822
       SETAA   WPTR,OBLIST-DESCR   Initialize bin list pointer
DMPB   ACOMP   WPTR,OBEND,RETNUL   Check for end                        4824
       INCRA   WPTR,DESCR          Increment pointer                    4825
       MOVD    YPTR,WPTR           Save working copy                    4826
DMPA   GETAC   YPTR,YPTR,LNKFLD    Get string structure                 4827
       IEQLC   YPTR,0,,DMPB        Check for end of chain
       GETDC   XPTR,YPTR,DESCR     Get value                            4829
       DEQL    XPTR,NULVCL,,DMPA   Skip null string values              4830
       SETLC   DMPSP,0             Clear specifier                      4831
       LOCSP   YSP,YPTR            Get specifier for variable           4832
       GETLG   YCL,YSP             Get length                           4833
       ACOMPC  YCL,BUFLEN,DMPOV1,DMPOV1
*                                  Check for excessive length           4835
* #### should fix this so such a large buffer not needed
       APDSP   DMPSP,YSP           Append variable                      4836
       APDSP   DMPSP,BLEQSP        Append ' = '                         4837
       VEQLC   XPTR,S,,DMPV        STRING is alright                    4838
       VEQLC   XPTR,I,,DMPI        Convert INTEGER                      4839
       RCALL   A1PTR,DTREP,XPTR    Else get representation              4840
       GETSPC  YSP,A1PTR,0         Get specifier                        4841
DMPX   GETLG   XCL,YSP             Get length                           4842
       SUM     YCL,YCL,XCL         Get total                            4843
       ACOMPC  YCL,BUFLEN,DMPOV2   Check for excessive length
       APDSP   DMPSP,YSP           Append value                         4845
       BRANCH  DMPRT               Go print it                          4846
*_
DMPV   LOCSP   YSP,XPTR            Get specifier                        4848
       GETLG   XCL,YSP             Get length                           4849
       SUM     YCL,YCL,XCL         Total length                         4850
       ACOMPC  YCL,BUFLEN,DMPOV3   Check for excessive length
       APDSP   DMPSP,QTSP          Append quote                         4852
       APDSP   DMPSP,YSP           Append value                         4853
       APDSP   DMPSP,QTSP          Append quote                         4854
DMPRT  STPRNTB IOKEY,OUTBLK,DMPSP  Print line
       BRANCH  DMPA                Continue                             4856
*_
DMPI   INTSPC  YSP,XPTR            Convert integer                      4858
       BRANCH  DMPX                Rejoin processing                    4859
*_
DMK    PROC    ,                   Procedure to dump keywords           4864
       OUTPUT  OUTPUT,PKEYF        Print unprotected keywords caption
       GETSIZ  XCL,KNLIST          Get size of pair list                4866
DMPK1  GETD    XPTR,KNLIST,XCL     Get name of keyword                  4867
       DECRA   XCL,DESCR           Adjust offset                        4868
       GETD    YPTR,KNLIST,XCL     Get value of keyword                 4869
       INTSPC  YSP,YPTR            Convert integer to string            4870
       LOCSP   XSP,XPTR            Get specifier                        4871
       SETLC   DMPSP,0             Clear specifier                      4872
       APDSP   DMPSP,AMPSP         Append ampersand                     4873
       APDSP   DMPSP,XSP           Append name                          4874
       APDSP   DMPSP,BLEQSP        Append ' = '                         4875
       APDSP   DMPSP,YSP           Append value                         4876
       STPRNTB IOKEY,OUTBLK,DMPSP  Print line
       DECRA   XCL,DESCR           Adjust offset                        4878
       IEQLC   XCL,0,DMPK1,RTN1    Check for end
* Alternate code for long prints:
DMPOV2 STPRNTB IOKEY,OUTBLK,DMPSP  Print line so far
       BRANCH  DMPPV2
DMPOV3 STPRNTB IOKEY,OUTBLK,DMPSP  Print line so far
       BRANCH  DMPPV3
DMPOV1 STPRNTB IOKEY,OUTBLK,YSP    Print pieces separately      v4.5
       STPRNTB IOKEY,OUTBLK,BLEQSP
       VEQLC   XPTR,S,,DMPV1       STRING is alright
       VEQLC   XPTR,I,,DMPI1       Convert INTEGER
       RCALL   A1PTR,DTREP,XPTR    Else get representation              4840
       GETSPC  YSP,A1PTR,0         Get specifier                        4841
DMPX1  GETLG   XCL,YSP             Get length
       SUM     YCL,YCL,XCL         Get total                            4843
DMPPV2 STPRNTB IOKEY,OUTBLK,YSP    Print value
       BRANCH  DMPRT1
*_
DMPV1  LOCSP   YSP,XPTR            Get specifier
       GETLG   XCL,YSP             Get length                           4849
       SUM     YCL,YCL,XCL         Total length                         4850
DMPPV3 STPRNTB IOKEY,OUTBLK,QTSP   Print quote
       STPRNTB IOKEY,OUTBLK,YSP    Print value
       STPRNTB IOKEY,OUTBLK,QTSP   Print quote
DMPRT1 BRANCH  DMPA                Continue
*_
DMPI1  INTSPC  YSP,XPTR            Convert integer
       BRANCH  DMPX1               Rejoin processing
*_
*---------------------------------------------------------------------*
*
*      DUPL(S,N)                                                        4883
*
DUPL   PROC    ,                   DUPL(S,N)                            4885
       RCALL   XPTR,VARVAL,,FAIL   Get string to duplicate              4886
       PUSH    XPTR                Save string                          4887
       RCALL   YPTR,INTVAL,,FAIL   Get duplication factor               4888
       POP     XPTR                Restore string                       4889
       ICOMPC  YPTR,0,,RETNUL,FAIL Return null for 0 duplications
       LOCSP   XSP,XPTR            Get specifier                        4891
       GETLG   XCL,XSP             Get length                           4892
       MULT    XCL,XCL,YPTR,AERROR E3.9.3
       ICOMP   XCL,MLENCL,INTR8    Check &MAXLNGTH
       RCALL   ZPTR,CONVAR,XCL     Allocate space for string            4895
       LOCSP   TSP,ZPTR            Get specifier                        4896
       SETLC   TSP,0               Zero length                          4897
DUPL1  APDSP   TSP,XSP             Append a copy                        4898
       DECRI   YPTR,1              Count down                           4899
       IEQLC   YPTR,0,DUPL1,GENVSZ Check for end
*_
*---------------------------------------------------------------------*
*
*      CENTER(S,L,C)
*
CENTER PROC    ,                   CENTER(S,L,C)
       RCALL   XPTR,VARVAL,,FAIL   Get 1st arg=string
       PUSH    XPTR                Save string
       RCALL   ZPTR,INTVAL,,FAIL   Get 2rd arg=integer length
       PUSH    ZPTR
       RCALL   WPTR,VARVAL,,FAIL   Get pad character if any
       POP     ZPTR
       POP     XPTR                Restore string
       LOCSP   VSP,WPTR            Pad character
       LOCSP   XSP,XPTR            Subject string
       ICOMP   ZPTR,MLENCL,INTR8   Make sure not too large
       ICOMP   ZPTR,MAXSTRS,INTR8  Max possible
       ICOMP   ZEROCL,ZPTR,LENERR  Make sure length not minus
       GETLG   YPTR,XSP            Subject string length
       ACOMP   YPTR,ZPTR,,CNTROK,CNTROK If string longer
       MOVA    ZPTR,YPTR           Increase length
CNTROK MOVA    XCL,ZPTR            Copy length (for GENVSZ)
       RCALL   ZPTR,CONVAR,XCL     Allocate space for string
       LOCSP   TSP,ZPTR            Get specifier
       CENTER  TSP,XSP,VSP         Center the string
       BRANCH  GENVSZ              Return the string
*_
*---------------------------------------------------------------------*
*
*      LPAD(S,L,C)
*
LPAD   PROC    ,                   LPAD(S,L,C)
       RCALL   XPTR,VARVAL,,FAIL   Get 1st arg=string
       PUSH    XPTR                Save string
       RCALL   ZPTR,INTVAL,,FAIL   Get 2rd arg=integer length
       PUSH    ZPTR
       RCALL   WPTR,VARVAL,,FAIL   Get pad character if any
       POP     ZPTR
       POP     XPTR                Restore string
       LOCSP   VSP,WPTR            Pad character
       LOCSP   XSP,XPTR            Subject string
       ICOMP   ZPTR,MLENCL,INTR8   Make sure not too large
       ICOMP   ZPTR,MAXSTRS,INTR8  Max possible
       ICOMP   ZEROCL,ZPTR,LENERR  Make sure length not minus
       GETLG   YPTR,XSP            Subject string length
       ACOMP   YPTR,ZPTR,,LPADOK,LPADOK If string longer
       MOVA    ZPTR,YPTR           Increase length
LPADOK MOVA    XCL,ZPTR            Copy length (for GENVSZ)
       RCALL   ZPTR,CONVAR,XCL     Allocate space for string
       LOCSP   TSP,ZPTR            Get specifier
       LPAD    TSP,XSP,VSP         Do left pad function
       BRANCH  GENVSZ              Return the string
*_
*---------------------------------------------------------------------*
*
*      Create DirEnt data type
*
*---------------------------------------------------------------------*
DIRENTDEF PROC  ,
       GETLG   XCL,DIRENTSP        Length of prototype string
       RCALL   XPTR,GNVARS,XCL     Allocate space
       LOCSP   TSP,XPTR            Get specifier to the area
       SETLC   TSP,0               Clear length
       APDSP   TSP,DIRENTSP        Move in the string
       BRANCH  EXPERIM1            Note we are not making it a variable

DIRENTRY PROC  ,
       RCALL   ZPTR,BLOCK,DIRENTTYP Allocate block for DirEnt
       GETLG   XCL,dirname
       RCALL   YPTR,CONVAR,XCL     Allocate space for text
       LOCSP   TSP,YPTR            Get specifier to the area
       SETLC   TSP,0               Clear length
       APDSP   TSP,dirname         Move in the string
       RCALL   YPTR,GNVARS,XCL     Make it a variable
       SETVC   YPTR,S              Say it is a string
       SETFI   YPTR,PTRF           Set pointer flag
       PUTDC   ZPTR,DESCR,YPTR     Put name in DirEnt

       GETLG   XCL,dirtype
       RCALL   YPTR,CONVAR,XCL     Allocate space for text
       LOCSP   TSP,YPTR            Get specifier to the area
       SETLC   TSP,0               Clear length
       APDSP   TSP,dirtype         Move in the string
       RCALL   YPTR,GNVARS,XCL     Make it a variable
       SETVC   YPTR,S              Say it is a string
       SETFI   YPTR,PTRF           Set pointer flag
       PUTDC   ZPTR,DESCR*2,YPTR   Put type into DirEnt

       GETLG   XCL,timetextcl
       RCALL   YPTR,CONVAR,XCL     Allocate space for text
       LOCSP   TSP,YPTR            Get specifier to the area
       SETLC   TSP,0               Clear length
       APDSP   TSP,timetextcl      Move in the string
       RCALL   YPTR,GNVARS,XCL     Make it a variable
       SETVC   YPTR,S              Say it is a string
       SETFI   YPTR,PTRF           Set pointer flag
       PUTDC   ZPTR,DESCR*3,YPTR   Put type into DirEnt

       PUTDC   ZPTR,DESCR*4,TEMPVAL
       PUTAC   ZPTR,DESCR*4,dirsize File size

       RRTURN  ZPTR,2              Return answer
*_
*---------------------------------------------------------------------*
*
*      bit(X)
*
BIT    PROC    ,                   bit(X)
       RCALL   YPTR,ARGVAL,,FAIL   Get object to turn into bits
       VEQLC   YPTR,I,,BITNUM      INTEGER
       VEQLC   YPTR,S,,BITSTR      STRING
       VEQLC   YPTR,R,,BITNUM      REAL
       BRANCH  FAIL                Fail for everything else
*_
BITSTR LOCSP   XSP,YPTR            Get specifier for source
       GETLG   XCL,XSP             Get length of source
       MULTC   XCL,XCL,BITSPA      Multiply by bits per byte
       ICOMP   XCL,MLENCL,INTR8    Make sure not too large
       RCALL   ZPTR,CONVAR,XCL     Allocate space for result
       LOCSP   TSP,ZPTR            Get specifier
       BITS    TSP,XSP             Expand to bits
       BRANCH  GENVSZ              Return the string ZPTR/XCL
*_
BITNUM SETVC   XCL,ALENG*BITSPA    Number of bits in A field
       SETAV   XCL,XCL             and fill in zeros in F and V
       PUSH    YPTR
       RCALL   ZPTR,CONVAR,XCL     Allocate space for result
       POP     YPTR
       LOCSP   TSP,ZPTR            Get specifier
       BITI    TSP,YPTR            Expand to bits
       BRANCH  GENVSZ              Return the string ZPTR/XCL
*_
*---------------------------------------------------------------------*
*
*      getenv(X)
*
GETENVV PROC   ,                   getenv(X)
       RCALL   XPTR,VARVAL,,FAIL   Get 1st arg=string
       LOCSP   XSP,XPTR            Get specifier for source
       GETLG   XCL,XSP             Get length of source
       ICOMP   XCL,I32KCL,INTR8    Make sure not too large >32k
       GETENV  ENVSP,XSP           Get value of environment variable
       GETLG   XCL,ENVSP           Set result length to allocate
       RCALL   ZPTR,CONVAR,XCL     Allocate space for result
       LOCSP   TSP,ZPTR            Get specifier
       SETLC   TSP,0               Set to zero so can move
       APDSP   TSP,ENVSP           Move string into TSP
       BRANCH  GENVSZ              Return the string ZPTR/XCL
*_
*---------------------------------------------------------------------*
*
*      bit2i(x) convert bit string to unsigned integer
*
B2I    PROC    ,                   bit2i(x)
       RCALL   XPTR,VARVAL,,FAIL   Get string
       LOCSP   XSP,XPTR            Get specifier for source
       GETLG   XCL,XSP             Get length of source
       ICOMPC  XCL,ALENG*BITSPA,FAIL Make sure not too large
       B2I     ZPTR,XSP            Convert bit string to Integer
       RRTURN  ZPTR,3              Return result
*_
*---------------------------------------------------------------------*
*
*      bit2r(x) convert bits to real
*
B2R    PROC    ,                   bit2r(x)
       RCALL   XPTR,VARVAL,,FAIL   Get string
       LOCSP   XSP,XPTR            Get specifier for source
       GETLG   XCL,XSP             Get length of source
       ICOMPC  XCL,ALENG*BITSPA,FAIL,,FAIL Make sure it has 64 chars
       B2R     ZPTR,XSP            Convert bit string to REAL
       RRTURN  ZPTR,3              Return result
*_
*---------------------------------------------------------------------*
*
*      bit2is(x) convert bits to integer sign extended
*
B2IS   PROC    ,                   bit2is(x)
       RCALL   XPTR,VARVAL,,FAIL   Get string
       LOCSP   XSP,XPTR            Get specifier for source
       GETLG   XCL,XSP             Get length of source
       ICOMPC  XCL,ALENG*BITSPA,FAIL Make sure not too large
       B2IS    ZPTR,XSP            Convert with sign bit propagation
       RRTURN  ZPTR,3              Return
*_
*---------------------------------------------------------------------*
*
*      bit2s(x)
*
B2S    PROC    ,                   bit2s(x)
       RCALL   XPTR,VARVAL,,FAIL   Get string
       LOCSP   XSP,XPTR            Get specifier for source
       GETLG   XCL,XSP             Get length of source
       INCRI   XCL,BITSPA-1        To round to next byte
       DIVIDE  XCL,XCL,BPACL       Divide by bits per byte
       ICOMP   XCL,MLENCL,INTR8    Make sure not too large
       RCALL   ZPTR,CONVAR,XCL     Allocate space for result
       LOCSP   TSP,ZPTR            Get specifier
       B2S     TSP,XSP             Convert bit string to string
       BRANCH  GENVSZ              Return the string ZPTR/XCL
*_
*---------------------------------------------------------------------*
*
*      endianb(x)   bit string endian shuffle
*
ENDIANB PROC    ,                  endianb(x)
       RCALL   XPTR,ARGVAL,,FAIL   Get object to endian
       VEQLC   XPTR,S,FAIL         Fail if not STRING
*_
       LOCSP   XSP,XPTR            Get specifier for source
       GETLG   XCL,XSP             Get length of source
       TESTAI  XCL,7,,FAIL         Make sure multiple of 8 bits
       ICOMP   XCL,MLENCL,INTR8    Make sure not too large
       RCALL   ZPTR,CONVAR,XCL     Allocate space for result
       LOCSP   TSP,ZPTR            Get specifier
       ENDIANB TSP,XSP             Do function
       BRANCH  GENVSZ              Return the string ZPTR/XCL
*_
*---------------------------------------------------------------------*
*
*      endianh(x)   hex digit string endian shuffle
*
ENDIANH PROC    ,                  endianh(x)
       RCALL   XPTR,ARGVAL,,FAIL   Get object to endian
       VEQLC   XPTR,S,FAIL         Fail if not STRING
*_
       LOCSP   XSP,XPTR            Get specifier for source
       GETLG   XCL,XSP             Get length of source
       TESTAI  XCL,1,,FAIL         Make sure even number of digits
       ICOMP   XCL,MLENCL,INTR8    Make sure not too large
       RCALL   ZPTR,CONVAR,XCL     Allocate space for result
       LOCSP   TSP,ZPTR            Get specifier
       ENDIANH TSP,XSP             Do function
       BRANCH  GENVSZ              Return the string ZPTR/XCL
*_
*---------------------------------------------------------------------*
*
*      bit2h(x)
*
B2H    PROC    ,                   b2h(x)
       RCALL   XPTR,VARVAL,,FAIL   Get string
       LOCSP   XSP,XPTR            Get specifier for source
       GETLG   XCL,XSP             Get length of source
       INCRI   XCL,3               To round to next hex digit
       DIVIDE  XCL,XCL,FOURCL      Divide by bits per hex digit
       RCALL   ZPTR,CONVAR,XCL     Allocate space for result
       LOCSP   TSP,ZPTR            Get specifier
       B2H     TSP,XSP             Convert bits to hex
       BRANCH  GENVSZ              Return the string ZPTR/XCL
*_
*---------------------------------------------------------------------*
*
*      hex2b(x)
*
H2B    PROC    ,                   h2b(x)
       RCALL   XPTR,VARVAL,,FAIL   Get string
       LOCSP   XSP,XPTR            Get specifier for source
       GETLG   XCL,XSP             Get length of source
       MULTC   XCL,XCL,4           Multiply by bits per hex dig
       ICOMP   XCL,MLENCL,INTR8    Make sure not too large
       RCALL   ZPTR,CONVAR,XCL     Allocate space for result
       LOCSP   TSP,ZPTR            Get specifier
       H2B     TSP,XSP             Convert hex string to bit string
       BRANCH  GENVSZ              Return the string ZPTR/XCL
*_
*---------------------------------------------------------------------*
*
*      hex2i(x) convert hwx string to unsigned integer
*
H2I    PROC    ,                   hex2i(x)
       RCALL   XPTR,VARVAL,,FAIL   Get string
       LOCSP   XSP,XPTR            Get specifier for source
       GETLG   XCL,XSP             Get length of source
       ICOMPC  XCL,ALENG*2,FAIL    Make sure not too large
       H2I     ZPTR,XSP            Convert hex string to Integer
       RRTURN  ZPTR,3              Return result
*_
*---------------------------------------------------------------------*
*
*      hex2is(x) convert hex digits to integer sign extended
*
H2IS   PROC    ,                   hex2is(x)
       RCALL   XPTR,VARVAL,,FAIL   Get string
       LOCSP   XSP,XPTR            Get specifier for source
       GETLG   XCL,XSP             Get length of source
       ICOMPC  XCL,ALENG*2,FAIL    Make sure not too large
       H2IS    ZPTR,XSP            Convert with sign bit propagation
       RRTURN  ZPTR,3              Return
*_
*---------------------------------------------------------------------*
*
*      hex2r(x) convert 16 (double float) hex digits to real
*
H2R    PROC    ,                   hex2r(x)
       RCALL   XPTR,VARVAL,,FAIL   Get string
       LOCSP   XSP,XPTR            Get specifier for source
       GETLG   XCL,XSP             Get length of source
       ICOMPC  XCL,16,FAIL,,FAIL   Make sure it has 16 hex digits
       H2R     ZPTR,XSP            Convert hex string to REAL
       RRTURN  ZPTR,3              Return result
*_
*---------------------------------------------------------------------*
*
*      hexs2r(x) convert 8 (single float) hex digits to real
*
HS2R   PROC    ,                   hexs2r(x)
       RCALL   XPTR,VARVAL,,FAIL   Get string
       LOCSP   XSP,XPTR            Get specifier for source
       GETLG   XCL,XSP             Get length of source
       ICOMPC  XCL,8,FAIL,,FAIL    Make sure it has 8 hex digits
       HS2R    ZPTR,XSP            Convert hex string to REAL
       RRTURN  ZPTR,3              Return result
*_
*_
*---------------------------------------------------------------------*
*
*      hexx2r(x) convert 20 (extended float) hex digits to real
*
HX2R   PROC    ,                   hexx2r(x)
       RCALL   XPTR,VARVAL,,FAIL   Get string
       LOCSP   XSP,XPTR            Get specifier for source
       GETLG   XCL,XSP             Get length of source
       ICOMPC  XCL,20,FAIL,,FAIL   Make sure it has 20 hex digits
       HX2R    ZPTR,XSP            Convert hex string to REAL
       RRTURN  ZPTR,3              Return result
*_
*---------------------------------------------------------------------*
*
*      hex2s(x)
*
H2S    PROC    ,                   h2s(x)
       RCALL   XPTR,VARVAL,,FAIL   Get string
       LOCSP   XSP,XPTR            Get specifier for source
       GETLG   XCL,XSP             Get length of source
       INCRA   XCL,1               Add one
       DIVIDE  XCL,XCL,ITWOCL      Divide by 2
       ICOMP   XCL,MLENCL,INTR8    Make sure not too large
       RCALL   ZPTR,CONVAR,XCL     Allocate space for result
       LOCSP   TSP,ZPTR            Get specifier
       H2S     TSP,XSP             Convert hex string to character string
       BRANCH  GENVSZ              Return the string ZPTR/XCL
*_
*---------------------------------------------------------------------*
*
*      hex(X)
*
HEX    PROC    ,                   hex(X)
       RCALL   YPTR,ARGVAL,,FAIL   Get object to turn into hex digits
       VEQLC   YPTR,I,,HEXNUM      INTEGER
       VEQLC   YPTR,S,,HEXSTR      STRING
       VEQLC   YPTR,R,,HEXNUM      REAL
       BRANCH  FAIL                Fail for everything else
*_
HEXSTR LOCSP   XSP,YPTR            Get specifier for source
       GETLG   XCL,XSP             Get length of source
       MULTC   XCL,XCL,BITSPA/4    Multiply by hex digits per byte
       ICOMP   XCL,MLENCL,INTR8    Make sure not too large
       RCALL   ZPTR,CONVAR,XCL     Allocate space for result
       LOCSP   TSP,ZPTR            Get specifier
       HEXS    TSP,XSP             Expand to hex digits
       BRANCH  GENVSZ              Return the string ZPTR/XCL
*_
HEXNUM SETVC   XCL,ALENG*BITSPA/4  Number of hex digits in A field
       SETAV   XCL,XCL             and fill in zeros in F and V
       PUSH    YPTR
       RCALL   ZPTR,CONVAR,XCL     Allocate space for result
       POP     YPTR
       LOCSP   TSP,ZPTR            Get specifier
       HEXI    TSP,YPTR            Expand to hex digits
       BRANCH  GENVSZ              Return the string ZPTR/XCL
*_
*---------------------------------------------------------------------*
*
*      r2hexs(X) Convert Double Precision REAL to Single Precision hex
*
R2HS   PROC    ,                   r2hexs(X)
       RCALL   YPTR,ARGVAL,,FAIL   Get REAL to turn into hex digits
       VEQLC   YPTR,R,FAIL         REAL?
       SETVC   XCL,8               Number of hex digits in A field
       SETAV   XCL,XCL             and fill in zeros in F and V
       PUSH    YPTR
       RCALL   ZPTR,CONVAR,XCL     Allocate space for result
       POP     YPTR
       LOCSP   TSP,ZPTR            Get specifier
       R2HS    TSP,YPTR            Expand to hex digits
       BRANCH  GENVSZ              Return the string ZPTR/XCL
*_
*---------------------------------------------------------------------*
*
*      r2hexx(X) Convert Double Precision to Extended Prrecision hex
*
R2HX   PROC    ,                   r2hexx(X)
       RCALL   YPTR,ARGVAL,,FAIL   Get REAL to turn into hex digits
       VEQLC   YPTR,R,FAIL         REAL?
       SETVC   XCL,20              Number of hex digits in A field
       SETAV   XCL,XCL             and fill in zeros in F and V
       PUSH    YPTR
       RCALL   ZPTR,CONVAR,XCL     Allocate space for result
       POP     YPTR
       LOCSP   TSP,ZPTR            Get specifier
       R2HX    TSP,YPTR            Expand to hex digits
       BRANCH  GENVSZ              Return the string ZPTR/XCL
*_
*---------------------------------------------------------------------*
*
*      NAND(x,y)
*
NANDFUNC PROC   ,
       RCALL   XPTR,VARVAL,,FAIL   Get first argument
       PUSH    XPTR                Save first argument
       RCALL   YPTR,VARVAL,,FAIL   Get second argument
       POP     XPTR                Restore first
       LOCSP   YSP,YPTR            Get specifier for second
       LOCSP   XSP,XPTR            Get specifier for first
       GETLG   XCL,XSP             Get length
       GETLG   YCL,YSP             Get length
       ICOMP   XCL,YCL,NANDFUNCX   Jump if first is longer
       MOVA    XCL,YCL             Set max of two lengths
NANDFUNCX RCALL ZPTR,CONVAR,XCL    Allocate space for result
       LOCSP   TSP,ZPTR            Get specifier
       NANDFUN TSP,XSP,YSP         Perform logical NAND function
       BRANCH  GENVSZ              Got generate variable
*_
*---------------------------------------------------------------------*
*
*      NOR(x,y)
*
NORFUNC PROC   ,
       RCALL   XPTR,VARVAL,,FAIL   Get first argument
       PUSH    XPTR                Save first argument
       RCALL   YPTR,VARVAL,,FAIL   Get second argument
       POP     XPTR                Restore first
       LOCSP   YSP,YPTR            Get specifier for second
       LOCSP   XSP,XPTR            Get specifier for first
       GETLG   XCL,XSP             Get length
       GETLG   YCL,YSP             Get length
       ICOMP   XCL,YCL,NORFUNCX    Jump if first is longer
       MOVA    XCL,YCL             Set max of two lengths
NORFUNCX RCALL ZPTR,CONVAR,XCL     Allocate space for result
       LOCSP   TSP,ZPTR            Get specifier
       NORFUN  TSP,XSP,YSP         Perform logical NOR function
       BRANCH  GENVSZ              Got generate variable
*_
*---------------------------------------------------------------------*
*
*      NOT(x)
*
NOTFUNC PROC   ,
       RCALL   XPTR,VARVAL,,FAIL   Get first argument
       IEQLC   XPTR,0,,RTXPTR      Ignore replacement on null
       LOCSP   XSP,XPTR            Get specifier for first
       GETLG   XCL,XSP             Get length
       RCALL   ZPTR,CONVAR,XCL     Allocate space for result
       LOCSP   TSP,ZPTR            Get specifier
       NOTFUN  TSP,XSP             Perform logical NOT function
       BRANCH  GENVSZ              Got generate variable
*_
*---------------------------------------------------------------------*
*
*      LOB(x)
*
LOBFUNC PROC   ,
       RCALL   XPTR,VARVAL,,FAIL   Get first argument
       IEQLC   XPTR,0,,RTXPTR      Ignore replacement on null
       LOCSP   XSP,XPTR            Get specifier for first
       GETLG   XCL,XSP             Get length
       RCALL   ZPTR,CONVAR,XCL     Allocate space for result
       LOCSP   TSP,ZPTR            Get specifier
       LOBFUN  TSP,XSP             Change low order bits to 0 or 1 chars
       BRANCH  GENVSZ              Got generate variable
*_
*---------------------------------------------------------------------*
*
*      OPSYN(F\,F\,N)                                                   4904
*
OPSYN  PROC    ,                   OPSYN(F,G,N)                         4906
       RCALL   XPTR,VARVAL,,FAIL   Get object function                  4907
       PUSH    XPTR                Save object function                 4908
       RCALL   YPTR,VARVAL,,FAIL   Get image function                   4909
       PUSH    YPTR                Save image function                  4910
       RCALL   ZPTR,INTVAL,,FAIL   Get type indicator                   4911
       POP     (YPTR,XPTR)         Restore image and object functions   4912
       IEQLC   XPTR,0,,NONAME      Object may not be null
       IEQLC   ZPTR,1,,UNYOP       Check for unary definition
       IEQLC   ZPTR,2,,BNYOP       Check for binary definition
       IEQLC   ZPTR,0,INTR30       Check for function definition
       RCALL   XPTR,FINDEX,XPTR    Get function descriptor for object   4917
UNBF   RCALL   YPTR,FINDEX,YPTR    E3.6.2
OPPD   MOVDIC  XPTR,0,YPTR,0       Move procedure descriptor pair       4921
       MOVDIC  XPTR,DESCR,YPTR,DESCR                                    4922
       RRTURN  NULVCL,3            Return null string by exit 3
*_
UNYOP  LOCSP   XSP,XPTR            Get specifier for image              4925
       LEQLC   XSP,1,UNAF          Length must be 1 for operator        4926
       SETSP   ZSP,PROTSP          E3.5.3
       SETLC   ZSP,0               E3.5.3
       APDSP   ZSP,XSP             E3.5.3
       APDSP   ZSP,LPRNSP          E3.5.3
       STREAM  TSP,ZSP,UNOPTB,UNAF,UNAF E3.5.3
       MOVD    XPTR,STYPE          STYPE has function descriptor        4931
UNCF   LOCSP   YSP,YPTR            Get specifier for image              4932
       LEQLC   YSP,1,UNBF          Length must be 1 for operator        4933
       SETSP   ZSP,PROTSP          E3.5.3
       SETLC   ZSP,0               E3.5.3
       APDSP   ZSP,YSP             E3.5.3
       APDSP   ZSP,LPRNSP          E3.5.3
       STREAM  TSP,ZSP,UNOPTB,UNBF,UNBF E3.5.3
       MOVD    YPTR,STYPE          STYPE has function descriptor        4938
       BRANCH  OPPD                Join to copy descriptors             4939
*_
UNAF   RCALL   XPTR,FINDEX,XPTR    Find definition of image             4941
       BRANCH  UNCF                Join search for object               4942
*_
BNYOP  LOCSP   XSP,XPTR            Get specifier for image              4944
       LCOMP   XSP,EQLSP,BNAF      Length must be 2 or less             4945
       SETSP   ZSP,PROTSP          E3.5.3
       SETLC   ZSP,0               E3.5.3
       APDSP   ZSP,XSP             E3.5.3
       APDSP   ZSP,BLSP            E3.5.3
       STREAM  TSP,ZSP,BIOPTB,BNAF,BNAF E3.5.3
       LEQLC   ZSP,0,BNAF          E3.5.3
       MOVD    XPTR,STYPE          STYPE has function descriptor        4951
BNCF   LOCSP   YSP,YPTR            Get specifier for object             4952
       LCOMP   YSP,EQLSP,BNBF      Length must be 2 or less             4953
       SETSP   ZSP,PROTSP          E3.5.3
       SETLC   ZSP,0               E3.5.3
       APDSP   ZSP,YSP             E3.5.3
       APDSP   ZSP,BLSP            E3.5.3
       STREAM  TSP,ZSP,BIOPTB,BNBF,BNBF E3.5.3
       LEQLC   ZSP,0,BNBF          E3.5.3
       MOVD    YPTR,STYPE          STYPE has function descriptor        4959
       BRANCH  OPPD                Join to copy descriptors             4960
*_
BNAF   LEXCMP  XSP,BLSP,,BNCN      Check for concatenation              4962
       RCALL   XPTR,FINDEX,XPTR    Find definition of image             4963
       BRANCH  BNCF                Join search for object               4964
*_
BNCN   MOVD    XPTR,CONCL          CONCL represents concatenation       4966
       BRANCH  BNCF                Join search for object               4967
*_
BNBF   LEXCMP  YSP,BLSP,UNBF,,UNBF Check for concatenation              4969
       MOVD    YPTR,CONCL          CONCL represents concatenation       4970
       BRANCH  OPPD                Join to copy descriptors             4971
*_
*---------------------------------------------------------------------*
*
*      OR(x,y)
*
ORFUNC PROC   ,
       RCALL   XPTR,VARVAL,,FAIL   Get first argument
       PUSH    XPTR                Save first argument
       RCALL   YPTR,VARVAL,,FAIL   Get second argument
       POP     XPTR                Restore first
       LOCSP   YSP,YPTR            Get specifier for second
       LOCSP   XSP,XPTR            Get specifier for first
       GETLG   XCL,XSP             Get length
       GETLG   YCL,YSP             Get length
       ICOMP   XCL,YCL,ORFUNCX     Jump if first is longer
       MOVA    XCL,YCL             Set max of two lengths
ORFUNCX RCALL  ZPTR,CONVAR,XCL     Allocate space for result
       LOCSP   TSP,ZPTR            Get specifier
       ORFUN   TSP,XSP,YSP         Perform logical OR function
       BRANCH  GENVSZ              Got generate variable
*_
*---------------------------------------------------------------------*
*
*      REVERSE(S)
*
REVERS PROC    ,                   REVERSE(S)
       RCALL   XPTR,VARVAL,,FAIL   Get 1st arg=string
       LOCSP   XSP,XPTR            Source string
       GETLG   ZPTR,XSP            Source string length
       ACOMPC  ZPTR,0,,RETNUL      Check for null string
       MOVA    XCL,ZPTR            Copy length (for GENVSZ)
       RCALL   ZPTR,CONVAR,XCL     Allocate space for string
       LOCSP   TSP,ZPTR            Get specifier
       REVERSE TSP,XSP             Reverse the string
       BRANCH  GENVSZ              Return the string
*_
*---------------------------------------------------------------------*
*
*      RPAD(S,L,C)
*
RPAD   PROC    ,                   RPAD(S,L,C)
       RCALL   XPTR,VARVAL,,FAIL   Get 1st arg=string
       PUSH    XPTR                Save string
       RCALL   ZPTR,INTVAL,,FAIL   Get 2rd arg=integer length
       PUSH    ZPTR
       RCALL   WPTR,VARVAL,,FAIL   Get pad character if any
       POP     ZPTR
       POP     XPTR                Restore string
       LOCSP   VSP,WPTR            Pad character
       LOCSP   XSP,XPTR            Source string
       ICOMP   ZPTR,MLENCL,INTR8   Make sure not too large
       ICOMP   ZPTR,MAXSTRS,INTR8  Max possible
       ICOMP   ZEROCL,ZPTR,LENERR  Make sure length not minus
       GETLG   YPTR,XSP            Source string length
       ACOMP   YPTR,ZPTR,,RPADOK,RPADOK If string longer
       MOVA    ZPTR,YPTR           Increase length
RPADOK MOVA    XCL,ZPTR            Copy length (for GENVSZ)
       RCALL   ZPTR,CONVAR,XCL     Allocate space for string
       LOCSP   TSP,ZPTR            Get specifier
       RPAD    TSP,XSP,VSP         Do RPAD function
       BRANCH  GENVSZ              Return the string
*_
*---------------------------------------------------------------------*
*
*      REPLACE(S\,S\,S\)                                                4975
*
RPLACE PROC    ,                   REPLACE(S\,S\,S\)                    4977
       RCALL   XPTR,VARVAL,,FAIL   Get first argument                   4978
       PUSH    XPTR                Save first argument                  4979
       RCALL   YPTR,VARVAL,,FAIL   Get second argument                  4980
       PUSH    YPTR                Save second argument                 4981
       RCALL   ZPTR,VARVAL,,FAIL   Get third argument                   4982
       POP     (YPTR,XPTR)         Restore first and second             4983
       IEQLC   XPTR,0,,RTXPTR      Ignore replacement on null
       LOCSP   YSP,YPTR            Get specifier for second             4985
       LOCSP   ZSP,ZPTR            Get specifier for third              4986
       LCOMP   ZSP,YSP,FAIL,,FAIL  Verify same lengths                  4987
       IEQLC   YPTR,0,,FAIL        Ignore null replacement
       LOCSP   XSP,XPTR            Get specifier for first              4989
       GETLG   XCL,XSP             Get length                           4990
       RCALL   ZPTR,CONVAR,XCL     Allocate space for result            4991
       LOCSP   TSP,ZPTR            Get specifier                        4992
       SETLC   TSP,0               Clear specifier                      4993
       APDSP   TSP,XSP             Append first argument                4994
       RPLACE  TSP,YSP,ZSP         Perform replacement                  4995
       BRANCH  GENVSZ              Got generate variable                4996
*_
*---------------------------------------------------------------------*
*
*      SAVE(Filename)
*
SAV    PROC    ,
       RCALL   XPTR,VARVAL,,FAIL   Get 1st arg=string
       PUSH    XPTR
       MOVD    ARG1CL,ZEROCL
       RCALL   ,GC,(ARG1CL)        Garbage collect
       POP     XPTR
       LOCSP   XSP,XPTR            Source string
* Clear unused stack area
       FUNC    SAVE,XSP,FAIL       Checkpoint the workspace
       RRTURN  NULVCL,3            Return null string by exit 3
REENT  MSTIME  ETMCL               Reset execution time
       MOVA    TIMECL,ZEROCL       Zero compilation time
       MOVA    EXNOCL,ZEROCL       Reset statement execution count
       MOVA    FALCL,ZEROCL        Reset statement failure count
       MOVA    ARTHCL,ZEROCL       Reset arith op count
       MOVA    SCNCL,ZEROCL        Reset pattern match count
       MOVA    GCNO,ZEROCL         Reset GC count
       MOVA    RSTAT,ZEROCL        Reset read count
       MOVA    WSTAT,ZEROCL        Reset write count
       TRAPCK  ,                   Start interrupt trap
* Do other things that need reseting on restart, &PARM, ...?
       SETAA   XPTR,PARMSP         Specifier for &PARM
       RCALL   PARMVL,GENVAR,(XPTR) Convert to string structure
       MOVD    ZPTR,IONECL
       RRTURN  ZPTR,3              Return integer one
*_
*---------------------------------------------------------------------*
*
*      SEEK(UNIT,POS,TYPE)
*
SEEK   PROC    ,                   SEEK(UNIT,POS,TYPE)
       RCALL   YPTR,INTVAL,,FAIL   Get 1st arg=unit number
       ICOMPC  YPTR,0,,UNTERR,UNTERR
       ICOMPC  YPTR,MXUNIT,UNTERR  Make sure not too high
       PUSH    YPTR
       RCALL   XPTR,INTVAL,,FAIL   Get 2nd arg=integer offset
       PUSH    XPTR
       RCALL   ZPTR,INTVAL,,FAIL   Get 3rd arg=type of seek
       POP     XPTR
       POP     YPTR
       SETVC   WPTR,I              Insert INTEGER data type
       SEEK    YPTR,XPTR,ZPTR,WPTR,FAIL,RTWPTR Seek
*_
*---------------------------------------------------------------------*
*
*      SLEEP(t)
*
SLEEPF PROC    ,                   SLEEP(t)
       RCALL   XPTR,INTVAL,,FAIL   Get 1st arg=string
       ICOMP   ZEROCL,XPTR,FAIL    Make sure length not minus
       SLEEP   XPTR                Do sleep function
       BRANCH  RETNUL              Return a null
*_
*---------------------------------------------------------------------*
*
*      bytes2i(s) converts bytes to integer
*
BY2I   PROC    ,                   bytes2i(s)
       RCALL   XPTR,VARVAL,,FAIL   Get 1st arg=string
       LOCSP   XSP,XPTR            Get specifier for source
       GETLG   XCL,XSP             Get length of source
       ICOMPC  XCL,ALENG,FAIL      Make sure not too large
       BY2I    ZPTR,XSP
       RRTURN  ZPTR,3              Return

BY2IS  PROC    ,                   bytes2is(s)
       RCALL   XPTR,VARVAL,,FAIL   Get 1st arg=string
       LOCSP   XSP,XPTR            Get specifier for source
       GETLG   XCL,XSP             Get length of source
       ICOMPC  XCL,ALENG,FAIL      Make sure not too large
       BY2IS   ZPTR,XSP
       RRTURN  ZPTR,3              Return

BY2R   PROC    ,                   bytes2r(s)
       RCALL   XPTR,VARVAL,,FAIL   Get 1st arg=string
       LOCSP   XSP,XPTR            Get specifier for source
       GETLG   XCL,XSP             Get length of source
       ICOMPC  XCL,ALENG,FAIL,,FAIL Make sure it is correct length
       BY2R    ZPTR,XSP
       RRTURN  ZPTR,3              Return

BYS2R  PROC    ,                   bytess2r(s)
       RCALL   XPTR,VARVAL,,FAIL   Get 1st arg=string
       LOCSP   XSP,XPTR            Get specifier for source
       GETLG   XCL,XSP             Get length of source
       ICOMPC  XCL,4,FAIL          Make sure not too large
       BYS2R   ZPTR,XSP
       RRTURN  ZPTR,3              Return
BYX2R  PROC    ,                   bytesx2r(s)
       RCALL   XPTR,VARVAL,,FAIL   Get 1st arg=string
       LOCSP   XSP,XPTR            Get specifier for source
       GETLG   XCL,XSP             Get length of source
       ICOMPC  XCL,10,FAIL         Make sure not too large
       BYX2R   ZPTR,XSP
       RRTURN  ZPTR,3              Return

R2BY   PROC    ,                   r2bytes(r)
       RCALL   YPTR,REALVAL,,FAIL  Get argument as real number
       VEQLC   YPTR,R,FAIL         REAL?
       SETVC   XCL,8               Number of bytes
       SETAV   XCL,XCL             and fill in zeros in F and V
       PUSH    YPTR
       RCALL   ZPTR,CONVAR,XCL     Allocate space for result
       POP     YPTR
       LOCSP   TSP,ZPTR            Get specifier
       R2BY    TSP,YPTR            Expand to bytes
       BRANCH  GENVSZ              Return the string ZPTR/XCL

R2BYS  PROC    ,                   r2bytess(r)
       RCALL   YPTR,REALVAL,,FAIL  Get argument as real number
       VEQLC   YPTR,R,FAIL         REAL?
       SETVC   XCL,4               Number of bytes
       SETAV   XCL,XCL             and fill in zeros in F and V
       PUSH    YPTR
       RCALL   ZPTR,CONVAR,XCL     Allocate space for result
       POP     YPTR
       LOCSP   TSP,ZPTR            Get specifier
       R2BYS   TSP,YPTR            Expand to bytes
       BRANCH  GENVSZ              Return the string ZPTR/XCL

R2BYX  PROC    ,                   r2bytesx(r)
       RCALL   YPTR,REALVAL,,FAIL  Get argument as real number
       VEQLC   YPTR,R,FAIL         REAL?
       SETVC   XCL,10              Number of bytes
       SETAV   XCL,XCL             and fill in zeros in F and V
       PUSH    YPTR
       RCALL   ZPTR,CONVAR,XCL     Allocate space for result
       POP     YPTR
       LOCSP   TSP,ZPTR            Get specifier
       R2BYX   TSP,YPTR            Expand to bytes
       BRANCH  GENVSZ              Return the string ZPTR/XCL

I2BY   PROC    ,                   i2bytes(i)
       RCALL   YPTR,INTVAL,,FAIL   Get argument as integer
       VEQLC   YPTR,I,FAIL         REAL?
       SETVC   XCL,8               Number of bytes
       SETAV   XCL,XCL             and fill in zeros in F and V
       PUSH    YPTR
       RCALL   ZPTR,CONVAR,XCL     Allocate space for result
       POP     YPTR
       LOCSP   TSP,ZPTR            Get specifier
       I2BY    TSP,YPTR            Expand to bytes
       BRANCH  GENVSZ              Return the string ZPTR/XCL
*_
*---------------------------------------------------------------------*
*
*      atan(x) returns radians
*
ATANRAD PROC    ,                  atan(x)
       RCALL   XPTR,REALVAL,,FAIL  Get argument as real number
       ATAN    YPTR,XPTR           arctangent function in radians
       RRTURN  YPTR,3              Return answer
*_
*---------------------------------------------------------------------*
*
*      atan2(y,x) returns radians
*
ATAN2RAD PROC    ,                 atan2(y,x)
       RCALL   ZPTR,REALVAL,,FAIL  Get argument as real number
       PUSH    ZPTR
       RCALL   XPTR,REALVAL,,FAIL  Get argument as real number
       POP     ZPTR
       ATAN2   YPTR,ZPTR,XPTR      arctangent function in radians
       RRTURN  YPTR,3              Return answer
*_
*---------------------------------------------------------------------*
*
*      sin(x) with x in radians
*
SINRAD PROC    ,                   sin(x)
       RCALL   XPTR,REALVAL,,FAIL  Get argument as real number
       SIN     YPTR,XPTR    sine function in radians
       RRTURN  YPTR,3              Return answer
*_
*---------------------------------------------------------------------*
*
*      cos(x) with x in radians
*
COSRAD PROC    ,                   cos(x)
       RCALL   XPTR,REALVAL,,FAIL  Get argument as real number
       COS     YPTR,XPTR           cosine function in radians
       RRTURN  YPTR,3              Return answer
*_
*---------------------------------------------------------------------*
*
*      LOG(x)                      LOG to the base e
*
LOG    PROC    ,                   LOG(x)
       RCALL   XPTR,REALVAL,,FAIL  Get argument as real number
       LOG     YPTR,XPTR           Natural Logarithm
       RRTURN  YPTR,3              Return answer
*_
*---------------------------------------------------------------------*
*
*      LOG2(x)                     LOG to the base 2
*
LOG2   PROC    ,                   LOG2(x)
       RCALL   XPTR,REALVAL,,FAIL  Get argument as real number
       LOG2    YPTR,XPTR           Base 2 Logarithm
       RRTURN  YPTR,3              Return answer
*_
*---------------------------------------------------------------------*
*
*      LOG10(x)                    LOG to the base 10
*
LOG10  PROC    ,                   LOG10(x)
       RCALL   XPTR,REALVAL,,FAIL  Get argument as real number
       LOG10   YPTR,XPTR           Base 10 Logarithm
       RRTURN  YPTR,3              Return answer
*_
*---------------------------------------------------------------------*
*
*      IO_FINDUNIT()               Find unused unit number
*
FINDUNIT PROC                      IO_FINDUNIT()
       FINDUNIT YPTR,,FAIL         Find free unit or fail
       RRTURN  YPTR,3              Return integer answer
*_
*---------------------------------------------------------------------*
*
*      SQRT(x)                     Square root
*
SQRT   PROC    ,                   SQRT(x)
       RCALL   XPTR,REALVAL,,FAIL  Get argument as real number
       SQRT    YPTR,XPTR           Square root function
       RRTURN  YPTR,3              Return answer
*_
*---------------------------------------------------------------------*
*
*      tan(x) with x in radians
*
TANRAD PROC    ,                   tan(x)
       RCALL   XPTR,REALVAL,,FAIL  Get argument as real number
       TAN     YPTR,XPTR           tangent function in radians
       RRTURN  YPTR,3              Return answer
*_
*---------------------------------------------------------------------*
*
*      rand()  random number generator
*
RANDOM PROC    ,                   rand(seed)
       RCALL   ZPTR,INTVAL,,FAIL   Get argument as integer
       RANDOM  YPTR,ZPTR
       RRTURN  YPTR,3              Return integer answer
*_
*---------------------------------------------------------------------*
*
*      SIZE(S)                                                          5000
*
SIZELBL PROC    ,                  SIZE(S)
       RCALL   XPTR,VARVAL,,FAIL   Get argument                         5003
       LOCSP   XSP,XPTR            Get specifier                        5004
       GETLG   ZPTR,XSP            Get length                           5005
       SETVC   ZPTR,I              Insert INTEGER data type             5006
       RRTURN  ZPTR,3              Return length
*_
*---------------------------------------------------------------------*
*
*      SORT(ARRAY,STYPE)
*
SORT   PROC    ,
       RCALL   ZPTR,ARGVAL,,FAIL   Get 1st arg=array
       PUSH    ZPTR
       RCALL   XPTR,INTVAL,,FAIL   Get 2nd arg=sort type
       POP     ZPTR
       VEQLC   ZPTR,A,INTR1        Only arrays can be sorted
       SORT    ZPTR,XPTR,FAIL      Sort
       RRTURN  ZPTR,3              Return sorted array
*_
*---------------------------------------------------------------------*
*
*      CHAR(n)                     CHAR(n) = SUBSTR(&ALPHABET,n,1)
*
CHARF  PROC    ,                   CHAR(n)
       RCALL   YPTR,INTVAL,,FAIL   Get argument as integer
       ICOMPC  YPTR,0,,,LENERR     Negative argument not allowed
       ICOMPC  YPTR,255,INTR30     Number greater than 255 not allowed
       SETSP   XSP,ALPHSP          Source string
       SETAC   ZPTR,1              Length is 1
       MOVA    XCL,ZPTR            Copy length (for GENVSZ)
       RCALL   ZPTR,CONVAR,XCL     Allocate space for string
       LOCSP   TSP,ZPTR            Get specifier
       SUBSTR  TSP,XSP,YPTR        Do function
       BRANCH  GENVSZ              Return the string
*_
*---------------------------------------------------------------------*
*
*      SUBSTR(S,O,L)
*
SUBSTRL PROC    ,                  SUBSTR(S,P,L)
       RCALL   XPTR,VARVAL,,FAIL   Get 1st arg=string
       PUSH    XPTR                Save string
       RCALL   YPTR,INTVAL,,FAIL   Get 2nd arg=integer position
       PUSH    YPTR                Save position
       RCALL   ZPTR,INTVAL,,FAIL   Get 3rd arg=integer length
       ICOMPC  ZPTR,0,,,LENERR     Is L negative?
*      SETAC   ZPTR,0              Don't allow negative length
SSZOK  POP     YPTR                Restore position
       POP     XPTR                Restore string
       ICOMPC  YPTR,0,,,LENERR     Make sure offset is >=0
       LOCSP   XSP,XPTR            Source string
       GETLG   WPTR,XSP            Source string length
       SUBTRT  WPTR,WPTR,YPTR      To see if substring too big
       ICOMP   ZPTR,WPTR,,SSLNOK,SSLNOK If substr too long
       MOVA    ZPTR,WPTR           Restrict length
SSLNOK ICOMPC  ZPTR,0,SSNOFX,SSNOFX See what length wanted
       MOVA    ZPTR,WPTR           Remaining length if negative
SSNOFX ICOMPC  ZPTR,0,,RETNUL,RETNUL NuLL string?
       MOVA    XCL,ZPTR            Copy length (for GENVSZ)
       RCALL   ZPTR,CONVAR,XCL     Allocate space for string
       LOCSP   TSP,ZPTR            Get specifier
       SUBSTR  TSP,XSP,YPTR        Do substring function
       BRANCH  GENVSZ              Return the string
*_
*---------------------------------------------------------------------*
*
*      SYSTEM(S)
*          S: is system command
*
SYSTEM PROC    ,                   SYSTEM(S)
       RCALL   XPTR,VARVAL,,FAIL   Get 1st arg=string
       LOCSP   TSP,XPTR            Get specifier
       SYSTEM  TSP                 Do system function
       RRTURN  NULVCL,3            Return null string by exit 3
*_
*---------------------------------------------------------------------*
*
*      TIME()                                                           5011
*
TIME   PROC    ,                   TIME()                               5013
       RCALL   ,ARGVAL,,FAIL       Get rid of argument                  5014
       MSTIME  ZPTR                Get elapsed time                     5015
       SUBTRT  ZPTR,ZPTR,ETMCL     Compute time in interpreter          5016
       SETVC   ZPTR,I              Insert INTEGER data type             5017
       RRTURN  ZPTR,3              Return time
*_
*---------------------------------------------------------------------*
*
*      TRIM(S,C,L)
*
TRIM   PROC    ,                   TRIM(S,C,L)                          5024
       RCALL   XPTR,VARVAL,,FAIL   Get string                           5025
       PUSH    XPTR
       RCALL   YPTR,VARVAL,,FAIL   Get trim characters if any
       PUSH    YPTR
       RCALL   WPTR,INTVAL,,FAIL   Get 3rd arg=min length
       POP     YPTR
       POP     XPTR                                                     3969
       LOCSP   YSP,YPTR            Get specifier                        4092
       LOCSP   ZSP,XPTR            Get specifier                        5026
       TRIMSP  ZSP,YSP,WPTR        Trim string
       BRANCH  GENVRZ              Generate new variable                5028
*_
*---------------------------------------------------------------------*
*
*      XOR(x,y)
*
XORFUNC PROC   ,
       RCALL   XPTR,VARVAL,,FAIL   Get first argument
       PUSH    XPTR                Save first argument
       RCALL   YPTR,VARVAL,,FAIL   Get second argument
       POP     XPTR                Restore first
       LOCSP   YSP,YPTR            Get specifier for second
       LOCSP   XSP,XPTR            Get specifier for first
       GETLG   XCL,XSP             Get length
       GETLG   YCL,YSP             Get length
       ICOMP   XCL,YCL,XORFUNCX    Jump if first is longer
       MOVA    XCL,YCL             Set max of two lengths
XORFUNCX RCALL ZPTR,CONVAR,XCL     Allocate space for result
       LOCSP   TSP,ZPTR            Get specifier
       XORFUN  TSP,XSP,YSP         Perform logical XOR function
       BRANCH  GENVSZ              Got generate variable
*_
*---------------------------------------------------------------------*
       TITLE   'Common Code'                                            5031
*######DATA   LHERE   ,
RT1NUL RRTURN  NULVCL,1            Return null string by exit 1         5033
*_
RTN1   LHERE   ,                                                        5035
FAIL   RRTURN  ,1                  Return by exit 1                     5036
*_
RETNUL RRTURN  NULVCL,3            Return null string by exit 3         5038
*_
RTN2   RRTURN  ,2                  Return by exit 2                     5040
*_
RTN3   LHERE   ,                                                        5042
RTNUL3 RRTURN  ,3                  Return by exit 3                     5043
RTNUL4 RRTURN  ,4                  Return by exit 4
RTNUL5 RRTURN  ,5                  Return by exit 5
RTNUL6 RRTURN  ,6                  Return by exit 6
*_
RTXNAM RRTURN  XPTR,2              Return XPTR by exit 2                5045
*_
RTXPTR RRTURN  XPTR,3              Return XPTR by exit 3                5047
*_
RTYPTR RRTURN  YPTR,3              Return YPTR by exit 3                5049
*
RTWPTR RRTURN  WPTR,3              Return WPTR by exit 3
*_
ARTN   INCRI   ARTHCL,1            Increment count of arithmetic        5051
RTZPTR RRTURN  ZPTR,3              Return ZPTR by exit 3                5052
*_
A5RTN  RRTURN  A5PTR,1             Return A5PTR by exit 1               5054
*_
TSALF  BRANCH  SALF,SCNR           Branch to SALF in scanner            5056
*_
TSALT  BRANCH  SALT,SCNR           Branch to SALT in scanner            5058
*_
TSCOK  BRANCH  SCOK,SCNR           Branch to SCOK in scanner            5060
*_
GENVSZ RCALL   ZPTR,GNVARS,XCL,RTZPTR                                   5062
*                                  Generate variable from storage       5063
*_
GENVRZ RCALL   ZPTR,GENVAR,ZSPPTR,RTZPTR                                5065
*                                  Generate variable                    5066
*_
GENVIX RCALL   XPTR,GNVARI,XPTR,RTXNAM                                  5068
*                                  Generate variable from integer       5069
*_
GENVRX RCALL   XPTR,GNVARR,XPTR,RTXNAM
*                                  Generate variable from real
*_
       TITLE   'Termination'                                            5071
ENDQ   IEQLC   STATCL,0,,FTLEN2    Jump if quiet mode
       OUTPUT  OUTPUT,NRMEND,(LVLCL) Normal termination msg
*                                  End procedure                        5073
       OUTPUT  OUTPUT,LASTSF,(STNOCL) Last statement executed msg
*                                  Print status                         5075
       BRANCH  FTLEN2              Join termination procedure           5076
*_
FTLEND OUTPUT  OUTPUT,FTLCF,(ERRTYP,STNOCL,LVLCL) Stmt error msg V3.7
       IEQLC   INICOM,0,FTLEN3     BE SURE OF INITIALIZATION    E3.10.6
       OUTPUT  OUTPUT,ALOCFL  Insufficient Storage for init msg E3.10.6
       BRANCH  ENDALL              GET OUT                      E3.10.6
*_                                                              E3.10.6
FTLEN3 MULTC   YCL,ERRTYP,DESCR    E3.10.6
       GETD    YCL,MSGNO,YCL       Get message pointer                  5082
       GETSPC  TSP,YCL,0           Get message specifier                5083
       STPRNTB IOKEY,OUTBLK,TSP    Print error message          E3.13
FTLEN2 ISTACK  ,                   Reset system stack                   5085
       IEQLC   ETMCL,0,FTLEN4      Was compiler done?
       MSTIME  ETMCL               Time out compiler                    5087
       SUBTRT  TIMECL,ETMCL,TIMECL Compute time in compiler             5088
       SETAC   ETMCL,0             Set interpreter time to 0            5089
       BRANCH  FTLEN1              Join end game                        5090
*_
FTLEN4 MSTIME  XCL                 Time out interpreter                 5092
       SUBTRT  ETMCL,XCL,ETMCL     Compute time in interpreter          5093
FTLEN1 IEQLC   DMPCL,0,,END1       Check &DUMP                          5094
       IEQLC   NODPCL,0,DMPNO      Check storage condition
       ORDVST  ,                   Order string structures              5096
       OUTPUT  OUTPUT,STDMP        Print dump title                     5097
       OUTPUT  OUTPUT,NVARF        Print subtitle - natural variables
       RCALL   ,DUMP,,(INTR10,INTR10,DMPK)                              5099
*                                  Dump natural variables               5100
*_
DMPNO  OUTPUT  OUTPUT,INCGCF       Garbage collector aborted msg        5102
       OUTPUT  OUTPUT,NODMPF       Print reason (dump not possible)
       BRANCH  END1                Join end game                        5104
*_
DMPK   RCALL   ,DMK                Dump keywords                        5106
END1   ICOMPC  STATCL,0,,NOSTAT    Jump if &STAT=0                      5107
       OUTPUT  OUTPUT,STATHD       Print statistics title
       ICOMP   TIMECL,ZEROCL,,NOCTIM
       INTRL   XCL,TIMECL
       MULTC   YCL,processormhz,1000000
       INTRL   YCL,YCL             Convert processor speed to REAL
       DVREAL  XCL,XCL,YCL         Convert to seconds
       OUTPUT  OUTPUT,CMTIME,(XCL) Compilation time
*                                  Print compilation time               5109
NOCTIM ICOMP   ETMCL,ZEROCL,,RESTATS
       INTRL   XCL,ETMCL
       MULTC   YCL,processormhz,1000000
       INTRL   YCL,YCL             Convert processor speed to REAL
       DVREAL  XCL,XCL,YCL         Convert to seconds
       OUTPUT  OUTPUT,INTIME,(XCL) Print execution time
*                                  Print interpretation time            5111
RESTATS OUTPUT  OUTPUT,EXNO,(EXNOCL,FALCL) Statements executed count msg
*                                  Print execution stats                5113
       OUTPUT  OUTPUT,ARTHNO,(ARTHCL) Print arithmetic operations count
*                                  Print arithmetic stats               5115
       OUTPUT  OUTPUT,SCANNO,(SCNCL) Print pattern match count
*                                  Print scanner stats                  5117
       OUTPUT  OUTPUT,STGENO,(GCNO) Print garbage collections count
*                                  Print regeneration stats             5119
       OUTPUT  OUTPUT,READNO,(RSTAT) Print reads count
*                                  Print read stats                     5121
       OUTPUT  OUTPUT,WRITNO,(WSTAT) Print writes count
*                                  Print write stats                    5123
       IEQLC   EXNOCL,0,END2       Check for no interpretation
       INTRL   FCL,ZEROCL                                               5125
       BRANCH  AVTIME              Join end game                        5126
*_
END2   INTRL   EXNOCL,EXNOCL       Convert execution count to REAL      5128
       INTRL   XCL,ETMCL           Convert execution time to REAL       5129
       MULTC   YCL,processormhz,1000000
       INTRL   YCL,YCL             Convert processor speed to REAL
       DVREAL  FCL,XCL,YCL         Convert to seconds
       DVREAL  FCL,FCL,EXNOCL      Compute average time
       MPREAL  FCL,FCL,billionflt  Multiply to get nanoseconds
AVTIME OUTPUT  OUTPUT,TIMEPS,(FCL) Print average statement exec time    5131
NOSTAT LHERE   ,
ENDALL ENDEX   ABNDCL,RETCOD
*_
SYSCUT OUTPUT  OUTPUT,SYSCMT,(STNOCL,LVLCL,EXNOCL)
* Print interrupted statment number, level and stcound
       ICOMPC  CUTNO,0,ENDALL,,ENDALL E3.2.2
       SETAC   CUTNO,1             E3.2.2
       BRANCH  FTLEN2              Join end game                        5136
*_
*---------------------------------------------------------------------*
       TITLE   'Error Handling'                                         5139
AERROR SETAC   ERRTYP,2            Arithmetic error                     5140
       BRANCH  FTLTST                                                   5141
*_
ALOC2  SETAC   ERRTYP,20           Storage exhausted                    5143
       BRANCH  FTLEND                                                   5144
*_
ARGNER SETAC   ERRTYP,25           Incorrect number of arguments        5146
       BRANCH  FTLEND                                                   5147
*_
INTR10 LHERE   ,                                                        5149
INTR13 LHERE   ,                                                        5150
COMP3  SETAC   ERRTYP,17           Program error                        5151
       BRANCH  FTLEND                                                   5152
*_
COMP5  SETAC   ERRTYP,11           Reading error                        5154
       BRANCH  FTLTST                                                   5155
*_
COMP7  SETAC   ERRTYP,27           Erroneous end statement              5157
       BRANCH  FTLEND                                                   5158
*_
COMP9  SETAC   ERRTYP,26           Compilation error limit              5160
       DECRA   ESAICL,1            Decrement error count
       BRANCH  FTLEND                                                   5162
*_
EROR   SETAC   ERRTYP,28           Erroneous statement                  5164
       INCRA   OCICL,DESCR         Increment offset                     5165
       GETD    STNOCL,OCBSCL,OCICL Get statement number                 5166
       BRANCH  FTLEND                                                   5167
*_
EXEX   SETAC   ERRTYP,22           Exceeded &STLIMIT                    5169
       BRANCH  FTLEND                                                   5170
*_
INTR1  SETAC   ERRTYP,1            Illegal data type                    5172
       BRANCH  FTLTST                                                   5173
*_
INTR4  SETAC   ERRTYP,24           Erroneous goto                       5175
       BRANCH  FTLEND                                                   5176
*_
INTR5  SETAC   ERRTYP,19           Failure in goto                      5178
       BRANCH  FTLEND                                                   5179
*_
INTR8  SETAC   ERRTYP,15           Exceeded &MAXLNGTH                   5181
       BRANCH  FTLTST                                                   5182
*_
INTR27 SETAC   ERRTYP,13           Excessive data types                 5184
       BRANCH  FTLTST                                                   5185
*_
INTR30 SETAC   ERRTYP,10           Illegal argument                     5187
       BRANCH  FTLTST                                                   5188
*_
INTR31 SETAC   ERRTYP,16           Overflow in pattern matching         5190
       SETAC   SCERCL,3                                                 5191
       BRANCH  FTERST                                                   5192
*_
LENERR SETAC   ERRTYP,14           Negative number                      5194
       BRANCH  FTLTST                                                   5195
*_
MAIN1  SETAC   ERRTYP,18           Return from level zero               5197
       BRANCH  FTLEND                                                   5198
*_
NANERR SETAC   ERRTYP,29           NaN error
       BRANCH  FTLEND
*_
NEMO   SETAC   ERRTYP,8            Variable not present                 5200
       BRANCH  FTLTST                                                   5201
*_
NONAME SETAC   ERRTYP,4            Null string                          5203
       BRANCH  FTLTST                                                   5204
*_
NONARY SETAC   ERRTYP,3            Erroneous array or table reference   5206
       BRANCH  FTLTST                                                   5207
*_
OVER   SETAC   ERRTYP,21           Stack overflow                       5209
       BRANCH  FTLEND                                                   5210
*_
PROTER SETAC   ERRTYP,6            Erroneous prototype                  5212
       BRANCH  FTLTST                                                   5213
*_
SCDTER SETAC   ERRTYP,1            Illegal data type                    5215
       BRANCH  SCERST                                                   5216
*_
SCLENR SETAC   ERRTYP,14           Negative number                      5218
       BRANCH  SCERST                                                   5219
*_
SCLNOR SETAC   ERRTYP,15           String overflow                      5221
       BRANCH  SCERST                                                   5222
*_
SCNAME SETAC   ERRTYP,4            Null string                          5224
       BRANCH  SCERST                                                   5225
*_
SCNEMO SETAC   ERRTYP,8            E3.4.4
       BRANCH  SCERST              E3.4.4
*_                                                              E3.4.4
SIZERR SETAC   ERRTYP,23           Object too large                     5227
       BRANCH  FTLEND                                                   5228
*_
UNDF   SETAC   ERRTYP,5            Undefined function                   5230
       BRANCH  FTLTST                                                   5231
*_
UNDFFE SETAC   ERRTYP,9            Function entry point not label       5233
       BRANCH  FTLTST                                                   5234
*_
UNKNKW SETAC   ERRTYP,7            Unknown keyword                      5236
       BRANCH  FTLTST                                                   5237
*_
UNTERR SETAC   ERRTYP,12           Illegal I/O unit                     5239
       BRANCH  FTLTST                                                   5240
*_
WRTERR SETAC   ERRTYP,30           Error during write
       BRANCH  FTLEND
*_
SCERST SETAC   SCERCL,1            Note failure during pattern matching 5242
       BRANCH  FTERST                                                   5243
*_
FTLTST SETAC   SCERCL,2            Note failure outside pattern matchin 5245
FTERST ICOMPC  ERRLCL,0,,FTLEND,FTLEND                                  5246
*                                  Check &ERRLIMIT                      5247
       DECRI   ERRLCL,1            Decrement &ERRLIMIT                  5248
       ICOMPC  TRAPCL,0,,FTERBR,FTERBR
*                                  Check &TRACE                         5250
       LOCAPT  ATPTR,TKEYL,ERRTKY,FTERBR                                5251
*                                  Look for KEYWORD trace               5252
       PUSH    SCERCL              E3.1.3
       RCALL   ,TRPHND,ATPTR       E3.3.1
*                                  Perform trace                        5254
       POP     SCERCL              E3.1.3
FTERBR SELBRA  SCERCL,(TSALF,FAIL,RTNUL3)                               5255
*
STRTIT RCALL   ,INTERP,,(MAIN1,MAIN1,MAIN1)
*                                  Call interpreter                     0423
*
       TITLE   'Program Initialization'                                 0330
BEGIN  INIT    ,                   Initialize system                    0331
       ISTACK  ,                   Initialize stack                     0332
       RCALL   SCBSCL,BLOCK,OCALIM Allocate block for object code       0336
       MOVD    OCSVCL,SCBSCL       Save object code pointer             0337
*      RESETF  SCBSCL,PTRF         Clear pointer flag For speed?
* 338 removed so GC moves 1st code block when prior things GCed
       MOVD    XPTR,OBLOCK         Initialize bins with PTR flags
       INCRA   XPTR,OBARY*DESCR    At end of two arrays and OBLOCK
BININI SETFI   XPTR,PTRF
       DECRA   XPTR,DESCR
       AEQLC   XPTR,OBLOCK,BININI
       GETSIZ  YCL,INITLS          Get size of initialization list      0339
SPCNVT GETD    XPTR,INITLS,YCL     Get pointer to list                  0340
       GETSIZ  XCL,XPTR            Get size of list                     0341
SPCNV1 GETD    ZPTR,XPTR,XCL       Get pointer to specifier             0342
       IEQLC   ZPTR,0,,SPCNV2      Skip dummy zero entries
       RCALL   ZPTR,GENVAR,ZPTR    Convert specifier to structure       0344
       PUTD    XPTR,XCL,ZPTR       Replace pointer to specifier         0345
SPCNV2 DECRA   XCL,2*DESCR         Decrement to next pair               0346
       ACOMPC  XCL,0,SPCNV1        Continue if one remains              0347
       DECRA   YCL,DESCR           Decrement to next list               0348
       ACOMPC  YCL,0,SPCNVT        Continue if one remains              0349
INITD1 GETDC   XPTR,INITB,0        Get specifier to convert             0350
       RCALL   YPTR,GENVAR,(XPTR)  Convert it to string structure       0351
       GETDC   ZPTR,INITB,DESCR    Get location to put it               0352
       PUTDC   ZPTR,0,YPTR         Place pointer to string structure    0353
       INCRA   INITB,2*DESCR       Decrement to next pair               0354
       ACOMP   INITB,INITE,,,INITD1                                     0355
*                                  Compare with end                     0356
*
       PUTDC   ABRTKY,DESCR,ABOPAT Initial value of ABORT               0358
       PUTDC   ARBKY,DESCR,ARBPAT  Initial value of ARB                 0359
       PUTDC   BALKY,DESCR,BALPAT  Initial value of BAL                 0360
       PUTDC   FAILKY,DESCR,FALPAT Initial value of FAIL                0361
       PUTDC   FNCEKY,DESCR,FNCPAT Initial value of FENCE               0362
       PUTDC   MXARKY,DESCR,MXAPAT Initial value of MAXARB
       PUTDC   REMKY,DESCR,REMPAT  Initial value of REM                 0363
       PUTDC   SUCCKY,DESCR,SUCPAT Initial value of SUCCEED             0364
*
*      SETAC   VARSYM,0            Set count of variables to zero
       RCALL   NBSPTR,BLOCK,NMOVER Allocate block for value assignment  0367
       MOVD    CMBSCL,SCBSCL       Set up pointer for compiler          0368
       MOVD    UNIT,INPUT          Set up input unit                    0369
       MOVD    OCBSCL,CMBSCL       Project base for interpreter         0370
       SUM     OCLIM,CMBSCL,OCALIM Compute end of code block            0371
       DECRA   OCLIM,5*DESCR       Leave room for overflow              0372
       RCALL   XPTR,DIRENTDEF      Define DirEnt data type
       MOVV    DIRENTTYP,DATSEG    Save DirEnt type code
       SETAC   INICOM,1            SIGNAL COMPLETION            E3.10.6
       MSTIME  TIMECL              Time in compiler                     0335
       BRANCH  XLATRN                                                   0373
*_
*---------------------------------------------------------------------*
       TITLE   'Compilation and Interpreter Invocation'                 0376
XLATRD IEQLC   LISTCL,0,,XLATRN    Skip print if list is off            0377
       SETLC   LNBFSP,CARDSZ+DSTSZ+1 Make full listing line
       TRIMSP  LNBFSP,ZEROSP,ZEROCL Trim listing line output
       STPRNT  IOKEY,OUTBLK,LNBFSP Print line image                     0378
XLATRN SETLC   INBFSP,CARDSZ       Reset INBFSP length field            0379
       STREAD  INBFSP,UNIT,XLATRN,COMP5,COMP5 Read card
       RPAD    INBFSPF,INBFSP,BLSP Pad with blanks
* because compiler is not set up for variable length statements
       SETSP   TEXTSP,NEXTSP       Set up line just read                0380
       STREAM  XSP,TEXTSP,CARDTB,COMP3,COMP3                            0381
*                                  Determine type of card               0382
       RCALL   ,NEWCRD,,(XLATRD,,) Process card type                    0383
XLATNX RCALL   ,CMPILE,,(COMP3,,XLATNX)                                 0384
*                                  Compile statement                    0385
       INCRA   CMOFCL,DESCR        Increment offset                     0386
       PUTD    CMBSCL,CMOFCL,ENDCL Insert END function                  0387
       IEQLC   LISTCL,0,,XLATP     Skip print if list is off
       SETLC   LNBFSP,CARDSZ+DSTSZ+1 Make full listing line
       TRIMSP  LNBFSP,ZEROSP,ZEROCL Trim listing line output
       STPRNT  IOKEY,OUTBLK,LNBFSP Print last line image                0389
XLATP  IEQLC   STYPE,EOSTYP,,XLAEND                                     0390
*                                  Finish on end of statement           0391
       STREAM  XSP,TEXTSP,IBLKTB,COMP3,XLAEND                           0392
*                                  Analyze END card                     0393
       IEQLC   STYPE,EOSTYP,,XLAEND
*                                  Finish on end of statement           0395
       IEQLC   STYPE,NBTYP,COMP7   Error if break character
       STREAM  XSP,TEXTSP,LBLTB,COMP7,COMP7                             0397
*                                  Analyze END label                    0398
       RCALL   XPTR,GENVAR,(XSPPTR)                                     0399
*                                  Generate variable for label          0400
       GETDC   OCBSCL,XPTR,ATTRIB  Get start for interpreter            0401
       IEQLC   OCBSCL,0,,COMP7     Error if not attribute
       IEQLC   STYPE,EOSTYP,,XLAEND
*                                  Finish on end of statement           0404
       STREAM  XSP,TEXTSP,IBLKTB,COMP7,,COMP7                           0405
*                                  Analyze remainder of card            0406
XLAEND IEQLC   ESAICL,0,,XLATSC    Were there any compilation errors?   0407
       OUTPUT  OUTPUT,ERRCF,(ESAICL) Print syntax error count
       INCRI   ABNDCL,1            Make return code one higher
       IEQLC   EXECER,1,ENDALL
       BRANCH  XLATND                                                   0409
*_
XLATSC IEQLC   STATCL,0,,XLATND    Jump if quiet mode                   0411
       IEQLC   LISTCL,0,,XLATND    Jump if UNLIST on
       OUTPUT  OUTPUT,SUCCF        Print message of no errors
XLATND SETAC   UNIT,0              Reset input unit                     0412
       SETAC   LPTR,0              Reset last label pointer             0413
       SETAC   OCLIM,0             Reset limit on object code           0414
       ZERBLK  COMREG,COMDCT       Clear compiler descriptors           0415
       SUM     XCL,CMBSCL,CMOFCL   Compute end of object code           0416
       RCALL   ,SPLIT,(XCL)        Split of unused part of block        0417
       SETAC   LISTCL,0            Turn off listing switch              0418
       MSTIME  ETMCL               Time out compiler                    0419
       SUBTRT  TIMECL,ETMCL,TIMECL Compute elapsed time                 0420
       SETAC   CNSLCL,1            Permit label redefinition            0421
       BRANCH  STRTIT
*_     end of executable code
