*---------------------------------------------------------------------*
*
*      X . Y and X $ Y                                                  2898
*
NME    PROC    ,                   Matching procedure for naming        2900
       INCRA   PDLPTR,3*DESCR      Make room for history entry          2901
       ACOMP   PDLPTR,PDLEND,INTR31                                     2902
*                                  Check for end of list                2903
       PUTDC   PDLPTR,DESCR,FNMECL Insert backup function               2904
       GETLG   TMVAL,TXSP          Get cursor position                  2905
       PUTDC   PDLPTR,2*DESCR,TMVAL                                     2906
*                                  Put on history list                  2907
       PUTDC   PDLPTR,3*DESCR,LENFCL                                    2908
*                                  Put length failure indicator         2909
       PUSH    (TMVAL)             Save cursor                          2910
       SETAC   LENFCL,1            Set length failure indicator         2911
       BRANCH  SCOK,SCNR           Return matching successfully         2912
*_
FNME   PROC    NME                 Backup procedure for naming          2914
       POP     (TVAL)              Restore cursor                       2915
FNME1  IEQLC   LENFCL,0,TSALT,TSALF                                     2916
*                                  Check length failure indicator       2917
*_
ENME   PROC    NME                 Naming process for X . Y             2919
       INCRA   PATICL,DESCR        Increment offset                     2920
       GETD    YPTR,PATBCL,PATICL  Get argument                         2921
       POP     (NVAL)              Restore previous cursor position     2922
       SETVA   YCL,NVAL            Set up length                        2923
       SETSP   TSP,TXSP            Copy specifier                       2924
       PUTLG   TSP,NVAL            Insert length                        2925
       REMSP   TSP,TXSP,TSP        Compute ramainder                    2926
       SUM     TPTR,NBSPTR,NAMICL  Compute position on name list        2927
       PUTSPC  TPTR,DESCR,TSP      Insert specifier                     2928
       PUTDC   TPTR,DESCR+SPEC,YPTR                                     2929
*                                  Insert argument                      2930
       INCRA   NAMICL,DESCR+SPEC   Increment list offset                2931
       ACOMP   NAMICL,NMOVER,INTR13,ENME1                               2932
*                                  Check for overflow                   2933
ENME2  INCRA   PDLPTR,DESCR+SPEC   Make room on history list            2934
       ACOMP   PDLPTR,PDLEND,INTR31                                     2935
*                                  Check for overflow                   2936
       PUTDC   PDLPTR,DESCR,DNMECL Insert unravelling function          2937
ENME3  GETLG   TMVAL,TXSP          Get cursor position                  2938
       MOVV    TMVAL,YCL                                                2939
       PUTDC   PDLPTR,2*DESCR,TMVAL                                     2940
*                                  Insert on list                       2941
       PUTDC   PDLPTR,3*DESCR,LENFCL                                    2942
*                                  Insert length failure                2943
       SETAC   LENFCL,1            Set length failure                   2944
       BRANCH  SCOK,SCNR           Return matching successfully         2945
*_
ENME1  MOVD    WCL,NMOVER          Save copy of current name list end   2947
       INCRA   NMOVER,NAMLSZ*SPDR  Increment for larger block           2948
       RCALL   TPTR,BLOCK,NMOVER   Allocate larger block                2949
       MOVBLK  TPTR,NBSPTR,WCL     Move in old block                    2950
       MOVD    NBSPTR,TPTR         Set up new base pointer              2951
       BRANCH  ENME2               Rejoin processing                    2952
*_
DNME   PROC    NME                 Unravelling procedure for naming     2954
       DECRA   NAMICL,DESCR+SPEC   Back off named string                2955
       SUM     TPTR,NBSPTR,NAMICL  Compute current position             2956
DNME1  PROC    NME                                                      2957
       SETAV   VVAL,YCL                                                 2958
       PUSH    (VVAL)              Preserve length                      2959
       BRANCH  FNME1                                                    2960
*_
ENMI   PROC    NME                 Matching for X $ Y                   2962
       INCRA   PATICL,DESCR        Increment offset                     2963
       GETD    YPTR,PATBCL,PATICL  Get argument                         2964
       POP     (NVAL)              Restore initial length               2965
       SETVA   YCL,NVAL            Move initial length into value field 2966
       SETSP   TSP,TXSP            Get working specifier                2967
       PUTLG   TSP,NVAL            Insert length                        2968
       REMSP   TSP,TXSP,TSP        Get specifier for part matched       2969
       GETLG   ZCL,TSP             Get length of part                   2970
       ICOMP   ZCL,MLENCL,SCLNOR   Check &MAXLNGTH
       VEQLC   YPTR,E,,ENMEXN      Is it EXPRESSION?                    2972
ENMI5  VEQLC   YPTR,K,,ENMIC       Check for KEYWORD data type          2973
       RCALL   VVAL,GENVAR,(TSPPTR)                                     2974
*                                  Generate variable                    2975
ENMI3  PUTDC   YPTR,DESCR,VVAL     Perform assignment                   2976
       IEQLC   OUTSWQ,0,,ENMI4     Check &OUTPUT
       LOCAPV  ZPTR,OUTATL,YPTR,ENMI4                                   2978
*                                  Look for output association          2979
       GETDC   ZPTR,ZPTR,DESCR     Get association                      2980
       RCALL   ,PUTOUT,(ZPTR,VVAL) Perform output                       2981
ENMI4  ICOMPC  TRAPCL,0,,ENMI2,ENMI2                                    2982
*                                  Check &TRACE                         2983
       LOCAPT  ATPTR,TVALL,YPTR,ENMI2                                   2984
*                                  Look for VALUE trace                 2985
       PUSH    (PATBCL,PATICL,WPTR,XCL,YCL)                             2986
*                                  Save relevant descriptors            2987
       PUSH    (MAXLEN,LENFCL,PDLPTR,PDLHED,NAMICL,NHEDCL)              2988
       SPUSH   (HEADSP,TSP,TXSP,XSP)                                    2989
*                                  Save relevant specifiers             2990
       MOVD    PDLHED,PDLPTR       Set up new history list head         2991
       MOVD    NHEDCL,NAMICL       Set up new name list head            2992
       RCALL   ,TRPHND,ATPTR       E3.3.1
*                                  Perform trace                        2994
       SPOP    (XSP,TXSP,TSP,HEADSP)                                    2995
*                                  Restore specifiers                   2996
       POP     (NHEDCL,NAMICL,PDLHED,PDLPTR,LENFCL,MAXLEN)              2997
*                                  Restore descriptors                  2998
       POP     (YCL,XCL,WPTR,PATICL,PATBCL)                             2999
ENMI2  INCRA   PDLPTR,3*DESCR      Make room on history list            3000
       ACOMP   PDLPTR,PDLEND,INTR31                                     3001
*                                  Check for overflow                   3002
       PUTDC   PDLPTR,DESCR,DNMICL Insert unravelling function          3003
       BRANCH  ENME3               Join common processing               3004
*_
ENMIC  SPCINT  VVAL,TSP,SCDTER,ENMI3                                    3006
*                                  Convert STRING to INTEGER            3007
*_
ENMEXN PUSH    ZEROCL              E3.4.4 & E3.5.8
       RCALL   YPTR,EXPEVL,YPTR,(TSALF,,SCNEMO) E3.4.4 & E3.5.8
       POP     ZEROCL              E3.4.4 & E3.5.8
       BRANCH  ENMI5               E3.4.4 & E3.5.8
*_
*---------------------------------------------------------------------*
*
*      SUCCEED                                                          3014
*
SUCE   PROC    ,                   Matching procedure for SUCCEED       3016
SUCE1  INCRA   PDLPTR,3*DESCR      Make room for history entry          3017
       ACOMP   PDLPTR,PDLEND,INTR31                                     3018
*                                  Check for overflow                   3019
       PUTDC   PDLPTR,DESCR,SUCFCL Insert SUCCESS backup function       3020
       GETLG   TMVAL,TXSP          Get length matched                   3021
       PUTDC   PDLPTR,2*DESCR,TMVAL                                     3022
*                                  Save on history list                 3023
       PUTDC   PDLPTR,3*DESCR,LENFCL                                    3024
*                                  Save current length failure          3025
       SETAC   LENFCL,1            Set length failure                   3026
       BRANIC  SCOKCL,0            Return successful match              3027
*_
SUCF   PROC    SUCE                SUCCEED failure                      3029
       GETDC   XCL,PDLPTR,DESCR    Get history entries                  3030
       GETDC   YCL,PDLPTR,2*DESCR                                       3031
       BRANCH  SUCE1               Go in front door                     3032
*_
*---------------------------------------------------------------------*
       TITLE   'Defined Functions'                                      3035
*
*      DEFINE(P,E)                                                      3037
*
DEFINE PROC    ,                   DEFINE(P,E)                          3039
       RCALL   XPTR,VARVAL,,FAIL   Get prototype                        3040
       PUSH    XPTR                Save prototype                       3041
       RCALL   YPTR,VARVAL,,FAIL   Get entry point                      3042
       POP     XPTR                Restore prototype                    3043
       LOCSP   XSP,XPTR            Specifier for prototype              3044
       STREAM  YSP,XSP,VARATB,PROTER,PROTER                             3045
*                                  Break out function name              3046
       IEQLC   STYPE,LPTYP,PROTER  Verify open parenthesis
       RCALL   XPTR,GENVAR,(YSPPTR)                                     3048
*                                  Get variable for function name       3049
       RCALL   ZCL,FINDEX,(XPTR)   Get function descriptor for function 3050
       DEQL    YPTR,NULVCL,DEFIN3  Check for omitted entry point        3051
       MOVD    YPTR,XPTR           If omitted use function name         3052
DEFIN3 PUSH    YPTR                Save entry point                     3053
       MOVD    YCL,ZEROCL          Set argument count to 0              3054
       PUSH    XPTR                Save function name                   3055
DEFIN4 FSHRTN  XSP,1               Remove break character               3056
       STREAM  YSP,XSP,VARATB,PROTER,PROTER                             3057
*                                  Break out argument                   3058
       SELBRA  STYPE,(PROTER,,DEFIN6)                                   3059
*                                  Check for end                        3060
       LEQLC   YSP,0,,DEFIN4       Check for null argument              3061
       RCALL   XPTR,GENVAR,(YSPPTR)                                     3062
*                                  Generate variable for argument       3063
       PUSH    XPTR                Save argument                        3064
       INCRA   YCL,1               Increment argument count             3065
       BRANCH  DEFIN4              Continue                             3066
*_
DEFIN6 LEQLC   YSP,0,,DEFIN9                                            3068
       INCRA   YCL,1               Increment argument count             3069
       RCALL   XPTR,GENVAR,(YSPPTR)                                     3070
*                                  Generate variable for argument       3071
       PUSH    XPTR                Save argument                        3072
DEFIN9 SETVA   DEFCL,YCL                                                3073
DEFIN8 FSHRTN  XSP,1                                                    3074
       STREAM  YSP,XSP,VARATB,PROTER,DEF10                              3075
*                                  Break out local arguments            3076
       IEQLC   STYPE,CMATYP,PROTER Verify comma
       LEQLC   YSP,0,,DEFIN8       Check for null argument              3078
       RCALL   XPTR,GENVAR,(YSPPTR)                                     3079
*                                  Generate variable                    3080
       PUSH    XPTR                Save local argument                  3081
       INCRA   YCL,1               Increment total count                3082
       BRANCH  DEFIN8              Continue                             3083
*_
DEF10  LEQLC   YSP,0,,DEF11        Check for null argument              3085
       RCALL   XPTR,GENVAR,YSPPTR  Generate variable                    3086
       PUSH    XPTR                Save argument                        3087
       INCRA   YCL,1               Increment total count                3088
DEF11  INCRA   YCL,2               Increment for name and label         3089
       MULTC   XCL,YCL,DESCR       Convert to address units             3090
       SETVC   XCL,B               Insert block data type               3091
       RCALL   XPTR,BLOCK,XCL      Allocate block for definition        3092
       PUTDC   ZCL,0,DEFCL         Point to procedure descriptor        3093
       PUTDC   ZCL,DESCR,XPTR      Insert definition block              3094
       SUM     XPTR,XPTR,XCL       Compute end of block                 3095
DEF12  DECRA   XPTR,DESCR          Decrement pointer                    3096
       POP     YPTR                Restore argument                     3097
       PUTDC   XPTR,DESCR,YPTR     Insert in definition block           3098
       DECRA   YCL,1               Decrement total count                3099
       IEQLC   YCL,0,DEF12,RETNUL  Check for end
*_
*---------------------------------------------------------------------*
*
*      Invocation of Defined Function                                   3104
*
DEFFNC PROC    ,                   Procedure to invoke defined function 3106
       SETAV   XCL,INCL            Get number of arguments in call      3107
       MOVD    WCL,XCL             Save copy                            3108
       MOVD    YCL,INCL            Save function descriptor             3109
       PSTACK  YPTR                Post stack position                  3110
       PUSH    NULVCL              Save null value for function name    3111
DEFF1  INCRA   OCICL,DESCR         Increment offset                     3112
       GETD    XPTR,OCBSCL,OCICL   Get object code descriptor           3113
       TESTF   XPTR,FNF,,DEFFC     Check for function descriptor
DEFF2  IEQLC   INSWQ,0,,DEFF14     Check &INPUT                         3115
       LOCAPV  ZPTR,INATL,XPTR,DEFF14                                   3116
*                                  Look for input association           3117
       GETDC   ZPTR,ZPTR,DESCR     Get association                      3118
       PUSH    (XCL,WCL,YCL,YPTR)  Save relevant descriptors            3119
       RCALL   XPTR,PUTIN,(ZPTR,XPTR),FAIL                              3120
*                                  Perform input                        3121
       POP     (YPTR,YCL,WCL,XCL)  Restore descriptors                  3122
       BRANCH  DEFF3               Join processing                      3123
*_
DEFF14 GETDC   XPTR,XPTR,DESCR     Get value                            3125
DEFF3  PUSH    XPTR                Save value                           3126
       DECRA   XCL,1               Decrement argument count             3127
       ACOMPC  XCL,0,DEFF1,,INTR10 Check for end                        3128
       GETDC   XCL,YCL,0           Get expected number of arguments     3129
       SETAV   XCL,XCL             Insert in A-field                    3130
DEFF4  ACOMP   WCL,XCL,DEFF9,DEFF5 Compare given and expected           3131
       PUSH    NULVCL              Not enough, save null string         3132
       INCRA   WCL,1               Increment count                      3133
       BRANCH  DEFF4               Continue                             3134
*_
DEFF9  POP     ZCL                 Throw away extra argument            3136
       DECRA   WCL,1               Decrement count                      3137
       BRANCH  DEFF4               Continue                             3138
*_
DEFF5  GETDC   ZCL,YCL,DESCR       Get definition block                 3140
       MOVD    XPTR,ZCL            Save copy                            3141
       GETSIZ  WCL,ZCL             Get size of block                    3142
       SUM     WPTR,ZCL,WCL        Compute pointer to end               3143
       INCRA   XCL,1               Increment for function name          3144
DEFF8  INCRA   XPTR,DESCR          Increment pointer to block           3145
       INCSP   YPTR,DESCR          Adjust stack pointer
       GETDC   ZPTR,XPTR,DESCR     Get argument name                    3147
       GETDC   TPTR,ZPTR,DESCR     Get current argument value           3148
       GETSTD  ATPTR,YPTR,DESCR    Get value from stack
       PUTDC   ZPTR,DESCR,ATPTR    Assign to argument name              3150
       PUTSTD  YPTR,DESCR,TPTR     Put current argument on stack
       DECRA   XCL,1               Decrement count                      3152
       ACOMPC  XCL,0,DEFF8,,INTR10 Check for end                        3153
DEFF10 INCRA   XPTR,DESCR          Increment pointer to block           3154
       AEQL    XPTR,WPTR,,DEFFGO                                        3155
       GETDC   ZPTR,XPTR,DESCR     Get argument name from block         3156
       GETDC   TPTR,ZPTR,DESCR     Get current value of argument        3157
       PUSH    TPTR                Save current value                   3158
       PUTDC   ZPTR,DESCR,NULVCL   Assign null value to local           3159
       BRANCH  DEFF10              Continue                             3160
*_
DEFFGO PUSH    (FRTNCL,STNOCL,OCICL,OCBSCL,ZCL,ZCL)                     3162
*                                  Save system state                    3163
       GETDC   XCL,ZCL,DESCR       Get entry label                      3164
       AEQLIC  XCL,ATTRIB,0,,UNDFFE E3.0.2
       GETDC   OCBSCL,XCL,ATTRIB   E3.0.2
       ICOMPC  TRACL,0,,DEFF18,DEFF18
*                                  Check &FTRACE                        3168
       DECRI   TRACL,1             Decrement &FTRACE                    3169
       GETDC   ATPTR,ZCL,2*DESCR   Get function name                    3170
       PUSH    ZCL                 Save definition block                3171
       RCALL   ,FENTR2,(ATPTR),(INTR10,INTR10)                          3172
*                                  Perform function trace               3173
       POP     ZCL                 Restore definition block             3174
DEFF18 ICOMPC  TRAPCL,0,,DEFF19,DEFF19                                  3175
*                                  Check &TRACE                         3176
       GETDC   ATPTR,ZCL,2*DESCR   Get function name                    3177
       LOCAPT  ATPTR,TFENTL,ATPTR,DEFF19                                3178
*                                  Check for CALL trace                 3179
       PUSH    (OCBSCL,ZCL)        Save object code base and block      3180
       RCALL   ,TRPHND,ATPTR       E3.3.1
*                                  Perform trace                        3182
       POP     (ZCL,OCBSCL)        Restore base and block               3183
DEFF19 INCRA   LVLCL,1             Increment &FNCLEVEL                  3184
       ICOMPC  TRAPCL,0,,DEFF15,DEFF15
*                                  Check &TRACE                         3186
       LOCAPT  ATPTR,TKEYL,FNCLKY,DEFF15                                3187
*                                  Look for KEYWORD trace               3188
       RCALL   ,TRPHND,ATPTR       E3.3.1
*                                  Perform trace                        3190
DEFF15 SETAC   OCICL,0             Zero offset                          3191
       RCALL   ,INTERP,,(DEFFF,DEFFNR)                                  3192
*                                  Call interpreter                     3193
       MOVD    RETPCL,RETCL        Set &RTNTYPE to RETURN               3194
DEFFS1 POP     ZCL                 Restore definition block             3195
       ICOMPC  TRACL,0,,DEFF20,DEFF20
*                                  Check &FTRACE                        3197
       DECRI   TRACL,1             Decrement &FTRACE                    3198
       GETDC   ATPTR,ZCL,2*DESCR   Get function name                    3199
       PUSH    ZCL                 Save definition block                3200
       RCALL   ,FNEXT2,(ATPTR),(INTR10,INTR10)                          3201
*                                  Perform function trace               3202
       POP     ZCL                 Restore definition block             3203
DEFF20 ICOMPC  TRAPCL,0,,DEFFS2,DEFFS2                                  3204
*                                  Check &TRACE                         3205
       GETDC   ATPTR,ZCL,2*DESCR   Get function name                    3206
       LOCAPT  ATPTR,TFEXTL,ATPTR,DEFFS2                                3207
*                                  Check for RETURN trace               3208
       PUSH    (RETPCL,ZCL)        Save return and block                3209
       RCALL   ,TRPHND,ATPTR       E3.3.1
*                                  Perform trace                        3211
       POP     (ZCL,RETPCL)        Restore block and return             3212
DEFFS2 DECRA   LVLCL,1             Decrement &FNCLEVEL                  3213
       ICOMPC  TRAPCL,0,,DEFF17,DEFF17
*                                  Check &TRACE                         3215
       LOCAPT  ATPTR,TKEYL,FNCLKY,DEFF17                                3216
*                                  Check for KEYWORD trace              3217
       PUSH    (RETPCL,ZCL)        Save return and block                3218
       RCALL   ,TRPHND,ATPTR       E3.3.1
*                                  Perform trace                        3220
       POP     (ZCL,RETPCL)        Restore block and return             3221
DEFF17 POP     (ZCL,OCBSCL,OCICL,STNOCL,FRTNCL)                         3222
*                                  Restore system state                 3223
       GETSIZ  WCL,ZCL             Get size of definition block         3224
       DECRA   WCL,DESCR           Decrement pointer                    3225
       ACOMPC  WCL,0,,INTR10,INTR10                                     3226
*                                  Check for end                        3227
       SUM     WPTR,ZCL,WCL        Compute pointer to last descriptor   3228
       MOVD    YPTR,ZCL            Save pointer to block                3229
       INCRA   YPTR,DESCR          Increment pointer                    3230
       GETDC   ZPTR,YPTR,DESCR     Get function name                    3231
       GETDC   ZPTR,ZPTR,DESCR     Get value to be returned             3232
DEFF6  POP     XPTR                Get old value                        3233
       GETDC   YPTR,WPTR,DESCR     Get argument name                    3234
       PUTDC   YPTR,DESCR,XPTR     Restore old value                    3235
       DECRA   WPTR,DESCR          Decrement pointer                    3236
       AEQL    WPTR,ZCL,DEFF6      Check for end                        3237
       DEQL    RETPCL,FRETCL,,FAIL Check for FRETURN                    3238
       DEQL    RETPCL,NRETCL,RTZPTR                                     3239
*                                  Check for NRETURN                    3240
       MOVD    XPTR,ZPTR           Move name to correct descriptor      3241
       VEQLC   XPTR,S,,DEFFVX      Check for natural variable           3242
       VEQLC   XPTR,I,,GENVIX      Convert integer                      3243
       VEQLC   XPTR,N,,RTXNAM      Check for created variable           3244
       VEQLC   XPTR,K,NONAME,RTXNAM                                     3245
*                                  Check for keyword variable           3246
DEFFVX IEQLC   XPTR,0,RTXNAM,NONAME                                     3247
*                                  Check for null string                3248
*_
DEFFF  MOVD    RETPCL,FRETCL       Set up FRETURN                       3250
       BRANCH  DEFFS1              Join processing                      3251
*_
DEFFC  PUSH    (XCL,WCL,YCL,YPTR)  Save relevant descriptors            3253
       RCALL   XPTR,INVOKE,(XPTR),(FAIL,DEFFN)                          3254
*                                  Evaluate argument                    3255
       POP     (YPTR,YCL,WCL,XCL)  Restore relevant variables           3256
       BRANCH  DEFF3               Join processing                      3257
*_
DEFFN  POP     (YPTR,YCL,WCL,XCL)  Restore relevant variables           3259
       BRANCH  DEFF2               Join processing                      3260
*_
DEFFNR MOVD    RETPCL,NRETCL       Set up NRETURN                       3262
       BRANCH  DEFFS1              Join processing                      3263
*_
*---------------------------------------------------------------------*
       TITLE   'External Functions'                                     3266
*
*      LOAD(P)                                                          3268
*
LOAD   PROC    ,                   LOAD(P)                              3270
       RCALL   XPTR,VARVAL,,FAIL   Get prototype                        3271
       PUSH    XPTR                Save prototype                       3272
       RCALL   WPTR,VARVAL,,FAIL   Get library name                     3273
       LOCSP   VSP,WPTR            Get specifier for library            3274
       POP     XPTR                Restore prototypr                    3275
       LOCSP   XSP,XPTR            Get specifier for prototype          3276
       STREAM  YSP,XSP,VARATB,PROTER,PROTER                             3277
*                                  Get function name from prototype     3278
       IEQLC   STYPE,LPTYP,PROTER  Verify left parenthesis
       RCALL   XPTR,GENVAR,YSPPTR  Generate variable for function       3280
       RCALL   ZCL,FINDEX,XPTR     Find function                        3281
       MOVD    YCL,ZEROCL          Set argument count to zero           3282
LOAD4  FSHRTN  XSP,1               Remove break character               3283
       STREAM  ZSP,XSP,VARATB,LOAD1,PROTER                              3284
*                                  Break out argument                   3285
       SELBRA  STYPE,(PROTER,,LOAD6)                                    3286
*                                  Branch on break type                 3287
       RCALL   XPTR,GENVAR,ZSPPTR  Generate variable for data type      3288
       LOCAPV  XPTR,DTATL,XPTR,LOAD9                                    3289
*                                  Look up data type                    3290
       GETDC   XPTR,XPTR,DESCR     Extract data type code               3291
       PUSH    XPTR                Save data type code                  3292
LOAD10 INCRA   YCL,1               Increment count of arguments         3293
       BRANCH  LOAD4               Continue                             3294
*_
LOAD6  INCRA   YCL,1               Count last argument                  3296
       RCALL   XPTR,GENVAR,ZSPPTR  Generate variable for data type      3297
       LOCAPV  XPTR,DTATL,XPTR,LOAD11                                   3298
*                                  Look up data type                    3299
       GETDC   XPTR,XPTR,DESCR     Get data type code                   3300
       PUSH    XPTR                Save data type code                  3301
LOAD13 FSHRTN  XSP,1               Delete right parenthesis             3302
       RCALL   XPTR,GENVAR,XSPPTR  Generate variable for target         3303
       LOCAPV  XPTR,DTATL,XPTR,LOAD7                                    3304
*                                  Look up data type                    3305
       GETDC   XPTR,XPTR,DESCR     Get data type code                   3306
       PUSH    XPTR                Save data type code                  3307
LOAD8  SETVA   LODCL,YCL           Insert number of arguments           3308
       INCRA   YCL,1               Increment count                      3309
       MULTC   XCL,YCL,DESCR       Convert to address units             3310
       INCRA   XCL,DESCR           Add space for entry point            3311
       SETVC   XCL,B               Insert BLOCK data type               3312
       RCALL   XPTR,BLOCK,XCL      Allocate block for definition        3313
       PUTDC   ZCL,0,LODCL         Insert procedure descriptor          3314
       PUTDC   ZCL,DESCR,XPTR      Insert definition block              3315
       SUM     XPTR,XPTR,XCL       Compute pointer to end of block      3316
LOAD12 DECRA   XPTR,DESCR          Decrement pointer                    3317
       POP     YPTR                Restore data type                    3318
       PUTDC   XPTR,DESCR,YPTR     Insert in block                      3319
       DECRA   YCL,1               Decrement count                      3320
       ACOMPC  YCL,0,LOAD12        Check for end                        3321
       LOAD    1,ZPTR,YPTR,YSP,VSP,FAIL Get size for load function
       RCALL   ZPTR,BLOCK,ZPTR     Allocate block for subroutine
       LOAD    2,ZPTR,YPTR,YSP,VSP,FAIL Load external function
       PUTDC   XPTR,0,YPTR         Insert entry point                   3323
       RRTURN  NULVCL,3            Return null string as value
*_
LOAD7  PUSH    ZEROCL              Save 0 for unspecified type          3326
       BRANCH  LOAD8               Continue                             3327
*_
LOAD9  PUSH    ZEROCL              Save 0 for unspecified type          3329
       BRANCH  LOAD10              Continue                             3330
*_
LOAD1  PUSH    ZEROCL              Save 0 for unspecified type          3332
       SETSP   TSP,XSP             Set up break check                   3333
       SETLC   TSP,1               Set length to 1                      3334
       INCRA   YCL,1                                                    3335
       LEXCMP  TSP,RPRNSP,LOAD4,LOAD13,LOAD4                            3336
*_
LOAD11 PUSH    ZEROCL              Save 0 for unspecified type          3338
       BRANCH  LOAD13              Continue                             3339
*_
*---------------------------------------------------------------------*
*
*      UNLOAD(F)                                                        3343
*
UNLOAD PROC    ,                   UNLOAD(F)                            3345
       RCALL   XPTR,VARVAL,,FAIL   Get function name                    3346
       RCALL   ZCL,FINDEX,XPTR     Locate function descriptor           3347
       PUTDC   ZCL,0,UNDFCL        Undefine function                    3348
       LOCSP   XSP,XPTR            Get specifier                        3349
       UNLOAD  XSP                 Unload external definition           3350
       RRTURN  NULVCL,3            Return null string by exit 3
*_
*---------------------------------------------------------------------*
*
*      Linkage to External Functions                                    3355
*
LNKFNC PROC    ,                   Procedure to link to externals       3357
       SETAV   XCL,INCL            Get actual number of arguments       3358
       MOVD    YCL,INCL            Save function descriptor             3360
       SETAV   WCL,YCL             E3.12.1
       GETDC   ZCL,YCL,DESCR       Get definition block                 3361
       PSTACK  YPTR                Post stack position                  3362
       SETAC   TCL,2*DESCR         Set offset for first argument        3363
LNKF1  PUSH    (XCL,ZCL,TCL,YPTR,WCL,YCL)                               3364
*                                  Save working descriptors             3365
       RCALL   XPTR,ARGVAL,,FAIL   Evaluate argument                    3366
       POP     (YCL,WCL,YPTR,TCL,ZCL,XCL)                               3367
*                                  Restore working descriptors          3368
       DECRA   WCL,1               E3.9.1
       ACOMPC  WCL,0,,,LNKF8       E3.9.1
LNKF7  GETD    ZPTR,ZCL,TCL        Get data type required               3369
       VEQLC   ZPTR,0,,LNKF6       Check for possible conversion        3370
       VEQL    ZPTR,XPTR,,LNKF6    Skip if data types the same          3371
       SETAV   DTCL,XPTR           Data type of argument                3372
       MOVV    DTCL,ZPTR           Data type required                   3373
       DEQL    DTCL,VIDTP,,LNKVI   STRING-INTEGER                       3374
       DEQL    DTCL,IVDTP,,LNKIV   INTEGER-STRING                       3375
       DEQL    DTCL,RIDTP,,LNKRI   REAL-INTEGER                         3376
       DEQL    DTCL,IRDTP,,LNKIR   INTEGER-REAL                         3377
       DEQL    DTCL,RVDTP,,LNKRV   REAL-STRING                          3378
       DEQL    DTCL,VRDTP,INTR1,LNKVR                                   3379
*                                  STRING-REAL                          3380
LNKIV  RCALL   XPTR,GNVARI,XPTR,LNKF6                                   3381
*                                  Convert INTEGER to STRING            3382
*_
LNKRI  RLINT   XPTR,XPTR,INTR1,LNKF6                                    3384
*                                  Convert REAL to INTEGER              3385
*_
LNKIR  INTRL   XPTR,XPTR           Convert INTEGER to REAL              3387
       BRANCH  LNKF6                                                    3388
*_
LNKVR  LOCSP   XSP,XPTR            Get specifier                        3390
       SPCINT  XPTR,XSP,,LNKIR     Convert STRING to INTEGER            3391
       SPREAL  XPTR,XSP,INTR1,LNKF6                                     3392
*                                  Convert STRING to REAL               3393
*_
LNKRV  REALST  XSP,XPTR                                                 3395
       RCALL   XPTR,GENVAR,XSPPTR,LNKF6                                 3396
*_
LNKVI  LOCSP   XSP,XPTR            Get specifier                        3398
       SPCINT  XPTR,XSP,,LNKF6     Convert to INTEGER                   3399
       SPREAL  XPTR,XSP,INTR1,LNKRI                                     3400
*                                  Convert STRING to REAL               3401
LNKF6  INCRA   TCL,DESCR           Increment offset                     3402
       PUSH    XPTR                Save argument                        3403
LNKF8  DECRA   XCL,1               E3.9.1
       ACOMPC  XCL,0,LNKF1         E3.9.1
       GETDC   WPTR,YCL,0          Get procedure descriptor             3406
       SETAV   WPTR,WPTR           Get argument count required          3407
LNKF4  ACOMPC  WCL,0,,LNKF5,LNKF5  E3.9.1
       PUSH    NULVCL              E3.9.1
       DECRA   WCL,1               Decrement argument count             3415
       BRANCH  LNKF4               Continue                             3416
*_
LNKF5  GETSIZ  WCL,ZCL             Get size of definition block         3418
       SUM     XPTR,ZCL,WCL        Compute pointer to end               3419
       GETDC   ZPTR,XPTR,0         Get data target descriptor           3420
       GETDC   ZCL,ZCL,DESCR       Get function address                 3421
       INCSP   YPTR,2*DESCR        Get pointer to argument list         3422
* The following code inverts argument list order because native stack
* Would be better to invert argument list in place. ####
       PUSH    (WPTR,XPTR,YPTR,ZPTR)
*####  SETAA   ZPTR,STACK          set ZPTR to low address in work space
       DUMPDA  ZPTR                #### why "STACK" ? or STACK + 1
LNKIAL ACOMPC  WPTR,0,,LNKNAL,LNKNAL Skip if no arguments
       GETSTD  XPTR,YPTR,0
       PUTDC   ZPTR,DESCR,XPTR
       DECRA   WPTR,DESCR
       INCRA   ZPTR,DESCR
       INCSP   YPTR,DESCR
       BRANCH  LNKIAL
LNKNAL POP     (ZPTR,YPTR,XPTR,WPTR)
*####  SETAA   YPTR,STACK+1        #### why stack+1????
* End of argument list inverter
* ZPTR=desired type
* YPTR=descriptor list for arguments
* WPTR=number of arguments
* ZCL=routine address
       LINK    ZPTR,YPTR,WPTR,ZCL,FAIL                                  3423
*                                  Link to external function            3424
       VEQLC   ZPTR,L,RTZPTR       Check for linked string              3425
*      GETSPC  ZSP,ZPTR,0          Get specifier (see link.inc)
       BRANCH  GENVRZ              Go generate variable                 3427
*_
*---------------------------------------------------------------------*
       TITLE   'Arrays, Tables, and Defined Data Objects'               3430
*
*      ARRAY(P,V)                                                       3432
*
ARRAY  PROC    ,                   ARRAY(P,V)                           3434
       RCALL   XPTR,VARVAL,,FAIL   Get prototype                        3435
       PUSH    XPTR                Save prototype                       3436
       RCALL   TPTR,ARGVAL,,FAIL   Get initial value for array elements 3437
       POP     XPTR                Restore prototype                    3438
       SETAC   ARRMRK,0            Clear prototype analysis switch      3439
       MOVD    WCL,ZEROCL          Initialize dimensionality to zero    3440
       MOVD    XCL,ONECL           Initialize size to one               3441
       LOCSP   XSP,XPTR            Get specifier to prototype           3442
       PUSH    XPTR                Save prototype for later insertion   3443
ARRAY1 STREAM  YSP,XSP,NUMBTB,PROTER,ARROT1 E3.5.1
       SPCINT  YCL,YSP,PROTER      Convert string to integer            3446
       SELBRA  STYPE,(,ARRAY3)     Branch on colon or comma             3447
       FSHRTN  XSP,1               Delete colon                         3448
       STREAM  ZSP,XSP,NUMBTB,PROTER,ARROT2                             3449
       SPCINT  ZCL,ZSP,PROTER      Convert upper bound to integer       3450
       SELBRA  STYPE,(PROTER,ARRAY5)                                    3451
*                                  Verify break character               3452
*_
ARRAY3 ICOMPC  YCL,0,,PROTER,PROTER                                     3454
*                                  Single number must be positive       3455
       MOVD    ZCL,YCL             Move to copy                         3456
       SETAC   YCL,1               Set lower bound to default of one    3457
       BRANCH  ARRAY6                                                   3458
*_
ARRAY5 SUBTRT  ZCL,ZCL,YCL         Compute difference                   3460
       SUM     ZCL,ZCL,ONECL       Add one                              3461
       ICOMPC  ZCL,0,,,PROTER
ARRAY6 SETVA   YCL,ZCL             Insert width of dimension            3463
       PUSH    YCL                 Save dimension information           3464
       MULT    XCL,XCL,ZCL,PROTER  Compute size of array to this point  3465
       INCRA   WCL,1               Increase count of dimensions         3466
       IEQLC   ARRMRK,0,ARRAY7     E3.5.1
       FSHRTN  XSP,1               Remove break character               3467
       BRANCH  ARRAY1                                                   3468
*_
ARROT1 SETAC   ARRMRK,1            On run out, mark end of prototype    3470
       SPCINT  YCL,YSP,PROTER,ARRAY3                                    3471
*                                  Convert string to integer            3472
*_
ARROT2 SETAC   ARRMRK,1            On run out, mark end of prototype    3474
       SPCINT  ZCL,ZSP,PROTER,ARRAY5                                    3475
*                                  Convert string to integer            3476
*_
ARRAY7 SUM     ZCL,XCL,WCL         Add dimensionality to array size     3478
       INCRA   ZCL,2               Add two for heading information      3479
       MULTC   ZCL,ZCL,DESCR       Convert to address units             3480
       ICOMP   ZCL,SIZLMT,SIZERR,SIZERR
       SETVC   ZCL,A               Insert ARRAY data type               3481
       RCALL   ZPTR,BLOCK,ZCL      Allocate block for array structure   3482
       MOVD    XPTR,ZPTR           Save copy                            3483
       SUM     WPTR,XPTR,ZCL       Get pointer to last descriptor       3484
       PUTDC   ZPTR,2*DESCR,WCL    Insert dimensionality                3485
       INCRA   XPTR,DESCR          Update working pointer               3486
ARRAY8 INCRA   XPTR,DESCR          Update working pointer for another   3487
       POP     YPTR                Restore index pair                   3488
       PUTDC   XPTR,DESCR,YPTR     Insert in structure                  3489
       DECRA   WCL,1               Decrement dimensionality             3490
       ACOMPC  WCL,0,ARRAY8,ARRFIL Check for last one                   3491
ARRAY9 PUTDC   XPTR,DESCR,TPTR     Insert initial value                 3492
ARRFIL INCRA   XPTR,DESCR          Update working pointer               3493
       ICOMP   XPTR,WPTR,INTR10,,ARRAY9
*                                  Check for end                        3495
       POP     WPTR                RESTORE PROTOTYPE            E3.10.1
       PUTDC   ZPTR,DESCR,WPTR     RETURN POINTER TO ARRAY      E3.10.1
       RRTURN  ZPTR,3              Return pointer to array structure
*_
*---------------------------------------------------------------------*
*
*      TABLE(N,M)                                                       3502
*
ASSOC  PROC    ,                   TABLE(N,M)                           3504
       RCALL   XPTR,INTVAL,,FAIL   Get table size                       3505
       PUSH    XPTR                Save size                            3506
       RCALL   WPTR,INTVAL,,FAIL   Get secondary allocation             3507
       POP     XPTR                Restore size                         3508
       ICOMPC  XPTR,0,ASSOC1,,LENERR
       SETAC   XPTR,EXTSIZ                                              3510
ASSOC1 INCRI   XPTR,1              E3.2.3
       MULTC   XPTR,XPTR,2*DESCR   E3.2.3
       ICOMP   XPTR,SIZLMT,SIZERR,SIZERR E3.10.4
       ICOMPC  WPTR,0,ASSOC4,,LENERR
       SETAC   WPTR,EXTSIZ                                              3513
ASSOC4 INCRI   WPTR,1              E3.2.3
       MULTC   WPTR,WPTR,2*DESCR   E3.2.3
       ICOMP   WPTR,SIZLMT,SIZERR,SIZERR E3.10.4
       SETVC   XPTR,T              E3.2.3
*
ASSOCE PROC    ASSOC               E3.2.3
       RCALL   ZPTR,BLOCK,XPTR     E3.2.3
       PUTD    ZPTR,XPTR,ONECL     E3.2.3
       DECRA   XPTR,DESCR          E3.2.3
       PUTD    ZPTR,XPTR,WPTR      E3.2.3
ASSOC2 DECRA   XPTR,2*DESCR        E3.2.3
       PUTD    ZPTR,XPTR,NULVCL    E3.2.3
       IEQLC   XPTR,DESCR,ASSOC2,RTZPTR E3.2.3
*_
*---------------------------------------------------------------------*
*
*      DATA(P)                                                          3532
*
DATDEF PROC    ,                   DATA(P)                              3534
       RCALL   XPTR,VARVAL,,FAIL   Get prototype                        3535
EXPERIM1 LHERE ,                   From EXPERIMENT ####
       SETAC   DATACL,0            Initialize prototype switch          3536
       LOCSP   XSP,XPTR            Get specifier                        3537
       STREAM  YSP,XSP,VARATB,PROTER,PROTER                             3538
*                                  Break out data type name             3539
       IEQLC   STYPE,LPTYP,PROTER  Verify left parenthesis
       RCALL   XPTR,GENVAR,(YSPPTR)                                     3541
*                                  Generate variable for name           3542
       RCALL   ZCL,FINDEX,(XPTR)   Find function descriptor             3543
       INCRV   DATSEG,1            Increment data type code             3544
       VEQLC   DATSEG,DATSIZ,,INTR27                                    3545
*                                  Check against limit                  3546
       MOVD    YCL,ZEROCL          Initialize count of fields           3547
       RCALL   DTATL,AUGATL,(DTATL,DATSEG,XPTR)                         3548
*                                  Augment data type pair list          3549
       PSTACK  WPTR                Post stack position                  3550
       PUSH    (DATSEG,XPTR)       Save code and name                   3551
DATA3  FSHRTN  XSP,1               Delete break character               3552
       IEQLC   DATACL,0,DAT5       Check for prototype end
       STREAM  YSP,XSP,VARATB,PROTER,PROTER                             3554
*                                  Break out field                      3555
       SELBRA  STYPE,(PROTER,,DATA6)                                    3556
DATA4  LEQLC   YSP,0,,DATA3        Check for zero length                3557
       RCALL   XPTR,GENVAR,YSPPTR  Generate variable                    3558
       PUSH    XPTR                Save field name                      3559
       RCALL   XCL,FINDEX,(XPTR)   Find function descriptor for field   3560
       GETDC   WCL,XCL,0           Get procedure descriptor             3561
       DEQL    WCL,FLDCL,DAT6      Check for FIELD procedure            3562
       GETDC   ZPTR,XCL,DESCR      Get field definition block           3563
       MULTC   TCL,YCL,DESCR                                            3564
       RCALL   ZPTR,AUGATL,(ZPTR,DATSEG,TCL)                            3565
DAT7   PUTDC   XCL,DESCR,ZPTR      Insert new definition block          3566
       INCRI   YCL,1
       BRANCH  DATA3               Continue                             3568
*_
DATA6  SETAC   DATACL,1            Note end of prototype analysis       3570
       BRANCH  DATA4               Join field processing                3571
*_
DAT5   LEQLC   XSP,0,PROTER        Verify prototype consumption         3573
       IEQLC   YCL,0,,PROTER       E3.1.2
       SETVA   DATCL,YCL           Insert field count for data function 3574
       PUTDC   ZCL,0,DATCL         Insert new procedure descriptor      3575
       MULTC   YCL,YCL,DESCR                                            3576
       INCRA   YCL,2*DESCR         Add two for the number and name      3577
       MOVV    YCL,DATSEG          Insert defined data code             3578
       RCALL   ZPTR,BLOCK,YCL      Allocate definition block            3579
       INCSP   WPTR,DESCR          E3.0.3
       MOVSTD  ZPTR,WPTR,YCL       Copy from stack into block
       PUTDC   ZCL,DESCR,ZPTR      Insert definition block              3581
       RRTURN  NULVCL,3            Return null string by exit 3
*_
DAT6   PUTDC   XCL,0,FLDCL         Insert FIELD procedure descriptor    3584
       RCALL   ZPTR,BLOCK,TWOCL    Allocate definition block            3585
       PUTDC   ZPTR,DESCR,DATSEG   Insert data type code                3586
       MULTC   TCL,YCL,DESCR                                            3587
       PUTDC   ZPTR,2*DESCR,TCL                                         3588
       BRANCH  DAT7                Join processing                      3589
*_
*---------------------------------------------------------------------*
*
*      PROTOTYPE(A)                                                     3593
*
PROTOT PROC    ,                   PROTOTYPE(A)
       RCALL   XPTR,ARGVAL,,FAIL   Get argument                         3596
       VEQLC   XPTR,A,NONARY       Verify ARRAY                         3597
       GETDC   ZPTR,XPTR,DESCR     Get prototype                        3598
       RRTURN  ZPTR,3              Return
*_
*---------------------------------------------------------------------*
*
*      Array and Table References                                       3603
*
ITEM   PROC    ,                   Array or table reference             3605
       SETAV   XCL,INCL            Get argument count                   3606
       DECRA   XCL,1               Skip referenced object               3607
       PUSH    XCL                 Save count                           3608
       RCALL   YCL,ARGVAL,,FAIL    Get referenced object                3609
       POP     XCL                 Restore count                        3610
       VEQLC   YCL,A,,ARYAD3       ARRAY is acceptable                  3611
       VEQLC   YCL,T,NONARY,ASSCR  TABLE is acceptable                  3612
ARYAD3 MOVD    WCL,XCL             Save copy of argument count          3613
ARYAD1 ACOMPC  XCL,0,,ARYAD2,ARYAD2                                     3614
*                                  Count down on arguments              3615
       PUSH    (XCL,WCL,YCL)       Save                                 3616
       RCALL   XPTR,INTVAL,,FAIL   Get index                            3617
       POP     (YCL,WCL,XCL)       Restore saved descriptors            3618
       PUSH    XPTR                Save index                           3619
       DECRA   XCL,1               Decrement argument count             3620
       BRANCH  ARYAD1                                                   3621
*_
ARYAD2 MOVD    ZPTR,ZEROCL         Initialize offset to zero            3623
       GETDC   ZCL,YCL,2*DESCR     Get number of dimensions             3624
       MULTC   YPTR,ZCL,DESCR      Convert to addressing units          3625
       SUM     YPTR,YCL,YPTR       Add base and offset                  3626
       INCRA   YPTR,2*DESCR        Add two for heading                  3627
ARYAD7 ACOMP   WCL,ZCL,ARGNER,ARYAD9                                    3628
*                                  Compare given and required number    3629
       PUSH    ZEROCL              If too few, supply a zero            3630
       INCRA   WCL,1               Increment and loop                   3631
       BRANCH  ARYAD7                                                   3632
*_
ARYAD9 INCRA   YCL,2*DESCR                                              3634
       GETDC   WPTR,YCL,DESCR      Get index pair                       3635
       SETAV   TPTR,WPTR           Get extent of dimension              3636
ARYA11 POP     XPTR                Get index value                      3637
       SUBTRT  XPTR,XPTR,WPTR      Compute differnece from lower bound  3638
       ICOMPC  XPTR,0,,,FAIL       If less than zero, out of bounds
       ICOMP   XPTR,TPTR,FAIL,FAIL If > extent, out of bound
       SUM     XPTR,ZPTR,XPTR      Else add to evolving sum             3641
       DECRA   ZCL,1               Decrement dimension count            3642
       ICOMPC  ZCL,0,,ARYA12       Get out if done
       INCRA   YCL,DESCR           Adjust base pointer
       GETDC   WPTR,YCL,DESCR      Get index pair                       3645
       SETAV   TPTR,WPTR           Get extent of dimension              3646
       MULTA   ZPTR,XPTR,TPTR      Multiply for next dimension          3647
       BRANCH  ARYA11              Continue with next dimension         3648
*_
ARYA12 MULTC   XPTR,XPTR,DESCR     Expand offset into addressing units  3650
       SUM     XPTR,YPTR,XPTR      Add to adjusted base                 3651
ARYA10 SETVC   XPTR,N              Insert NAME data type                3652
       BRANCH  RTXNAM              Return interior pointer              3653
*_
ASSCR  IEQLC   XCL,1,ARGNER,       Only one argument for tables
       PUSH    YCL                 Save pointer to table
       RCALL   YPTR,ARGVAL,,FAIL   Evaluate argument of table reference
       POP     XPTR
*      MOVD    YCL,XPTR            Save ptr to start of table
ASSCR5 LOCAPV  XPTR,XPTR,YPTR,,ASSCR8
*                                  Look up in this table extent
       GETSIZ  TCL,XPTR            Not found. Get size of table
       GETD    ZPTR,XPTR,TCL       Get last value entry         [PLB82]
       IEQLC   ZPTR,1,,ASSCR6      Jump if this was last extent
       MOVD    XPTR,ZPTR           No. Move to next extent
       BRANCH  ASSCR5              and search there
*_
* Here if not found
*ASSCR6 TESTFI  YCL,FRZN,,RETNUL    Return null by value if frozen
ASSCR6 LOCAPV  XPTR,XPTR,ZEROCL,ASSCR3,
*                                  Not found. Find empty slot
ASSCR8 PUTDC   XPTR,2*DESCR,YPTR   Make value entry (subscript)
       BRANCH  ARYA10              Join array reference exit
*_
ASSCR3 DECRA   TCL,DESCR           No zero entry
       GETD    WPTR,XPTR,TCL       Get expansion size
       MOVD    ZCL,XPTR            Save current extent
       RCALL   ZPTR,BLOCK,WPTR,    Get new next one
       MOVD    XPTR,WPTR           New extent's size
       RCALL   XPTR,ASSOCE,,(INTR10,INTR10)
*                                  Initialize new extent
       INCRA   TCL,DESCR
       PUTD    ZCL,TCL,XPTR        Point old extent to new one
       BRANCH  ASSCR8
*_
*---------------------------------------------------------------------*
*      Defined Object Creation                                          3685
*
DEFDAT PROC    ,                   Procedure to create defined objects  3687
       SETAV   XCL,INCL            Get given number of arguments        3688
       MOVD    WCL,XCL             Save a copy                          3689
       MOVD    YCL,INCL            Save function descriptor             3690
       PSTACK  YPTR                Post stack position                  3691
DEFD1  INCRA   OCICL,DESCR         Increment offset                     3692
       GETD    XPTR,OCBSCL,OCICL   Get object code descriptor           3693
       TESTF   XPTR,FNF,,DEFDC     Check for function
DEFD2  IEQLC   INSWQ,0,,DEFD8      Check &INPUT                         3695
       LOCAPV  ZPTR,INATL,XPTR,DEFD8                                    3696
*                                  Look for input association           3697
       GETDC   ZPTR,ZPTR,DESCR     Get association                      3698
       PUSH    (XCL,WCL,YCL,YPTR)  Save relevant descriptors            3699
       RCALL   XPTR,PUTIN,(ZPTR,XPTR),FAIL                              3700
       POP     (YPTR,YCL,WCL,XCL)  Restore relevant descriptors         3701
       BRANCH  DEFD3               Join main processing                 3702
*_
DEFD8  GETDC   XPTR,XPTR,DESCR     Get value                            3704
DEFD3  PUSH    XPTR                Save value                           3705
       DECRA   XCL,1               Decrement argument count             3706
       ACOMPC  XCL,0,DEFD1,,INTR10 Check for end                        3707
       GETDC   XCL,YCL,0           Get procedure descriptor             3708
       SETAV   XCL,XCL             Get number of arguments expected     3709
DEFD4  ACOMP   WCL,XCL,DEFD5,DEFD5 Compare given with expected          3710
       PUSH    NULVCL              Save null for omitted argument       3711
       INCRA   WCL,1               Increment count                      3712
       BRANCH  DEFD4               Continue                             3713
*_
DEFD5  GETDC   WCL,YCL,DESCR       Get definition block                 3715
       MULTC   XCL,XCL,DESCR                                            3716
       MOVV    XCL,WCL             Insert data type code                3717
       RCALL   ZPTR,BLOCK,XCL      Allocate block for data object       3718
       INCSP   YPTR,DESCR          Adjust stack position                3719
       MOVSTD  ZPTR,YPTR,XCL       Move values into block
       RRTURN  ZPTR,3              Return new object
*_
DEFDC  PUSH    (XCL,WCL,YCL,YPTR)  Save relevant descriptors            3723
       RCALL   XPTR,INVOKE,(XPTR),(FAIL,DEFDN)                          3724
       POP     (YPTR,YCL,WCL,XCL)  Restore relevant descriptors         3725
       BRANCH  DEFD3               Join main processing                 3726
*_
DEFDN  POP     (YPTR,YCL,WCL,XCL)  Restore relevant descriptors         3728
       BRANCH  DEFD2               Join main processing                 3729
*_
*---------------------------------------------------------------------*
*
*      Fields of Defined Data Objects                                   3733
*
FIELD  PROC    ,                   Field function procedure             3735
       PUSH    INCL                Save function descriptor             3736
       RCALL   XPTR,ARGVAL,,FAIL   Get value                            3737
       DEQL    XPTR,NULVCL,,NONAME Check for null value                 3738
       POP     YCL                 Restore function descriptor          3739
       VEQLC   XPTR,I,FIELD1       Check for INTEGER                    3740
       RCALL   XPTR,GNVARI,XPTR    Convert INTEGER to STRING            3741
FIELD1 MOVV    DT1CL,XPTR          Set up data type                     3742
       GETDC   YPTR,YCL,DESCR      Get definition block                 3743
       LOCAPT  ZCL,YPTR,DT1CL,INTR1                                     3744
*                                  Look for data type offset            3745
       GETDC   ZCL,ZCL,2*DESCR     Get offset                           3746
       SUM     XPTR,XPTR,ZCL       Compute field position               3747
       SETVC   XPTR,N              Insert NAME data type                3748
       BRANCH  RTXNAM              Return name                          3749
*_
*---------------------------------------------------------------------*
       TITLE   'Input and Output'                                       3752
*
*      INPUT(V,U,L,NAME,ATTR)
*
READ   PROC    ,                   INPUT(V,U,L,NAME,ATTR)               3756
       RCALL   XPTR,IND,,FAIL      Get variable                         3757
       PUSH    XPTR                Save variable                        3758
       RCALL   YPTR,INTVAL,,FAIL   Get unit                             3759
       PUSH    YPTR                Save unit                            3760
       RCALL   ZPTR,INTVAL,,FAIL   Get length                           3761
       PUSH    ZPTR                Save file length
       RCALL   WPTR,VARVAL,,FAIL   Get file name
       PUSH    WPTR
       RCALL   VPTR,VARVAL,,FAIL   Get file attributes
       POP     (WPTR,ZPTR,YPTR,XPTR) Restore unit var len
*                                  Check for defaulted unit             3764
       ICOMPC  YPTR,0,,READ5,UNTERR 0=Default to 5
       ICOMPC  YPTR,MXUNIT,UNTERR  Make sure not too high
READ6  IEQLC   WPTR,0,,READ9       Check if specified name              3765
       LOCSP   XSP,WPTR            Locate specifier
       LEQLC   XSP,0,,READ9        Check for null string
       IEQLC   VPTR,0,,READNA      Check if attributes given
       LOCSP   VSP,VPTR
       LEQLC   VSP,0,,READNA
READAN FILNAMI YPTR,XSP,VSP,RDFAIL Set file name for unit
READ9  ICOMPC  ZPTR,0,READ2,,LENERR
*                                  Check for defaulted length           3766
       LOCAPT  TPTR,INSATL,YPTR,READ4                                   3767
*                                  Look for default length              3768
READ3  LOCAPV  ZPTR,INATL,XPTR,READ1                                    3769
*                                  Look for existing association        3770
       PUTDC   ZPTR,DESCR,TPTR     Insert input block                   3771
       RRTURN  NULVCL,3            Return null string by exit 3
READNA SETSP   VSP,ZEROSP          Set to null string
       BRANCH  READAN
RDFAIL BRANCH  FAIL
*_                                 Add new association pair             3773
READ1  RCALL   INATL,AUGATL,(INATL,TPTR,XPTR),RETNUL                    3774
*_
READ4  MOVD    ZPTR,DFLSIZ         Set standard default                 3776
READ2  RCALL   TPTR,BLOCK,IOBLSZ   Allocate block                       3777
       PUTDC   TPTR,DESCR,YPTR     Insert unit                          3778
       PUTDC   TPTR,2*DESCR,ZPTR   Insert format                        3779
       BRANCH  READ3               Rejoin processing                    3780
*_
READ5  SETAC   YPTR,UNITI          Set up default unit                  3782
       BRANCH  READ6               Join processing                      3783
*_
*---------------------------------------------------------------------*
*
*      OUTPUT(V,U,F,NAME,ATTR)
*
PRINT  PROC    ,                   OUTPUT(V,U,F,NAME,ATTR)              3789
       RCALL   XPTR,IND,,FAIL      Get variable                         3790
       PUSH    XPTR                Save variable                        3791
       RCALL   YPTR,INTVAL,,FAIL   Get unit                             3792
       PUSH    YPTR                Save unit                            3793
       RCALL   ZPTR,VARVAL,,FAIL   Get format                           3794
       PUSH    ZPTR                Save format
       RCALL   WPTR,VARVAL,,FAIL   Get file name
       PUSH    WPTR
       RCALL   VPTR,VARVAL,,FAIL   Get file attributes
       POP     (WPTR,ZPTR,YPTR,XPTR) Restore
       ICOMPC  YPTR,0,,PRINT5,UNTERR Check for defaulted unit
       ICOMPC  YPTR,MXUNIT,UNTERR  Make sure not too high
PRINT6 IEQLC   WPTR,0,,PRINT9      Check if specified name              3797
       LOCSP   XSP,WPTR            Locate specifier
       LEQLC   XSP,0,,PRINT9
       IEQLC   VPTR,0,,PRNTNA      Check if attributes given
       LOCSP   VSP,VPTR
       LEQLC   VSP,0,,PRNTNA
PRNTAN FILNAMO YPTR,XSP,VSP,PRFAIL Set file name for unit
PRINT9 IEQLC   ZPTR,0,PRINT2       Check for defaulted format
       LOCAPT  TPTR,OTSATL,YPTR,PRINT4                                  3798
*                                  Insert length                        3799
PRINT3 LOCAPV  ZPTR,OUTATL,XPTR,PRINT1                                  3800
*                                  Look for output association          3801
       PUTDC   ZPTR,DESCR,TPTR     Insert output block                  3802
       RRTURN  NULVCL,3            Return null string by exit
PRNTNA SETSP   VSP,ZEROSP          Say no attributes given
       BRANCH  PRNTAN
PRFAIL BRANCH  FAIL
*_
PRINT1 RCALL   OUTATL,AUGATL,(OUTATL,TPTR,XPTR),RETNUL                  3805
*                                  Add new association pair             3806
*_
PRINT4 MOVD    ZPTR,DFLFST         Set up standard default              3808
PRINT2 RCALL   TPTR,BLOCK,IOBLSZ   Allocate block                       3809
       PUTDC   TPTR,DESCR,YPTR     Insert unit                          3810
       PUTDC   TPTR,2*DESCR,ZPTR   Insert format                        3811
       BRANCH  PRINT3              Rejoin processing                    3812
*_
PRINT5 SETAC   YPTR,UNITO          Set default unit                     3814
       BRANCH  PRINT6              Join processing                      3815
*_
*---------------------------------------------------------------------*
*
*      BACKSPACE(U), ENDFILE(U), and REWIND(U)                          3819
*
BKSPCE PROC    ,                   BACKSPACE(N)                         3821
       SETAC   SCL,1               Indicate backspace                   3822
       BRANCH  IOOP                                                     3823
*_
ENFILE PROC    ,                   ENDFILE(N)                           3825
       SETAC   SCL,2               Indicate end of file                 3826
       BRANCH  IOOP                                                     3827
*_
REWIND PROC    ,                   REWIND(N)                            3829
       SETAC   SCL,3               Indicate rewind                      3830
IOOP   PUSH    SCL                 Push indicator                       3831
       RCALL   XCL,INTVAL,,FAIL    Evaluate integer argument            3832
       ICOMPC  XCL,0,,UNTERR,UNTERR
       ICOMPC  XCL,MXUNIT,UNTERR   Make sure not too high
*                                  Reject negative or zero              3834
       POP     SCL                 Restore indicator                    3835
       SELBRA  SCL,(,EOP,ROP)      Select operation                     3836
       BKSPCE  XCL                 Backspace unit                       3837
       RRTURN  NULVCL,3            Return null string by exit 3
*_
EOP    ENFILE  XCL                 End file unit                        3840
       RRTURN  NULVCL,3            Return null string by exit 3
*_
ROP    SEEK    XCL,ZEROCL,ZEROCL,WCL,COMP5,RETNUL Rewind unit
*_
*---------------------------------------------------------------------*
*
*      DETACH(N)                                                        3848
*
DETACH PROC    ,                   DETACH(N)                            3850
       RCALL   XPTR,IND,,FAIL      Get name of variable                 3851
       LOCAPV  ZPTR,INATL,XPTR,DTCH1                                    3852
*                                  Look for input association           3853
       PUTDC   ZPTR,DESCR,ZEROCL   Delete association if there is one   3854
       PUTDC   ZPTR,2*DESCR,ZEROCL Clear association pointer also       3855
DTCH1  LOCAPV  ZPTR,OUTATL,XPTR,RETNUL                                  3856
*                                  Look for output association          3857
       PUTDC   ZPTR,DESCR,ZEROCL   Delete association if there is one   3858
       PUTDC   ZPTR,2*DESCR,ZEROCL Clear association pointer also       3859
       RRTURN  NULVCL,3            Return null string by exit 3
*_
*---------------------------------------------------------------------*
*
*      Input Procedure                                                  3864
*
PUTIN  PROC    ,                   Input procedure                      3866
       POP     (IO1PTR,IO2PTR)     Restore block and variable           3867
       GETDC   IO3PTR,IO1PTR,DESCR Get unit                             3868
       GETDC   IO1PTR,IO1PTR,2*DESCR                                    3869
*                                  Get length                           3870
       RCALL   IO4PTR,CONVAR,(IO1PTR)                                   3872
*                                  Get space for string                 3873
       LOCSP   IOSP,IO4PTR         Get specifier                        3874
       INCRI   RSTAT,1             Increment count of reads
       STRDNP  IOSP,IO3PTR,FAIL,COMP5,DIRENTRY
*                               Perform read with no buffer pad
       IEQLC   TRIMCL,0,,PUTIN1    Check &TRIM
       TRIMSP  IOSP,ZEROSP,ZEROCL  Trim string
PUTIN1 GETLG   IO1PTR,IOSP         Get length
       ICOMP   IO1PTR,MLENCL,INTR8 E3.9.2
       VEQLC   IO2PTR,K,,PUTIN3    CHECK FOR KEYWORD            E3.10.2
       RCALL   IO1PTR,GNVARS,IO1PTR E3.9.2
*                                  Form variable for string             3882
PUTIN2 PUTDC   IO2PTR,DESCR,IO1PTR E3.10.2
       RRTURN  IO1PTR,2            Return value                         3884
PUTIN3 LOCSP   XSP,IO1PTR          E3.10.2
       SPCINT  IO1PTR,XSP,INTR1,PUTIN2 E3.10.2
*_
*---------------------------------------------------------------------*
*
*      Output Procedure                                                 3888
*
PUTOUT PROC    ,                   Output procedure                     3890
       POP     (IO1PTR,IO2PTR)     Restore block and value              3891
       VEQLC   IO2PTR,S,,PUTV      Is value STRING?                     3892
       VEQLC   IO2PTR,I,,PUTI      Is value INTEGER?                    3893
       RCALL   IO2PTR,DTREP,IO2PTR Get data type representation         3894
       GETSPC  IOSP,IO2PTR,0       Get specifier                        3895
       BRANCH  PUTVU               Join processing                      3896
*_
PUTV   LOCSP   IOSP,IO2PTR         Get specifier                        3898
PUTVU  STPRNT  IOKEY,IO1PTR,IOSP   Perform print                        3899
       INCRI   WSTAT,1             Increment count of writes
       RRTURN  ,1                  Return
*_
PUTI   INTSPC  IOSP,IO2PTR         Convert INTEGER to STRING            3903
       BRANCH  PUTVU               Rejoin processing                    3904
*_
*---------------------------------------------------------------------*
       TITLE   'Tracing Procedures and Functions'                       3907
*
*      TRACE(V,R,T,F)                                                   3909
*
TRACE  PROC    ,                   TRACE(V,R,T,F)                       3911
       RCALL   XPTR,IND,,FAIL      Get name of variable                 3912
       PUSH    XPTR                Save name                            3913
       RCALL   YPTR,VARVAL,,FAIL   Get trace type                       3914
       PUSH    YPTR                Save type                            3915
       RCALL   WPTR,ARGVAL,,FAIL   Get tag                              3916
       PUSH    WPTR                Save tag                             3917
       RCALL   ZPTR,VARVAL,,FAIL   Get trace function                   3918
       POP     (WPTR,YPTR,XPTR)    Restore saved arguments              3919
       DEQL    YPTR,NULVCL,TRAC5   Is type defaulted??                  3920
       MOVD    YPTR,VALTRS         Set up VALUE default                 3921
TRAC5  LOCAPV  YPTR,TRATL,YPTR,TRAC1                                    3922
*                                  Look for trace type                  3923
       GETDC   YPTR,YPTR,DESCR     Get sub pair list                    3924
TRACEP PROC    TRACE               Subentry for TRACE                   3925
       GETDC   TPTR,YPTR,DESCR     Get default function                 3926
       DEQL    ZPTR,NULVCL,,TRAC2  Check for null                       3927
       RCALL   TPTR,FINDEX,(ZPTR)  Locate function descriptor           3928
TRAC2  SETAC   XSIZ,5*DESCR        V3.7
       SETVC   XSIZ,C              Insert CODE data type                3930
       RCALL   XCL,BLOCK,XSIZ      Allocate block for code              3931
       MOVBLK  XCL,TRCBLK,XSIZ     V3.7
       SETVC   TPTR,2              Set up 2 arguments                   3933
       PUTDC   XCL,1*DESCR,TPTR    Insert function descriptor           3934
       PUTDC   XCL,3*DESCR,XPTR    Insert name to be traced             3935
       PUTDC   XCL,5*DESCR,WPTR    Insert tag                           3936
       GETDC   TPTR,YPTR,0         Make entry for proper attribute      3937
       IEQLC   TPTR,0,,TRAC4
       LOCAPT  TPTR,TPTR,XPTR,TRAC3                                     3939
*                                  Locate trace                         3940
       PUTDC   TPTR,2*DESCR,XCL    Insert new code block                3941
       RRTURN  NULVCL,3            Return null string by exit 3
*_
TRAC3  RCALL   TPTR,AUGATL,(TPTR,XPTR,XCL)                              3944
*                                  Augment pair list for new entry      3945
TRAC6  PUTDC   YPTR,0,TPTR         Link in new pair list                3946
       RRTURN  NULVCL,3            Return null string by exit 3
*_
TRAC1  DEQL    YPTR,FUNTCL,INTR30  Is type FUNCTION?                    3949
       MOVD    YPTR,TFNCLP         Set up CALL trace                    3950
       RCALL   ,TRACEP,,(INTR10,INTR10)                                 3951
*                                  Call subentry to do it               3952
       MOVD    YPTR,TFNRLP         Set up RETURN trace                  3953
       BRANCH  TRACEP              Branch to subentry to do it          3954
*_
TRAC4  RCALL   TPTR,BLOCK,TWOCL    Allocate new pair list               3956
       PUTDC   TPTR,DESCR,XPTR     Insert name to be traced             3957
       PUTDC   TPTR,2*DESCR,XCL    Insert pointer to pseudo-code        3958
       BRANCH  TRAC6                                                    3959
*_
*---------------------------------------------------------------------*
*
*      STOPTR(N,T)                                                      3963
*
STOPTR PROC    ,                   STOPTR(T,R)                          3965
       RCALL   XPTR,IND,,FAIL      Get name of variable                 3966
       PUSH    XPTR                Save name                            3967
       RCALL   YPTR,VARVAL,,FAIL   Get trace respect                    3968
       POP     XPTR                                                     3969
       DEQL    YPTR,NULVCL,STOPT2  Check for defaulted respect          3970
       MOVD    YPTR,VALTRS         Set up VALUE as default              3971
STOPT2 LOCAPV  YPTR,TRATL,YPTR,STOPT1                                   3972
*                                  Look for trace respect               3973
       GETDC   YPTR,YPTR,DESCR     Get pointer to trace list            3974
STOPTP PROC    STOPTR              Subentry for FUNCTION                3975
       GETDC   YPTR,YPTR,0         Get trace list                       3976
       LOCAPT  YPTR,YPTR,XPTR,FAIL Look for traced variable             3977
       PUTDC   YPTR,DESCR,ZEROCL   Zero the entry                       3978
       PUTDC   YPTR,2*DESCR,ZEROCL Overwrite trace                      3979
       RRTURN  NULVCL,3            Return null string by exit 3
*_
STOPT1 DEQL    YPTR,FUNTCL,INTR30  Check for FUNCTION                   3982
       MOVD    YPTR,TFNCLP         Set up CALL                          3983
       RCALL   ,STOPTP,,(FAIL,INTR10)                                   3984
*                                  Call subprocedure                    3985
       MOVD    YPTR,TFNRLP         Set up RETURN                        3986
       BRANCH  STOPTP              Branch to subentry                   3987
*_
*---------------------------------------------------------------------*
*
*      Call Tracing                                                     3991
*
FENTR  PROC    ,                   Procedure to trace on CALL           3993
       RCALL   WPTR,VARVAL,,FAIL   Get argument                         3994
FENTR3 SETLC   PROTSP,0            Clear specifier                      3995
       APDSP   PROTSP,TRSTSP       Append trace message                 3996
       INTSPC  XSP,STNOCL          Convert &STNO to string              3997
       APDSP   PROTSP,XSP          Append &STNO                         3998
       APDSP   PROTSP,COLSP        Append colon                         3999
       APDSP   PROTSP,TRLVSP       Append level message                 4000
       INTSPC  XSP,LVLCL           Convert &FNCLEVEL to string          4001
       APDSP   PROTSP,XSP          Append &FNCLEVEL                     4002
       APDSP   PROTSP,TRCLSP       Append call message                  4003
       LOCSP   XSP,WPTR            Get specifier for argument           4004
       GETLG   TCL,XSP             Get length                           4005
       ACOMPC  TCL,BUFLEN,VXOVR,VXOVR                                   4006
*                                  Check for excessively long string    4007
       APDSP   PROTSP,XSP          Append function name                 4008
       APDSP   PROTSP,LPRNSP       Append left parenthesis              4009
       SETAC   WCL,0               Set argument count to 0              4010
FNTRLP INCRA   WCL,1               Increment argument count             4011
       RCALL   ZPTR,ARGINT,(WPTR,WCL),(FENTR4,INTR10)                   4012
*                                  Get argument                         4013
       GETDC   ZPTR,ZPTR,DESCR     Get value                            4014
       VEQLC   ZPTR,S,,DEFTV       Is it STRING?                        4015
       VEQLC   ZPTR,I,,DEFTI       Is it INTEGER?                       4016
       RCALL   A2PTR,DTREP,ZPTR    Get data type representation         4017
       GETSPC  XSP,A2PTR,0         Get specifier                        4018
       GETLG   SCL,XSP             Get length                           4019
       SUM     TCL,TCL,SCL         Total length                         4020
       ACOMPC  TCL,BUFLEN,VXOVR,VXOVR                                   4021
*                                  Check for excessively long string    4022
DEFTIA APDSP   PROTSP,XSP          Append value                         4023
       BRANCH  DEFDTT              Continue with next argument          4024
*_
DEFTI  INTSPC  XSP,ZPTR            Convert INTEGER to STRING            4026
       BRANCH  DEFTIA              Rejoin processing                    4027
*_
DEFTV  LOCSP   XSP,ZPTR            Get specifier                        4029
       GETLG   SCL,XSP             Get length                           4030
       SUM     TCL,TCL,SCL         Get total length                     4031
       ACOMPC  TCL,BUFLEN,VXOVR,VXOVR                                   4032
*                                  Check for excessively long string    4033
       APDSP   PROTSP,QTSP         Append quote                         4034
       APDSP   PROTSP,XSP          Append value                         4035
       APDSP   PROTSP,QTSP         Append quote                         4036
DEFDTT APDSP   PROTSP,CMASP        Append comma                         4037
       BRANCH  FNTRLP              Continue processing                  4038
*_
FENTR4 IEQLC   WCL,1,,FENTR5       Leave paren if no arguments          4040
       SHORTN  PROTSP,1            Delete last comma                    4041
FENTR5 APDSP   PROTSP,RPRNSP       Append right parenthesis             4042
       MSTIME  ZPTR                Get time                             4043
       SUBTRT  ZPTR,ZPTR,ETMCL     Compute elapsed time                 4044
       INTSPC  XSP,ZPTR            Convert to STRING                    4045
       APDSP   PROTSP,ETIMSP       Append time message                  4046
       APDSP   PROTSP,XSP          Append time                          4047
       STPRNT  IOKEY,OUTBLK,PROTSP Print trace message                  4048
       BRANCH  RTNUL3              Return                               4049
*_
FENTR2 PROC    FENTR               Standard entry                       4051
       POP     WPTR                Restore function name                4052
       BRANCH  FENTR3                                                   4053
*_
*---------------------------------------------------------------------*
*
*      Keyword and Label Tracing                                        4060
*
KEYTR  PROC    ,                   Procedure to trace keywords          4062
       SETAC   FNVLCL,1            Set entry indicator                  4063
       RCALL   WPTR,VARVAL,,FAIL   Get keyword                          4064
       LOCSP   XSP,WPTR            Get specifier                        4065
       RCALL   YCL,KEYT,(WPTR),(INTR10,)                                4066
*                                  Get value of keyword                 4067
KEYTR3 SETLC   PROTSP,0            Clear specifier                      4068
       APDSP   PROTSP,TRSTSP       Append trace message                 4069
       INTSPC  TSP,STNOCL          Convert &STNO to string              4070
       APDSP   PROTSP,TSP          Append &STNO                         4071
       APDSP   PROTSP,COLSP        Append colon                         4072
       IEQLC   FNVLCL,0,,KEYTR4    Check entry indicator
       APDSP   PROTSP,AMPSP        Append ampersand                     4074
KEYTR4 APDSP   PROTSP,XSP          Append name of keyword               4075
       APDSP   PROTSP,BLSP         Append blank                         4076
       IEQLC   FNVLCL,0,,KEYTR5    Check entry indicator
       INTSPC  YSP,YCL             Convert keyword value to string      4078
       APDSP   PROTSP,EQLSP        Append equal sign                    4079
KEYTR5 APDSP   PROTSP,YSP          Append value                         4080
       MSTIME  YPTR                Get time                             4081
       SUBTRT  YPTR,YPTR,ETMCL     Compute elapsed time                 4082
       INTSPC  XSP,YPTR            Convert time to string               4083
       APDSP   PROTSP,ETIMSP       Append time message                  4084
       APDSP   PROTSP,XSP          Append time                          4085
       STPRNT  IOKEY,OUTBLK,PROTSP Print trace message                  4086
       BRANCH  RTN2                Return                               4087
*_
LABTR  PROC    KEYTR               Procedure to trace labels            4089
       SETAC   FNVLCL,0            Set entry indicator                  4090
       RCALL   YPTR,VARVAL,,FAIL   Get label name                       4091
       LOCSP   YSP,YPTR            Get specifier                        4092
       SETSP   XSP,XFERSP          Set up message specifier             4093
       BRANCH  KEYTR3              Join common processing               4094
*_
*---------------------------------------------------------------------*
*
*      Trace Handler                                                    4098
*
TRPHND PROC    ,                   Trace handling procedure             4100
       POP     ATPTR               Restore trace                        4101
       DECRI   TRAPCL,1            Decrement &TRACE                     4102
       PUSH    (LSTNCL,STNOCL,FRTNCL,OCBSCL,OCICL,TRAPCL,TRACL)         4103
*                                  Save system descriptors              4104
       GETDC   OCBSCL,ATPTR,2*DESCR NEW CODE BASE                       4105
*                                  Get new code base                    4106
       SETAC   OCICL,DESCR         Set up offset                        4107
       GETD    XPTR,OCBSCL,OCICL   Get function descriptor              4108
       SETAC   TRAPCL,0            Set &TRACE to 0                      4109
       SETAC   TRACL,0             Set &FTRACE to 0                     4110
       RCALL   ,INVOKE,XPTR,(,)    E3.3.1
*                                  Evaluate function                    4112
       POP     (TRACL,TRAPCL,OCICL,OCBSCL,FRTNCL,STNOCL,LSTNCL)         4113
*                                  Restore system descriptors           4114
       RRTURN  ,1                  E3.3.1
*_
*---------------------------------------------------------------------*
*
*      Value Tracing                                                    4123
*
VALTR  PROC    ,                   Tracing procedures                   4125
       SETAC   FNVLCL,1            Note entry                           4126
VALTR2 RCALL   XPTR,IND,,FAIL      Get variable to be traced            4127
       PUSH    XPTR                Save name                            4128
       RCALL   ZPTR,VARVAL,,FAIL   Get tag                              4129
       POP     XPTR                Restore variable                     4130
VALTR4 SETLC   TRACSP,0            Clear specifier                      4131
       APDSP   TRACSP,TRSTSP       Append trace message                 4132
       INTSPC  XSP,STNOCL          Convert &STNO to string              4133
       APDSP   TRACSP,XSP          Append &STNO                         4134
       APDSP   TRACSP,COLSP        Append colon                         4135
       IEQLC   FNVLCL,0,,FNEXT1    Check entry indicator
       VEQLC   XPTR,S,DEFDT        Is variable a string?                4137
VALTR3 LOCSP   XSP,XPTR            Get specifier                        4138
       GETLG   TCL,XSP             Get length                           4139
       ACOMPC  TCL,BUFLEN,VXOVR,VXOVR                                   4140
*                                  Check for excessively long name      4141
VALTR1 APDSP   TRACSP,XSP          Append name of variable              4142
       APDSP   TRACSP,BLEQSP       Append ' = '                         4143
       GETDC   YPTR,XPTR,DESCR     Get value of traced variable         4144
       VEQLC   YPTR,S,,TRV         Is it STRING?                        4145
       VEQLC   YPTR,I,,TRI         Is it INTEGER?                       4146
       RCALL   XPTR,DTREP,YPTR     Else get data type representation    4147
       GETSPC  XSP,XPTR,0          Get specifier                        4148
TRI2   APDSP   TRACSP,XSP          Append value                         4149
       BRANCH  TRPRT               Join common processing               4150
*_
TRV    LOCSP   XSP,YPTR            Get specifier                        4152
       GETLG   SCL,XSP             Get length                           4153
       SUM     TCL,TCL,SCL         Compute total length                 4154
       ACOMPC  TCL,BUFLEN,VXOVR,VXOVR                                   4155
*                                  Check for excessively long message   4156
       APDSP   TRACSP,QTSP         Append quote                         4157
       APDSP   TRACSP,XSP          Append string                        4158
       APDSP   TRACSP,QTSP         Append quote                         4159
TRPRT  MSTIME  YPTR                Get time                             4160
       SUBTRT  YPTR,YPTR,ETMCL     Compute time in interpreter          4161
       INTSPC  XSP,YPTR            Convert to STRING                    4162
       APDSP   TRACSP,ETIMSP       Append time message                  4163
       APDSP   TRACSP,XSP          Append time                          4164
       STPRNT  IOKEY,OUTBLK,TRACSP Print trace message                  4165
       BRANCH  RTNUL3              Return                               4166
*_
TRI    INTSPC  XSP,YPTR            Convert INTEGER to STRING            4168
       BRANCH  TRI2                Join processing                      4169
*_
DEFDT  LOCSP   XSP,ZPTR            Get specifier for tag                4171
       BRANCH  VALTR1              Join processing                      4172
*_
FNEXTR PROC    VALTR               Return tracing procedure             4174
       SETAC   FNVLCL,0            Note entry                           4175
       BRANCH  VALTR2              Join processing                      4176
*_
FNEXT1 APDSP   TRACSP,TRLVSP       Append level message                 4178
       MOVD    XCL,LVLCL           Copy &FNCLEVEL                       4179
       DECRA   XCL,1               Decrement                            4180
       INTSPC  XSP,XCL             Convert to STRING                    4181
       APDSP   TRACSP,XSP          Append function level                4182
       APDSP   TRACSP,BLSP         Append blank                         4183
       LOCSP   XSP,RETPCL          Get specifier for return             4184
       APDSP   TRACSP,XSP          Append return type                   4185
       APDSP   TRACSP,OFSP         Append ' OF '                        4186
       DEQL    RETPCL,FRETCL,VALTR3                                     4187
*                                  Check for FRETURN                    4188
       LOCSP   XSP,XPTR            Get specifier for function name      4189
       GETLG   TCL,XSP             Get length                           4190
       ACOMPC  TCL,BUFLEN,VXOVR,VXOVR                                   4191
*                                  Check for excessively long string    4192
       APDSP   TRACSP,XSP          Append name of function              4193
       BRANCH  TRPRT               Join common processing               4194
*_                                 FTRACE call trace                    4195
FNEXT2 PROC    VALTR               Note entry                           4196
       SETAC   FNVLCL,0            Restore function name                4197
       POP     XPTR                Join common processing               4198
       BRANCH  VALTR4                                                   4199
*_
VXOVR  OUTPUT  OUTPUT,PRTOVF       Print request too long message       4201
       BRANCH  RTNUL3              Return                               4202
*_
