*---------------------------------------------------------------------*
*
*      Unary Operator Analysis                                          1479
*
UNOP   PROC    ,                   Unary operator analysis              1481
       RCALL   ,FORWRD,,COMP3      Get to next nonblank character       1482
       SETAC   XPTR,0              Zero code tree                       1483
       IEQLC   BRTYPE,NBTYP,RTN1   Verify nonbreak
UNOPA  STREAM  XSP,TEXTSP,UNOPTB,RTXNAM,RTN1 E3.4.3
*                                  Break out unary operator             1486
       RCALL   YPTR,BLOCK,CNDSIZ   Allocate block for tree node         1487
       PUTDC   YPTR,CQDE,STYPE     Insert function descriptor
       IEQLC   XPTR,0,,UNOPB       Is tree empty
       ADDSON  XPTR,YPTR           Add new node as son                  1490
UNOPB  MOVD    XPTR,YPTR           Move to new node                     1491
       BRANCH  UNOPA               Continue                             1492
*_
*---------------------------------------------------------------------*
       TITLE   'Interpreter Executive and Control Procedures'           1495
*
*      Code Basing                                                      1497
*
BASE   PROC    ,                   Interpreter code basing procedure    1499
       SUM     OCBSCL,OCBSCL,OCICL Add offset to base                   1500
       SETAC   OCICL,0             Zero offset                          1501
       BRANCH  RTNUL3                                                   1502
*_
*---------------------------------------------------------------------*
*
*      Direct Goto                                                      1506
*
GOTG   PROC    ,                   :<X>                                 1508
       RCALL   OCBSCL,ARGVAL,,INTR5                                     1509
*                                  Get code pointer                     1510
       VEQLC   OCBSCL,C,INTR4      Must have CODE data type             1511
       SETAC   OCICL,0             Zero offset                          1512
       BRANCH  RTNUL3                                                   1513
*_
*---------------------------------------------------------------------*
*
*      Label Goto                                                       1517
*
GOTL   PROC    ,                   :(X)                                 1519
       INCRA   OCICL,DESCR         Increment offset                     1520
       GETD    XPTR,OCBSCL,OCICL   Get object code descriptor           1521
       TESTF   XPTR,FNF,,GOTLC     Test for function
GOTLV  ICOMPC  TRAPCL,0,,GOTLV1,GOTLV1                                  1523
*                                  Check &TRACE                         1524
       LOCAPT  ATPTR,TLABL,XPTR,GOTLV1                                  1525
*                                  Look for LABEL trace                 1526
       PUSH    XPTR                Save variable                        1527
       RCALL   ,TRPHND,ATPTR       E3.3.1
*                                  Perform trace                        1529
       POP     XPTR                Restore variable                     1530
GOTLV1 DEQL    XPTR,RETCL,,RTNUL6  Compare with RETURN                  1531
*_
GOTL1  DEQL    XPTR,FRETCL,,RTNUL4 Compare with FRETURN                 1534
*_
GOTL2  DEQL    XPTR,NRETCL,,RTNUL5 Compare with NRETURN                 1537
*_
GOTL3  GETDC   OCBSCL,XPTR,ATTRIB  Get object code base                 1540
       IEQLC   OCBSCL,0,,INTR4     Must not be zero
       SETAC   OCICL,0             Zero offset                          1542
       RRTURN  ,3                  Return
*_
GOTLC  RCALL   XPTR,INVOKE,XPTR,(INTR5,,INTR4) E3.10.3
*                                  Evaluate goto                        1546
       VEQLC   XPTR,S,INTR4,GOTLV  Variable must be STRING              1547
*_
*---------------------------------------------------------------------*
*
*      Internal Goto                                                    1551
*
GOTOI  PROC    ,                   Interpreter goto procedure
       INCRA   OCICL,DESCR         Increment offset                     1554
       GETD    OCICL,OCBSCL,OCICL  Get offset                           1555
       BRANCH  RTNUL3              Return                               1556
*_
*---------------------------------------------------------------------*
*
*      Statement Initialization                                         1560
*
INIT   PROC    ,                   Statement initialization procedure   1562
       MOVD    LSTNCL,STNOCL       Update &LASTNO                       1563
       INCRA   OCICL,DESCR         Increment offset                     1564
       GETD    XCL,OCBSCL,OCICL    Get statement data                   1565
       MOVA    STNOCL,XCL          Update &STNO                         1566
       SETAV   FRTNCL,XCL          Set up failure offset                1567
       ICOMP   EXNOCL,EXLMCL,EXEX,EXEX
*                                  Check &STLIMIT                       1569
       TRAPCK  ,                   Check for interrupt
       INCRI   EXNOCL,1            Increment &STCOUNT
       ICOMPC  TRAPCL,0,INITX1
       RRTURN  ,3
*                                  Check &TRACE                         1572
INITX1 LOCAPT  ATPTR,TKEYL,STCTKY,RTNUL3
       RCALL   ,TRPHND,ATPTR       E3.3.1
*                                  Perform trace                        1575
       BRANCH  RTNUL3                                                   1576
*_
*---------------------------------------------------------------------*
*
*      Basic Interpreter Procedure                                      1580
*
INTERP PROC    ,                   Interpreter core procedure           1582
       INCRA   OCICL,DESCR         Increment offset                     1583
       GETD    XPTR,OCBSCL,OCICL   Get object code descriptor           1584
       TESTF   XPTR,FNF,INTERP     Test for function
       RCALL   XPTR,INVOKE,(XPTR),(,INTERP,INTERP,RTN1,RTN2,RTN3)       1586
       MOVD    OCICL,FRTNCL        Set offset for failure               1587
       INCRI   FALCL,1             Increment &STFCOUNT
       ICOMPC  TRAPCL,0,,INTERP,INTERP
*                                  Check &TRACE                         1590
       LOCAPT  ATPTR,TKEYL,FALKY,INTERP                                 1591
       RCALL   ,TRPHND,ATPTR       E3.3.1
*                                  Perform trace                        1593
       BRANCH  INTERP                                                   1594
*_
*---------------------------------------------------------------------*
*
*      Procedure Invocation                                             1598
*
INVOKE PROC    ,                   Invokation procedure                 1600
       FUNC    INVOKE              Assember version of INVOKE
* Now handled by INVOKE function
       POP     INCL                Get function index                   1601
       GETDC   XPTR,INCL,0         Get procedure descriptor             1602
       VEQL    INCL,XPTR,INVK2     Check argument counts                1603
INVK1  LHERE   ,                                                        1604
       BRANIC  INCL,0              If equal, branch indirect
*_
INVK2  TESTF   XPTR,FNF,ARGNER,INVK1                                    1606
*                                  Check for variable argument number   1607
*_
*---------------------------------------------------------------------*
       TITLE   'Argument Evaluation Procedures'                         1610
*
*      Argument Evaluation                                              1612
*
ARGVAL PROC    ,                   Procedure to evaluate argument       1614
       INCRA   OCICL,DESCR         Increment interpreter offset         1615
       GETD    XPTR,OCBSCL,OCICL   Get argument                         1616
       TESTF   XPTR,FNF,,ARGVC     Test for function descriptor
ARGV1  IEQLC   INSWQ,0,,ARGV2      Check &INPUT                         1618
       LOCAPV  ZPTR,INATL,XPTR,ARGV2                                    1619
*                                  Look for input association           1620
       GETDC   ZPTR,ZPTR,DESCR     Get input descriptor                 1621
       RCALL   XPTR,PUTIN,(ZPTR,XPTR),(FAIL,RTXNAM)                     1622
*_
ARGVC  RCALL   XPTR,INVOKE,(XPTR),(FAIL,ARGV1,RTXNAM)                   1624
*_
ARGV2  GETDC   XPTR,XPTR,DESCR     Get value from name                  1626
       BRANCH  RTXNAM                                                   1627
*_
*---------------------------------------------------------------------*
*
*      Evaluation of Unevaluated Expressions                            1631
*
EXPVAL PROC    ,                   Procedure to evaluate expression     1633
       SETAC   SCL,1               Note procedure entrance              1634
EXPVJN POP     XPTR                Restore pointer to object code       1635
EXPVJ2 PUSH    (OCBSCL,OCICL,PATBCL,PATICL,WPTR,XCL,YCL,TCL)            1636
       PUSH    (MAXLEN,LENFCL,PDLPTR,PDLHED,NAMICL,NHEDCL)              1637
*                                  Save system state descriptors        1638
       SPUSH   (HEADSP,TSP,TXSP,XSP)                                    1639
*                                  Save system state specifiers         1640
       MOVD    OCBSCL,XPTR         Set up new code base                 1641
       SETAC   OCICL,DESCR         Initialize offset                    1642
       MOVD    PDLHED,PDLPTR       Set up new history list header       1643
       MOVD    NHEDCL,NAMICL       Set up new name list header          1644
       GETD    XPTR,OCBSCL,OCICL   Get object code descriptor           1645
       TESTF   XPTR,FNF,,EXPVC     Check for function
EXPV11 IEQLC   SCL,0,,EXPV6        Check procedure entry                1647
       IEQLC   INSWQ,0,,EXPV4      Check &INPUT
       LOCAPV  ZPTR,INATL,XPTR,EXPV4                                    1649
*                                  Look for input association           1650
       GETDC   ZPTR,ZPTR,DESCR     Get input association                1651
       RCALL   XPTR,PUTIN,(ZPTR,XPTR),(EXPV1,EXPV6)                     1652
*                                  Perform input                        1653
*_
EXPV4  GETDC   XPTR,XPTR,DESCR     Get value                            1655
EXPV6  SETAC   SCL,2               Set up exit                          1656
       BRANCH  EXPV7               Join processing                      1657
*_
EXPV9  POP     SCL                 Popoff switch                        1659
EXPV1  SETAC   SCL,1               Set new exit switch                  1660
EXPV7  SPOP    (XSP,TXSP,TSP,HEADSP)                                    1661
*                                  Restore system specifiers            1662
       POP     (NHEDCL,NAMICL,PDLHED,PDLPTR,LENFCL,MAXLEN)              1663
       POP     (TCL,YCL,XCL,WPTR,PATICL,PATBCL,OCICL,OCBSCL)            1664
*                                  Restore system descriptors           1665
       SELBRA  SCL,(FAIL,RTXNAM,RTZPTR)                                 1666
*                                  Select exit                          1667
*_
EXPVC  PUSH    SCL                 Save entrance indicator              1669
       RCALL   XPTR,INVOKE,XPTR,(EXPV9,EXPV5,)                          1670
*                                  Evaluate function                    1671
       POP     SCL                 Restore entrance indicator           1672
       IEQLC   SCL,0,EXPV6         Check entry indicator
       SETAC   SCL,3               Set exit switch                      1674
       MOVD    ZPTR,XPTR           Set up value                         1675
       BRANCH  EXPV7               Join end processing                  1676
*_
EXPV5  POP     SCL                 Restore entry indicator              1678
       BRANCH  EXPV11              Join processing with name            1679
*_
EXPEVL PROC    EXPVAL              Procedure to get expression value    1681
       SETAC   SCL,0               Set entry indicator                  1682
       BRANCH  EXPVJN              Join processing                      1683
*_
EVAL   PROC    EXPVAL              EVAL(X)                              1685
       RCALL   XPTR,ARGVAL,,FAIL   Get argument                         1686
       VEQLC   XPTR,E,,EVAL1       Is it EXPRESSION?                    1687
       VEQLC   XPTR,I,,RTXPTR      INTEGER is idempotent                1688
       VEQLC   XPTR,R,,RTXPTR      REAL is idempotent                   1689
       VEQLC   XPTR,S,INTR1        Is it STRING?                        1690
       LOCSP   XSP,XPTR            Get specifier                        1691
       LEQLC   XSP,0,,RTXPTR       E3.1.4
       SPCINT  XPTR,XSP,,RTXPTR    Convert to INTEGER                   1692
       SPREAL  XPTR,XSP,,RTXPTR    Convert to REAL                      1693
       MOVD    ZPTR,XPTR           Set up to convert to EXPRESSION      1694
       RCALL   XPTR,CONVE,,(FAIL,INTR10)                                1695
*                                  Convert to EXPRESSION                1696
EVAL1  SETAC   SCL,0               Set up entry indicator               1697
       BRANCH  EXPVJ2              Join processing                      1698
*_
*---------------------------------------------------------------------*
*
*      Evaluation of Real Argument
*
REALVAL PROC   ,                   Real argument procedure
       INCRA   OCICL,DESCR         Increment offset
       GETD    XPTR,OCBSCL,OCICL   Get object code descriptor
       TESTF   XPTR,FNF,,RELVC     Check for function
RELV1  IEQLC   INSWQ,0,,RELV3      Check &INPUT
       LOCAPV  ZPTR,INATL,XPTR,RELV3
*                                  Look for input association
       GETDC   ZPTR,ZPTR,DESCR     Get association
       RCALL   XPTR,PUTIN,(ZPTR,XPTR),FAIL
*                                  Perform input
RELV   LOCSP   XSP,XPTR            Get specifier for string
       SPREAL  XPTR,XSP,INTR1,RTXNAM
*                                  Convert to integer
*_
RELV3  GETDC   XPTR,XPTR,DESCR     Get value
RELV2  VEQLC   XPTR,R,,RTXNAM      REAL alerady
       VEQLC   XPTR,S,,RELV        STRING must be converted
       VEQLC   XPTR,I,INTR1        Error if not INTEGER
       INTRL   XPTR,XPTR           Convert to REAL and return
       RRTURN  XPTR,2
*_
RELVC  RCALL   XPTR,INVOKE,(XPTR),(FAIL,RELV1,RELV2)
*_
*---------------------------------------------------------------------*
*
*      Evaluation of Integer Argument                                   1702
*
INTVAL PROC    ,                   Integer argument procedure           1704
       INCRA   OCICL,DESCR         Increment offset                     1705
       GETD    XPTR,OCBSCL,OCICL   Get object code descriptor           1706
       TESTF   XPTR,FNF,,INTVC     Check for function
INTV1  IEQLC   INSWQ,0,,INTV3      Check &INPUT                         1708
       LOCAPV  ZPTR,INATL,XPTR,INTV3                                    1709
*                                  Look for input association           1710
       GETDC   ZPTR,ZPTR,DESCR     Get association                      1711
       RCALL   XPTR,PUTIN,(ZPTR,XPTR),FAIL                              1712
*                                  Perform input                        1713
INTV   LOCSP   XSP,XPTR            Get specifier for string             1714
       SPCINT  XPTR,XSP,INTR1,RTXNAM                                    1715
*                                  Convert to integer                   1716
*_
INTV3  GETDC   XPTR,XPTR,DESCR     Get value                            1718
INTV2  VEQLC   XPTR,I,,RTXNAM      INTEGER desired                      1719
       VEQLC   XPTR,S,,INTV        STRING must be converted
       VEQLC   XPTR,R,INTR1        REAL must be converted
       RLINT   XPTR,XPTR,FAIL,RTXNAM Convert and return
*_
INTVC  RCALL   XPTR,INVOKE,(XPTR),(FAIL,INTV1,INTV2)                    1722
*_
*---------------------------------------------------------------------*
*
*      Evaluation of Argument as Pattern                                1726
*
PATVAL PROC    ,                   Evaluate argument as pattern         1728
       INCRA   OCICL,DESCR         Increment offset                     1729
       GETD    XPTR,OCBSCL,OCICL   Get object code descriptor           1730
       TESTF   XPTR,FNF,,PATVC     Check for function descriptor
PATV1  IEQLC   INSWQ,0,,PATV2      Check &INPUT                         1732
       LOCAPV  ZPTR,INATL,XPTR,PATV2                                    1733
*                                  Look for input association           1734
       GETDC   ZPTR,ZPTR,DESCR     Get association                      1735
       RCALL   XPTR,PUTIN,(ZPTR,XPTR),(FAIL,RTXNAM)                     1736
*                                  Perform input                        1737
*_
PATVC  RCALL   XPTR,INVOKE,(XPTR),(FAIL,PATV1,PATV3)                    1739
*                                  Evaluate argument                    1740
*_
PATV2  GETDC   XPTR,XPTR,DESCR     Get value                            1742
PATV3  VEQLC   XPTR,P,,RTXNAM      Is it PATTERN?                       1743
       VEQLC   XPTR,S,,RTXNAM      Is it STRING?                        1744
       VEQLC   XPTR,I,,GENVIX      Is it INTEGER?                       1745
       VEQLC   XPTR,R,,PATVR       Is it REAL?                          1746
       VEQLC   XPTR,E,INTR1        Is it EXPRESSION?                    1747
       RCALL   TPTR,BLOCK,STARSZ   Allocate block for pattern           1748
       MOVBLK  TPTR,STRPAT,STARSZ  Copy pattern for expression          1749
       PUTDC   TPTR,4*DESCR,XPTR   Insert expression                    1750
       MOVD    XPTR,TPTR           Set up value                         1751
       BRANCH  RTXNAM              Return                               1752
*_
PATVR  REALST  XSP,XPTR            Convert REAL to STRING               1754
       RCALL   XPTR,GENVAR,XSPPTR,RTXNAM                                1755
*                                  Generate variable                    1756
*_
*---------------------------------------------------------------------*
*
*      Evaluation of Argument as String                                 1760
*
VARVAL PROC    ,                   Evaluate argument as string          1762
       INCRA   OCICL,DESCR         Increment offset                     1763
       GETD    XPTR,OCBSCL,OCICL   Get object code descriptor           1764
       TESTF   XPTR,FNF,,VARVC     Check for function
VARV1  IEQLC   INSWQ,0,,VARV4      Check &INPUT                         1766
       LOCAPV  ZPTR,INATL,XPTR,VARV4                                    1767
*                                  Look for input association           1768
       GETDC   ZPTR,ZPTR,DESCR     Get input association                1769
       RCALL   XPTR,PUTIN,(ZPTR,XPTR),(FAIL,RTXNAM)                     1770
*                                  Perform input                        1771
*_
VARV4  GETDC   XPTR,XPTR,DESCR     Get value                            1773
VARV2  VEQLC   XPTR,S,,RTXNAM      Is it STRING?                        1774
       VEQLC   XPTR,I,,GENVIX      Convert INTEGER to STRING
       VEQLC   XPTR,R,INTR1,GENVRX Convert REAL to STRING
*_
VARVC  RCALL   XPTR,INVOKE,(XPTR),(FAIL,VARV1,VARV2)                    1777
*                                  Evaluate function                    1778
*_
*---------------------------------------------------------------------*
*
*      Evaluation of Argument Pair                                      1782
*
XYARGS PROC    ,                   Procedure to evaluate argument pair  1784
       SETAC   SCL,0               Note first argument                  1785
XYN    INCRA   OCICL,DESCR         Increment offset                     1786
       GETD    YPTR,OCBSCL,OCICL   Get object code descriptor           1787
       TESTF   YPTR,FNF,,XYC       Check for function
XY1    IEQLC   INSWQ,0,,XY2        Check &INPUT                         1789
       LOCAPV  ZPTR,INATL,YPTR,XY2 Look for input association           1790
       GETDC   ZPTR,ZPTR,DESCR     Get input association                1791
       RCALL   YPTR,PUTIN,(ZPTR,YPTR),FAIL                              1792
*                                  Perform input                        1793
XY3    IEQLC   SCL,0,RTN2          Check for completion                 1794
       SETAC   SCL,1               Note second argument
       MOVD    XPTR,YPTR           Set up first argument                1796
       BRANCH  XYN                 Go around again                      1797
*_
XY2    GETDC   YPTR,YPTR,DESCR     Get value                            1799
       BRANCH  XY3                 Continue                             1800
*_
XYC    PUSH    (SCL,XPTR)          Save indicator and argument          1802
       RCALL   YPTR,INVOKE,(YPTR),(FAIL,XY4)                            1803
*                                  Evaluate function                    1804
       POP     (XPTR,SCL)          Restore indicator and argument       1805
       BRANCH  XY3                 Join processing                      1806
*_
XY4    POP     (XPTR,SCL)          Restore indicator and argument       1808
       BRANCH  XY1                 Join processing                      1809
*_
*---------------------------------------------------------------------*
       TITLE   'Arithmetic Operations, Predicates, and Functions'       1812
ADDLBL PROC    ,                   X + Y
       SETAC   SCL,1                                                    1814
       BRANCH  ARITH                                                    1815
*_
DIVLBL PROC    ADD                 X / Y
       SETAC   SCL,2                                                    1818
       BRANCH  ARITH                                                    1819
*_
EXPLBL PROC    ADD                 X ** Y and X ^ Y and X ! Y ####
       SETAC   SCL,3                                                    1822
       BRANCH  ARITH                                                    1823
*_
MPY    PROC    ADD                 X * Y                                1825
       SETAC   SCL,4                                                    1826
       BRANCH  ARITH                                                    1827
*_
SUBLBL PROC    ADD                 X - Y
       SETAC   SCL,5                                                    1830
       BRANCH  ARITH                                                    1831
*_
EQLBL  PROC    ADD                 EQ(X,Y)
       SETAC   SCL,6                                                    1834
       BRANCH  ARITH                                                    1835
*_
GELBL  PROC    ADD                 GE(X,Y)
       SETAC   SCL,7                                                    1838
       BRANCH  ARITH                                                    1839
*_
GTLBL  PROC    ADD                 GT(X,Y)
       SETAC   SCL,8                                                    1842
       BRANCH  ARITH                                                    1843
*_
LELBL  PROC    ADD                 LE(X,Y)
       SETAC   SCL,9                                                    1846
       BRANCH  ARITH                                                    1847
*_
LTLBL  PROC    ADD                 LT(X,Y)
       SETAC   SCL,10                                                   1850
       BRANCH  ARITH                                                    1851
*_
NELBL  PROC    ADD                 NE(X,Y)
       SETAC   SCL,11                                                   1854
       BRANCH  ARITH                                                    1855
*_
REMDR  PROC    ADD                 REMDR(X,Y)                           1857
       SETAC   SCL,12                                                   1858
       BRANCH  ARITH                                                    1859
*_
MAXFF  PROC    MAX                 MAX(X,Y)
       SETAC   SCL,13
       BRANCH  ARITH
*_
MINFF  PROC    MIN                 MIN(X,Y)
       SETAC   SCL,14
       BRANCH  ARITH
*_
ARITH  PUSH    SCL                 Save procedure switch                1861
       RCALL   ,XYARGS,,FAIL       Evaluate arguments                   1862
       POP     SCL                 Restore procedure switch             1863
       SETAVO  DTCL,XPTR           Set up data type pair
       MOVV0   DTCL,YPTR
       DEQL    DTCL,IIDTP,,ARTHII  INTEGER-INTEGER                      1866
       DEQL    DTCL,IVDTP,,ARTHIV  INTEGER-STRING                       1867
       DEQL    DTCL,VIDTP,,ARTHVI  STRING-INTEGER                       1868
       DEQL    DTCL,VVDTP,,ARTHVV  STRING-STRING                        1869
       DEQL    DTCL,RRDTP,,ARTHRR  REAL-REAL                            1870
       DEQL    DTCL,IRDTP,,ARTHIR  INTEGER-REAL                         1871
       DEQL    DTCL,RIDTP,,ARTHRI  REAL-INTEGER                         1872
       DEQL    DTCL,VRDTP,,ARTHVR  STRING-REAL                          1873
       DEQL    DTCL,RVDTP,INTR1,ARTHRV                                  1874
*                                  REAL-STRING                          1875
*_
ARTHII SELBRA SCL,(AD,DV,EX,MP,SB,CEQ,CGE,CGT,CLE,CLT,CNE,RM,MXFI,MNFI)
*_
ARTHVI LOCSP   XSP,XPTR            Get specifier                        1879
       SPCINT  XPTR,XSP,,ARTHII    Convert string to integer            1880
       SPREAL  XPTR,XSP,INTR1,ARTHRI                                    1881
*                                  Convert to real if possible          1882
*_
ARTHIV LOCSP   YSP,YPTR            Get specifier                        1884
       SPCINT  YPTR,YSP,,ARTHII    Convert string to integer            1885
       SPREAL  YPTR,YSP,INTR1,ARTHIR                                    1886
*                                  Convert to real if possible          1887
*_
ARTHVV LOCSP   XSP,XPTR            Get specifier                        1889
       SPCINT  XPTR,XSP,,ARTHIV    Convert string to integer            1890
       SPREAL  XPTR,XSP,INTR1,ARTHRV                                    1891
*                                  Convert to real if possible          1892
*_
ARTHRR SELBRA SCL,(AR,DR,EXR,MR,SR,REQ,RGE,RGT,RLE,RLT,RNE,INTR1,MXFR,MNFR)
*_
ARTHIR INTRL   XPTR,XPTR           Convert integer to real              1896
       BRANCH  ARTHRR                                                   1897
*_
ARTHRI INTRL   YPTR,YPTR           Convert integer to real              1899
       BRANCH  ARTHRR                                                   1900
*_
ARTHVR LOCSP   XSP,XPTR            Get specifier                        1902
       SPCINT  XPTR,XSP,,ARTHIR    Convert string to integer            1903
       SPREAL  XPTR,XSP,INTR1,ARTHRR                                    1904
*                                  Convert to real if possible          1905
*_
ARTHRV LOCSP   YSP,YPTR                                                 1907
       SPCINT  YPTR,YSP,,ARTHRI    Convert string to integer            1908
       SPREAL  YPTR,YSP,INTR1,ARTHRR                                    1909
*                                  Convert to real if possible          1910
*_
AD     SUM     ZPTR,XPTR,YPTR,AERROR,ARTN                               1912
*_
DV     DIVIDE  ZPTR,XPTR,YPTR,AERROR2,ARTN                              1914
AERROR2 SETAC   ERRTYP,2           Arithmetic error
       BRANCH  FTLTST                                                   5141
*_
EX     EXPINT  ZPTR,XPTR,YPTR,AERROR,ARTN                               1916
*_
MP     MULT    ZPTR,XPTR,YPTR,AERROR,ARTN                               1918
*_
SB     SUBTRT  ZPTR,XPTR,YPTR,AERROR,ARTN                               1920
*_
CEQ    AEQL    XPTR,YPTR,FAIL,RETNUL                                    1922
*_
CGE    ICOMP   XPTR,YPTR,RETNUL,RETNUL,FAIL                             1924
*_
CGT    ICOMP   XPTR,YPTR,RETNUL,FAIL,FAIL                               1926
*_
CLE    ICOMP   XPTR,YPTR,FAIL,RETNUL,RETNUL                             1928
*_
CLT    ICOMP   XPTR,YPTR,FAIL,FAIL,RETNUL                               1930
*_
CNE    AEQL    XPTR,YPTR,RETNUL,FAIL                                    1932
*_
AR     ADREAL  ZPTR,XPTR,YPTR,AERROR,ARTN                               1934
*_
DR     DVREAL  ZPTR,XPTR,YPTR,AERROR,ARTN                               1936
*_
EXR    EXREAL  ZPTR,XPTR,YPTR,AERROR,ARTN                               1938
*_
MR     MPREAL  ZPTR,XPTR,YPTR,AERROR,ARTN                               1940
*_
SR     SBREAL  ZPTR,XPTR,YPTR,AERROR,ARTN                               1942
*_
REQ    RCOMP   XPTR,YPTR,FAIL,RETNUL,FAIL,NANERR
*_
RGE    RCOMP   XPTR,YPTR,RETNUL,RETNUL,FAIL,NANERR
*_
RGT    RCOMP   XPTR,YPTR,RETNUL,FAIL,FAIL,NANERR
*_
RLE    RCOMP   XPTR,YPTR,FAIL,RETNUL,RETNUL,NANERR
*_
RLT    RCOMP   XPTR,YPTR,FAIL,FAIL,RETNUL,NANERR
*_
RNE    RCOMP   XPTR,YPTR,RETNUL,FAIL,RETNUL,NANERR
*_
MXFR   MOVD    ZPTR,XPTR
       RCOMP   XPTR,YPTR,ARTN,ARTN
       MOVD    ZPTR,YPTR
       BRANCH  ARTN
*_
MNFR   MOVD    ZPTR,YPTR
       RCOMP   XPTR,YPTR,ARTN,ARTN
       MOVD    ZPTR,XPTR
       BRANCH  ARTN
*_
MXFI   MOVD    ZPTR,XPTR
       ICOMP   XPTR,YPTR,ARTN,ARTN
       MOVD    ZPTR,YPTR
       BRANCH  ARTN
*_
MNFI   MOVD    ZPTR,YPTR
       ICOMP   XPTR,YPTR,ARTN,ARTN
       MOVD    ZPTR,XPTR
       BRANCH  ARTN
*_
AERROR3 SETAC   ERRTYP,2           Arithmetic error
       BRANCH  FTLTST                                                   5141
RM     DIVIDE  ZPTR,XPTR,YPTR,AERROR3                                   1956
*                                  First divide                         1957
       MULT    WPTR,ZPTR,YPTR      Multiply truncated part              1958
       SUBTRT  ZPTR,XPTR,WPTR      Get difference to get remainder      1959
       BRANCH  ARTN                                                     1960
*_
*---------------------------------------------------------------------*
*
*      INTEGER(X)                                                       1964
*
INTGER PROC    ,                   INTEGER(X)                           1966
       RCALL   XPTR,ARGVAL,,FAIL   Get argument                         1967
       VEQLC   XPTR,I,,RETNUL      INTEGER succeeds                     1968
       VEQLC   XPTR,S,FAIL         STRING must be checked               1969
       LOCSP   XSP,XPTR            Get specifier                        1970
       SPCINT  XPTR,XSP,FAIL,RETNUL                                     1971
*                                  Try conversion to INTEGER            1972
*_
*---------------------------------------------------------------------*
*
*      Arithmetic Negative                                              1976
*
MNS    PROC    ,                   -X                                   1978
       RCALL   XPTR,ARGVAL,,FAIL   Get argument                         1979
       VEQLC   XPTR,I,,MNSM        INTEGER acceptable                   1980
       VEQLC   XPTR,S,,MNSV        STRING must be converted             1981
       VEQLC   XPTR,R,INTR1,MNSR   REAL is acceptable                   1982
*_
MNSM   MNSINT  ZPTR,XPTR,AERROR,ARTN                                    1984
*                                  Form negative of integer             1985
*_
MNSV   LOCSP   XSP,XPTR            Get specifier for string             1987
       SPCINT  XPTR,XSP,,MNSM      Convert to INTEGER                   1988
       SPREAL  XPTR,XSP,INTR1      Convert to REAL                      1989
MNSR   MNREAL  ZPTR,XPTR           Form negative of real                1990
       BRANCH  ARTN                                                     1991
*_
*---------------------------------------------------------------------*
*
*      Arithmetic Absolute Value
*
ABS    PROC    ,                   -X
       RCALL   XPTR,ARGVAL,,FAIL   Get argument
       VEQLC   XPTR,I,,ABSM        INTEGER acceptable
       VEQLC   XPTR,S,,ABSV        STRING must be converted
       VEQLC   XPTR,R,INTR1,ABSR   REAL is acceptable
*_
ABSM   MOVD    ZPTR,XPTR
       ICOMPC  XPTR,0,ARTN,ARTN    Return if positive
       MNSINT  ZPTR,XPTR,AERROR,ARTN Make it positive
*_
ABSV   LOCSP   XSP,XPTR            Get specifier for string
       SPCINT  XPTR,XSP,,ABSM      Convert to INTEGER
       SPREAL  XPTR,XSP,INTR1      Convert to REAL
ABSR   MOVD    ZPTR,XPTR
       RCOMP   XPTR,FZERO,ARTN,ARTN
       MNREAL  ZPTR,XPTR           Make it positive
       BRANCH  ARTN
*_
*---------------------------------------------------------------------*
*
*      Unary Plus Operator                                              1995
*
PLS    PROC    ,                   +X                                   1997
       RCALL   ZPTR,ARGVAL,,FAIL   Get argument                         1998
       VEQLC   ZPTR,I,,ARTN        Is it INTEGER?                       1999
       VEQLC   ZPTR,S,,PLSV        Is it STRING?                        2000
       VEQLC   ZPTR,R,INTR1,ARTN   Is it REAL?                          2001
*_
PLSV   LOCSP   XSP,ZPTR            Get specifier                        2003
       SPCINT  ZPTR,XSP,,ARTN      Convert STRING to INTEGER            2004
       SPREAL  ZPTR,XSP,INTR1,ARTN Convert STRING to REAL               2005
*_
*---------------------------------------------------------------------*
       TITLE   'Pattern-valued Functions and Operations'                2008
ANY    PROC    ,                   ANY(S)                               2009
       PUSH    ANYCCL              Save function descriptor             2010
       BRANCH  CHARZ               Join common processing               2011
*_
BREAKL PROC    ANY                 BREAK(S)
       PUSH    BRKCCL              Save function descriptor             2014
       PUSH    ZEROCL              Save minimum length of zero          2015
       BRANCH  ABNSND              Join common processing               2016
*_
NOTANY PROC    ANY                 NOTANY(S)                            2018
       PUSH    NNYCCL              Save function descriptor             2019
       BRANCH  CHARZ                                                    2020
*_
SPAN   PROC    ANY                 SPAN(S)                              2022
       PUSH    SPNCCL              Save function descriptor             2023
CHARZ  PUSH    CHARCL              Save minimum length of one           2024
ABNSND RCALL   XPTR,ARGVAL,,FAIL   Evaluate argument                    2025
       POP     (ZCL,YCL)           Restore descriptor and length        2026
       VEQLC   XPTR,S,,PATNOD      STRING is acceptable argument        2027
       VEQLC   XPTR,E,,PATNOD      So is EXPRESSION                     2028
       VEQLC   XPTR,I,INTR1        INTEGER must be converted            2029
       RCALL   XPTR,GNVARI,XPTR                                         2030
PATNOD DEQL    XPTR,NULVCL,,NONAME E3.5.4
       RCALL   TPTR,BLOCK,LNODSZ   E3.5.4
       MAKNOD  ZPTR,TPTR,ZCL,ZEROCL,YCL,XPTR                            2032
*                                  Construct the pattern                2033
       RRTURN  ZPTR,3
*_
SPANNOT PROC   ANY                 SPANNOT(S)
       PUSH    NSPNCCL             Save function descriptor
       PUSH    CHARCL              Save minimum length of one
       RCALL   XPTR,ARGVAL,,FAIL   Evaluate argument
       POP     (ZCL,YCL)           Restore descriptor and length
       VEQLC   XPTR,S,,PATNOD      STRING is acceptable argument
       VEQLC   XPTR,E,,PATNOD      So is EXPRESSION
       VEQLC   XPTR,I,INTR1        INTEGER must be converted
       RCALL   XPTR,GNVARI,XPTR
       DEQL    XPTR,NULVCL,,NONAME E3.5.4
       RCALL   TPTR,BLOCK,LNODSZ   E3.5.4
       MAKNOD  ZPTR,TPTR,ZCL,ZEROCL,YCL,XPTR
*                                  Construct the pattern
       RRTURN  ZPTR,3
*_
* BREAKX(s)
BREKX  PROC    ANY
       RCALL   XPTR,ARGVAL,,FAIL   Evaluate argument                    3366
       VEQLC   XPTR,S,,XATNOD      STRING is acceptable argument
       VEQLC   XPTR,E,,XATNOD      So is EXPRESSION
       VEQLC   XPTR,I,INTR1        INTEGER must be converted            2029
       RCALL   XPTR,GNVARI,XPTR                                         2030
XATNOD DEQL    XPTR,NULVCL,,NONAME
       RCALL   TPTR,BLOCK,XNODSZ
       MAKNOD  ZPTR,TPTR,ZEROCL,ZEROCL,SCOKCL
       PUTVC   TPTR,2*DESCR,XSET3
       INCRA   TPTR,NODESZ
       MAKNOD  TPTR,TPTR,ZEROCL,ZEROCL,BRKCCL,XPTR
       PUTVC   TPTR,2*DESCR,XSET7
       INCRA   TPTR,NODESZ+DESCR
       MAKNOD  TPTR,TPTR,ZEROCL,ZEROCL,SCOKCL
       PUTAC   TPTR,2*DESCR,XSET10
       INCRA   TPTR,NODESZ
       MAKNOD  TPTR,TPTR,ZEROCL,ZEROCL,LNTHCL,IONECL
       PUTVC   TPTR,2*DESCR,XSET3
       PUTAC   TPTR,3*DESCR,ONECL
       INCRA   TPTR,NODESZ+DESCR
       RRTURN  ZPTR,3
*_
LEN    PROC    ANY                 LEN(N)                               2036
       PUSH    LNTHCL              Save function descriptor             2037
       BRANCH  LPRTND                                                   2038
*_
POS    PROC    ANY                 POS(N)                               2040
       PUSH    POSICL              Save function descriptor             2041
       BRANCH  LPRTND                                                   2042
*_
RPOS   PROC    ANY                 RPOS(N)                              2044
       PUSH    RPSICL              Save function descriptor             2045
       BRANCH  LPRTND                                                   2046
*_
RTAB   PROC    ANY                 RTAB(N)                              2048
       PUSH    RTBCL               Save function descriptor             2049
       BRANCH  LPRTND                                                   2050
*_
TAB    PROC    ANY                 TAB(N)                               2052
       PUSH    TBCL                Save function descriptor             2053
LPRTND RCALL   XPTR,ARGVAL,,FAIL   Evaluate argument                    2054
       POP     YCL                 Restore function descriptor          2055
       MOVD    ZCL,ZEROCL          Predict minimum length of zero       2056
       VEQLC   XPTR,I,,LPRTNI      If INTEGER check for LEN             2057
       VEQLC   XPTR,E,,PATNOD      EXPRESSION is acceptable             2058
       VEQLC   XPTR,S,INTR1        STRING must be converted to INTEGER  2059
       LOCSP   ZSP,XPTR            Get specifier                        2060
       SPCINT  XPTR,ZSP,INTR1      Convert to INTEGER                   2061
LPRTNI ICOMPC  XPTR,0,,,LENERR     E3.6.1
       DEQL    YCL,LNTHCL,PATNOD   E3.6.1
       MOVA    ZCL,XPTR            If so, use value of integer          2063
       BRANCH  PATNOD              Go form pattern                      2064
*_
*---------------------------------------------------------------------*
*
*      ARBNO(P)                                                         2068
*
ARBNO  PROC    ,                   ARBNO(P)                             2070
       RCALL   XPTR,PATVAL,,FAIL   Evaluate argument as pattern         2071
       VEQLC   XPTR,P,,ARBP        PATTERN is desired form              2072
       VEQLC   XPTR,S,INTR1        STRING must be made into PATTERN     2073
       LOCSP   TSP,XPTR            Get specifier                        2074
       GETLG   TMVAL,TSP           Get length of string                 2075
       RCALL   TPTR,BLOCK,LNODSZ   Allocate block for argument          2076
       MAKNOD  XPTR,TPTR,TMVAL,ZEROCL,CHRCL,XPTR                        2077
ARBP   GETSIZ  XSIZ,XPTR           Get size of pattern                  2078
       SUM     TSIZ,XSIZ,ARBSIZ    Add additional space for ARBNO node  2079
       SETVC   TSIZ,P              Insert PATTERN data type             2080
       RCALL   TPTR,BLOCK,TSIZ     Allocate block for pattern           2081
       MOVD    ZPTR,TPTR           Save pointer to return               2082
       GETSIZ  TSIZ,ARHEAD         Set up copy for heading node         2083
       CPYPAT  TPTR,ARHEAD,ZEROCL,ZEROCL,ZEROCL,TSIZ                    2084
       SUM     ZSIZ,XSIZ,TSIZ                                           2085
       CPYPAT  TPTR,XPTR,ZEROCL,TSIZ,ZSIZ,XSIZ                          2086
       SUM     TSIZ,NODSIZ,NODSIZ  Set up size for trailing node        2087
       CPYPAT  TPTR,ARTAIL,ZEROCL,ZSIZ,ZEROCL,TSIZ                      2088
       SUM     ZSIZ,TSIZ,ZSIZ      Set up size for backup node          2089
       CPYPAT  TPTR,ARBACK,ZEROCL,ZSIZ,TSIZ,TSIZ                        2090
       RRTURN  ZPTR,3
*_
*---------------------------------------------------------------------*
*
*      @X                                                               2095
*
ATOP   PROC    ,                   @X                                   2097
       INCRA   OCICL,DESCR         Increment interpreter offset         2098
       GETD    YPTR,OCBSCL,OCICL   Get object code descriptor           2099
       TESTF   YPTR,FNF,ATOP1      Test for function descriptor
       RCALL   YPTR,INVOKE,YPTR,(FAIL,ATOP1,)                           2101
       VEQLC   YPTR,E,NEMO         Only EXPRESSION can be value         2102
ATOP1  RCALL   TPTR,BLOCK,LNODSZ   Allocate pattern node                2103
       MAKNOD  ZPTR,TPTR,ZEROCL,ZEROCL,ATOPCL,YPTR                      2104
       RRTURN  ZPTR,3
*_
*---------------------------------------------------------------------*
*
*      Value Assignment Operators                                       2109
*
NAM    PROC    ,                   X . Y                                2111
       PUSH    ENMECL              Save function descriptor             2112
       BRANCH  NAM5                Join processing                      2113
*_
DOL    PROC    NAM                 X $ Y                                2115
       PUSH    ENMICL              Save function descritpor             2116
NAM5   RCALL   XPTR,PATVAL,,FAIL   Get pattern for first argument       2117
       INCRA   OCICL,DESCR         Increment offset                     2118
       GETD    YPTR,OCBSCL,OCICL   Get object code descriptor           2119
       TESTF   YPTR,FNF,,NAMC2     Check for function
NAM3   VEQLC   XPTR,S,,NAMV        Is first argument STRING?            2121
       VEQLC   XPTR,P,INTR1,NAMP   Is it PATTERN?                       2122
*_
NAMC2  PUSH    XPTR                Save first argument                  2124
       RCALL   YPTR,INVOKE,YPTR,(FAIL,NAM4,)                            2125
*                                  Evaluate second argument             2126
       VEQLC   YPTR,E,NEMO         Verify EXPRESSION                    2127
NAM4   POP     XPTR                Restore first argument               2128
       BRANCH  NAM3                Join processing                      2129
*_
NAMV   LOCSP   TSP,XPTR            Get specifier                        2131
       GETLG   TMVAL,TSP           Get length                           2132
       RCALL   TPTR,BLOCK,LNODSZ   Allocate block for pattern           2133
       MAKNOD  XPTR,TPTR,TMVAL,ZEROCL,CHRCL,XPTR                        2134
*                                  Make pattern node                    2135
NAMP   RCALL   TPTR,BLOCK,SNODSZ   Allocate block for pattern           2136
       MAKNOD  WPTR,TPTR,ZEROCL,ZEROCL,NMECL                            2137
*                                  Make node for naming                 2138
       RCALL   TPTR,BLOCK,LNODSZ   Allocate block for  pattern          2139
       POP     TVAL                Restore function descriptor          2140
       MAKNOD  YPTR,TPTR,ZEROCL,ZEROCL,TVAL,YPTR                        2141
*                                  Make pattern for backup              2142
       GETSIZ  XSIZ,XPTR           Get size of first pattern            2143
       SUM     YSIZ,XSIZ,NODSIZ    Compute total size                   2144
       GETSIZ  TSIZ,YPTR           Get size of naming node              2145
       SUM     ZSIZ,YSIZ,TSIZ      Compute total                        2146
       SETVC   ZSIZ,P              Insert PATTERN data type             2147
       RCALL   TPTR,BLOCK,ZSIZ     Allocate block for total pattern     2148
       MOVD    ZPTR,TPTR           Save copy                            2149
       LVALUE  TVAL,XPTR           Get least value                      2150
       CPYPAT  TPTR,WPTR,TVAL,ZEROCL,NODSIZ,NODSIZ                      2151
*                                  Copy three patterns                  2152
       CPYPAT  TPTR,XPTR,ZEROCL,NODSIZ,YSIZ,XSIZ                        2153
       CPYPAT  TPTR,YPTR,ZEROCL,YSIZ,ZEROCL,TSIZ                        2154
       RRTURN  ZPTR,3              Return pattern as value
*_
*---------------------------------------------------------------------*
*
*      Binary Alternation Operator                                      2159
*
ORLBL  PROC    ,                   X | Y
       RCALL   XPTR,PATVAL,,FAIL   Get first argument                   2162
       PUSH    XPTR                Save first argument                  2163
       RCALL   YPTR,PATVAL,,FAIL   Get second argument                  2164
       POP     XPTR                Restore first argument               2165
       SETAV   DTCL,XPTR           Get first data type                  2166
       MOVV    DTCL,YPTR           Insert second data type              2167
       DEQL    DTCL,VVDTP,,ORVV    Is it STRING-STRING?                 2168
       DEQL    DTCL,VPDTP,,ORVP    Is it STRING-PATTERN?                2169
       DEQL    DTCL,PVDTP,,ORPV    Is it PATTERN-STRING?                2170
       DEQL    DTCL,PPDTP,INTR1,ORPP                                    2171
*                                  Is it PATTERN_PATTERN?               2172
*_
ORVV   LOCSP   XSP,XPTR            Get specifier                        2174
       GETLG   TMVAL,XSP           Get length                           2175
       RCALL   TPTR,BLOCK,LNODSZ   Get block for pattern                2176
       MAKNOD  XPTR,TPTR,TMVAL,ZEROCL,CHRCL,XPTR                        2177
*                                  Construct pattern                    2178
ORPV   LOCSP   YSP,YPTR            Get specifier                        2179
       GETLG   TMVAL,YSP           Get length                           2180
       RCALL   TPTR,BLOCK,LNODSZ   Get block for pattern                2181
       MAKNOD  YPTR,TPTR,TMVAL,ZEROCL,CHRCL,YPTR                        2182
*                                  Construct pattern                    2183
ORPP   GETSIZ  XSIZ,XPTR           Get size of first pattern            2184
       GETSIZ  YSIZ,YPTR           Get size of second pattern           2185
       SUM     TSIZ,XSIZ,YSIZ      Compute total size                   2186
       SETVC   TSIZ,P              Insert PATTERN data type             2187
       RCALL   TPTR,BLOCK,TSIZ     Allocate block for pattern           2188
       MOVD    ZPTR,TPTR           Save copy                            2189
       CPYPAT  TPTR,XPTR,ZEROCL,ZEROCL,ZEROCL,XSIZ                      2190
*                                  Copy first pattern                   2191
       CPYPAT  TPTR,YPTR,ZEROCL,XSIZ,ZEROCL,YSIZ                        2192
*                                  Copy second pattern                  2193
       LINKOR  ZPTR,XSIZ           Link alternatives                    2194
       RRTURN  ZPTR,3              Return pattern as value
*_
ORVP   LOCSP   XSP,XPTR            Get specifier                        2197
       GETLG   TMVAL,XSP           Get length                           2198
       RCALL   TPTR,BLOCK,LNODSZ   Get block for pattern                2199
       MAKNOD  XPTR,TPTR,TMVAL,ZEROCL,CHRCL,XPTR                        2200
*                                  Construct pattern                    2201
       BRANCH  ORPP                Join processing                      2202
*_
*---------------------------------------------------------------------*
       TITLE   'Pattern Matching Procedures'                            2205
*
*      Simple Pattern Matching                                          2207
*
SCAN   PROC    ,                   Pattern Matching                     2209
       RCALL   XPTR,ARGVAL,,FAIL   Get subject                          2210
       PUSH    XPTR                Save subject                         2211
       RCALL   YPTR,PATVAL,,FAIL   Get pattern                          2212
       POP     XPTR                Restore subject                      2213
       SETAV   DTCL,XPTR           Set up data type pair                2214
       MOVV    DTCL,YPTR                                                2215
       INCRI   SCNCL,1             Increment count of scanner entries
       DEQL    DTCL,VVDTP,,SCANVV  Is it STRING-STRING?                 2217
       DEQL    DTCL,VPDTP,,SCANVP  Is it STRING-PATTERN?                2218
       DEQL    DTCL,IVDTP,,SCANIV  Is it INTEGER-STRING?                2219
       DEQL    DTCL,RVDTP,,SCANRV  Is it REAL-STRING?                   2220
       DEQL    DTCL,RPDTP,,SCANRP  Is it REAL-PATTERN?                  2221
       DEQL    DTCL,IPDTP,INTR1,SCANIP                                  2222
*                                  Is it INTEGER-PATTERN?               2223
*_
SCANVV LOCSP   XSP,XPTR            Get specifier for subject            2225
       LOCSP   YSP,YPTR            Get specifier for pattern            2226
SCANVB SUBSP   TSP,YSP,XSP,FAIL    Get part to compare                  2227
       LEXCMP  TSP,YSP,,RETNUL     Compare strings                      2228
       IEQLC   ANCCL,0,FAIL        Check &ANCHOR
       FSHRTN  XSP,1               Delete lead character                2230
       BRANCH  SCANVB              Try again                            2231
*_
SCANIV RCALL   XPTR,GNVARI,XPTR    Generate variable for integer        2233
       BRANCH  SCANVV              Join processing                      2234
*_
SCANVP LOCSP   XSP,XPTR            Get specifier for subject            2236
       RCALL   ,SCNR,,(FAIL,,FAIL) Call scanner                         2237
       RCALL   ,NMD,,(FAIL,RTN2)   Perform naming                       2238
*_
SCANIP RCALL   XPTR,GNVARI,XPTR    Generate variable for integer        2240
       BRANCH  SCANVP              Join processing                      2241
*_
SCANRV REALST  XSP,XPTR            Convert REAL to STRING               2243
       RCALL   XPTR,GENVAR,XSPPTR,SCANVV                                2244
*_
SCANRP REALST  XSP,XPTR            Convert REAL to STRING               2246
       RCALL   XPTR,GENVAR,XSPPTR,SCANVP                                2247
*                                  Generate variable                    2248
*_
*_
*---------------------------------------------------------------------*
*
*      Pattern Matching with Replacement                                2253
*
SJSR   PROC    ,                   Pattern matching with replacement    2255
       INCRA   OCICL,DESCR         Increment offset                     2256
       GETD    WPTR,OCBSCL,OCICL   Get object code descriptor           2257
       TESTF   WPTR,FNF,,SJSRC1    Check for function
SJSR1  IEQLC   INSWQ,0,,SJSR1A     Check &INPUT                         2259
       LOCAPV  ZPTR,INATL,WPTR,SJSR1A                                   2260
*                                  Look of input association            2261
       GETDC   ZPTR,ZPTR,DESCR     Get association                      2262
       RCALL   XPTR,PUTIN,(ZPTR,WPTR),(FAIL,SJSR1B)                     2263
*                                  Perform input                        2264
*_
SJSR1A GETDC   XPTR,WPTR,DESCR     Get value                            2266
SJSR1B PUSH    (WPTR,XPTR)         Save name and value                  2267
       RCALL   YPTR,PATVAL,,FAIL   Get pattern                          2268
       POP     XPTR                Restore value                        2269
       SETAV   DTCL,XPTR           Set up data type pair                2270
       MOVV    DTCL,YPTR                                                2271
       INCRI   SCNCL,1             Increment count of scanner calls
       DEQL    DTCL,VVDTP,,SJSSVV  Is it STRING-PATTERN?                2273
       DEQL    DTCL,VPDTP,,SJSSVP  Is it INTEGER-STRING?                2274
       DEQL    DTCL,IVDTP,,SJSSIV  Is it INTEGER-PATTERN?               2275
       DEQL    DTCL,RVDTP,,SJSSRV  Is it REAL-STRING?                   2276
       DEQL    DTCL,RPDTP,,SJSSRP  Is it REAL-PATTERN?                  2277
       DEQL    DTCL,IPDTP,INTR1,SJSSIP                                  2278
*_
SJSRC1 RCALL   WPTR,INVOKE,(WPTR),(FAIL,SJSR1,NEMO)                     2280
*                                  Evaluate subject                     2281
*_
SJSSVP LOCSP   XSP,XPTR            Get specifier                        2283
       RCALL   ,SCNR,,(FAIL,,FAIL) Call scanner                         2284
       SETAC   NAMGCL,1            Set naming switch                    2285
       REMSP   TAILSP,XSP,TXSP     Get tail of subject                  2286
       BRANCH  SJSS1               Join common processing               2287
*_
SJSSIP RCALL   XPTR,GNVARI,XPTR    Generate STRING from INTEGER         2289
       BRANCH  SJSSVP              Join common processing               2290
*_
SJSSIV RCALL   XPTR,GNVARI,XPTR    Generate STRING from INTEGER         2292
       BRANCH  SJSSVV              Join common processing               2293
*_
SJSSRV REALST  XSP,XPTR            Convert REAL to STRING               2295
       RCALL   XPTR,GENVAR,XSPPTR,SJSSVV                                2296
*                                  Generate variable                    2297
*_
SJSSRP REALST  XSP,XPTR            Convert REAL to STRING               2299
       RCALL   XPTR,GENVAR,XSPPTR,SJSSVP                                2300
*                                  Generate variable                    2301
*_
SJVVON IEQLC   ANCCL,0,FAIL        Check &ANCHOR                        2303
       ADDLG   HEADSP,ONECL        Increment length of head             2304
       FSHRTN  XSP,1               Delete head character                2305
       BRANCH  SJSSV2              Join common processing               2306
*_
SJSSVV LOCSP   XSP,XPTR            Get specifier for subject            2308
       LOCSP   YSP,YPTR            Get specifier for pattern            2309
       SETSP   HEADSP,XSP          Set up head specifier                2310
       SETLC   HEADSP,0            Initialize zero length               2311
SJSSV2 SUBSP   TSP,YSP,XSP,FAIL    Get common length                    2312
       LEXCMP  TSP,YSP,SJVVON,,SJVVON                                   2313
*                                  Compare strings                      2314
       SETAC   NAMGCL,0            Clear naming switch                  2315
       REMSP   TAILSP,XSP,TSP      Get tail of subject                  2316
SJSS1  SPUSH   (TAILSP,HEADSP)     Save head and tail                   2317
       IEQLC   NAMGCL,0,,SJSS1A    Check naming switch
       RCALL   ,NMD,,FAIL          Perform naming                       2319
SJSS1A RCALL   ZPTR,ARGVAL,,FAIL   Get object                           2320
       SPOP    (HEADSP,TAILSP)     Restore head and tail                2321
       POP     WPTR                Restore name of subject              2322
       LEQLC   HEADSP,0,SJSSDT     Check for null head                  2323
       LEQLC   TAILSP,0,,SJSRV1    Check for null tail                  2324
SJSSDT VEQLC   ZPTR,S,,SJSRV       Is object STRING?                    2325
       VEQLC   ZPTR,P,,SJSRP       Is object PATTERN?                   2326
       VEQLC   ZPTR,I,,SJSRI       Is object INTEGER?                   2327
       VEQLC   ZPTR,R,,SJSRR       Is object REAL?                      2328
       VEQLC   ZPTR,E,INTR1        Is object EXPRESSION?                2329
       RCALL   TPTR,BLOCK,STARSZ   Allocate block for pattern           2330
       MOVBLK  TPTR,STRPAT,STARSZ  Set up pattern for expression        2331
       PUTDC   TPTR,4*DESCR,ZPTR   Insert object                        2332
       MOVD    ZPTR,TPTR           Set up converted value               2333
SJSRP  SETSP   XSP,HEADSP          Copy specifier                       2334
       RCALL   XPTR,GENVAR,(XSPPTR)                                     2335
*                                  Generate variable for head           2336
       GETLG   TMVAL,HEADSP        Get length of head                   2337
       RCALL   TPTR,BLOCK,LNODSZ   Allocate block for pattern           2338
       MAKNOD  XPTR,TPTR,TMVAL,ZEROCL,CHRCL,XPTR                        2339
*                                  Make pattern node                    2340
       SETSP   YSP,TAILSP          Set up tail specifier                2341
       RCALL   YPTR,GENVAR,(YSPPTR)                                     2342
*                                  Generate variable for tail           2343
       GETLG   TMVAL,TAILSP        Get length of tail                   2344
       RCALL   TPTR,BLOCK,LNODSZ   Allocate block for pattern           2345
       MAKNOD  YPTR,TPTR,TMVAL,ZEROCL,CHRCL,YPTR                        2346
*                                  Make pattern node                    2347
       GETSIZ  XSIZ,XPTR           Get size of head node                2348
       GETSIZ  YSIZ,YPTR           Get size of tail node                2349
       GETSIZ  ZSIZ,ZPTR           Get size of object                   2350
       SUM     TSIZ,XSIZ,ZSIZ      Compute total size                   2351
       SUM     TSIZ,TSIZ,YSIZ      Get size of new pattern              2352
       SETVC   TSIZ,P              Insert PATTERN data type             2353
       RCALL   TPTR,BLOCK,TSIZ     Allocate block for total pattern     2354
       MOVD    VVAL,TPTR           Get working copy                     2355
       LVALUE  TVAL,ZPTR           Get least value of replacement       2356
       CPYPAT  TPTR,XPTR,TVAL,ZEROCL,XSIZ,XSIZ                          2357
*                                  Copy in head                         2358
       LVALUE  TVAL,YPTR           Get least value of tail              2359
       SUM     TSIZ,XSIZ,ZSIZ      Get size of first two                2360
       CPYPAT  TPTR,ZPTR,TVAL,XSIZ,TSIZ,ZSIZ                            2361
*                                  Copy in object                       2362
       CPYPAT  TPTR,YPTR,ZEROCL,TSIZ,ZEROCL,YSIZ                        2363
*                                  Copy in tail                         2364
       MOVD    ZPTR,VVAL           Set up return value                  2365
       BRANCH  SJSRV1              Join common processing               2366
*_
SJSRV  LOCSP   ZSP,ZPTR                                                 2368
SJSRS  GETLG   XPTR,TAILSP         Get length of tail                   2369
       GETLG   YPTR,HEADSP         Get length of tail                   2370
       GETLG   ZPTR,ZSP            Get length of object                 2371
       SUM     XPTR,XPTR,YPTR      Compute total length                 2372
       SUM     XPTR,XPTR,ZPTR                                           2373
       ICOMP   XPTR,MLENCL,INTR8   Check &MAXLNGTH
       RCALL   ZPTR,CONVAR,(XPTR)  Allocate storage for string          2375
       LOCSP   TSP,ZPTR            Get specifier                        2376
       SETLC   TSP,0               Clear length                         2377
       APDSP   TSP,HEADSP          Append head                          2378
       APDSP   TSP,ZSP             Append object                        2379
       APDSP   TSP,TAILSP          Append tail                          2380
       RCALL   ZPTR,GNVARS,XPTR    Enter string into storage            2381
SJSRV1 PUTDC   WPTR,DESCR,ZPTR     Assign value to subject name         2382
       IEQLC   OUTSWQ,0,,SJSRV2    Check &OUTPUT
       LOCAPV  YPTR,OUTATL,WPTR,SJSRV2                                  2384
*                                  Look for output association          2385
       GETDC   YPTR,YPTR,DESCR     Get output association               2386
       RCALL   ,PUTOUT,(YPTR,ZPTR) Perform output                       2387
SJSRV2 ICOMPC  TRAPCL,0,,RTN3,RTN3 Check &TRACE                         2388
       LOCAPT  ATPTR,TVALL,WPTR,RTN3                                    2389
*                                  Look for VALUE trace                 2390
       RCALL   ,TRPHND,ATPTR,RTN3  E3.3.1
*                                  Perform trace                        2392
*_
SJSRI  INTSPC  ZSP,ZPTR            Convert INTEGER                      2394
       BRANCH  SJSRS                                                    2395
*_
SJSRR  REALST  ZSP,ZPTR            Convert REAL                         2397
       BRANCH  SJSRS                                                    2398
*_
*---------------------------------------------------------------------*
*
*      Basic Scanning Procedure                                         2402
*
SCNR   PROC    ,                   Scanning procedure                   2404
       GETLG   MAXLEN,XSP          Get maximum length                   2405
       LVALUE  YSIZ,YPTR           Get least value                      2406
       IEQLC   FULLCL,0,SCNR1      Check &FULLSCAN
       ACOMP   YSIZ,MAXLEN,FAIL    Check maximum against minimum        2408
SCNR1  SETSP   TXSP,XSP            Set up working specifier for head    2409
       SETLC   TXSP,0              Zero length                          2410
       MOVD    PDLPTR,PDLHED       Initialize history list              2411
       MOVD    NAMICL,NHEDCL       Initialize name list                 2412
       IEQLC   ANCCL,0,SCNR3       Check &ANCHOR
       IEQLC   FULLCL,0,,SCNR4     Check &FULLSCAN
       MOVD    YSIZ,MAXLEN         Set up length                        2415
       BRANCH  SCNR5               Join processing                      2416
*_
SCNR4  SUBTRT  YSIZ,MAXLEN,YSIZ    Get difference of lengths            2418
SCNR5  SUM     YSIZ,YSIZ,CHARCL    Add one                              2419
SCNR2  PUSH    (YPTR,YSIZ)         Save pattern and length              2420
       SETSP   HEADSP,TXSP         Set up head specifier                2421
       INCRA   PDLPTR,3*DESCR      Make room for history entry          2422
       ACOMP   PDLPTR,PDLEND,INTR31                                     2423
*                                  Check for overflow                   2424
       SETAC   LENFCL,1            Set length failure                   2425
       PUTDC   PDLPTR,DESCR,SCONCL Insert scan function                 2426
       GETLG   TMVAL,TXSP          Get cursor position                  2427
       PUTDC   PDLPTR,2*DESCR,TMVAL                                     2428
*                                  Insert on history list               2429
       PUTDC   PDLPTR,3*DESCR,LENFCL                                    2430
*                                  Insert length failure                2431
       BRANCH  SCIN1               Join common scanning                 2432
*_
SCNR3  INCRA   PDLPTR,3*DESCR      Make room for history entry          2434
       ACOMP   PDLPTR,PDLEND,INTR31                                     2435
*                                  Check for overflow                   2436
       SETLC   HEADSP,0            Zero length of head                  2437
       PUTDC   PDLPTR,DESCR,SCFLCL Insert scan failure function         2438
       GETLG   TMVAL,TXSP          Get cursor position                  2439
       PUTDC   PDLPTR,2*DESCR,TMVAL                                     2440
*                                  Insert on history list               2441
       PUTDC   PDLPTR,3*DESCR,LENFCL                                    2442
*                                  Insert length failure                2443
       BRANCH  SCIN1               Join common scanning                 2444
*_
SCIN   PROC    SCNR                                                     2446
SCIN1  MOVD    PATBCL,YPTR         Set up pattern base pointer          2447
       SETAC   PATICL,0            Zero offset                          2448
SCIN2  SETAC   LENFCL,1            Set length failure                   2449
SCIN3  INCRA   PATICL,DESCR        Increment offset                     2450
       TRAPCK  ,                   Check for interrupts
       GETD    ZCL,PATBCL,PATICL   Get function descriptor              2451
       INCRA   PATICL,DESCR        Increment offset                     2452
       GETD    XCL,PATBCL,PATICL   Get then-or descriptor               2453
       INCRA   PATICL,DESCR        Increment offset                     2454
       GETD    YCL,PATBCL,PATICL   Get value-residual descriptor        2455
       INCRA   PDLPTR,3*DESCR      Make room for history entry          2456
       ACOMP   PDLPTR,PDLEND,INTR31                                     2457
*                                  Check for overflow                   2458
       PUTDC   PDLPTR,DESCR,XCL    Insert then-or descriptor            2459
       GETLG   TMVAL,TXSP          Get cursor position                  2460
       MOVV    TMVAL,YCL           Insert residual                      2461
       PUTDC   PDLPTR,2*DESCR,TMVAL                                     2462
*                                  Insert on history list               2463
       PUTDC   PDLPTR,3*DESCR,LENFCL                                    2464
*                                  Insert length failure                2465
       IEQLC   FULLCL,0,SCIN4      Check &FULLSCAN
       CHKVAL  MAXLEN,YCL,TXSP,SALT1                                    2467
*                                  Check values                         2468
SCIN4  BRANIC  ZCL,0               Branch to procedure                  2469
*_
SALF   PROC    SCNR                Nonlength failure procedure          2471
SALF1  SETAC   LENFCL,0            Clear length failure                 2472
       BRANCH  SALT2               Join common processing               2473
*_
SALT   PROC    SCNR                Length failure procedure             2475
SALT1  GETDC   LENFCL,PDLPTR,3*DESCR                                    2476
*                                  Get length failure from history      2477
SALT2  GETDC   XCL,PDLPTR,DESCR    Get then-or descriptor               2478
       GETDC   YCL,PDLPTR,2*DESCR  Get value-residual                   2479
       DECRA   PDLPTR,3*DESCR      Back over history entry              2480
       MOVD    PATICL,XCL          Set offset to OR link                2481
       IEQLC   PATICL,0,,SALT3     Check for none
       PUTLG   TXSP,YCL            Insert old length of head            2483
       TESTF   PATICL,FNF,SCIN3    Check for function
       BRANIC  PATICL,0            Branch to procedure                  2485
*_
SALT3  IEQLC   LENFCL,0,SALT1      Check length failure                 2487
       BRANCH  SALF1               Go to nonlength failure              2488
*_
SCOK   PROC    SCNR                Successful scanning procedure        2490
       SETAV   PATICL,XCL          Set offset from THEN link            2491
       IEQLC   PATICL,0,SCIN2,RTN2 Check for none
*_
SCON   PROC    SCNR                                                     2494
       IEQLC   FULLCL,0,SCON1      Check &FULLSCAN
       IEQLC   LENFCL,0,FAIL       Check length failure
SCON1  POP     (YSIZ,YPTR)         Restore save descriptors             2497
       DECRI   YSIZ,1              Decrement possible count             2498
       ACOMPC  YSIZ,0,,FAIL,INTR13 CHeck for end                        2499
       ADDLG   TXSP,ONECL          Increment length of head             2500
       BRANCH  SCNR2               Continue                             2501
*_
UNSC   PROC    SCNR                Backout procedure                    2503
       MOVD    PATBCL,YPTR         Reset pattern base                   2504
       BRANCH  SALT3               Join processing                      2505
*_
*---------------------------------------------------------------------*
*
*      ANY, BREAK, NOTANY, SPAN                                         2509
*
ANYC   PROC    ,                   Matching procedure for ANY(S)        2511
       SETAC   SCL,1               Post entry                           2512
ABNS   INCRA   PATICL,DESCR        Increment offset                     2513
       GETD    XPTR,PATBCL,PATICL  Get argument                         2514
       PUSH    SCL                 Save processor switch                2515
ABNS1  VEQLC   XPTR,S,,ABNSV       E3.5.5
       VEQLC   XPTR,E,,ABNSE       EXPRESSION must be evaluated         2518
       VEQLC   XPTR,I,,ABNSI       E3.5.6
       POP     SCL                 E3.5.6
       BRANCH  SCDTER              E3.5.6
*_                                                              E3.5.6
ABNSE  RCALL   XPTR,EXPVAL,XPTR,(ABNSF,ABNS1) E3.5.5
*_                                                              E3.5.5
ABNSF  POP     SCL                 E3.5.5
       BRANCH  TSALF               E3.5.5
*_                                                              E3.5.5
ABNSI  RCALL   XPTR,GNVARI,XPTR                                         2521
ABNSV  POP     SCL                 Restore procedure switch             2522
       IEQLC   XPTR,0,,SCNAME      E3.5.5
       SELBRA  SCL,(,BRKV,NNYV,SPNV,NSPNV)                                    2523
*                                  Select processor                     2524
ANYV   DEQL    XPTR,TBLCS,ANYC2    Was last argument the same?          2525
       AEQL    TBLFNC,ANYCCL,,ANYC3                                     2526
*                                  If so, was last procedure for ANY(S) 2527
ANYC2  CLERTB  SNABTB,ERROR        If not, clear stream table           2528
       LOCSP   YSP,XPTR                                                 2529
       PLUGTB  SNABTB,STOP,YSP     Plug entries for characters          2530
       MOVD    TBLCS,XPTR          Save argument to check next time     2531
       MOVD    TBLFNC,ANYCCL       Save procedure to check next time    2532
ANYC3  SETSP   VSP,XSP             Set up working specifier             2533
       IEQLC   FULLCL,0,ANYC4      Leave length alone in FULLSCAN mode
       PUTLG   VSP,MAXLEN          Else insert maximum length           2535
       LCOMP   VSP,TXSP,,,TSALT    Length failure if too short          2536
       CHKVAL  MAXLEN,ZEROCL,XSP,,ANYC4,ANYC4 E3.5.7
       ADDLG   VSP,ONECL           E3.5.7
ANYC4  REMSP   YSP,VSP,TXSP        Get specifier to unscanned portion   2537
       STREAM  ZSP,YSP,SNABTB,TSALF,TSALT                               2538
       GETLG   XPTR,ZSP            Get length accepted                  2539
       ADDLG   TXSP,XPTR           Add to length matched                2540
       BRANCH  SCOK,SCNR           Return to success point              2541
*_
BRKC   PROC    ANYC                Matching procedure for BREAK(S)      2543
       SETAC   SCL,2               Post entry                           2544
       BRANCH  ABNS                                                     2545
*_
BRKV   DEQL    XPTR,TBLCS,BRKC2    Was last argument the same?          2547
       AEQL    TBLFNC,BRKCCL,,ANYC3                                     2548
*                                  Was the last procedure for BREAK     2549
BRKC2  CLERTB  SNABTB,CONTIN       If not, clear stream table           2550
       LOCSP   YSP,XPTR                                                 2551
       PLUGTB  SNABTB,STOPSH,YSP   Plug entries for characters          2552
       MOVD    TBLCS,XPTR          Save argument to check next time     2553
       MOVD    TBLFNC,BRKCCL       Save procedure to check next time    2554
       BRANCH  ANYC3               Proceed                              2555
*_
NNYC   PROC    ANYC                Matching procedure for NOTANY(S)     2557
       SETAC   SCL,3               Post entry                           2558
       BRANCH  ABNS                                                     2559
*_
NNYV   DEQL    XPTR,TBLCS,NNYC2    Was last argument the same?          2561
       AEQL    TBLFNC,NNYCCL,,ANYC3                                     2562
*                                  Was the last procedure for NOTANY?   2563
NNYC2  CLERTB  SNABTB,STOP         If not, clear stream table           2564
       LOCSP   YSP,XPTR                                                 2565
       PLUGTB  SNABTB,ERROR,YSP    Plug entries for characters          2566
       MOVD    TBLCS,XPTR          Save argument to check next time     2567
       MOVD    TBLFNC,NNYCCL       Save procedure to check next time    2568
       BRANCH  ANYC3               Proceed                              2569
*_
SPNC   PROC    ANYC                Matching procedure for SPAN(S)       2571
       SETAC   SCL,4               Post entry                           2572
       BRANCH  ABNS                                                     2573
*_
NSPNC  PROC    ANYC                Matching procedure for SPANNOT(S)
       SETAC   SCL,5               Post entry
       BRANCH  ABNS
*_                                 SPAN(S)
SPNV   DEQL    XPTR,TBLCS,SPNC2    Was last argument the same?          2575
       AEQL    TBLFNC,SPNCCL,,SPNC3                                     2576
*                                  Was the last procedure for SPAN?     2577
SPNC2  CLERTB  SNABTB,STOPSH       If not, clear stream table           2578
       LOCSP   YSP,XPTR                                                 2579
       PLUGTB  SNABTB,CONTIN,YSP   Plug entries for characters          2580
       MOVD    TBLCS,XPTR          Save argument to check next time     2581
       MOVD    TBLFNC,SPNCCL       Save procedure to check next time    2582
SPNC3  LCOMP   XSP,TXSP,,TSALT,TSALT                                    2583
*                                  Length failure if too short          2584
       REMSP   YSP,XSP,TXSP        Get specifier to unscanned portion   2585
       STREAM  ZSP,YSP,SNABTB,TSALF                                     2586
       LEQLC   ZSP,0,,TSALF        Failure if length accepted is zero   2587
       GETLG   XPTR,ZSP            Get length of accepted portion       2588
       IEQLC   FULLCL,0,SPNC5      Skip length check in FULLSCAN mode
       CHKVAL  MAXLEN,XPTR,TXSP,TSALT                                   2590
SPNC5  ADDLG   TXSP,XPTR           Add length accepted                  2591
       BRANCH  SCOK,SCNR                                                2592
*_                                 SPANNOT(S)
NSPNV  DEQL    XPTR,TBLCS,NSPNC2   Was last argument the same?
       AEQL    TBLFNC,NSPNCCL,,SPNC3
*                                  Was the last procedure for SPANNOT?
NSPNC2 CLERTB  SNABTB,CONTIN       If not, clear stream table
       LOCSP   YSP,XPTR
       PLUGTB  SNABTB,STOPSH,YSP   Plug entries for characters
       MOVD    TBLCS,XPTR          Save argument to check next time
       MOVD    TBLFNC,NSPNCCL      Save procedure to check next time
       BRANCH  SPNC3
*_
*---------------------------------------------------------------------*
*
*      LEN, POS, RPOS, RTAB, TAB                                        2596
*
LNTH   PROC    ,                   Matching procedure for LEN(N)        2598
       SETAC   SCL,1               Note entry                           2599
LPRRT  INCRA   PATICL,DESCR        Increment offset                     2600
       GETD    XPTR,PATBCL,PATICL  Get argument                         2601
       PUSH    SCL                 Save entry indicator                 2602
*
LPRRT1 VEQLC   XPTR,I,,LPRRTI      Is it INTEGER?                       2604
       VEQLC   XPTR,E,,LPRRTE      Is it EXPRESSION?                    2605
       VEQLC   XPTR,S,,LPRRTV      E3.5.6
       POP     SCL                 E3.5.6
       BRANCH  SCDTER              E3.5.6
*                                  Is it STRING?                        2607
LPRRTE RCALL   XPTR,EXPVAL,XPTR,(,LPRRT1) E3.2.1
       POP     SCL                 E3.2.1
       BRANCH  TSALF               E3.2.1
*_                                                              E3.2.1
*                                  Evaluate EXPRESSION                  2609
LPRRTV LOCSP   ZSP,XPTR            Get specifier                        2610
       SPCINT  XPTR,ZSP,SCDTER     Convert to INTEGER                   2611
LPRRTI POP     SCL                 Restore entry indicator              2612
       SELBRA  SCL,(,POSII,RPSII,RTBI,TBI)                              2613
*                                  Select matching procedure            2614
       ICOMPC  XPTR,0,,,SCLENR     Check for negative length
       CHKVAL  MAXLEN,XPTR,TXSP,TSALT                                   2616
*                                  Compare with maximum length          2617
       ADDLG   TXSP,XPTR           Add to length matched                2618
       BRANCH  SCOK,SCNR           Return successful match              2619
*_
POSII  ICOMPC  XPTR,0,,,SCLENR     Check for negative position          2621
       GETLG   NVAL,TXSP           Get cursor position                  2622
       ACOMP   XPTR,MAXLEN,TSALT   Check desired against maximum        2623
       ACOMP   XPTR,NVAL,TSALF,TSCOK                                    2624
*                                  Ceck against cursor position         2625
       BRANCH  SALT,SCNR                                                2626
*_
RPSII  ICOMPC  XPTR,0,,,SCLENR     Check for negative position          2628
       GETLG   NVAL,XSP            Get total length                     2629
       SUBTRT  TVAL,NVAL,XPTR      Find desired position                2630
       GETLG   NVAL,TXSP           Get cursor position                  2631
       ICOMP   NVAL,TVAL,TSALT,TSCOK,TSALF
*                                  Compare two positions                2633
*_
RTBI   ICOMPC  XPTR,0,,,SCLENR     Check for negative length            2635
       GETLG   NVAL,XSP            Get total length                     2636
       SUBTRT  TVAL,NVAL,XPTR      Find desired position                2637
       GETLG   NVAL,TXSP           Get current position                 2638
       ICOMP   NVAL,TVAL,TSALT     Compare two positions
       IEQLC   FULLCL,0,RTBII      Check &FULLSCAN
       SETAV   NVAL,YCL            Get residual                         2641
       SUBTRT  NVAL,MAXLEN,NVAL    Find maximum allowed position        2642
       ACOMP   NVAL,TVAL,,,TSALT   Compare with desired position        2643
RTBII  PUTLG   TXSP,TVAL           Update length of string matched      2644
       BRANCH  SCOK,SCNR                                                2645
*_
TBI    ICOMPC  XPTR,0,,,SCLENR     Check for negative length            2647
       GETLG   NVAL,TXSP           Get cursor position                  2648
       ACOMP   NVAL,XPTR,TSALT     Check against desired position       2649
       ACOMP   XPTR,MAXLEN,TSALT   Check for tab beyond end             2650
       PUTLG   TXSP,XPTR           Update length of string matched      2651
       BRANCH  SCOK,SCNR                                                2652
*_
POSI   PROC    LNTH                Matching procedure for POS(N)        2654
       SETAC   SCL,2               Note entry                           2655
       BRANCH  LPRRT               Join common processing               2656
*_
RPSI   PROC    LNTH                Matching procedure for RPOS(N)       2658
       SETAC   SCL,3               Note entry                           2659
       BRANCH  LPRRT               Join common processing               2660
*_
RTB    PROC    LNTH                Matching procedure for RTAB(N)       2662
       SETAC   SCL,4               Note entry                           2663
       BRANCH  LPRRT               Join common processing               2664
*_
TB     PROC    LNTH                Matching procedure for TAB(N)        2666
       SETAC   SCL,5               Note entry                           2667
       BRANCH  LPRRT               Join common processing               2668
*_
*---------------------------------------------------------------------*
*
*      ARBNO                                                            2672
*
ARBN   PROC    ,                   Matching for ARBNO(P)                2674
       GETLG   TMVAL,TXSP          Get cursor position                  2675
       PUSH    TMVAL               Save cursor position                 2676
       BRANCH  SCOK,SCNR           Return matching successfully         2677
*_
ARBF   PROC    ARBN                Backup matching for ARBNO(P)         2679
       POP     (TMVAL)             Restore cursor position              2680
       BRANCH  ONAR2               Join common processing               2681
*_
EARB   PROC    ARBN                                                     2683
       POP     (TMVAL)             Restore cursor position              2684
       PUTDC   PDLPTR,DESCR,TMVAL  Insert on history list               2685
       GETLG   TMVAL,TXSP          Get cursor position                  2686
       PUTDC   PDLPTR,2*DESCR,TMVAL                                     2687
       PUTDC   PDLPTR,3*DESCR,ZEROCL                                    2688
       BRANCH  SCOK,SCNR           Return matching successfully         2689
*_
ONAR   PROC    ARBN                                                     2691
       IEQLC   FULLCL,0,TSCOK      Check &FULLSCAN
       MOVD    TVAL,ZEROCL                                              2693
       GETAC   TVAL,PDLPTR,-2*DESCR                                     2694
*                                  Get old cursor position              2695
       GETLG   TMVAL,TXSP          Get current cursor position          2696
       ACOMP   TVAL,TMVAL,TSCOK,,TSCOK                                  2697
*                                  Compare positions                    2698
ONAR1  PUSH    TVAL                Save cursor position                 2699
       DECRA   PDLPTR,6*DESCR      Delete history entries               2700
ONAR2  IEQLC   LENFCL,0,TSALT      Check length failure                 2701
       BRANCH  SALF,SCNR           Return matching failure              2702
*_
ONRF   PROC    ARBN                                                     2704
       MOVD    TVAL,ZEROCL                                              2705
       GETAC   TVAL,PDLPTR,-2*DESCR                                     2706
*                                  Get old cursor position              2707
       BRANCH  ONAR1               Join processing                      2708
*_
FARB   PROC    ,                                                        2710
       IEQLC   FULLCL,0,,FARB2     Check &FULLSCAN
       SETAC   NVAL,0              Set residual length to 0             2712
       BRANCH  FARB3               Join processing                      2713
*_
FARB2  IEQLC   LENFCL,0,FARB1      Check for length failure             2715
       SETAV   NVAL,YCL            Get residual length                  2716
FARB3  GETLG   TVAL,TXSP           Get cursor position                  2717
       SUM     TVAL,TVAL,NVAL      Add them                             2718
       ACOMP   TVAL,MAXLEN,FARB1,FARB1                                  2719
*                                  Check against maximum                2720
       ADDLG   TXSP,ONECL          Add one for ARB                      2721
       GETLG   TVAL,TXSP           Get length matched                   2722
       PUTAC   PDLPTR,2*DESCR,TVAL Insert on history list               2723
       BRANCH  SCOK,SCNR           Return successful match              2724
*_
FARB1  DECRA   PDLPTR,3*DESCR      Back over history entry              2726
       BRANCH  SALT,SCNR                                                2727
*_
*---------------------------------------------------------------------*
*
*      @X                                                               2731
*
ATP    PROC    ,                   Matching procedure for @X            2733
       INCRA   PATICL,DESCR        Increment pattern offset             2734
       GETD    XPTR,PATBCL,PATICL  Get argument                         2735
ATP1   VEQLC   XPTR,E,,ATPEXN      EXPRESSION must be evaluated         2736
       GETLG   NVAL,TXSP           Get length of text matched           2737
       SETVC   NVAL,I              Set INTEGER data type                2738
       PUTDC   XPTR,DESCR,NVAL     Assign as value of variable X        2739
       IEQLC   OUTSWQ,0,,ATP2      Check &OUTPUT
       LOCAPV  ZPTR,OUTATL,XPTR,ATP2                                    2741
*                                  Look for output association          2742
       GETDC   ZPTR,ZPTR,DESCR     Get output association descriptor    2743
       RCALL   ,PUTOUT,(ZPTR,NVAL) Perform output                       2744
ATP2   IEQLC   TRAPCL,0,,TSCOK     Check &TRACE                         2745
       LOCAPT  ATPTR,TVALL,XPTR,TSCOK                                   2746
*                                  Look for trace association           2747
       PUSH    (PATBCL,PATICL,WPTR,XCL,YCL)                             2748
       PUSH    (MAXLEN,LENFCL,PDLPTR,PDLHED,NAMICL,NHEDCL)              2749
       SPUSH   (HEADSP,TSP,TXSP,XSP)                                    2750
       MOVD    PDLHED,PDLPTR       Set new stack heading                2751
       MOVD    NHEDCL,NAMICL       Set new name list heading            2752
       RCALL   ,TRPHND,ATPTR       E3.3.1
*                                  Perform tracing                      2754
       SPOP    (XSP,TXSP,TSP,HEADSP)                                    2755
       POP     (NHEDCL,NAMICL,PDLHED,PDLPTR,LENFCL,MAXLEN)              2756
       POP     (YCL,XCL,WPTR,PATICL,PATBCL)                             2757
       BRANCH  SCOK,SCNR                                                2758
*_
ATPEXN RCALL   XPTR,EXPEVL,XPTR,(TSALF,ATP1,SCNEMO) E3.4.4
*_
*---------------------------------------------------------------------*
*
*      BAL                                                              2764
*
BAL    PROC    ,                   Matching procedure for BAL           2766
BALF1  IEQLC   FULLCL,0,,BALF4     Check &FULLSCAN                      2767
       SETAC   NVAL,0              Set length to zero                   2768
       BRANCH  BALF2                                                    2769
*_
BALF4  SETAV   NVAL,YCL                                                 2771
BALF2  GETLG   TVAL,TXSP           Get length of text matched so far    2772
       SUM     TVAL,TVAL,NVAL      Add remainder possible               2773
       ACOMP   TVAL,MAXLEN,BAL1,BAL1                                    2774
*                                  Compare to maximum                   2775
       SUBTRT  TVAL,MAXLEN,TVAL    Get maximum length for BAL           2776
       GETBAL  TXSP,TVAL,BAL1      Get balanced string                  2777
       GETLG   TVAL,TXSP           Get length matched                   2778
       PUTAC   PDLPTR,2*DESCR,TVAL Insert history entry                 2779
       BRANCH  SCOK,SCNR           Successful match                     2780
*_
BAL1   DECRA   PDLPTR,3*DESCR      Back over history entry              2782
       ACOMP   PDLPTR,PDLHED,TSALF,TSALF,INTR13                         2783
*_
BALF   PROC    BAL                 Matching procedure for BAL retry     2785
       IEQLC   FULLCL,0,,BALF3     Check &FULLSCAN
       SETAC   NVAL,0              If off, set length to zero           2787
       BRANCH  BALF2               Reenter balanced matching            2788
*_
BALF3  IEQLC   LENFCL,0,BAL1,BALF1 If on, test for length failure       2790
*_
*---------------------------------------------------------------------*
*
*      MAXARB
*
MXAR   PROC    ,                   Matching procedure for MAXARB
       GETLG   TVAL,XSP            Get total length
       IEQLC   FULLCL,0,MXAR2      If not fullscan, reduce lenth
       GETDC   NVAL,PDLPTR,2*DESCR Get residual length
       SETAV   NVAL,NVAL
       ACOMP   NVAL,TVAL,TSALF     Er if cursor becomes negative
       SUBTRT  TVAL,TVAL,NVAL      Reduce max len by residual
       GETLG   NVAL,TXSP
       ACOMP   NVAL,TVAL,TSALF     Er if moves before current cursor
MXAR2  PUTLG   TXSP,TVAL           Set new cursor position
       PUTAC   PDLPTR,5*DESCR,TVAL Insert history entry ####
       BRANCH  SCOK,SCNR           Successful match                     2780
*_
MXAR1  DECRA   PDLPTR,3*DESCR      Back over history entry
       ACOMP   PDLPTR,PDLHED,TSALF,TSALF,INTR13                         2783
*_
MXARF  PROC    MXAR                Matching procedure for MAXARB retry
*####  GETLG   TVAL,TXSP           Get length of text matched so far
       GETAC   TVAL,PDLPTR,5*DESCR Get prior matched length
       ACOMP   TVAL,ZEROCL,,MXAR1,MXAR1 Don't let it go neg ####need?
       DECRA   TVAL,1              Get maximum length for MAXARB
* #### should only back up to original position
       GETAC   NVAL,PDLPTR,-DESCR  Get original cursor position
       ACOMP   TVAL,NVAL,,,MXAR1
       PUTLG   TXSP,TVAL           Reduce length matched
       PUTAC   PDLPTR,2*DESCR,TVAL Insert history entry                 2779
       BRANCH  SCOK,SCNR           Successful match                     2780
*_
*---------------------------------------------------------------------*
*
*      Matching for String                                              2794
*
CHR    PROC    ,                   Matching character string            2796
       INCRA   PATICL,DESCR        Increment offset                     2797
       GETD    YPTR,PATBCL,PATICL  Get argument                         2798
CHR1   LOCSP   TSP,YPTR            Get specifier                        2799
CHR2   REMSP   VSP,XSP,TXSP        Remove part matched                  2800
       SUBSP   VSP,TSP,VSP,TSALT   Get part to match                    2801
       LEXCMP  VSP,TSP,TSALF,,TSALF                                     2802
*                                  Compare strings                      2803
       GETLG   YPTR,TSP            Get length                           2804
       ADDLG   TXSP,YPTR           Update string matched                2805
       BRANCH  SCOK,SCNR           Return successful match              2806
*_
*---------------------------------------------------------------------*
*
*      *X                                                               2810
*
STARE  PROC    CHR                 Matching procedure for expressions
       INCRA   PATICL,DESCR        Increment offset                     2813
       GETD    YPTR,PATBCL,PATICL  Get argument expression              2814
STAR2  RCALL   YPTR,EXPVAL,YPTR,TSALF                                   2815
*                                  Evaluate argument                    2816
       VEQLC   YPTR,E,,STAR2       Is it EXPRESSION?                    2817
       SUM     XPTR,PATBCL,PATICL  Compute pointer to argument          2818
       PUTDC   XPTR,7*DESCR,YPTR   Insert pointer in backup node        2819
       VEQLC   YPTR,S,,CHR1        Is it STRING?                        2820
       VEQLC   YPTR,P,,STARP       Is it  PATTERN?                      2821
       VEQLC   YPTR,I,SCDTER       Is it INTEGER?                       2822
       INTSPC  TSP,YPTR            Get specifier for integer            2823
       BRANCH  CHR2                Join processing                      2824
*_
STARP  IEQLC   FULLCL,0,,STARP1    Check &FULLSCAN                      2826
       SETAC   NVAL,0              Zero length                          2827
       BRANCH  STARP4              Join processing                      2828
*_
STARP1 SETAV   NVAL,YCL            Get length                           2830
STARP4 SUBTRT  NVAL,MAXLEN,NVAL    Compute residual                     2831
       ICOMPC  NVAL,0,,,TSALT
       LVALUE  TSIZ,YPTR           Check &FULLSCAN                      2833
       IEQLC   FULLCL,0,STARP6
       ACOMP   TSIZ,NVAL,TSALT     Check against length                 2835
STARP6 INCRA   PDLPTR,3*DESCR      Make room for history                2836
       ACOMP   PDLPTR,PDLEND,INTR31                                     2837
*                                  Check for overflow                   2838
       PUTDC   PDLPTR,DESCR,SCFLCL Insert failure function              2839
       GETLG   TMVAL,TXSP          Get cursor position                  2840
       PUTDC   PDLPTR,2*DESCR,TMVAL                                     2841
*                                  Insert on history list               2842
       PUTDC   PDLPTR,3*DESCR,LENFCL                                    2843
*                                  Insert length failure                2844
       PUSH    (MAXLEN,PATBCL,PATICL,XCL,YCL)                           2845
*                                  Save scanner state                   2846
       MOVD    MAXLEN,NVAL         Set up new maximum                   2847
       RCALL   ,SCIN,,(STARP5,,RTNUL3)                                  2848
*                                  Call the scanner                     2849
STARP2 POP     (YCL,XCL,PATICL,PATBCL,MAXLEN)                           2850
*                                  Restore scanner state                2851
       BRANCH  SCOK,SCNR           Return matching successfully         2852
*_
STARP5 POP     (YCL,XCL,PATICL,PATBCL,MAXLEN)                           2854
*                                  Restore scanner state                2855
STARP3 IEQLC   LENFCL,0,TSALT      Check length failure                 2856
       BRANCH  SALF,SCNR           Return matching failure              2857
*_
DSAR   PROC    CHR                 Backup matching for expression       2859
       INCRA   PATICL,DESCR        Increment offset                     2860
       GETD    YPTR,PATBCL,PATICL  Get argument                         2861
       VEQLC   YPTR,S,,STARP3      Is it STRING?                        2862
       VEQLC   YPTR,P,,DSARP       Is it PATTERN?                       2863
       VEQLC   YPTR,I,SCDTER,STARP3                                     2864
*                                  Is it INTEGER?                       2865
*_
DSARP  IEQLC   FULLCL,0,,DSARP1    Check &FULLSCAN                      2867
       SETAC   NVAL,0              Zero length                          2868
       BRANCH  DSARP2              Join processing                      2869
*_
DSARP1 SETAV   NVAL,YCL            Get length                           2871
DSARP2 SUBTRT  NVAL,MAXLEN,NVAL    Compute residual                     2872
       PUSH    (MAXLEN,PATBCL,PATICL,XCL,YCL)                           2873
*                                  Save scanner state                   2874
       MOVD    MAXLEN,NVAL         Set up new maximum                   2875
       RCALL   ,UNSC,,(STARP5,STARP2,RTNUL3)                            2876
*                                  Call unscanning procedure            2877
*_
*---------------------------------------------------------------------*
*
*      FENCE                                                            2881
*
FNCE   PROC    ,                   Procedure for matching FENCE         2883
       INCRA   PDLPTR,3*DESCR      Create new history entry             2884
       ACOMP   PDLPTR,PDLEND,INTR31                                     2885
*                                  Check for overflow                   2886
       PUTDC   PDLPTR,DESCR,FNCFCL Insert FENCE failure function        2887
       GETLG   TMVAL,TXSP          Get length                           2888
       PUTDC   PDLPTR,2*DESCR,TMVAL                                     2889
*                                  Save length                          2890
       PUTDC   PDLPTR,3*DESCR,LENFCL                                    2891
*                                  Save length failure switch           2892
       SETAC   LENFCL,1            Set length failure switch            2893
       BRANIC  SCOKCL,0            Return matching                      2894
*_
